/* $Id: idblock.c,v 1.3 1998/03/23 22:57:35 fraserm Exp $ : id-block stuff for span
   $Log: idblock.c,v $
   Revision 1.3  1998/03/23 22:57:35  fraserm
   changed status messages
   added getopt support for -q quiet and -l volume label options
   more minor bugfixes

   Revision 1.2  1998/03/22 20:36:43  fraserm
   moved blocks_this_volume out of struct and into a global -
   fixed incorrect blocks-this-volume bug

   Revision 1.1  1998/03/22 19:29:56  fraserm
   Initial revision

*/

#include "span.h"

void write_id_block (bd, seek_or_not, more)
     struct device *bd;
     int seek_or_not, more; /* more is set if this is not the last volume */
{
  char tmpbuf[bufsize];

  /* blank it out, so it looks okay in the file */
  memset (tmpbuf, 0, bufsize);
  sprintf (tmpbuf, "%s,%s,%s,%d,%d,%ld,%ld,%ld,%ld,%d",
	   ID_MAGIC, ID_FORMAT_VERSION,
	   label, bufsize, volume_number, bytes_this_volume,
	   bd->bytes_so_far, first_all, first_volume, more);
  if (seek_or_not == YES_SEEK) {
    if (lseek (bd->fd, (off_t)0, SEEK_SET) == -1) {
      die ("unable to lseek to volume start to write ID block",
	   errno, ERR_CANTSEEK);
    }
  }
  if (write_robust (bd->fd, tmpbuf, bufsize) < bufsize) {
    die ("unrecoverable error writing ID block", errno, ERR_IDBLOCK);
  }
}

long read_id_block (bd, more)
     struct device *bd;
     int *more;
{
  int vn;
  long tv, tw, fa, fv;
  int vbufsize; /* what the volume label says the block size is */
  char tmpbuf[bufsize];
  char magic[NAMESIZE], version[NAMESIZE], thislabel[NAMESIZE];

  if (read_robust (bd->fd, tmpbuf, bufsize) < bufsize) {
    die ("unrecoverable error reading id-block", errno, ERR_CANTREAD);
  }
  if (sscanf (tmpbuf, "%[^,],%[^,],%[^,],%d,%d,%ld,%ld,%ld,%ld,%d",
	      magic, version, thislabel, &vbufsize,
	      &vn, &tv, &tw, &fa, &fv, more) != 10
      || strcmp (magic, ID_MAGIC) != 0) {
    fprintf (stderr, "%s: this volume wasn't written by '%s' - guess again\n",
	     OUTNAME, progname);
    return -1;
  }
  if (strcmp (version, ID_FORMAT_VERSION) > 0) {
    fprintf (stderr, "%s: warning: volume has format version %s, this program only reads\n\tup to %s reliably; continuing anyway, but expect failure\n",
	     progname, version, ID_FORMAT_VERSION);
  }
  if (strcmp (label, NO_LABEL) == 0) { /* set the label if its empty */
    strcpy (label, thislabel);
  }
  else {
    if (strcmp (thislabel, label) != 0) {
      fprintf (stderr, "%s: this volume has label \"%s\", expected \"%s\"\n",
	       progname, thislabel, label);
      return -1;
    }
  }
  if (vn != volume_number+1) {
    fprintf (stderr, "%s: volume %d is in the drive; please remove it and insert volume %d\n",
	     progname, vn, volume_number+1);
    return -1;
  }
  if (vbufsize != bufsize || buffer == NULL) {
    /* hmmm... volume uses a different block size
       than the last volume reported - better
       use the new volume's one :) */
    if (bufsize != DEFAULT_BLOCKSIZE) { /* don't print a warning for the
					   first volume :-) */
      fprintf (stderr,"%s: warning: last volume blksize was %d, this one is %d - using %d\n",
	       progname, bufsize, vbufsize, vbufsize);
    }
    /* this slightly dodgy, but safe - this routine is never called except
       when reading, so we can safely change the size of the buffer without
       fear of screwing up anything elsewhere; note that we need to check
       that the buffer is already set before freeing it */
    bufsize = vbufsize;
    if (buffer != NULL) {
      free (buffer);
    }
    if ((buffer = (char *) malloc (bufsize)) == NULL) {
      die ("failed to allocate buffer space", errno, ERR_ALLOC);
    }
    /* since we changed the blocksize, we must be sure to position
       ourselves immediately after it, regardless how much we just read */
    if (lseek (bd->fd, (off_t)bufsize, SEEK_SET) == -1) {
      die ("failed to seek past id-block", errno, ERR_CANTSEEK);
    }
  }
  fv /= 1000; /* :-) */
  fprintf (stderr, "%s: volume %d \"%s\":\n\tblocksize %d id V%s, %ld bytes (%ldK) [%s]\n",
	   progname, vn, label, bufsize, version, tv, tv / 1024,
	   (*more)?"more":"final");
  return tv;
}
