static char Id_mtimefilter_c[] =
"$Id: mtimefilter.c_v 1.8 1997/10/25 15:49:19 jhl Exp $";

/* 
   Copyright (C) 1995,1996,1997  James H. Lowe, Jr. <jhl@richmond.infi.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <errno.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include "cplob.h"
#include "miscfn.h"

/* #define MTIMEFILTER_DEBUG  */

int mt_GLOBAL_DEBUG=0;

typedef struct {
    char name[512];  /* directory path components can't be more than this in length */
    int state;       /* 0 = not to be included, 1 = to be included */
} DIRSTATE;


#define LINELEN 3000

time_t mkstrtime ( char * datestring, int debug );
static int write_out_test  ( int use_ctime, time_t filectime, time_t testtime,  int newer , time_t filemtime);
static int fileCompare(const void * one, const void * two);
static int fileCompare1 (const void * one, const void * two);
static char * get_parent_path ( char * path ); 
static char * dirstate_add ( char * name, int state , CPLOB * cplob );
static char * dirstate_del ( char * name , CPLOB * cplob );
static int dirstate_getstate ( char *name, CPLOB * cplob );
static void print_dirlist ( CPLOB * cplob , char  * str );
static int delete_out_of_scope_dirs ( char *name, CPLOB * cplob ); 
static int fnmatch (const char * pattern, const char * string, int flags);

int main (int argc, char *argv[])
{

  char line[LINELEN], tmpline[LINELEN], datestring[LINELEN]; 
  extern char *optarg;
  extern int optind;
  int newer, c, optionerror = 0,DEBUG=0, use_ctime=0, dir_override=0, tmpi, first_line=1;
  int lstat_quiet=0;
  time_t testtime, testtime_correction=0, filemtime, filectime, t1, t2;
  struct stat st, sti;
  char current_dir[512], tmpdir[112]; 
  CPLOB * dirstate_list;  /* character pointer list object, i.e array of DIRSTATE's */

  newer = 1;
  while ((c = getopt (argc, argv, "f:oqsdc-:")) != EOF)
    {
      switch (c)
	{
	case 'c':    /* filter by ctime or mtime */ 
	  use_ctime = 1;
	  break;
	case 'd':    /* debug mode on */ 
	  DEBUG = 1;
          mt_GLOBAL_DEBUG=1;
	  break;
	case 'o':    /* pass older files, */ 
	  newer = 0;
	  break;
	case 's':   /* if dir is included, include all its contents */
	  dir_override=1;
	  dirstate_list = cplob_open ( 10, (CPLOB *)(NULL));
	  if ( sizeof (char *) != sizeof (CPLOB*) ) {
              fprintf (stderr, "mtimefilter:  char and CPLOB type have different pointer widths, FIXME.\n");
	      exit (1);
	  }
	  if (! dirstate_list ) {
              fprintf (stderr, "mtimefilter:  out of memory.\n");
	      exit (1); 
	  }
	  break;
	case 'f':   /* time offset */
	  testtime_correction = atoi (optarg);
	  break;
	case 'q':   /* time offset */
	  lstat_quiet = 1;
	  break;
	case '-':
          optionerror=1;
	  break;
	default:
          optionerror = 1;

	}
    }
  argv += optind;
  argc -= optind;

  if ((optionerror == 1))
    {
       fprintf (stderr, "Usage: mtimefilter [-d][-c][-o][-s][-f[ ]seconds] [date]\n");
       fprintf (stderr, "     -c  :use ctime, not mtime (default), value in filter test.\n");
       fprintf (stderr, "     -o  :means pass older files, filter newer\n");
       fprintf (stderr, "     -f 'seconds'  :is a integer, pos or neg to add to 'date' \n");
       fprintf (stderr, "     -d  : prints the interpretation of the date string to stderr.\n");
       fprintf (stderr, "     -s  : writes out all files in directories that are written out.\n");
       fprintf (stderr, "     -q  : quiet about file existence errors.\n");
       fprintf (stderr, "     'date'  is a date string, current time if not provided.\n");
       fprintf (stderr, "mtimefilter: invalid arguments\n");
       exit (1);
    }

  if (argc == 0)
    testtime = time ((time_t *)(NULL));
  else
    {
      if (strlen (*argv) >= LINELEN -1L) exit (1);
      strcpy (datestring, *argv);
      if ( (testtime = mkstrtime ( datestring, DEBUG )) < 0 ) {
        fprintf (stderr,"mtimefilter: mkstrtime failure, failed. ( %s ).\n", datestring );
        exit (1);
      }
    }
  
  testtime += testtime_correction;
  
  if ( dir_override ) {
      if ( getcwd ( current_dir, 511 ) == (char *)(NULL)) {
         fprintf (stderr, "mtimefilter: getcwd error.\n");
         exit (1);
      }
      if (lstat (strtok (current_dir, "\n\r"), &st) == 0) {
          filemtime = st.st_mtime;
          filectime = st.st_ctime;
      } else {
         fprintf (stderr, "mtimefilter: lstat error.\n");
         exit (1);
      }
#ifdef MTIMEFILTER_DEBUG 
     print_dirlist ( dirstate_list , " BEFORE FIRST_ADD"  );
#endif     
     
     strcpy (tmpdir,"."); 
     dirstate_add (tmpdir,
                    write_out_test  (use_ctime, filectime, testtime, newer, filemtime),
                    dirstate_list );
     
#ifdef MTIMEFILTER_DEBUG 
     print_dirlist ( dirstate_list , " AFTER FIRST_ADD"  );
#endif     
     
  } 
  
  while (fgets (line, LINELEN - 1, stdin) != (char *) (NULL))
    {
      if (strlen (line) >= LINELEN - 2)
	{
	  fprintf (stderr, "mtimefilter: line too long : %s\n", line);
	}
      else
	{
	  if (lstat (strtok (line, "\n\r"), &st) == 0)
	    {
	      filemtime = st.st_mtime;
	      filectime = st.st_ctime;

              if ( !dir_override ) {
                  if ( write_out_test  ( use_ctime, filectime, testtime,  newer , filemtime))
     	              puts (line);
               } else {

                  /* 
		     *All* this code is to avoid calling lstat 2 times for every node which 
		     would be the easiest to program.  
		     
		     Below is code which caches directories
		     and its time dispostion state to avoid calling lstat twice. 
		     
		     It uses a CPLOB object, an unbounded Character Pointer List OBject to
		     store a sorted list of directories and discards them when they are no longer
		     needed.  The list is actually a list of DIRSTATE pointer types although neither
		     CPLOB nor gcc cares or knows the difference.
		  */


                  if ( first_line ) { /* kludge, init the cache list with the lists top directory ?? */
		                        /* I hope this works most of the time */
                      strcpy (current_dir, line);
                      get_parent_path ( current_dir);
	              if (lstat (strtok (current_dir, "\n\r"), &sti) == 0) {
	                  t1 = sti.st_mtime;
	                  t2 = sti.st_ctime;
		       } else  {
	                    fprintf (stderr,"\nmtimefilter: directory %s not found.\n", current_dir);
		       }
		      dirstate_add (current_dir ,
                          write_out_test  (use_ctime, t2, testtime, newer, t1) ,
                          dirstate_list );
		       first_line=0;
		   }

                 if ( S_ISDIR (st.st_mode)) {
                      
#ifdef MTIMEFILTER_DEBUG 
		      print_dirlist ( dirstate_list , " BEFORE _ADD"  );
#endif     
                      dirstate_add (line,
                                    write_out_test  (use_ctime, filectime, testtime, newer, filemtime),
                                    dirstate_list );
                      
#ifdef MTIMEFILTER_DEBUG 
                      print_dirlist ( dirstate_list , " AFTER _ADD"  );
#endif     
		     
		       if ( delete_out_of_scope_dirs ( line, dirstate_list )) {
                                 fprintf (stderr, "mtimefilter: deletion error.\n");
		       }
		      
		      if ( write_out_test  ( use_ctime, filectime, testtime,  newer, filemtime ))
     	                  fprintf (stdout, "%s\n", line);
     	                  /*puts (line); */
		  } else {
		       strcpy(tmpline, line); 
#ifdef MTIMEFILTER_DEBUG 
                       print_dirlist ( dirstate_list , " BEFORE GETSTATE"  );
#endif     
		       if ( (tmpi=dirstate_getstate ( get_parent_path (tmpline) , dirstate_list)) >= 0) { 
			         if (tmpi) {
				     puts (line);
	                          } else { 
                                     if ( write_out_test  ( use_ctime, filectime, testtime,  newer , filemtime))
     	                                puts (line);
				  } 
                        } else {
                                 fprintf (stderr, "mtimefilter: dirstate_getstate error.: %s\n", tmpline);
		        }
#ifdef MTIMEFILTER_DEBUG 
                       print_dirlist ( dirstate_list , " AFTER GETSTATE"  );
#endif     
		   }
	       
	       
	       
	       
	       }
	   } else {
	     if (! lstat_quiet) fprintf (stderr,"\nmtimefilter: %s not found.\n", line);
           }
        }
    }
  exit (0); /* without free'ing anything, hopefully the OS will. */
}


static int 
write_out_test  ( int use_ctime, time_t filectime, time_t testtime,  int newer , time_t filemtime) {

                 if (use_ctime && (filectime < testtime) )
		     {
                      if (!newer)
		        return 1;
		     }

		   else if (use_ctime && (filectime >= testtime) )
		     {
                      if (newer)
		        return 1;
		     }

	   	   else if ( !use_ctime && (filemtime < testtime) )
		     {
                      if (!newer)
		        return 1;
		     }
	   	   else if ( !use_ctime && (filemtime >= testtime) )
		     {
                      if (newer)
		        return 1;
		     }
     return 0;
}

static int fileCompare(const void * one, const void * two) {
    return strcmp(  ((DIRSTATE*) (*(char**)(one)))->name ,
                    ((DIRSTATE*) (*(char**)(two)))->name
		 );
}

static int fileCompare1 (const void * one, const void * two) {
    return strcmp((char*)(one), ((DIRSTATE*) (*(char**)(two)))->name );
}


static char * get_parent_path ( char * path ) {
   char *p; 
   if ((p=strrchr (path, '/')) != (char*)(NULL)) {
     *p='\00';
   }
   return path;
}


static char * dirstate_add ( char * name, int state , CPLOB * cplob ) {
   DIRSTATE *p;
   
   if (bsearch (name,(void*)(cplob->list), (size_t)cplob->nused, sizeof (char *),fileCompare1 ) && strcmp (name,".")) {
      fprintf (stderr, "mtimefilter: warning, duplicate name: %s\n", name);
      return name;
   } 
   if  ((p=(DIRSTATE*)malloc(sizeof(DIRSTATE))) == (DIRSTATE*)(NULL)  || strlen (name) >511 )
      return (char*)(NULL);
   strcpy (p->name, name);
   p->state = state;
   cplob_additem (cplob, cplob->nused, (char **)(&p));
   /* print_dirlist (cplob, "BEFORE--"); */
   qsort ( (void*)(cplob->list), (size_t)cplob->nused, sizeof (char *),fileCompare);
   /* print_dirlist (cplob, "AFTER---"); */
   return  p->name;
}

static char * dirstate_del ( char * name , CPLOB * cplob ) {
   void * p;
   p=bsearch (name,(void*)(cplob->list), (size_t)cplob->nused, sizeof (char *),fileCompare1 );
   if (p) {
      cplob_deleteitem ( cplob, (int)(p - (void*)cplob->list)/sizeof(char*) );
      return name; 
   } else {
     return (char*)(NULL);
   }
}

static int dirstate_getstate ( char *name, CPLOB * cplob ) {
   void * p;
   p=bsearch (name,(void*)(cplob->list), (size_t)cplob->nused, sizeof (char *),fileCompare1 );
   if (p) {
      return (int)(   (   (DIRSTATE *)    ( *((char**)(p)) )    ) -> state); 
   }
   return -1; 
}

static int delete_out_of_scope_dirs ( char *name, CPLOB * cplob ) {
  char tmpname[LINELEN]; 
  char tmpname1[LINELEN]; 
  char pattern[LINELEN]; 
  char * array1[512]; 
  char * array2[512]; 
  int i=0, ret=0, j=0, k=0;
  DIRSTATE *ds;
 
  strcpy (tmpname, name);
  /* determine deepest common root that name has in common with ds->name */  
 
  /* tokenize tmpname */
  i=0; 
  while ( (array1[i] = strtok (i ? (char *) (NULL) : tmpname, "/") ) ) i++;
  array1[++i] = (char*)(NULL);
  
  while  ( cplob->nused > j && (ds=(DIRSTATE*)(*(cplob->list + j++))) != NULL ) {
     
     
      strcpy (tmpname1, ds->name);
      i=0; 
      while ((array2[i] = strtok (i ? (char *) (NULL) : tmpname1, "/"))) i++;
      array2[++i] = (char*)(NULL);
      i=0; 
      while ( array1[i] && array2[i] && !strcmp (array1[i], array2[i] )) i++;
      /* i holds the number of common levels */ 
      strcpy (pattern, array1[0]);
      for (k=1; k<i; k++) {
          strcat (pattern, "/"); strcat (pattern, array1[k] ); 

      }
      strcat (pattern, "/");
      strcat (pattern, "*");


     if ( ! fnmatch (pattern, ds->name , 0) && i) {
          
	  pattern[ strlen (pattern) - 1 ] = '\00'; 
          strcat (pattern, array1[i-1]);
	  if ( fnmatch (pattern, ds->name , 0)) {
	  
#ifdef MTIMEFILTER_DEBUG 
	     fprintf (stderr, "DELETING currentname:%s pattern:%s DDD  %s %d\n", name, pattern , ds->name, ds->state);
             print_dirlist ( cplob , " BEFORE "  );
/*          fprintf (stderr, "DELETED--- %s\n",  ((DIRSTATE*)(cplob_deleteitem ( cplob, --j )))->name ); */
#endif
          
	  if (mt_GLOBAL_DEBUG) { fprintf (stderr,"deleting %s\n", ds->name);
             print_dirlist ( cplob , " AFTER "  );
	             }
	  if ( ! dirstate_del ( ds->name , cplob ))
               fprintf (stderr, "mtimefilter: internal array deletion error: %s\n", ds->name);

#ifdef MTIMEFILTER_DEBUG 
             print_dirlist ( cplob , " AFTER "  );
#endif
      
          } 
      
      }
   } 
  return ret;
}

static void print_dirlist ( CPLOB * cplob , char  * str ) {
    int i=0;
    DIRSTATE *ds;
    
    fprintf (stderr, "LISTING %s %d \n ", str, cplob->nused);
    
    while  ( (i < cplob->nused) && ((ds=(DIRSTATE*)(*(cplob->list + i))) != NULL )) {
       fprintf (stderr, "LISTING %s    ", str);
       fprintf (stderr, "%x: %d %s %d\n", (unsigned)(*(cplob->list +i)),  i, ds->name, ds->state);
       i++;
    }
}

extern int errno;

/* Match STRING against the filename pattern PATTERN, returning zero if
   it matches, nonzero if not.  */
static int
fnmatch (pattern, string, flags)
     const char *pattern;
     const char *string;
     int flags;
{
  register const char *p = pattern, *n = string;
  register char c;

/* Note that this evalutes C many times.  */
#define FOLD(c)	((flags & FNM_CASEFOLD) && isupper (c) ? tolower (c) : (c))

  while ((c = *p++) != '\0')
    {
      c = FOLD (c);

      switch (c)
	{
	case '?':
	  if (*n == '\0')
	    return FNM_NOMATCH;
	  else if ((flags & FNM_FILE_NAME) && *n == '/')
	    return FNM_NOMATCH;
	  else if ((flags & FNM_PERIOD) && *n == '.' &&
		   (n == string || ((flags & FNM_FILE_NAME) && n[-1] == '/')))
	    return FNM_NOMATCH;
	  break;

	case '\\':
	  if (!(flags & FNM_NOESCAPE))
	    {
	      c = *p++;
	      c = FOLD (c);
	    }
	  if (FOLD (*n) != c)
	    return FNM_NOMATCH;
	  break;

	case '*':
	  if ((flags & FNM_PERIOD) && *n == '.' &&
	      (n == string || ((flags & FNM_FILE_NAME) && n[-1] == '/')))
	    return FNM_NOMATCH;

	  for (c = *p++; c == '?' || c == '*'; c = *p++, ++n)
	    if (((flags & FNM_FILE_NAME) && *n == '/') ||
		(c == '?' && *n == '\0'))
	      return FNM_NOMATCH;

	  if (c == '\0')
	    return 0;

	  {
	    char c1 = (!(flags & FNM_NOESCAPE) && c == '\\') ? *p : c;
	    c1 = FOLD (c1);
	    for (--p; *n != '\0'; ++n)
	      if ((c == '[' || FOLD (*n) == c1) &&
		  fnmatch (p, n, flags & ~FNM_PERIOD) == 0)
		return 0;
	    return FNM_NOMATCH;
	  }

	case '[':
	  {
	    /* Nonzero if the sense of the character class is inverted.  */
	    register int not;

	    if (*n == '\0')
	      return FNM_NOMATCH;

	    if ((flags & FNM_PERIOD) && *n == '.' &&
		(n == string || ((flags & FNM_FILE_NAME) && n[-1] == '/')))
	      return FNM_NOMATCH;

	    not = (*p == '!' || *p == '^');
	    if (not)
	      ++p;

	    c = *p++;
	    for (;;)
	      {
		register char cstart = c, cend = c;

		if (!(flags & FNM_NOESCAPE) && c == '\\')
		  cstart = cend = *p++;

		cstart = cend = FOLD (cstart);

		if (c == '\0')
		  /* [ (unterminated) loses.  */
		  return FNM_NOMATCH;

		c = *p++;
		c = FOLD (c);

		if ((flags & FNM_FILE_NAME) && c == '/')
		  /* [/] can never match.  */
		  return FNM_NOMATCH;

		if (c == '-' && *p != ']')
		  {
		    cend = *p++;
		    if (!(flags & FNM_NOESCAPE) && cend == '\\')
		      cend = *p++;
		    if (cend == '\0')
		      return FNM_NOMATCH;
		    cend = FOLD (cend);

		    c = *p++;
		  }

		if (FOLD (*n) >= cstart && FOLD (*n) <= cend)
		  goto matched;

		if (c == ']')
		  break;
	      }
	    if (!not)
	      return FNM_NOMATCH;
	    break;

	  matched:;
	    /* Skip the rest of the [...] that already matched.  */
	    while (c != ']')
	      {
		if (c == '\0')
		  /* [... (unterminated) loses.  */
		  return FNM_NOMATCH;

		c = *p++;
		if (!(flags & FNM_NOESCAPE) && c == '\\')
		  /* XXX 1003.2d11 is unclear if this is right.  */
		  ++p;
	      }
	    if (not)
	      return FNM_NOMATCH;
	  }
	  break;

	default:
	  if (c != FOLD (*n))
	    return FNM_NOMATCH;
	}

      ++n;
    }

  if (*n == '\0')
    return 0;

  if ((flags & FNM_LEADING_DIR) && *n == '/')
    /* The FNM_LEADING_DIR flag says that "foo*" matches "foobar/frobozz".  */
    return 0;

  return FNM_NOMATCH;
}





