static char Id_mkstrtime_c[] =
"$Id: mkstrtime.c_v 1.2 1995/10/06 23:33:42 jhl Exp $";

/* 
   Copyright (C) 1995  James H. Lowe, Jr.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>

int partime ( char * datestring, struct tm * unix_tm, int *returned_zone_offset);
time_t mkstrtime ( char * datestring, int debug_0_or_1 );

time_t mkstrtime ( datestring, debug )
   char * datestring;
   int debug;
{

  int zone;
  time_t testtime, zone_altered;
  struct tm tm;

  if (partime (datestring, &tm, &zone) < 0)
    {
      fprintf (stderr, "mtimefilter: date string unparsable \n");
      return -1;
    }

  if (debug) {
  fprintf (stderr,"AFTER partime\n");
  fprintf (stderr,"tm_sec %d\n ",tm.tm_sec);
  fprintf (stderr,"tm_min %d\n ",tm.tm_min);
  fprintf (stderr,"tm_hour %d\n ",tm.tm_hour);
  fprintf (stderr,"tm_mday %d\n ",tm.tm_mday);
  fprintf (stderr,"tm_mon %d\n ",tm.tm_mon);
  fprintf (stderr,"tm_year %d\n ",tm.tm_year);
  fprintf (stderr,"tm_isdst %d\n ",tm.tm_isdst);
  fprintf (stderr,"zone offset is  %d\n ",zone);
  }
  
  putenv ("TZ=GMT0UTC"); 
    if ((testtime = mktime (&tm)) < 0) {
       fprintf (stderr, "mkstrtime: mktime failure \n");
       return -1;
     }

  if (debug) {
  fprintf (stderr,"\nAFTER mktime\n");
  fprintf (stderr,"tm_sec %d\n ",tm.tm_sec);
  fprintf (stderr,"tm_min %d\n ",tm.tm_min);
  fprintf (stderr,"tm_hour %d\n ",tm.tm_hour);
  fprintf (stderr,"tm_mday %d\n ",tm.tm_mday);
  fprintf (stderr,"tm_mon %d\n ",tm.tm_mon);
  fprintf (stderr,"tm_year %d\n ",tm.tm_year);
  fprintf (stderr,"tm_isdst %d\n ",tm.tm_isdst);
  fprintf (stderr,"zone offset is  %d\n ",zone);
  }
  
/*  zone_altered = testtime + zone*60 + 3600*tm.tm_isdst; */
  zone_altered = testtime + (time_t) ( zone * 60 );

  if (debug) fprintf 
  (stderr, " %ld (zone altered: %ld)\n", testtime, zone_altered);

  return zone_altered;
}
