#ifdef DOTO_ID
static char testlob_c[] =
"$Id$";
#endif

/*
$Log$
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "cplob.h"

void get_string (char *str);
int get_integer (int j);

char get_character (char ch);

int main ()
{
   CPLOB * lob;
   int i=0, nobj,index, width;
   char  *chp;
   char ch='0'; 
   
   i=0;
   for(;;)
     {
       printf("\n"
"LOB test program menu:\n"       
"0.exit  1.open  2.close  3.add  4. insert 5. delete 6. reopen 7. show \n");
       printf(" ENTER CHOICE: <%c> ", ch); ch=get_character (ch);

        switch(ch)
          {
            case '0':
              exit(0);

            case '1':
              printf("cplob_open: enter nobj ");
              nobj=get_integer (15);
	      
	      lob = cplob_open(nobj,  NULL);
              if(!lob)
                { 
                  printf(" Open failure on filename: \n");
                  break;
                } 
              break;  

            case '2':
             printf("cplob_close:\n");
             if(cplob_close(lob))
                printf(" edclose error\n");
              break;  

            case '3':
              printf("cplob_additem\n "); 
              printf("Enter index ");
              index=get_integer (1);
              chp=malloc (1000); 
	      printf("Enter value string ");
              get_string(chp);
              cplob_additem (lob, index, &chp); 
	      break;

            case '4':
              printf("cplob_insertitem\n "); 
              printf("Enter index ");
              index=get_integer (1);
              chp=malloc (1000); 
              printf("Enter value string ");
              get_string(chp);
              cplob_insertitem (lob, index, &chp); 
	      break;

            case '5':
              printf("cplob_delete\n "); 
              printf("Enter index ");
              index=get_integer (1);
              cplob_deleteitem (lob, index); 

	      break;

            case '6':
              printf("cplob_reopen : enter new size \n"); 
              i=get_integer (1);
              if (! cplob_reopen (i, lob ))
                printf ("reopen ERROR \n");
              break;
         
            case '7':
              printf("show lob\n"); 
              printf ("lob->nused = %d\n", lob->nused);
              printf ("lob->nlen = %d\n", lob->nlen);
              printf ("lob->width = %d\n", lob->width);
              for (i=0; i<lob->nused; i++)
                if (*(lob->list + i))
	          printf ("index %d : %s\n", i, *(lob->list + i));
	      break;
            
            case '8':
              printf("cplob_appendstring\n "); 
              chp=malloc (1000); 
	      printf("Enter value string ");
              get_string(chp);
              cplob_appendstring (lob, chp); 
	      break;
	    
	    break;
	    }
     }
}



#define UGET_STRLEN 120
#define gets uget_gets

static char * uget_gets (char *);

char 
get_character (ch)
     char ch;
{
  char d[UGET_STRLEN];
  int c = 0;
  if (fflush (stdin))
    printf ("flush error\n");
  gets (d);
  while (*(d + c) == 32)
    c++;
  if (*(d + c) == '\0')
    return ch;
  return *(d + c);
}


int
get_integer (j)
     int j;
{
  char s[UGET_STRLEN], *p1;
  int decflag, zeroflag, i;
  do
    {
      decflag = zeroflag = 0;
      if (fflush (stdin))
	printf ("flush error\n");
      gets (s);
      if (s[0] == '\0')
	return j;
      p1 = s;
      while (*p1 && isspace (*p1))
	p1++;
      while (*p1)
	{
	  if ((*p1 != '0') && (*p1 != '.'))
	    break;
	  if (*p1 == '.')
	    decflag++;
	  if (*p1 == '0')
	    zeroflag++;
	  p1++;
	  if (!*p1 && ((decflag == 0) && zeroflag))
	    return (0);
	}
    }
  while (!(i = atoi (s)));
  return i;
}




double 
get_double (x)
     double x;
{
  char s[UGET_STRLEN], *p1;
  int decflag, zeroflag;
  double retx;
  do
    {
      decflag = zeroflag = 0;
      if (fflush (stdin))
	printf ("flush error\n");
      gets (s);
      if (s[0] == '\0')
	return x;
      p1 = s;
      while (*p1 && isspace (*p1))
	p1++;
      while (*p1)
	{
	  if ((*p1 != '0') && (*p1 != '.'))
	    break;
	  if (*p1 == '.')
	    decflag++;
	  if (*p1 == '0')
	    zeroflag++;
	  p1++;
	  if (!*p1 && (decflag <= 1 && zeroflag))
	    return (0);
	}

    }
  while (!(retx = atof (s)));
  return retx;
}

unsigned 
get_unsigned (uu)
     unsigned uu;
{
  unsigned long ul;
  unsigned long get_ulong (unsigned long u);
  while ((ul = get_ulong ((unsigned long) uu)) > UINT_MAX);

  return (unsigned) ul;

}

signed char 
get_signedchar (gch)
     int gch;
{
  int c;


  while (((c = get_integer ((signed char) gch)) > SCHAR_MAX) || (c < SCHAR_MIN));
  return (signed char) c;

}


unsigned long 
get_ulong (j)
     unsigned long j;
{
  char s[UGET_STRLEN], *p1, *endp;
  int decflag, zeroflag;
  do
    {
      decflag = zeroflag = 0;
      if (fflush (stdin))
	printf ("flush error\n");
      gets (s);
      if (s[0] == '\0')
	return j;
      p1 = s;
      while (*p1 && isspace (*p1))
	p1++;
      while (*p1)
	{
	  if ((*p1 != '0') && (*p1 != '.'))
	    break;
	  if (*p1 == '.')
	    decflag++;
	  if (*p1 == '0')
	    zeroflag++;
	  p1++;
	  if (!*p1 && ((decflag == 0) && zeroflag))
	    return (0);
	}

    }
  while (!strtoul (s, &endp, 10));
  return strtoul (s, &endp, 10);
}


void 
get_string (str)
     char *str;
{
  char d[UGET_STRLEN];
  if (fflush (stdin))
    printf ("flush error\n");
  gets (d);
  if (d[0] == '\0')
    return;
  strcpy (str, &d[0]);
  return;
}


long 
get_long (j)

     long int j;

{
  char s[UGET_STRLEN], *p1;
  int decflag, zeroflag;
  do
    {
      decflag = zeroflag = 0;
      if (fflush (stdin))
	printf ("flush error\n");
      gets (s);
      if (s[0] == '\0')
	return j;
      p1 = s;
      while (*p1 && isspace (*p1))
	p1++;
      while (*p1)
	{
	  if ((*p1 != '0') && (*p1 != '.'))
	    break;
	  if (*p1 == '.')
	    decflag++;
	  if (*p1 == '0')
	    zeroflag++;
	  p1++;
	  if (!*p1 && ((decflag == 0) && zeroflag))
	    return (0);
	}

    }
  while (!atol (s));
  return atol (s);

}


static char *
uget_gets (s)
     char * s;
{
  if (! fgets (s, UGET_STRLEN-2, stdin)) 
    {
      fprintf 
        (stderr,
           "usr_get.c: uget_gets(): fgets() failure, returning empty string.\n"
        );
      s[0] = '\0';
      return s;
    }
  if (strchr (s,(int)'\n')) * strchr(s,(int)'\n') = '\0';
  if (strchr (s,(int)'\r')) * strchr(s,(int)'\r') = '\0';
  return s;
}


