#ifndef lob_h
#define lob_h
#ifdef DOTO_ID
static char Idlob_h[] =
"$Id: cplob.h_v 1.1 1997/03/07 01:58:37 jhl Exp jhl $";
#endif
#endif

/*
$Log: cplob.h_v $
 * Revision 1.1  1997/03/07  01:58:37  jhl
 * Initial revision
 *
*/

/* 
   Copyright (C) 1997  James H. Lowe, Jr.
   May be copied under terms of GNU GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

/* LOB: character pointer list object  */

#define CPLOB_NINITLENGTH 16
#define CPLOB_NLENGTHINCR 8

typedef struct
{
  int nlen;
  int nused;
  size_t width;  
  char * (*list); 
} CPLOB;

typedef void (*CPLOB_F)(void *);

/*-------------------------------------------------------------*/
/*------- CPLOB  API (PUBLIC FUNCTIONS)------------------------*/

CPLOB * cplob_open ( int nobj,  CPLOB * copy_from );
int cplob_close ( CPLOB * strb);
CPLOB * cplob_reopen ( int new_nobj, CPLOB * strb );
char ** cplob_additem (CPLOB * lob, int index, char ** addr);
char * cplob_val (CPLOB * lob, int index);
char ** cplob_insertitem (CPLOB * lob, int index, char ** val_addr);
char * cplob_deleteitem (CPLOB * lob, int index );
char * cplob_appendstring (CPLOB * lob, char * str );
char * cplob_addstring (CPLOB * lob, int index, char * str );


