#ifndef cplob_c
static char Idlob_c[] =
"$Id: cplob.c_v 1.1 1997/03/07 01:58:33 jhl Exp jhl $";
#endif

/*
$Log: cplob.c_v $
 * Revision 1.1  1997/03/07  01:58:33  jhl
 * Initial revision
 *
*/

/* 
   Copyright (C) 1997  James H. Lowe, Jr.
   May be copied under terms of GNU GPL.
*/
/* CPLOB: character pointer list object */

#include "cplob.h"


/*------------ public API routines ------------------------- */

CPLOB * cplob_open ( int nobj, CPLOB * copy_from )
{
  int i; 
  CPLOB * lob;

  lob = (CPLOB *) malloc ( sizeof (CPLOB) );
  if (lob == (CPLOB *)(NULL))
    return (CPLOB*)(NULL);

  if (nobj <= 0)
    nobj=CPLOB_NINITLENGTH;

  lob->nlen= nobj;
  if ( (lob->list=(char **) malloc ( nobj * sizeof(char*) )) == NULL )
    return (CPLOB*)(NULL);
  lob->width=sizeof(char*);
  lob->nused=0;
  for (i=0; i<nobj; i++) *(lob->list + ( i )) = (char *)(NULL);
  return lob;
}

int cplob_close ( CPLOB * lob )
{
  int i;

  for (i=0; i<lob->nused; i++)
        if ( * (lob->list + ( i )) )  free (* (lob->list + (i))); 
  free (lob);
  return 0;
}

CPLOB * cplob_reopen ( int new_length, CPLOB * lob )
{
  char ** tmpstr;
  int i;

  if (new_length <= 1)
    new_length = 2;
  
  if ( new_length > lob -> nlen ) {
     tmpstr = (char**) malloc ( (size_t) ((new_length) * lob->width) );
     if (! tmpstr )
        return (CPLOB *)(NULL);
     for (i=0; i<new_length; i++)  *(tmpstr + ( i )) = (char *)(NULL)  ;
     memmove (tmpstr, lob->list,  lob->nused * lob->width );
     
     for (i=new_length; i<lob->nused; i++)
        if ( * (lob->list + ( i )) )  free (* (lob->list + (i))); 
     
     free (lob->list);
     lob->list=tmpstr;
     lob->nlen = new_length;
  } else {
     for (i=new_length; i<lob->nused; i++)
        if ( * (lob->list + ( i )) )  free (* (lob->list + (i))); 
     lob->nlen = new_length;
     lob->nused = new_length; 
  } 
  return lob;
}


char ** cplob_additem ( CPLOB * lob, int index, char ** addr )
{
  CPLOB * l;
  if ( index + 1 > lob->nlen )
     l=cplob_reopen ( index + 1 + CPLOB_NLENGTHINCR, lob);     

  if ( index < lob->nused  && *(lob->list + ( index)) )  free (* (lob->list + ( index))); 
 
  memmove ( lob->list + ( index ) , addr, lob->width ); 

  if (index + 1 > lob->nused)
    lob->nused = index + 1;
  return (char **)(lob->list + ( index ));
}

char * cplob_val ( CPLOB * lob, int index )
{
  return *(lob->list + ( index));
}

char **  cplob_insertitem ( CPLOB * lob, int index, char ** addr)
{
  if (lob->nused + 1 > lob->nlen )
     cplob_reopen ( lob->nlen + CPLOB_NLENGTHINCR, lob);
  if (index  < lob->nused ) {
    memmove ( lob->list + ((index + 1)), lob->list + (index ), lob->width);
    memmove ( lob->list + (index), addr, lob->width);
    (lob->nused)++;
  }
  else {
    memmove ( lob->list + (index), addr, lob->width);
    lob->nused = index + 1;
  }
  return (char **)(lob->list + ( index));
}


char * cplob_deleteitem ( CPLOB * lob, int index )
{
  char *p;

  if (index + 1 > lob->nused)
    return (void*)lob;
  if (lob->nused < 1)
    return (void*)lob;
  if ( index < lob->nused  && *(lob->list + ( index)) )  free (* (lob->list + ( index))); 
  p=(char*)(*(lob->list + ( index)));
  if ( index < lob->nused - 1 )
     memmove (lob->list + (index), lob->list + (index + 1), (lob->nused - index - 1) * lob->width );
  lob->nused--;
  return p;
}


char * cplob_appendstring ( CPLOB * cplob, char * str )
{
   char *p;

   p= (char*) malloc ( strlen (str) + 1 );
   if ( !p ) return p;
   strcpy ( p, str);
   return * cplob_additem ( cplob, cplob->nused, &p );
}

char * cplob_addstring ( CPLOB * cplob, int index, char * str )
{
   char *p;

   p= (char*) malloc ( strlen (str) + 1 );
   if ( !p ) return p;
   strcpy ( p, str);
   return * cplob_additem ( cplob, index, &p );
}


