#!/bin/sh
IDSTRING="\$Id: header.sh_v 1.7 1997/02/01 18:09:39 jhl Exp $"

if [ $# -ge 1 ]; then
  idstr="$1"
else
  idstr="$IDSTRING"
fi

LOGFILE="${SHAK_LOGPATH}/${SHAK_LOGBASENAME}${SHAK_TAPENUMBER}${SHAK_SHAKTYPE}_`date -u +%y%m%d%H%M`"
echo $LOGFILE
echo -n "#" | ${SHAK_USERPATH}/lib/shak0_write_file ${SHAK_LOGHOST} ${LOGFILE}

export LOGFILE idstr
(
cat <<EOF
# NEW BACKUP LOG
# $SHAK_SHAKHEADER
# BACKUP DATE:`date`
# ${idstr}
# Backup filter date: $SHAK_SHAKDATE
# Backup filter time: $SHAK_TIME_T
# FILEARGS : $FILEARGS
# COMMAND  :  $FCMD
EOF
) |
${SHAK_USERPATH}/lib/shak0_append_file ${SHAK_LOGHOST} ${LOGFILE}

echo "# Backup filter date: $SHAK_SHAKDATE" 1>&2
echo "# Backup filter time: $SHAK_TIME_T" 1>&2

