#!/bin/sh
# $Id: footer.sh_v 1.4 1996/04/14 19:58:32 jhl Exp $

status=$1
blocks=$2

if [ $status -eq 0 ]; then
  echo "Backup complete, exit status 0"
  echo "#Backup successful. `date`"| ${SHAK_USERPATH}/lib/shak0_append_file ${SHAK_LOGHOST} ${LOGFILE}
  echo "#Tape number: ${SHAK_TAPENUMBER} <---" |
  ${SHAK_USERPATH}/lib/shak0_append_file ${SHAK_LOGHOST} ${LOGFILE}
  mail -s "Backup succeeded: $blocks" root <<EOF
Backup Succeeded.
$SHAK_SHAKHEADER
EOF

  exit 0


else
  echo "###Program exception. `date`" | ${SHAK_USERPATH}/lib/shak0_append_file ${SHAK_LOGHOST} ${LOGFILE}
  echo "###Tape number: ${SHAK_TAPENUMBER} <---" |
  ${SHAK_USERPATH}/lib/shak0_append_file ${SHAK_LOGHOST} ${LOGFILE}
  echo "Exception indicated by exit status." 1>&2
  mail -s "Backup failed: $blocks" root <<EOF
Backup Failed: exit status $status
$SHAK_SHAKHEADER
EOF

  exit $status
fi


