#!/bin/sh
Id_file="\$Id: backuplocal.sh_v 1.2 1997/01/15 01:46:39 jhl Exp $"
IDSTRING="$Id_file"
trap 'echo __SIGTERM__ 1>&2; exit 1' 1 2 15

	# The id string above indentifies this file.
	# Changing the trunk revision will cause a reset of
	# the filter date for this backup set.

	# This is the block size that becomes the data buffer
	# length that is written with each write(3) system call.
	# Typical good values range from 1024 to 32768
BLOCKSIZE_STWRITE=1024

	# This is the number of bytes that are accumulated on the 
	# tape host before the tape gets written.  This will cause
	# the tape to stream for this amount of data then stop and wait
	# for the next accumulated block.  This is preferable to high
	# start/stop frequency operation which may occur with slow
	# hardware and remote backups.  Set this to as high a value
	# as possible based on your physical memory size.
BLOCKSIZE_ACCUM=4194304

	# BLOCKSIZE_ACCUM and BLOCKSIZE_STWRITE should divide 
	# to a whole integer (evenly).


	# This is the archive command.  It reads a list of
	# files to backup.
FCMD="cpio -o -H crc"

	# This is the root directory to backup
BACKUPROOT=/

	# These are the files to backup.
	# They should always present a list
	# with relative path prefix. i.e ./ never /
FILEARGS=" \
./home \
./usr/local \
( \
-path "'\./usr/local/src/other/slackware'" -o \
-regex "'\./usr/src/.*\.o$'" \
)"
	# The 4 lines above form the excluded file set.
	# In this case it probably doesn't match anything and
	# is shown only as an example.

# End of configuration section.
###########################################################
# Nothing need be editted below.

export IDSTRING
export FILEARGS
export FCMD
export BACKUPROOT
export BLOCKSIZE_STWRITE
export BLOCKSIZE_ACCUM

${SHAK_USERPATH}/backup.common "$@"
 
exit $?

