static char Id_filesize_c[] =
"$Id: filesize.c_v 1.2 1995/10/06 23:36:37 jhl Exp $";

/* 
   Copyright (C) 1995  James H. Lowe, Jr.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>

#define LINELEN 3000

int main ()
{

  char line[LINELEN]; 
  off_t si;
  struct stat st;



  while (fgets (line, LINELEN - 1, stdin) != (char *) (NULL))
    {
      if (strlen (line) >= LINELEN - 2)
	{
	  fprintf (stderr, "filesize: line too long : %s\n", line);
	}
      else
	{
	  if (lstat (strtok (line, "\n\r"), &st) == 0)
	    {
              if ( S_ISREG (st.st_mode) )
                  si = st.st_size;
              else
                  si = 0;
              fprintf ( stdout, "%-10ld %-20ld %s\n",  (long)st.st_blocks , (long)si, line );
            }
	   else 
	     fprintf (stderr,"\nmtimefilter: lstat failed: %s\n", line);
	}
    }
  exit (0);
}
