#!/bin/sh
# $Id$

# Test program for shak.

# arg1 is a list of tests.


testlist=$1

case $testlist in
	testlist.0)
		rm -fr var
		cp -pr var.0 var
		;;
	testlist.1)
		rm -fr var
		mkdir var
		mkdir var/index
		mkdir var/log
		;;
esac

outputname=./${testlist}.out
>$outputname


# Test 1: the -q option and trivial.sh
# Test 2: special character protection and -E switch
# Test 3: -E switch
# Test 4: query
# Test 5: query -p option
i=1

cat $testlist | egrep -v '^#' | egrep -v '^$' | while read test
do
	echo "S$i $test" 1>>$outputname 2>&1
	echo "Running Test $i: $test" 1>&2
	sh -c "$test" 1>>$outputname 2>&1 </dev/null
	if [ $? -ne 0 ]; then
		echo "E$i $test" 1>>$outputname 2>&1
	else
		echo "        $test --  exit value O." 1>&2
		echo "        $test --  exit value O." 1>>$outputname 2>&1
	fi
	echo "F $test" 1>>$outputname 2>&1
	i="`expr $i + 1`"
done

