#ident "@(#)sush.c	1.1"
/* sush - exec() the bourne shell to execute an analog shell of this program,
	after setting the real user id and the real group id to the owner ID
	and group ID, respectivly, of the analog shell program.  Each is
	set iff the appropriate setuid()/setgid() bit is on for the
	analog program file. */

/*
	sush, Set User-ID Shell, Revision 1.0

	Copyright (c) 1994, Albert John FitzPatrick, III

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 1, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Change History:
      03/06/92 00:24 AJF Fixed declaration/usage of xarg to be
				"char **xargv".
			 Removed setuid(geteuid()).  That is not what we want
				to do.  
      03/07/92 13:06 AJF Changed to setuid(uid(analog)) and to
				setgid(gid(analog)).
			 Restricted access to analog program based upon the
				permission bits of the analog program.
      03/08/92 14:27 AJF Fixed to reset effective user and group ID's iff
				they are not set from the analog program's.
				This is important; root privledges must be
				removed.
      05/12/94 10:36 AJF Changed SHDIR from "/usr/bin" to "/usr/local/bin".
			 Placed the program under the GNU General Public
				License.

      05/16/96 20:04 jhl Integrated with shak(8) by adding line
                         #include "config.h"
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#define SHDIR "/usr/local/bin/"
#define SHSUFFIX ".sh"

#include "config.h"

main(argc, argv, envp)
	int argc;
	char *argv[];
	char *envp[];
{
	char *malloc();
	char *basename;		/* Ptr to base name of command */
	char *shCommand;	/* Ptr to name of analog shell script */
	char **xargv;		/* Ptr to new argv array */
	struct stat shStat;

	if (argc > 0) {

		/* Generate the name of the analog bourne shell script. */

		basename = argv[0];
		basename = &basename[strlen(basename) - 1];
		while (basename > argv[0] && *(basename - 1) != '/') {
			basename--;
		}
		if ((shCommand = malloc(strlen(SHDIR) + strlen(basename)
			+ strlen(SHSUFFIX) + 1)) == (char *) NULL) {
			fprintf(stderr, "%s: malloc() failed.\n", argv[0]);
			exit(1);
		}
		strcpy(shCommand, SHDIR);
		strcat(shCommand, basename);
		strcat(shCommand, SHSUFFIX);

		/* Restrict access to analog program based upon the analog
		   program's permission bits. */

		if (access(shCommand, 4 | 1) != 0) {
			fprintf(stderr, "%s: access denied to %s.\n",
				argv[0], shCommand);
			exit(1);
		}

		/* Generate the argument list for the bourne shell script. */

		if ((xargv = (char **) malloc((argc + 2) * sizeof(char *))) == (char **) 0) {
			fprintf(stderr, "%s: malloc() failed.\n", argv[0]);
			exit(1);
		}
		xargv[argc + 1] = (char *) 0;
		while (argc--)
			xargv[argc + 1] = argv[argc];
		xargv[1] = shCommand;

		/* Assume the appropriate user ID and group ID. */
		/* BE CERTAIN TO REMOVE ROOT PRIVLEDGES. */

		if (stat(shCommand, &shStat) != 0) {
			fprintf(stderr, "%s: cannot stat() %s.\n",
				argv[0], shCommand);
			exit(1);
		}

		if (shStat.st_mode & S_ISGID)
			setgid(shStat.st_gid);
		else
			setgid(getgid());

		if (shStat.st_mode & S_ISUID)
			setuid(shStat.st_uid);
		else
			setuid(getuid());

		/* exec() the bourne shell as the appropriate user. */

		xargv[0] = "/bin/sh";
		execve(xargv[0], xargv, envp);
		xargv[0] = "/usr/bin/sh";
		execve(xargv[0], xargv, envp);

		/* Express our regrets and then bug out. */

		fprintf(stderr, "%s: Cannot execute %s.\n",
			argv[0],
			shCommand);
		exit(2);
	}

	exit(3);
}
