static char Id_shak_mkstrtime_c[] =
"$Id: shak_mkstrtime.c_v 1.2 1996/05/08 03:17:38 jhl Exp jhl $";

/* 
   Copyright (C) 1996  James H. Lowe, Jr.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>

#define LINELEN 3000

time_t mkstrtime ( char * datestring, int debug );

int main (int argc, char *argv[])
{
  char  datestring[LINELEN], * c ; 
  time_t testtime;

  argv++; argc--;
  if (argc == 0) {
    testtime = time ((time_t *)(NULL));
    fprintf (stdout,"%ld\n", (long)testtime );
    exit (0);
    }
  else
    {
      if (strlen (*argv) >= LINELEN -1L) {
        fprintf (stderr,"mkstrtime: line too long.\n" );
  	fprintf (stdout,"-1\n" );
        exit (1); 
      }
      strcpy (datestring, *argv);
      c=datestring;

      while ( *c && isdigit ( (int) ( *c ) )) c++;
      if ( *c == (char *)(NULL) ) {
         fprintf (stdout,"%s\n", datestring );
         exit (0);
      } else {
          if ( (testtime = mkstrtime ( datestring, 0 )) < 0 ) {
            fprintf (stderr,"mkstrtime: mkstrtime failure ( %s ).\n", datestring );
  	    fprintf (stdout,"%ld\n",(long)testtime );
            exit (1);
          }
          fprintf (stdout,"%ld\n",(long)testtime );
          exit (0);
      }
    }
}

