#!/bin/sh
# (c) Copyright 1995, 1996  James H. Lowe, Jr.
#
#$Id: shak.sh_v 2.10 1997/03/23 16:11:52 jhl Exp $
#
#   October 1995
#
#   SHAK is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# ----------------------------------------------------------------------

# some bootstrapping assumptions
shak_libpath="`echo $0 | sed -e 's@\(.*\)/[^/]*$@\1@'`"
export shak_libpath
SHAK_REMSH=${SHAK_REMSH="rsh"}
export SHAK_REMSH

# Make the tmp directory
# Global temporary filename name components.
SHAK_PID=$$
shak_tmpdir="/usr/tmp/shak_${SHAK_PID}"
shak_tmpbasename="${shak_tmpdir}/_"

# These files belong to asyncronously running programs and are
# deleted by those programs.
shak_tmpbasename_a="/usr/tmp/shak.${SHAK_PID}"

mkdir ${shak_tmpdir}
if [ $? -ne 0 ]; then
	echo "shak: tmpdir failed." 1>&2
	exit 1
fi

#
# STATIC CONFIGURATION PARAMETERS and POLICY DEFAULTS
#    `shak__' variables are the defaults for the `shak_'
#     variables

shak_errmon="0"
SHAK_stderrmon=no
SHAK_stderrmonlog=yes
SHAK_stderrmonmail=yes
SHAK_stderrmonterm=no

SHAK_CFG_DIR="/usr/etc/shak"
SHAK_CFG_DIR_LC="/etc/shak"

SHAK_REALLOGIN="`id -nur`"
SHAK_REALID="`id -ur`"

SHAK_TRUSTED_GROUP=shak

	#  mt(1) defaults: the name of the mt command.
SHAK_MT="shak_mt"

	#  The path used for remote backups.
SHAK_clientpath="/bin:/usr/bin:/sbin:/usr/local/bin"


	# The name of the getopt(1) program.
shak_getopt="/usr/bin/getopt"

	# The base name component of a tape index file.
shak_indexbase="INDEX_"


	# The directory where lock files will be written.
shak_lockdir="/var/lock"

	# The wake-up frequency (sec) and the total wait time.
	# This is used by a waiting backup.
shak_chkfreq=25
shak_waittime=14400

	# This is the default user that gets the notification mail
shak__mailuser="root"

	# Set this default for notification mail
shak__mailflag="yes"

	# Only root can make a new tape, fix a tape.
	# Requires the variable USER be "root" and the real uid
	# must be root.
shak_rootonly0="no"

	# Internal debugging levels
	# set to 2 and yes for debugging.
shak__debugQ=1
shak__debug_locks=no

	# SHAK_USERID is set by the trusted parent process and is the uid 
	# of the user before changing priviledge level.
SHAK__USERID=""

	# SHAK__USERLOGIN was the login before changing priviledge level.
SHAK__USERLOGIN="nobody"

	# SHAK__REALLOGIN is the login underwhich this program is running.
SHAK__REALLOGIN="nobody"

shak__errmon_fatal='I/O|Error|ERROR|error|fail|fatal'
shak__errmon_warn='^..*$'
shak__errmon_begin='__BEGIN__\r\n'
shak__errmon_end='__END__\r\n'
shak__errmon_sigterm='__SIGTERM__\r\n'
shak__errmon_maxwarn='25'
shak__errmon_timeout1='-1'

export SHAK_MT
export shak_getopt
export shak_indexbase
export SHAK_clientpath
export SHAK_PID
export shak_tmpdir
export shak_tmpbasename
export shak_tmpbasename_a
export shak_lockdir
export shak_chkfreq
export shak_waittime
export shak_rootonly0
export SHAK_TRUSTED_GROUP

	# Set the signal handler.
trap '${shak_libpath}/shak_shutdown; exit $?' 1 2 15

	# make a empty temporary file.
TMPFILE_ENV=${shak_tmpbasename}.config0
umask 077
>$TMPFILE_ENV

	# Make a list of pre-existing configuration item settings.
env | egrep -e SHAK_SHAKPATH -e SHAK_USERPATH -e SHAK_TAPEHOST -e SHAK_TAPEDEVICE \
-e SHAK_INDEXPATH -e SHAK_LOGPATH -e SHAK_LOGBASENAME -e SHAK_REMSH -e SHAK_DOMAIN \
-e SHAK_tapesecure -e SHAK_devicesecure -e SHAK_sitesecure \
-e SHAK_LOGHOST -e SHAK_INDEXHOST -e SHAK_DEFAULTTEST -e SHAK_TAPECAPACITY -e SHAK_USEHEADERS -e SHAK_MT_EOM |
sed -e 's@=.*@@' >>$TMPFILE_ENV


	# ** WatchDog Timer Defaults **
	#	Set to zero to disable watchdog timer.
	#--------------------------------------------------
# Time to perform any mt(1) tape operation
	delay__tape=6000
# Time to read a disk file
	delay__readfile=120
# Time to write a disk file
	delay__writefile=120
# Time to read a tape header file
	delay__readtape=120
# Time to write  to the tape, low value
	delay__writetape0=240
# Time to write  to the tape, high value
	delay__writetape1=2000
# Time to write a header to tape
	delay__writeheader=120
# Time to run the User backup
	delay__userbackup=0

#################################################################################
## END OF POLICY ITEMS  and defaults ############################################
#################################################################################

#
#  USER SETTINGS CONFIGURABLE VIA PARENT ENVIRONMENT
#

delay_tape=${delay_tape-${delay__tape}}
delay_readfile=${delay_readfile-${delay__readfile}}
delay_writefile=${delay_writefile-${delay__writefile}}
delay_readtape=${delay_readtape-${delay__readtape}}
delay_writetape0=${delay_writetape0-${delay__writetape0}}
delay_writetape1=${delay_writetape1-${delay__writetape1}}
delay_writeheader=${delay_writeheader-${delay__writeheader}}
delay_userbackup=${delay_userbackup-${delay__userbackup}}

	# SHAK_USERID variable must be securely set by the
	# parent of this script if shak is to be secure.
#SHAK_USERID=${SHAK_USERID-${SHAK__USERID}}
SHAK_USERID=${SHAK_REALID}

	# USER variable must be securely set by the
	# parent of this script if shak is to be secure.
#SHAK_USERLOGIN=${USER-${SHAK__USERLOGIN}}
SHAK_USERLOGIN=${SHAK_REALLOGIN}

	# Set SHAK_REALLOGIN to itself if set, or the default if
	# not set.  This should be set by the trusted parent process.
SHAK_REALLOGIN=${SHAK_REALLOGIN-${SHAK__REALLOGIN}}

	# Set the shak_mailuser variable.
shak_mailuser=${shak_mailuser-${shak__mailuser}}

	# Set this to yes to enable notification mail, of no
	# to disable.
shak_mailflag=${shak_mailflag-${shak__mailflag}}

shak_debugQ=${shak_debugQ-${shak__debugQ}}

shak_debug_locks=${shak_debug_locks-${shak__debug_locks}}

shak_errmon_fatal=${shak_errmon_fatal-${shak__errmon_fatal}}
shak_errmon_warn=${shak_errmon_warn-${shak__errmon_warn}}
shak_errmon_begin=${shak_errmon_begin-${shak__errmon_begin}}
shak_errmon_end=${shak_errmon_end-${shak__errmon_end}}
shak_errmon_sigterm=${shak_errmon_sigterm-${shak__errmon_sigterm}}
shak_errmon_maxwarn=${shak_errmon_maxwarn-${shak__errmon_maxwarn}}
shak_errmon_timeout1=${shak_errmon_timeout1-${shak__errmon_timeout1}}

export shak_debug_locks
export shak_mailuser
export shak_mailflag
export shak_debugQ
export delay_tape
export delay_readfile
export delay_writefile
export delay_readtape
export delay_writetape0
export delay_writetape1
export delay_writeheader
export delay_userbackup
export SHAK_USERLOGIN
export shak_errmon_fatal
export shak_errmon_warn
export shak_errmon_begin
export shak_errmon_end
export shak_errmon_sigterm
export shak_errmon_maxwarn
export shak_errmon_timeout1

#################################################################################
## END OF USER ENVIRONMENT OPTIONS ##############################################
#################################################################################

	# The usage instructions.
shak_usage ()  {
          echo "Usage: shak [ options ] subcommand [args ...]" 1>&2 
          echo "shak [options...] <subcommand> [args ...]" 1>&2 
          echo "shak [options...] run  [-r stderrfile] [-h  host]  -t  type  file" 1>&2
          echo "shak [options...] testtape [-abmx] [ -f file] [-o file] [command]" 1>&2
          echo "shak [options...] copyheader [-f file]" 1>&2
          echo "shak [options...] newtape [-i tape_number] [-c]" 1>&2
	  echo "shak [options...] fix [-c|-l] [-m number] {-f|-t}" 1>&2
	  echo "shak [options...] query {-r|-s filespec }" 1>&2
	  echo "shak [options...] admin -o arg" 1>&2
          rm -fr /usr/tmp/shak_${SHAK_PID}
}


	#  Set some defaults 
shak_hack_1=0
shak_async="0";
shak_rsh_is_sh="1";
shak_nouserconfig="0"
shak_quickrun="0"
shak_no_run_user="0"
shak_expert="0";
shak_trunclevel="0"
shak_debug="0"
shak_interactive="0"
shak_noindexfile="0"
shak_minimal="0"
userconfig=""
shak_noreadconfig="0"
shak_noheader="0"
shak_userenv="0"
shak_headeroverride="0"
shak_env="0"
shak_Q=0
shak_verifyi="0"
SHAK_TAPENUMBER=""
SHAK_tapenumber=""
SHAK_MTHOST=""
shak_batchmode=0
shak__batchmode=0
SHAK_TAPECAPACITY=""
SHAK_DTAPECAPACITY="0"
SHAK_configfile_host=localhost
run_space_command=""
shak_catcherror=1

export SHAK_USERLOGIN
export SHAK_REALID
export SHAK_TAPENUMBER
export SHAK_tapenumber
export SHAK_TAPECAPACITY
export SHAK_DTAPECAPACITY
export shak_verifyi
export shak_batchmode
export shak__batchmode
export shak_debugQ
export shak_errmon
O_TAPEHOST=""
O_TAPEDEVICE=""
export SHAK_stderrmon
export SHAK_stderrmonlog
export SHAK_stderrmonmail
export SHAK_stderrmonterm
export SHAK_configfile_host
export run_space_command
export shak_catcherror

shak_defaults () {

SHAK_NULLDATE="1970/01/01 00:00:00 UTC"
SHAK_NULLTIME="0"
set ${SHAK_SHAKPATH="/usr/local/lib/shak"}
set ${SHAK_USERPATH="/usr/local/sbin/backup/shak"}
SHAK_HOST="localhost"
if [ -f "/bin/hostname" ]; then
   SHAK_HOST="`/bin/hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
else
   SHAK_HOST="`hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
fi

set ${SHAK_TAPEHOST="localhost"}
set ${SHAK_INDEXHOST="localhost"}
set ${SHAK_LOGHOST="localhost"}
set ${SHAK_TAPEDEVICE="/dev/nst0"}
set ${SHAK_REMSH="rsh"}
set ${SHAK_LOGPATH="/var/adm/backup/shak"}
set ${SHAK_LOGBASENAME="LOG_"}
set ${SHAK_MT_EOM="eod"}

# Default tape capacity
set ${SHAK_DTAPECAPACITY=0}

if [ ! "$SHAK_TAPECAPACITY" ]; then
	SHAK_TAPECAPACITY=$SHAK_DTAPECAPACITY
fi

if [ ! "$SHAK_TAPENUMBER" ]; then
	SHAK_TAPENUMBER="NULL"
fi

SHAK_SHAKDATE="${SHAK_NULLDATE}"
SHAK_TIME_T="${SHAK_NULLTIME}"
SHAK_SHAKTYPE="NULL"

set ${SHAK_INDEXPATH="/var/adm/backup/shak"}
SHAK_LIBPATH="${SHAK_SHAKPATH}/lib"
SHAK_LOGNAME="${SHAK_LOGPATH}/${SHAK_LOGBASENAME}"
set ${SHAK_DOMAIN="domainname"}
SHAK_OVERWRITE="0"
set ${SHAK_DEFAULTTEST="b"}
set ${SHAK_USEHEADERS=yes}

set ${SHAK_devicesecure=no}
set ${SHAK_tapesecure=no}
set ${SHAK_sitesecure=no}

export SHAK_DOMAIN
export SHAK_TAPENUMBER
export SHAK_LOGPATH
}

shak_hack_1=1
shak_configure () {
. $shak_libpath/shak_config $1 $2 $3 
return
}
shak_hack_1=0

PROG=$0

# separate the shak args from the subprogram args
# in order to keep as much as possible away from getopt
# because the call strips the quotes. Hopefully the 
# shak args are simple enough where nothing will have to
# quoted.

shakargs=""
until [ $# = 0 ];
do
	case $1 in
	      run|newtape|copyheader|testtape|fix|query|admin) 
		  break
		  ;;

              *) shakargs="$shakargs $1"
	         shift
		 ;;
        esac
done


# Run getopts
TMPFILEOPT=${shak_tmpbasename}.getopts$$
aftergetopt="`$shak_getopt i:ac:dD:Eg:hk:lmNqQrtTuUvwxy $shakargs 2>$TMPFILEOPT`"

set -- $aftergetopt "$@"


# Check for getopts failure.
if [ $? != 0 ]; then
   cat <$TMPFILEOPT
   /bin/rm -f $TMPFILEOPT
   shak_usage 
   exit 1
fi
grep '.' <$TMPFILEOPT
if [ "$?" = "0" ]; then
   cat <$TMPFILEOPT
   /bin/rm -f $TMPFILEOPT
   shak_usage
   exit 1
fi
/bin/rm -f $TMPFILEOPT



# Parse options
for i in $*; do
   case $1 in
     -a)
        shak_async="1";
	shift;
	;;
     -c)
	shift;
        if [ $# -ge 1 ]; then
           SHAK_TAPECAPACITY="$1"
           export SHAK_TAPECAPACITY
	   shift
	else
	  usage
	fi
	;;
     -D)
	shift;
        if [ "$1" = "-" ]; then 
     	  exit 1
        else
	  o_tapedevice="$1";
	fi
        o_tapehost="`echo "$o_tapedevice" | sed -e 's/:.*$//'`"
        o_tapedevicefile="`echo "$o_tapedevice" | sed -e 's/^.*://'`"
        if [ "$o_tapehost" = "$o_tapedevicefile" ]; then
	   O_TAPEDEVICE="$o_tapedevice"
	else
           O_TAPEHOST="$o_tapehost"
	   O_TAPEDEVICE="$o_tapedevicefile"
	fi
        shift;
	;;
     -d)
        shak_nouserconfig="1";
	shift;
	;;
     -E)
        shak_env="1";
	shift;
	;;
     -h)
        shak_rsh_is_sh="0";
	shift;
        ;;
     -i)
	shift;
        if [ $# -ge 1 ]; then
           SHAK_TAPENUMBER="`echo $1 | awk '{ printf ("%04s\n",$1) }'`"
	   SHAK_tapenumber=$SHAK_TAPENUMBER
           export SHAK_TAPENUMBER
           export SHAK_tapenumber
	   
	   shift
	else
	  usage
	fi
	;;
     -g)
        shift;
        if [ "$1" = "-" ]; then
          exit 1
        else
          userconfig="$1";
        fi
        cfghost="`echo "$userconfig" | sed -e 's/:.*$//'`"
        if [ "$userconfig" = "$cfghost" ]; then
            :
        else
                SHAK_configfile_host="$cfghost"
                userconfig="`echo "$userconfig" | sed -e 's/^.*://'`"
                export SHAK_configfile_host
        fi
        shift;
        ;;

#	shift;
#        if [ "$1" = "-" ]; then 
#     	  exit 1
#        else
#	  userconfig="$1";
#	fi
#        shift;
#	;;
     -k)
	shift;
        if [ "$1" = "-" ]; then 
     	  exit 1
        else
	  shak_trunclevel="$1";
	fi
        shift;
	;;
     -l)
        shak_noreadconfig="` expr $shak_noreadconfig + 1 `"
	shift;
	;;
     -N)
        shak_verifyi="1"
        shift;
        ;;
     -q)
        shak_quickrun="1"
        shift;
        ;;
     -Q)
        shak_noheader=2
        shak_noindexfile=1
	shak_Q=1
        shift;
        ;;
     -r)
        shak_userenv="1"
        shift;
        ;;
     -t)
        shak_noindexfile="1"
        shift;
        ;;
     -T)
        shak_noheader=1
        shift;
        ;;
     -v)
        shak_debug="` expr $shak_debug + 1 `"
        shift;
        ;; 
     -w)
	shift;
        if [ $# -ge 1 ]; then
           shak_waittime=$1
           export shak_waittime
	   shift
	else
	  usage
	fi
	;;
     -u)
        shak_interactive="1"
        shift;
        ;; 
      
     -U)
        shak_headeroverride="1"
        shift;
        ;; 
     
     -m)
        shak_minimal="1"
        shift;
        ;; 
     -x)
        shak_expert="1";
	shift;
	;;
     -y)
        shak_minimal="1"
        shak_no_run_user="` expr $shak_no_run_user + 1 `"
        shift;
        ;;
     --) shift;
         break;
	 ;;
    esac
done


# Expert mode incompatible with query modes.
if [ $shak_expert -eq  1 ]; then
	if [ $shak_Q -eq 1 -o $shak_no_run_user -ge 1 ]; then
		echo "shak: incompatible options: x with Q or y." 1>&2
		exit 1
	fi
fi



# Query modes are mutually exclusive.
if [ $shak_Q -eq 1 -a $shak_no_run_user -ge 1 ]; then
	echo "shak: incompatible options: Q with y." 1>&2
	exit 1
fi



# If not reading any config files then set some defaults
# else run the standards defaults setup function.
if [ "$shak_noreadconfig" -gt "1" ]; then
	SHAK_NULLDATE="1970/01/01 00:00:00 UTC"
	SHAK_NULLTIME="0"
	SHAK_HOST="localhost"

	SHAK_SHAKDATE="${SHAK_NULLDATE}"
	SHAK_TIME_T="${SHAK_NULLTIME}"

	if [ ! "$SHAK_TAPENUMBER" ]; then
		SHAK_TAPENUMBER="NULL"
	fi

	if [ ! "$SHAK_TAPECAPACITY" ]; then
		SHAK_TAPECAPACITY=$SHAK_DTAPECAPACITY
	fi
	
	if [ ! "$SHAK_MTHOST" ]; then
		SHAK_MTHOST="$SHAK_TAPEHOST"
	fi

	SHAK_OVERWRITE="0"
	SHAK_LIBPATH="${SHAK_SHAKPATH}/lib"
	SHAK_LOGNAME="${SHAK_LOGPATH}/${SHAK_LOGBASENAME}"
	export SHAK_LIBPATH
	export SHAK_LOGNAME
	export SHAK_DOMAIN
	export SHAK_TAPENUMBER
else
	shak_defaults
fi

export shak_minimal
export shak_debug
export shak_interactive
export shak_quickrun
export shak_noreadconfig
export shak_no_run_user
export shak_nouserconfig
export shak_async
export shak_expert
export shak_rsh_is_sh
export shak_trunclevel
export shak_noindexfile
export shak_noheader
export shak_userenv
export shak_env
export shak_Q
export shak_verifyi



# Comply with verbose execution request.
if [ "$shak_debug" -ge 2 ]; then
 set -vx
fi


# get a tmpfile name 
TMPFILE="${shak_tmpbasename}.shak$$"



# Save the arguments.  This is an attempt to be
# bourne (non-POSIX) shell compatible.
#nargs=$#
#ARGS=""
#while [ $nargs -ge 1 ];
# do
#   DOL1="`echo "$1" | sed -e 's|:|\\\072|'`"
#   ARGS="$ARGS${DOL1}:"
#   shift
#   nargs="`expr $nargs - 1`"
# done
#OLDIFS="$IFS"



# Read the configuration files.
if [ $shak_noreadconfig -ge "1" ]; then
   if [ "$userconfig" ]; then
     if [ -f "$userconfig" ]; then
       shak_configure $userconfig $TMPFILE $TMPFILE_ENV
       . $TMPFILE 
       /bin/rm -f $TMPFILE
     else
       echo "shak: $userconfig not found." 1>&2  
       exit 1
     fi
   fi
else
   if [ -f ${SHAK_CFG_DIR}/shak.conf ]; then
     shak_configure ${SHAK_CFG_DIR}/shak.conf $TMPFILE $TMPFILE_ENV
     . $TMPFILE 
     /bin/rm -f $TMPFILE
   fi
   if [ -f ${SHAK_CFG_DIR_LC}/shak.conf ]; then
     if [ "$SHAK_sitesecure" = "yes" ]; then
        . ${shak_libpath}/shak_export
        umask 077
        >$TMPFILE_ENV
	env | egrep -e SHAK_SHAKPATH -e SHAK_USERPATH -e SHAK_TAPEHOST -e SHAK_TAPEDEVICE \
	-e SHAK_INDEXPATH -e SHAK_LOGPATH -e SHAK_LOGBASENAME -e SHAK_REMSH -e SHAK_DOMAIN \
	-e SHAK_LOGHOST -e SHAK_INDEXHOST -e SHAK_DEFAULTTEST -e SHAK_TAPECAPACITY -e SHAK_USEHEADERS \
	-e SHAK_sitesecure -e SHAK_tapesecure -e SHAK_devicesecure -e SHAK_MT_EOM |
	sed -e 's@=.*@@' >>$TMPFILE_ENV
     fi
     shak_configure ${SHAK_CFG_DIR_LC}/shak.conf $TMPFILE $TMPFILE_ENV
     . $TMPFILE 
     /bin/rm -f $TMPFILE
   fi
   if [ "$userconfig" ]; then
     if [ -f "$userconfig" ]; then
       shak_configure $userconfig $TMPFILE $TMPFILE_ENV
       . $TMPFILE 
       /bin/rm -f $TMPFILE
     else
       echo "shak: $userconfig not found." 1>&2  
       exit 1
     fi
   fi
fi

/bin/rm -f "$TMPFILE_ENV"


# Check for imbedded host in the tapedevice variable e.g  localhost:/dev/nst0
devhost="`echo "$SHAK_TAPEDEVICE" | sed -e 's/:.*$//'`"
if [ "$SHAK_TAPEDEVICE" = "$devhost" ]; then 
   :
else
        SHAK_TAPEHOST="$devhost"
        SHAK_TAPEDEVICE="`echo "$SHAK_TAPEDEVICE" | sed -e 's/^.*://'`"
        export SHAK_TAPEHOST
        export SHAK_TAPEDEVICE
fi


if [ "$SHAK_TAPEHOST" = localhost ]; then
	if [ -f "/bin/hostname" ]; then
		SHAK_TAPEHOST="`/bin/hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
	else
		SHAK_TAPEHOST="`hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
	fi
fi


# Set up some implied states.
if [ $shak_headeroverride -gt 0 ]; then
	SHAK_USEHEADERS=yes
fi

if [ $SHAK_USEHEADERS = "no" ]; then
	shak_noheader=1
fi

if [ $shak_noheader -gt 0 ]; then
	SHAK_USEHEADERS=no
fi

if [ $shak_Q -eq 1 ]; then
	SHAK_TAPEDEVICE=/dev/null
fi

#if [ $SHAK_tapesecure = "yes" ]; then
#	shak_verifyi=1
#	SHAK_TAPENUMBER="NULL"
#fi

case $SHAK_stderrmon in
      yes)
              shak_async=1
              shak_errmon=1
              export shak_async
              export shak_errmon
              ;;
esac

case $O_TAPEDEVICE in
	"")
		:
		;;
	 *)
		SHAK_TAPEDEVICE="$O_TAPEDEVICE"
		;;
esac

case $O_TAPEHOST in
	"")
		:
		;;
	 *)
		SHAK_TAPEHOST="$O_TAPEHOST"
		;;
esac

case $SHAK_DEFAULTTEST in
	-*)
		SHAK_DEFAULTTEST="`echo $SHAK_DEFAULTTEST | sed -e 's/.*\(.\)$/\1/'`"
	;;
esac

case $SHAK_DEFAULTTEST in
	a|b|t|m|x)
		:
		;;
	*)
		echo "shak: invalid testtape test" 1>&2
		exit 1
		;;
esac

# export the variables.
. ${SHAK_LIBPATH}/shak_export

rrun=0
export rrun
# Main Case Statement.
# These are the things that shak does.
case $1 in
    admin)
          shift;
	  ${SHAK_LIBPATH}/shak_admin "$@"
	  retval=$?
	  ;;
    run)  
	  shift;
	  rrun=1
	  ${SHAK_LIBPATH}/shak_run "$@"
	  retval="$?"
          ;;

    testtape)
	  shift;

	  if [ "$shak_no_run_user" -gt 1 -o "$shak_Q" -eq 1 ]; then
		:
	  else
		${SHAK_LIBPATH}/shak_waitlock $shak_waittime
		retval=$?
		if [ $retval -eq 0 ]; then
			:
		else
			exit $retval
		fi
	  fi

	  $SHAK_LIBPATH/shak_testtape "$@"
	  retval="$?"
          ;;
    newtape)
	  shift; 
	  SHAK_useheader=$SHAK_USEHEADERS
	  export SHAK_useheader
          SHAKDAT="${SHAK_LIBPATH}/shak0_date"
	  sh ${SHAK_LIBPATH}/shak_newtape "$@" "`${SHAKDAT}`"
          retval=$?
          ;;	  
    copyheader)
	  shift;
          sh $SHAK_LIBPATH/shak_copyheader "$@"
	  retval="$?"
          ;;
    fix)
	  shift;
          ${SHAK_LIBPATH}/shak_fixtape "$@"
          retval=$?
          ;;

    query)
          shift;
	  ${SHAK_LIBPATH}/shak_query "$@"
	  retval=$?
	  ;;

    *)
	  shak_usage
          exit 2
    esac

	if [ $retval -ne 0 -a $rrun = 1 ]; then
		sleep 5
		# This to avoid a close finish (race) with
		# the operations of shak_haltq
	fi

	( trap '' 1 2 15; "${SHAK_LIBPATH}/shak_unlock" ) &
	rm -fr /usr/tmp/shak_${SHAK_PID}

exit $retval

