#!/bin/sh

#$Id: install.sh_v 1.16 1996/02/15 03:00:20 jhl Exp jhl $

ans="yes"
userlogin="`id -un`"
export userlogin

cat <<EOF
SHAK INSTALLATION AND CONFIGURATION PROGRAM
-------------------------------------------
YOU WILL BE ASKED QUESTIONS ANSERABLE
BY READING THE MAN PAGE, shak.5

You can display the manpage by answering "yes"
to the following question:.

Are you currently in the 'X' graphical display envirionment
and do you want to display the man page in a xterm 
EOF
echo -n "? <$ans> "
read ans

if [ .$ans = . ]; then
  ans="yes"
fi

if [ .$ans = .yes ]; then
  if [ -f /usr/bin/groff ]; then
    NROFF=groff
  else
    NROFF=nroff
  fi
  if [ -f /usr/bin/less ]; then
    xPAGER=/usr/bin/less
  else
    xPAGER=/usr/bin/more
  fi
  
  $NROFF -T ascii -man ./proper/man/shak.5 >var/shak.man
  /usr/bin/X11/xterm -e $xPAGER var/shak.man &
   echo ""
   echo "INSTRUCTIONS: hit :q to quit xterm running $xPAGER"
   echo "press space-bar to scroll"
   echo ""
fi  

echo "Continuing ..."
ans="yes"
echo -n "Do you want to continue ? <$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
if [ ! "$ans" = "yes" ]; then
  exit 0
fi

echo " INSTALLATION QUESTIONS "

ans="/usr/tmp/testshak/shak/etc"
cat <<EOF  
Enter the directory for the local configuration file
shak.conf
(see page 4)
EOF
echo -n "<$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_CFG_DIR="$ans"

if [ -f "${SHAK_CFG_DIR}/shak.conf" ]; then
  echo "Making backup copy of ${ans}/shak.conf"
  cp  ${SHAK_CFG_DIR}/shak.conf ${SHAK_CFG_DIR}/shak.conf.bak
fi

cat <<EOF 
***********************************************************
** The file proper/bin/shak is being editted to reflect  **
** desired configuration directory.                      **     
***********************************************************
EOF

sed -e "s@SHAK_CFG_DIR_LC=\"/etc/shak\"@SHAK_CFG_DIR_LC=\"${SHAK_CFG_DIR}\"@" \
<proper/lib/shak.sh >var/shak.sh

cmp proper/lib/shak.sh var/shak.sh 1>/dev/null 2>&1
if [ ! $? -eq 0 ]; then
  echo "WARNING: the installed shak script is different from "
  echo "the stock distribution version."
  echo "This is due to your choice of config directory."
fi

#########################################################

echo ""
echo ""
echo "CONFIGURATION QUESTIONS"

echo "--------------------"
ans="`hostname -d 2>/dev/null`"
if [ "$ans" = "" ]; then
	echo "install.sh: domain name query failed, you may have trouble running tests" 1>&2
fi
cat <<EOF  
Enter your domain name (see SHAK_DOMAIN p.4 )
EOF
echo -n "<$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_DOMAIN="$ans"
export SHAK_DOMAIN

echo "--------------------"
ans="/usr/tmp/testshak/shak"
cat <<EOF  
Enter preferred location of the
shak distribution containing the lib
directory. (see SHAK_SHAKPATH p.3 ):
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_SHAKPATH="$ans"

SKconfig="`grep '#define *SHAKPATH' <proper/src/config.h | sed -e 's@#define SHAKPATH @@' -e 's@\"@@g'`"

if [ "$SHAK_SHAKPATH" = "$SKconfig" ]; then
	:
else
    echo "SHAKPATH must be the same as in proper/src/config.h , fixing..."
    echo "Re-editting proper/src/config.h"
    SKconfig0="`grep '#define *SHAKPATH' <proper/src/config.h.in | sed -e 's@#define SHAKPATH @@' -e 's@\"@@g'`"
    sed -e s@$SKconfig0@$SHAK_SHAKPATH@ <proper/src/config.h.in >proper/src/config.h
    echo "Compiling proper/bin/shak"
    make shak
    
    if [ $? = 0 ]; then
       echo "continuing ..."
    else
      echo Error in make shak
      exit 1
    fi
fi



echo "--------------------"
ans="${SHAK_SHAKPATH}/bin"
echo -n "Enter the bin directory for shak executable <$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
BIN_DIR="$ans"

echo "--------------------"
ans="${SHAK_SHAKPATH}/var/index"
cat <<EOF  
Enter the directory path for the tape index files 
(see SHAK_INDEXPATH p.4 )
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_INDEXPATH="$ans"

echo "--------------------"
ans="${SHAK_SHAKPATH}/script"
cat <<EOF  
Enter the location of user-supplied backup scripts.
(see SHAK_USERPATH p.3)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_USERPATH="$ans"

echo "--------------------"
ans="${SHAK_SHAKPATH}/var/log"
cat <<EOF  
Enter the directory where logfiles will be written.
(see SHAK_LOGPATH p. 5)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_LOGPATH="$ans"

echo "--------------------"
ans="localhost"
cat <<EOF  
Enter the hostname for the tape drive.
(see SHAK_TAPEHOST p.4 )
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_TAPEHOST="$ans"

echo "--------------------"
ans="localhost"
cat <<EOF  
Enter the hostname for the "tape index files"
(see SHAK_INDEXHOST p.4)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_INDEXHOST="$ans"

echo "--------------------"
ans="localhost"
cat <<EOF  
Enter the hostname which will receive the log files.
(see SHAK_LOGHOST p.3)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_LOGHOST="$ans"

echo "--------------------"
ans="/dev/nst0"
cat <<EOF  
Enter the no-rewind device filename on host $SHAK_TAPEHOST.
(see SHAK_TAPEDEVICE p.3 )
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_TAPEDEVICE="$ans"


echo "--------------------"
ans="LOG_"
cat <<EOF  
Enter the base filename of the logfiles that will be written to
EOF
echo "${SHAK_LOGPATH} ."
echo "(see SHAK_LOGBASENAME p. 3)"
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_LOGBASENAME="$ans"

echo "--------------------"
ans="rsh"
cat <<EOF  
Enter the remote shell program name:
  SVR4: remsh
  BSD : rsh
  Linux : rsh
(see SHAK_REMSH p. 4)
EOF
echo -n "<$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_REMSH="$ans"

echo "--------------------"
ans="yes"
cat <<EOF  
Do you want tape headers on the tape?
(see Abridged Shak Tape Format)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_USEHEADERS="$ans"

if [ $ans = yes ]; then
	ans=b
else
	ans=m
fi

echo "--------------------"
cat <<EOF  
Enter the default test type.
'b' or 'a' or 'm' or 'x' or
't' for the no-option-given test.
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_DEFAULTTEST="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want to use locking ?
(see devicesecure)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_devicesecure="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want enhanced  tape number verification ?
(see tapesecure)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_tapesecure="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want to prevent site-wide configuration
from being overridden locally?
(see sitesecure)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_sitesecure="$ans"

echo "--------------------"
ans=eod
cat <<EOF  
Enter the mt option for moving to end-of-logical-tape
(eom or eod)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_MT_EOM="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want stderr monitoring ?
(This requires expect and tcl)
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_stderrmon="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want stderr monitoring output written to
syslog ?
(requires logger(1))
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_stderrmonlog="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want stderr monitoring output mailed to
the user?
(requires mail(1))
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_stderrmonmail="$ans"

echo "--------------------"
ans=no
cat <<EOF  
Do you want stderr monitoring output echoed to 
the terminal?
EOF
echo -n "<$ans> "
 read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi
SHAK_stderrmonterm="$ans"


echo "--------------------"
echo ""
echo "SHAK_DOMAIN     :$SHAK_DOMAIN"
echo "SHAK_SHAKPATH   :$SHAK_SHAKPATH"
echo "SHAK_USERPATH   :$SHAK_USERPATH"
echo "SHAK_TAPEHOST   :$SHAK_TAPEHOST"
echo "SHAK_LOGHOST    :$SHAK_LOGHOST"
echo "SHAK_INDEXHOST  :$SHAK_INDEXHOST"
echo "SHAK_INDEXPATH  :$SHAK_INDEXPATH"
echo "SHAK_TAPEDEVICE :$SHAK_TAPEDEVICE"
echo "SHAK_REMSH      :$SHAK_REMSH"
echo "SHAK_LOGPATH    :$SHAK_LOGPATH"
echo "SHAK_LOGBASENAME:$SHAK_LOGBASENAME"
echo "SHAK_USEHEADERS :$SHAK_USEHEADERS"
echo "SHAK_DEFAULTTEST:$SHAK_DEFAULTTEST"
echo "SHAK_sitesecure :$SHAK_sitesecure"
echo "SHAK_devicesecure:$SHAK_devicesecure"
echo "SHAK_tapesecure  :$SHAK_tapesecure"
echo "SHAK_MT_EOM     :$SHAK_MT_EOM"
echo "SHAK_stderrmon  :$SHAK_stderrmon"
echo "SHAK_stderrmonmail  :$SHAK_stderrmonmail"
echo "SHAK_stderrmonlog  :$SHAK_stderrmonlog"
echo "SHAK_stderrmonterm  :$SHAK_stderrmonterm"

echo ""

ans="yes"
echo -n "Do you want to continue ? <$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi

if [  "$ans" != "yes" ]; then
  :
  exit 1
fi

ans="no"
runtests=0
echo -n "Do you want to run the test suite ? (yes or no) <$ans> "
read ans1
if [ ! "$ans1" = "" ]; then
  ans="$ans1"
fi

if [  "$ans" = "yes" ]; then
	runtests=1
fi

ans="no"
hasexpect=0
#echo -n "Do you want to run tests requiring expect/TCL (stderr monitoring) ? (yes or no) <$ans> "
#read ans1
#if [ ! "$ans1" = "" ]; then
#  ans="$ans1"
#fi
#
#if [  "$ans" = "yes" ]; then
#	hasexpect=1
#fi

#############################################################

#############################################################

echo ""
echo "Installing shak program in $BIN_DIR"
echo ""

if [ ! -d $BIN_DIR ]; then
  install -m 755 -o $userlogin -d  ${BIN_DIR}
fi
install -m 550 -o $userlogin proper/bin/shak ${BIN_DIR}

##################################################
echo ""
echo " Creating config file: shak.conf"

>var/shak.conf
echo "domain:$SHAK_DOMAIN" >>var/shak.conf
echo "shakpath:$SHAK_SHAKPATH" >>var/shak.conf
echo "loghost:$SHAK_LOGHOST" >>var/shak.conf
echo "indexhost:$SHAK_INDEXHOST" >>var/shak.conf
echo "indexpath:$SHAK_INDEXPATH" >>var/shak.conf
echo "tapehost:$SHAK_TAPEHOST" >>var/shak.conf
echo "device:$SHAK_TAPEDEVICE" >>var/shak.conf
echo "userpath:$SHAK_USERPATH" >>var/shak.conf
echo "logbasename:$SHAK_LOGBASENAME" >>var/shak.conf
echo "logpath:$SHAK_LOGPATH" >>var/shak.conf
echo "remsh:$SHAK_REMSH" >>var/shak.conf
echo "useheaders:$SHAK_USEHEADERS" >>var/shak.conf
echo "defaulttest:$SHAK_DEFAULTTEST" >>var/shak.conf
echo "devicesecure:$SHAK_devicesecure" >>var/shak.conf
echo "tapesecure:$SHAK_tapesecure" >>var/shak.conf
echo "sitesecure:$SHAK_sitesecure" >>var/shak.conf
echo "mt_eom:$SHAK_MT_EOM" >>var/shak.conf
echo "stderrmon:$SHAK_stderrmon" >>var/shak.conf
echo "stderrmonmail:$SHAK_stderrmonmail" >>var/shak.conf
echo "stderrmonlog:$SHAK_stderrmonlog" >>var/shak.conf
echo "stderrmonterm:$SHAK_stderrmonterm" >>var/shak.conf


echo "INSTALLING shak.conf to $SHAK_CFG_DIR"

if [ -d "$SHAK_CFG_DIR" ]; then
 :
else
   install -m 755 -o $userlogin -d  ${SHAK_CFG_DIR}
fi

cd var && install -m 644 -o $userlogin shak.conf $SHAK_CFG_DIR
rm shak.conf
cd ..

####################################################

echo ""
INDEXPATH=""
if [ -d $SHAK_INDEXPATH ]; then
  INDEXPATH=$SHAK_INDEXPATH
else
  echo "Making directory $SHAK_INDEXPATH "
  install -m 755 -o $userlogin -d ${SHAK_INDEXPATH}
  INDEXPATH=$SHAK_INDEXPATH
fi

echo ""
LOGPATH=""
if [ -d $SHAK_LOGPATH ]; then
 :
else
  echo "Making directory $SHAK_LOGPATH "
  install -m 755 -o $userlogin -d ${SHAK_LOGPATH}
  LOGPATH=$SHAK_LOGPATH
fi

####################################################

echo ""
echo "Installing sample user backup scripts in "
echo $SHAK_USERPATH
echo ""
if [ -d "$SHAK_USERPATH" ]; then
 :
else
  install -m 755 -o $userlogin -d ${SHAK_USERPATH}
fi
 ( cd user/script && install -m 550 -o $userlogin * ${SHAK_USERPATH} )

if [ -d "$SHAK_USERPATH/lib" ]; then
 :
else
  install -m 755 -o $userlogin -d ${SHAK_USERPATH}/lib
fi
 ( cd user/lib && install -m 550 -o $userlogin * ${SHAK_USERPATH}/lib )


################################
echo ""
echo "Installing library"
echo ${SHAK_SHAKPATH}/lib
echo ""
if [ -d "$SHAK_SHAKPATH/lib" ]; then
 :
else
   install -m 755 -o $userlogin -d  ${SHAK_SHAKPATH}/lib
fi
cd proper/lib 
install -m 550 -o $userlogin shak* ${SHAK_SHAKPATH}/lib
install -m 550 -o $userlogin sush ${SHAK_SHAKPATH}/lib
( cd ${SHAK_SHAKPATH}/lib; ln -s shak_lock.sh shak_lock; ln -s shak_unlock.sh shak_unlock )
( cd ../../var && install -m 550 -o $userlogin shak.sh ${SHAK_SHAKPATH}/lib )

rm ../../var/shak.sh
cd ../..
################################
if [ -d "$SHAK_USERPATH/bin" ]; then
 :
else
   install -m 755 -o $userlogin -d  ${SHAK_USERPATH}/bin
fi

echo "installing mtimefilter(1) to $SHAK_USERPATH/bin"
( cd user/bin && install -o $userlogin -m 555 mtimefilter $SHAK_USERPATH/bin )

echo "installing filesize to $SHAK_USERPATH/bin"
( cd user/bin && install -o $userlogin -m 555 filesize $SHAK_USERPATH/bin )

################################
echo "Checking for existence of device file"
ret="`${SHAK_REMSH} ${SHAK_TAPEHOST} ls $SHAK_TAPEDEVICE 2>/dev/null`"
if [ ! "$ret" ]; then
 echo "Device file $SHAK_TAPEDEVICE was not found on $SHAK_TAPEHOST"
 echo "A valid device file must be configured manually"
else
 echo "$SHAK_TAPEDEVICE was looked for."
 echo "$ret was found on $SHAK_TAPEHOST"
fi

################################

if [ "$runtests" = "1" ]; then
	echo "Installing test components."
	echo "Installing test indexfile database."
	cp proper/testing/index/* $INDEXPATH
	if [ $? -ne 0 ]; then
		exit 1
	fi
	echo "Translating domainname in index files"
	if [ -f /bin/hostname ]; then
    	      B="`/bin/hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
        else
	      B="`hostname | sed -e 's/^\([^\.]*\)\..*/\1/'`"
        fi
	export INDEXPATH
	export B
	(
	cd proper/testing
	for file in $INDEXPATH/*
	do
		./tr_hostname $B $file
	done
	)
	echo "Renaming index files"
	(
	cd $INDEXPATH
	for file in *
	do
		newname="`echo $file | sed -e s@linux\.com@$SHAK_DOMAIN@`"
		mv $file $newname
		if [ $? -ne 0 ]; then
			echo "install.sh error" 1>&2
			exit 1
		fi
	done
	cd ../..
	mv -f var var.0
	)
	cp proper/testing/batchfile1 ${SHAK_USERPATH}
	cp proper/testing/batchfile2 ${SHAK_USERPATH}
	cp proper/testing/test.sh ${SHAK_SHAKPATH}
	cp proper/testing/testlist.0 ${SHAK_SHAKPATH}
	cp proper/testing/testlist.1 ${SHAK_SHAKPATH}
	cp proper/testing/retr_hostname ${SHAK_SHAKPATH}
	cp proper/testing/runtest0.sh ${SHAK_SHAKPATH}
#	if [ $hasexpect = 1 ]; then
#		cp proper/testing/testlist.2 ${SHAK_SHAKPATH}
#	else
#		:
#	fi
	cp proper/testing/test.baseline ${SHAK_SHAKPATH}
	cp user/testprograms/* ${SHAK_USERPATH}

	echo "Test installation complete and ready for testing."
	echo "Instructions:"
	echo "   Login as non-root user, then"
	echo "   type: cd $SHAK_SHAKPATH && ./runtest0.sh testlist.0"
	echo "         This test will not require a tape drive."
	echo ""
	echo "   To run tests that require a tape drive and a"
	echo "   loaded scratch tape , first edit the config file"
	echo "   ${SHAK_SHAKPATH}/etc/shak.conf to point"
	echo "   to the tape drive, then type:"
	echo "         cd $SHAK_SHAKPATH && ./test.sh testlist.1"
fi

################################
IOP="var/installed_files"
echo -n "" >var/installed_files
echo "see var/installed files for a list of installed files"
echo "$SHAK_CFG_DIR/`basename etc/shak.conf`" >>$IOP
echo "$BIN_DIR/`basename proper/bin/shak`" >>$IOP
for i in user/script/*
do
   echo "$SHAK_USERPATH/`basename $i`" >>$IOP
done
for i in proper/lib/*
do
   echo "$SHAK_SHAKPATH/lib/`basename $i`" >>$IOP
done
echo "$SHAK_SHAKPATH/bin/mtimefilter" >>$IOP
echo "$SHAK_USERPATH" >>$IOP
echo "$SHAK_SHAKPATH/bin" >>$IOP
echo "$SHAK_SHAKPATH/lib" >>$IOP
echo "$SHAK_SHAKPATH" >>$IOP
echo "$INDEXPATH" >>$IOP
echo "$LOGPATH" >>$IOP



echo "Installation program exiting normally"
exit 0
