/*

Copy Policy
-----------

pgppipe.c is under the GPL.

*/

#include <stdio.h>
#include <strings.h>
#include <getopt.h>
#include <unistd.h>

#include <idea.h>
#include <md5.h>

/*

The block size used for read-ahead

*/

#define BLOCKSIZE 1024*1000

/*

Copy a block to a stream

Should print errors...

*/

dofwrite(void *block, int bytes, FILE *outfile)
 {
  byte *data=(byte *)block;
  int count;
  
  while(bytes!=0)
   {
    count=fwrite(data, 1, bytes, outfile);
    bytes-=count;
    data+=count;
   }
 }

/*

Generate a key from the password

*/

void generatekey(char *password, byte *key)
 {
  struct MD5Context context;
  
  MD5Init(&context);
  MD5Update(&context, password, strlen(password));
  MD5Final(key, &context);
 }
 
/*

Do the IDEA encryption

*/

void encrypt_idea(char *password)
 {
  char block_in[BLOCKSIZE], block_out[BLOCKSIZE];
  size_t count;
  struct IdeaCfbContext context;
  byte key[16];

  generatekey(password, key);

  ideaCfbInit(&context, key);

  while(!feof(stdin))
   {
    count=fread(block_in, 1, BLOCKSIZE, stdin);
   
    fprintf(stderr, "COUNT: %d\n", count);
   
    if(count>0)
     {
      dofwrite(&count, sizeof(count), stdout);
      ideaCfbEncrypt(&context, block_in, block_out, count);
      dofwrite(block_out, count, stdout);
     }
   }
   
  ideaCfbDestroy(&context);
 }

/*

Do the IDEA decryption

*/

void decrypt_idea(char *password)
 {
  char block_in[BLOCKSIZE], block_out[BLOCKSIZE];
  size_t count;
  struct IdeaCfbContext context;
  byte key[16];

  generatekey(password, key);

  ideaCfbInit(&context, key);
  
  while(!feof(stdin))
   {
    if(fread(&count, 1, sizeof(count), stdin)==sizeof(count))
     {
      fprintf(stderr, "COUNT: %d\n", count);
    
      fread(block_in, 1, count, stdin);
      
      ideaCfbDecrypt(&context, block_in, block_out, count);
                    
      dofwrite(block_out, count, stdout);
     }
   }
   
  ideaCfbDestroy(&context);
 }

/*

main & commandline arguments parsing

*/

int main(int argc, char **argv)
 {
  char do_ch=' ', *password;
 
  while(1)
   {
    switch(getopt(argc, argv, "e:d:?h"))
     {
     case 'e':
      do_ch='e';
      password=optarg;
      break;
     
     case 'd':
      do_ch='d';
      password=optarg;
      break;
      
     case EOF:
      if(do_ch=='e')
        encrypt_idea(password);
      else if(do_ch=='d')
        decrypt_idea(password);
      else
        goto help;
        
      return 0;
     
     default:
     help:
      fprintf(stderr, "Usage:\n"
                      " %s -e Password  encrypt  < input-file  > output-file\n"
                      " %s -d Password  decrypt  < input-file  > output-file\n"
                      "\n"
                      "To make an encrypted backup on /dev/st0:\n"
                      "\n"
                      " tar cf - /home/test/secret | %s -e Password > /dev/st0\n"
                      "\n");
      return 1;
     }
   }
  
 }
 