/*	Date:	Thu Sep  5 19:01:32 MET DST 1996
 *	Author:	Jens Nie
 *              Universitaet Osnabrueck
 *	Programname:	part
 *	Filename:	part.c
 *	Version:	1.0.2
 *	Explanation:	reads a stream either from stdin or file and splits it
 *			into pieces that fit onto a DOS-formatted 1.44 MB-
 *			Floppy.
 *			The created pieces will have a filename consisting of
 * 			a basename that is given as an argument to the program
 *			and a self-created suffix starting with ".000".
 *			The pieces may later be catenated into one file using
 *			the "cat" Program or something else.
 *			Errorcodes:
 *				
 *			1	-	unable to open file for reading
 *			2	-	unable to open file for writing
 *			3	-	unable to read from file
 *			4	-	unable to write to file
 *			5	-	to many pieces	
 *			6	-	wrong usage	
 *			7	-	unable to allocate memory
 *
 *	last modified: Tue Nov  5 22:25:36 MET DST 1996
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#define SIZE 1024


static unsigned short number = 000;                     /* counter for suffix */
static char suffix[4] = ".000";                               /* dummy-suffix */
static unsigned short length = 0;                               /* filelength */


void usage(void)
/* 
 * explains usage of "part" 
 */
{
  fprintf(stderr, "\n\npart <outputbasename> <inputstream>\n"\
                  "\n\nExample:\n\n"\
                  "part foo first.dat\n\n"\
                  "reads from File \"first.dat\" and writes to \"foo.nnn\"\n"\
                  "where nnn is one of the automatically created Suffixes\n\n"
                  "tar -cvf foo/* | gzip -v9 | part new -\n\n"
                  "will read the from tar and gzip created stuff from stdin\n"\
                  "and write to new.nnn\n\n");
  exit(6);
}


char * newname(char * basename)
/* 
 * This function creates with both, argument to the program and suffix, the
 * filename for the new package
 */
{
  int temp;                                   /* for splitting the counter */

  if (number == 0) length = strlen(basename)-1; /* 
						 * when called the first time
						 * get the length of basename
                                                 */
 
  number++;
  if (number > 999) 
  /* 
   * To many floppies. Who the hell will carry them 
   * terminating with errorcode 5
   */ 
  {
    fprintf(stderr, "To many floppies. Who the hell will carry them\n"); 
    exit(5);
  }
  
  /* 
   * in the following the new filename will be created 
   */
  
	basename[length-3]='.';
	
	if (++basename[length]==':')
	{	
		basename[length]='0';
	    if (++basename[length-1]==':')
		{
		  basename[length-1]='0';
		  ++basename[length-2];
		}
	}

  return basename;
}


int main(int argc, char ** argv)
{
  int handle1;                               /* Handle for writing procedures */
  int handle2;                               /* Handle for reading procedures */
  int haveread=0;                   /* counter for stuff that is already read */
  int havewritten=0;             /* counter for stuff that is already written */
  unsigned packagecounter=0;                   /* Zaehlt die gelesenen Pakete */
  unsigned maxsize=1423;            /* maximal count of packages for one disk */

  char * buffer;		                                 /* pointer to buffer */
  char * basename = (char *) malloc(255*sizeof(char)); /* 
                                                        * buffer for filename
                                                        */ 


  /* 
   * first of all test the correct usage 
   */
  if (argc != 3) usage();
  if (*argv[1] == '-') usage();

  /*
   * now we allocate some memory for the buffer
   */
  if((buffer = (char *) malloc(SIZE*sizeof(char))) == NULL)
  {
	fprintf(stderr, "unable to allocate memory for buffer...\n");
	exit(7);
  }




  if ((strcmp(argv[2],"-"))!=0)
  /*
   * if "part" should not read from stdin... 
   */
  {
    handle2 = open(argv[2], O_RDONLY);
    if (handle2<0)
    {
      fprintf(stderr, "unable to open %s for reading\n", argv[2]);
      exit(1);
    }
  }
  else handle2=0;                                   /* use stdin for reading */


  basename = strcat(argv[1], suffix);     /* 
                                           * copys the dummy-Suffix .000 
                                           * to basename 
                                           */

   
  handle1 = open(basename, O_WRONLY | O_CREAT , 0666); /* open the first file */
  if (handle1 < 0)
  /* 
   * if an error occured...
   */
  {
    fprintf(stderr, "unable to open %s for writing\n", basename);
    exit(2);
  }
  
 
  for(;;)
  {
    haveread = read(handle2, buffer, SIZE);
    /* 
     * read a package... 
     */
    if (haveread <0) 
    /* 
     * if read returns a value lower than zero a reading-error occured
     * terminating with errorcode 3
     */
    {
      fprintf(stderr, "unable to read from file %s\n", argv[2]);
      exit(3);
    }
    
    if (haveread == 0) break;                 /* file was completely read in */
    
    havewritten = write(handle1, buffer, haveread);
    /* 
     * if write returns a value lower than zero a writing error occured
     * terminating with errorcode 2
     */
    if (havewritten <0 )
    {
      fprintf(stderr, "unable to write to file %s\n", basename);
      exit(4);
    }
  
    packagecounter++;                                 /* counts the packages */
 
    if (packagecounter == maxsize)
    /* 
     * after reading the 1423th package 1423*1024=1457664 Byte have been
     * read in.
     * time for a new file...
     */
    {
      close(handle1);                                  /* close the old file */
      /* 
       * print status 
       */
      fprintf(stderr, "File Nr. %d:	%s created\n", number+1, basename);
      packagecounter =0;                        /* set packaecounter to zero */
      basename = newname(basename);                  /* creat a new filename */
  
      handle1 = open(basename, O_WRONLY | O_CREAT, 0666);    /* open new file*/
      if (handle1 < 0)
      /* 
       * if an error occured...
       */
      {
        fprintf(stderr, "unable to open %s for writing \n", basename);
        exit(2);
      }
    }  
  }
  if(handle2 != 0) close(handle2); /* 
                                    * if handle2 is not stdin then close
                                    */
  close(handle1);                                /* close the last open file */
  /* 
   * print status 
   */
  fprintf(stderr, "File Nr. %d:	%s created\n", number+1, basename);
  
  return 0;
}
