#!/usr/bin/perl -w

# Paranoid Backup main module

use integer;
use English;

$No = 0;
$Yes = 1;

$NoAction = 0;
$Backup = 1;
$PrepareForNewFiles = 2;
$ExcludeNewFiles = 3;
$Compare = 4;
$CompareLastBackup = 5;
$CompareSelectedFiles = 6;
$Find = 7;
$Restore = 8;
$RestoreSelectedFiles = 9;
$CheckConfiguration = 10;
$MakeVirtualRestoreList = 11;
$DesperateRestore1a = 12;
$DesperateRestore1b = 13;
$DesperateRestore2 = 14;
$List = 15;

$Action = $NoAction;
$AnErrorOccurred = $No;
$AnErrorOccurredLastMdtiCommand = $No;
@BackupToCompareOrRestoreFrom = ();
$CheckControlFile = $No;
$ConfigDirectoryAndFile = '';
$ConfigFile = 'config';
$BackupIsIncomplete = $No;
@FileNames = ();
$FileNamesFrom = '';
@FileToCompareOrRestore = ();
$Force = $No;
$IncludeCorruptedFiles = $No;
$LastMdtiCommand = '';
$MaxNestedConfigFiles = 100;
$MdtiRunning = $No;
@Patterns = ();
$PatternsFrom = '';
@TempFiles = ();
$VerifyBackup = $No;
$WarnAboutTrailingSpaces = $Yes;

$NA = -1;
while ( $NA < $#ARGV ) {
  $NA = $NA + 1;
  if ($ARGV[$NA] eq '--backup') {
    $Action = $Backup;
    next;
    }
  if ($ARGV[$NA] eq '--check-configuration') {
    $Action = $CheckConfiguration;
    next;
    }
  if ($ARGV[$NA] eq '--check-control-file') {
    $CheckControlFile = $Yes;
    next;
    }
  if ($ARGV[$NA] eq '--compare') {
    $Action = $Compare;
    next;
    }
  if ($ARGV[$NA] eq '--compare-last-backup') {
    $Action = $CompareLastBackup;
    next;
    }
  if ($ARGV[$NA] eq '--compare-selected-files') {
    $Action = $CompareSelectedFiles;
    next;
    }
  if (substr($ARGV[$NA],0,9) eq '--config=') {
    $ConfigDirectoryAndFile = substr($ARGV[$NA],9);
    next;
    }
  if ($ARGV[$NA] eq '--desperate-restore-1a') {
    $Action = $DesperateRestore1a;
    next;
    }
  if ($ARGV[$NA] eq '--desperate-restore-1b') {
    $Action = $DesperateRestore1b;
    next;
    }
  if ($ARGV[$NA] eq '--desperate-restore-2') {
    $Action = $DesperateRestore2;
    next;
    }
  if ($ARGV[$NA] eq '--exclude-new-files') {
    $Action = $ExcludeNewFiles;
    next;
    }
  if ($ARGV[$NA] eq '--find') {
    $Action = $Find;
    next;
    }
  if (substr($ARGV[$NA],0,12) eq '--file-name=') {
    push(@FileNames,substr($ARGV[$NA],12));
    next;
    }
  if (substr($ARGV[$NA],0,18) eq '--file-names-from=') {
    $FileNamesFrom = substr($ARGV[$NA],18);
    next;
    }
  if ($ARGV[$NA] eq '--force') {
    $Force = $Yes;
    next;
    }
  if ($ARGV[$NA] eq '--help') {
    print("
paranoidbackup.pl [action] [options]

actions, one and only one action is required:
--version  --help    --make-virtual-restore-list   --check-configuration
--backup   --compare    --compare-last-backup   --list
--find     --restore    --prepare-for-new-files   --exclude-new-files
--restore-selected-files      --compare-selected-files
--desperate-restore-1a     --desperate-restore-1b    --desperate-restore-2

options:
--config=[config directory]/[config file]
--force      --include-corrupted-files
--pattern=[perl pattern]    --patterns-from=[name of file]
--file-name=[name of file]       --file-names-from=[name of file]
--check-control-file   --verify-backup

--file-name= and --file-names-from= are for --restore-selected-files
and --compare-selected-files; patterns are for --find

configuration files may be nested $MaxNestedConfigFiles levels deep
default configuration file is '$ConfigFile'
");
    exit(0);
    }
  if ($ARGV[$NA] eq '--include-corrupted-files') {
    $IncludeCorruptedFiles = $Yes;
    next;
    }
  if ($ARGV[$NA] eq '--list') {
    $Action = $List;
    next;
    }
  if ($ARGV[$NA] eq '--make-virtual-restore-list') {
    $Action = $MakeVirtualRestoreList;
    next;
    }
  if (substr($ARGV[$NA],0,10) eq '--pattern=') {
    @Patterns = (@Patterns,substr($ARGV[$NA],10));
    next;
    }
  if (substr($ARGV[$NA],0,16) eq '--patterns-from=') {
    $PatternsFrom = substr($ARGV[$NA],16);
    next;
    }
  if ($ARGV[$NA] eq '--prepare-for-new-files') {
    $Action = $PrepareForNewFiles;
    next;
    }
  if ($ARGV[$NA] eq '--restore') {
    $Action = $Restore;
    next;
    }
  if ($ARGV[$NA] eq '--restore-selected-files') {
    $Action = $RestoreSelectedFiles;
    next;
    }
  if ($ARGV[$NA] eq '--verify-backup') {
    $VerifyBackup = $Yes;
    next;
    }
  if ($ARGV[$NA] eq '--version') {
    print("Paranoid Backup      paranoidbackup.pl      version 1.0\n");
    exit(0);
    }
  print(STDERR "
paranoidbackup.pl: unknown command line option:  $ARGV[$NA]
try     paranoidbackup.pl --help
");
  exit(10);
  }
#print(STDERR "got command line parameters\n");



if ( $Action == $NoAction )  {
  print(STDERR "
paranoidbackup.pl: no action given. try --help
");
  exit(10);
  }

if ( $Action != $Backup )  { $VerifyBackup = $No }
$IgnoreGrepErrors = $Force;



if ( $ConfigDirectoryAndFile eq '' )  { print(STDERR "
paranoidbackup.pl: You have not said what configuration directory to use.
"); exit(10) }
if ( substr($ConfigDirectoryAndFile,0,1) ne '/' )  { print(STDERR "
paranoidbackup.pl: The name of the configuration directory must begin
with '/'
"); exit(10) }
if ( -d $ConfigDirectoryAndFile )
    { $ConfigDirectory = $ConfigDirectoryAndFile }
elsif ( -f $ConfigDirectoryAndFile )  {
  $NA = rindex($ConfigDirectoryAndFile,'/');
  if ( $NA < 1 )  { print(STDERR "
paranoidbackup.pl: the configuration directory can not be the root directory
"); exit(10) }
  else  {
    $ConfigDirectory = substr($ConfigDirectoryAndFile,0,$NA);
    $ConfigFile = substr($ConfigDirectoryAndFile, ($NA + 1));
    }
  }
else  { print(STDERR "
paranoidbackup.pl: no such directory or file as
$ConfigDirectoryAndFile
"); exit(10) }
if ( ! chdir($ConfigDirectory) )  { print(STDERR "
paranoidbackup.pl: unable to change to directory $ConfigDirectory
"); exit(10) }

#print(STDERR "changed to directory $ConfigDirectory\n");


$FileNumber = 0;
&readConfigurationFile($ConfigFile);
if ( ! defined($ArchiveOption_ArchiveIsStdInOrOut) )
    { &zNotDefined('ArchiveOption_ArchiveIsStdInOrOut') }
if ( ! defined($ArchiveOption_Compare) )
    { &zNotDefined('ArchiveOption_Compare') }
if ( ! defined($ArchiveOption_FileListForRestoreOrCompare) )
    { &zNotDefined('ArchiveOption_FileListForRestoreOrCompare') }
if ( ! defined($ArchiveOption_FileListForMakeArchive) )
    { &zNotDefined('ArchiveOption_FileListForMakeArchive') }
if ( ! defined($ArchiveOption_IncludeCorruptedFiles) )
    { &zNotDefined('ArchiveOption_IncludeCorruptedFiles') }
if ( ! defined($ArchiveOption_List) ) { &zNotDefined('ArchiveOption_List') }
if ( ! defined($ArchiveOption_MakeArchive) )
    { &zNotDefined('ArchiveOption_MakeArchive') }
if ( ! defined($ArchiveOption_Restore) )
    { &zNotDefined('ArchiveOption_Restore') }
if ( ! defined($ArchiveProgram_MaximumExitCode) )
    { &zNotDefined('ArchiveProgram_MaximumExitCode') }
if ( ! defined($ArchiveProgram) ) { &zNotDefined('ArchiveProgram') }
if ( ! defined($BackupFileNameBase) ) { &zNotDefined('BackupFileNameBase') }
if ( ! defined($BackupFileNameExtension) )
    { &zNotDefined('BackupFileNameExtension') }
if ( ! defined($BeforeNewFilesList) ) { &zNotDefined('BeforeNewFilesList') }
if ( ! defined($DirectoryIncludeExclude) )
    { &zNotDefined('directory include excludes') }
if ( ! defined($CFLIncludeExcludes) ) { &zNotDefined('CFLIncludeExcludes') }
if ( ! defined($CFLoptions) ) { &zNotDefined('CFLoptions') }
if ( ! defined($ControlFilesBackupNameBase) )
    { &zNotDefined('ControlFilesBackupNameBase') }
if ( ! defined($ControlNameBase) ) { &zNotDefined('ControlNameBase') }
if ( ! defined($CompareFileLists) ) { &zNotDefined('CompareFileLists') }
if ( ! defined($CurrentFilesList) ) { &zNotDefined('CurrentFilesList') }
if ( ! defined($DeletedAndChangedFiles) )
    { &zNotDefined('DeletedAndChangedFiles') }
if ( ! defined($DirectoryToBackup) ) { &zNotDefined('DirectoryToBackup') }
elsif ( ! -d $DirectoryToBackup )
    { &zNoDirectory('DirectoryToBackup', $DirectoryToBackup) }
if ( ! defined($ExcludedNewFilesLsListNameBase) )
    { &zNotDefined('ExcludedNewFilesLsListNameBase') }
if ( ! defined($FindSeperator) ) { &zNotDefined('FindSeperator') }
$LengthOfFindSeperator = length($FindSeperator);
if ( ! defined($LsListNameBase) ) { &zNotDefined('LsListNameBase') }
if ( ! defined($MaxSizeDeletedAndChangedFilesList) )
    { &zNotDefined('MaxSizeDeletedAndChangedFilesList') }
if ( $MaxSizeDeletedAndChangedFilesList < 1 )  { &zDelSize0 }
if ( ! defined($MdtiDirectory) ) { &zNotDefined('MdtiDirectory') }
elsif ( ! -d $MdtiDirectory )
    { &zNoDirectory('MdtiDirectory', $MdtiDirectory) }
elsif ( ! -e "$MdtiDirectory/start" )
    { &zNoStart }
if ( ! defined($TempExtension) ) { &zNotDefined('TempExtension') }
if ( ! defined($TemporaryControlList) )
    { &zNotDefined('TemporaryControlList') }
if ( ! defined($VirtualRestoreList) )
    { &zNotDefined('VirtualRestoreList') }
if ( ! defined($CompressLists) ) { &zNotDefined('CompressLists') }
elsif ( $CompressLists == $Yes )  {
  if ( ! defined($CompressionExtension) )
     { &zNotDefined('CompressionExtension') }
  if ( ! defined($CompressStdin) ) { &zNotDefined('CompressStdin') }
  if ( ! defined($TooSmallToCompress) ) { &zNotDefined('TooSmallToCompress') }
  if ( ! defined($UncompressStdin) ) { &zNotDefined('UncompressStdin') }
  }
#if ( ! defined($) ) { &zNotDefined('') }
#if ( ! -d $ )  { &zNoDirectory('',$) }




#print(STDERR "pre error check\n");
if ( $AnErrorOccurred     and     $Action != $MakeVirtualRestoreList
    and     $Action != $CheckConfiguration )  { exit(11) }
#print(STDERR "post error check\n");


if ( defined($AddToPath) )
  { $ENV{PATH} = $ENV{PATH} . ':' . $AddToPath }
# should we check SHELL, and make sure it recognizes '<' and '>'?
# are there any shells which do not recognize '<' and '>'?

if ( defined($PreAccessToBackupsCommands) )   {
if ( $Action == $Backup   or   $Action == $Compare   or
     $Action == $CompareLastBackup   or   $Action == $CompareSelectedFiles
     or   $Action == $CheckConfiguration   or   $Action == $Restore   or
     $Action == $RestoreSelectedFiles   or   $Action == $DesperateRestore1a
     or   $Action == $DesperateRestore1b  or   $Action == $DesperateRestore2
     or   $Action == $List )  {
if ( $PreAccessToBackupsCommands ne '' )  { &runExternalCommand(
             $PreAccessToBackupsCommands,'PreAccessToBackupsCommands') }
}}


#print(STDERR "about to get number of last backup\n");
$NA = 1;
while ( -e "$LsListNameBase$NA$CompressionExtension"     or
    -e "$LsListNameBase$NA" )  { $NA = $NA + 1 }
$NumberOfLastBackup = $NA - 1;
#print(STDERR "number of last backup is $NumberOfLastBackup\n");






if ( $Action == $Backup )  {
$NumberOfThisBackup = $NumberOfLastBackup + 1;
# &startMdti;
# we could start the mdti server now, to grab control of it so no other
# program can use it; except we go into the background when we start it,
# and we need to stay in the foreground if we are doing a backup with
# the check control file option.
&listCurrentFiles;

# uncompress old file lists
if ( -e $VirtualRestoreList )
     { $OldVirtualRestoreList = $VirtualRestoreList }
elsif ( -e "$VirtualRestoreList$CompressionExtension" )  {
  $OldVirtualRestoreList = $VirtualRestoreList. $TempExtension;
  push(@TempFiles,$OldVirtualRestoreList);
  &runExternalCommand(("$UncompressStdin" .
      " < $VirtualRestoreList$CompressionExtension" .
      " > $OldVirtualRestoreList"), 'uncompression command');
  }
else { &zNoVRL }
$NewLsList = $LsListNameBase . $NumberOfThisBackup . $TempExtension;
$NewVirtualRestoreList = $VirtualRestoreList . $TempExtension . '2';
$NewControlList = $ControlNameBase . $NumberOfThisBackup . $TempExtension;
unlink($NewVirtualRestoreList,$DeletedAndChangedFiles,
       $NewControlList,$NewLsList);
push(@TempFiles,$NewVirtualRestoreList,$DeletedAndChangedFiles,
       $NewControlList,$NewLsList);

# compare current file list with old file lists
&runExternalCommand("$CompareFileLists " . 
    "$CFLIncludeExcludes $CurrentFilesList $OldVirtualRestoreList " .
    "$NewVirtualRestoreList $DeletedAndChangedFiles " .
    "$NewControlList $NewLsList $CFLoptions");

# compare file lists with lists of new excluded files
$NA = 1;
while ()  {
  if ( -e "$ExcludedNewFilesLsListNameBase$NA" )
        { $ExcludedNewFilesLsList = $ExcludedNewFilesLsListNameBase . $NA }
  elsif ( -e "$ExcludedNewFilesLsListNameBase$NA$CompressionExtension" )  {
    $ExcludedNewFilesLsList =
        $ExcludedNewFilesLsListNameBase . $NA . $TempExtension;
    push(@TempFiles,$ExcludedNewFilesLsList);
    &runExternalCommand(("$UncompressStdin" .
        " < $ExcludedNewFilesLsListNameBase$NA$CompressionExtension" .
        " > $ExcludedNewFilesLsList"), 'uncompression command');
    }
  else { last }
  $PreviousNewLsList = $NewLsList;
  $NewControlList =
     $ControlNameBase . $NumberOfThisBackup . $TempExtension . $NA;
  $NewLsList = $LsListNameBase . $NumberOfThisBackup . $TempExtension . $NA;
  push(@TempFiles,$NewControlList,$NewLsList);
  &runExternalCommand("$CompareFileLists " .
    "$CFLIncludeExcludes $PreviousNewLsList $ExcludedNewFilesLsList " .
    "/dev/null /dev/null $NewControlList $NewLsList $CFLoptions");
  $NA = $NA + 1;
  }
$NextExcludedNewFilesLsListNumber = $NA;

if ( $CheckControlFile )  {
  print(STDERR "control file is $NewControlList, ls list is $NewLsList\n",
        "press enter to continue, type 'abort' to abort\n");
  $SA = <STDIN>;
  if ( $SA eq "abort\n" )  { &deleteTmpFilesAndExit(1) }
  }
if ( -z $NewControlList )  { &zNothingToBackup }
&startMdti;

# start the list of control files
push(@TempFiles,$TemporaryControlList);
if ( ! open(FH_TemporaryControlList, "> $TemporaryControlList") )  {
  print(STDERR "
paranoidbackup.pl: unable to write to temporary file
$TemporaryControlList
");
  &deleteTmpFilesAndExit(20);
  }

# delete old control files backup
if ( $NumberOfThisBackup > 1 )  { &mdtiCommand(
   "delete\n$ControlFilesBackupNameBase$BackupFileNameExtension\n") }

# if we abort now, there will be trouble because the old control files have
# been deleted and cannot be undeleted. Since it is no longer
# safe to abort, we should try to continue even if errors occur
$BackupIsIncomplete = $Yes;

# do the backup
chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
&archive_MakeArchive("$ConfigDirectory/$NewControlList",
   $BackupFileNameBase . $NumberOfThisBackup . $BackupFileNameExtension);
chdir($ConfigDirectory) or &zNoCD($ConfigDirectory);


&modifyOldControlLists;

# finish the new control list, ls list, and virtual restore list;
# and add them to the list of control files
if ( $CompressLists == $Yes )  {
  # we could check the sizes of these files, and not compress them if the
  # size is less than or equal to $TooSmallToCompress, but the code is
  # simpler this way, and I am not sure if it matters. The control list will
  # be adjusted next backup, and the virtual restore list and the ls list
  # will probably be big enough to compress.
  &runExternalCommand(("$CompressStdin < $NewControlList > " .
        $ControlNameBase . $NumberOfThisBackup . $CompressionExtension),
        'compression command');
  &runExternalCommand(("$CompressStdin < $NewLsList > " .
      $LsListNameBase . $NumberOfThisBackup . $CompressionExtension),
      'compression command');
  &runExternalCommand(("$CompressStdin < $NewVirtualRestoreList > " .
      $VirtualRestoreList . $CompressionExtension),
      'compression command');
  push(@TempFiles,"$ControlNameBase$NumberOfThisBackup",
      "$LsListNameBase$NumberOfThisBackup",$VirtualRestoreList);
  print(FH_TemporaryControlList $ControlNameBase, $NumberOfThisBackup,
       $CompressionExtension, "\n", $LsListNameBase, $NumberOfThisBackup,
       $CompressionExtension, "\n");
  }
else  {
  unlink("$LsListNameBase$NumberOfThisBackup$CompressionExtension",
      "$LsListNameBase$NumberOfThisBackup", "$ControlNameBase$NumberOfThisBackup",
      "$ControlNameBase$NumberOfThisBackup$CompressionExtension",
      "$VirtualRestoreList$CompressionExtension",$VirtualRestoreList);
  rename($NewControlList,"$ControlNameBase$NumberOfThisBackup");
  rename($NewLsList,"$LsListNameBase$NumberOfThisBackup");
  rename($NewVirtualRestoreList,$VirtualRestoreList);
  print(FH_TemporaryControlList $ControlNameBase, $NumberOfThisBackup, "\n",
                              $LsListNameBase, $NumberOfThisBackup, "\n");
  }

# do control files backup
close(FH_TemporaryControlList);
&archive_MakeArchive("$TemporaryControlList",
  $ControlFilesBackupNameBase . $BackupFileNameExtension);

if ( $AnErrorOccurred == $No )  { $BackupIsIncomplete = $No }

# delete any finished or unfinished lists of excluded new files
$NA = 1;
while ( $NA < $NextExcludedNewFilesLsListNumber )  {
  unlink("$ExcludedNewFilesLsListNameBase$NA",
      "$ExcludedNewFilesLsListNameBase$NA$CompressionExtension");
  $NA = $NA + 1;
  }
if ( -e ($BeforeNewFilesList . $CompressionExtension) )
    { unlink($BeforeNewFilesList . $CompressionExtension) }

if ( $VerifyBackup == $No )  { &deleteTmpFilesAndExit(0) }
$NumberOfLastBackup = $NumberOfThisBackup;
}  # end of if ( $Action == $Backup )




if ( $Action == $CompareLastBackup    or    $VerifyBackup == $Yes )  {
if ( $NumberOfLastBackup < 1 )  { &zNoOldBackups }
&startMdti;
if ( -e "$ControlNameBase$NumberOfLastBackup" )
    { $ControlList = $ControlNameBase . $NumberOfLastBackup }
elsif ( -e "$ControlNameBase$NumberOfLastBackup$CompressionExtension" )  {
      $ControlList = $ControlNameBase . $NumberOfLastBackup . $TempExtension;
      push(@TempFiles,$ControlList);
      &runExternalCommand(("$UncompressStdin" .
        " < $ControlNameBase$NumberOfLastBackup$CompressionExtension" .
        " > $ControlList"), 'uncompression command');
      }
else { &zNoControlList($NumberOfLastBackup) }
$NameOfBackupArchiveFile =
    $BackupFileNameBase . $NumberOfLastBackup . $BackupFileNameExtension;
chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
&archive_Compare("$ConfigDirectory/$ControlList",$NameOfBackupArchiveFile);
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $CompareLastBackup )



if ( $Action == $PrepareForNewFiles )  {
&listCurrentFiles;
if ( $CompressLists == $Yes )
   { &runExternalCommand("$CompressStdin < $CurrentFilesList > " .
       "$BeforeNewFilesList$CompressionExtension",'compression command') }
else { &runExternalCommand("cp $CurrentFilesList $BeforeNewFilesList",
            'copy command') }
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $PrepareForNewFiles )



if ( $Action == $ExcludeNewFiles )  {
if ( ! -e ($BeforeNewFilesList . $CompressionExtension) )  {
  print(STDERR "
paranoidbackup.pl: there is no file named
$BeforeNewFilesList$CompressionExtension
that file should have been made by --prepare-for-new-files.
Paranoid Backup can not run --exclude-new-files without it.
");
  &deleteTmpFilesAndExit(20);
  }
&listCurrentFiles;
$NA = 1;
while ( -e "$ExcludedNewFilesLsListNameBase$NA$CompressionExtension"
     or     -e "$ExcludedNewFilesLsListNameBase$NA" )   { $NA = $NA + 1 }
$NextExcludedNewFilesLsListNumber = $NA;
if ( $CompressLists == $Yes )  {
  &runExternalCommand("$UncompressStdin" .
      " < $BeforeNewFilesList$CompressionExtension" .
      " > $BeforeNewFilesList$TempExtension", 'uncompression command');
  $WorkingBeforeNewFilesList = $BeforeNewFilesList . $TempExtension;
  push(@TempFiles,$WorkingBeforeNewFilesList);
  }
else  { $WorkingBeforeNewFilesList = $BeforeNewFilesList }
$NewLsList = $ExcludedNewFilesLsListNameBase .
        $NextExcludedNewFilesLsListNumber . $TempExtension;
unlink($NewLsList);
push(@TempFiles,$NewLsList);
&runExternalCommand("$CompareFileLists " . 
    "$CFLIncludeExcludes $CurrentFilesList " .
    "$WorkingBeforeNewFilesList " .
    "/dev/null /dev/null /dev/null $NewLsList $CFLoptions --NewFilesOnly");
if ( $CompressLists == $Yes )  {
  &runExternalCommand(("$CompressStdin < $NewLsList > " .
    $ExcludedNewFilesLsListNameBase . $NextExcludedNewFilesLsListNumber
    . $CompressionExtension), 'compression command') }
else { rename($NewLsList,
  ($ExcludedNewFilesLsListNameBase . $NextExcludedNewFilesLsListNumber)) }
unlink($BeforeNewFilesList . $CompressionExtension);
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $ExcludeNewFiles )



if ( $Action == $Restore )  {
&startMdti;
my $RealForce = $Force;
$Force = $Yes;
&archive_Restore('',$ControlFilesBackupNameBase . $BackupFileNameExtension);
$Force = $RealForce;
if ( $AnErrorOccurred )  { &zNoCFR }
# $NA = 1;
# while ( -e "$LsListNameBase$NA$CompressionExtension" )  { $NA = $NA + 1 }
# $NumberOfLastBackup = $NA;
}



if ( $Action == $DesperateRestore1a )  {
&startMdti;
$Force = $Yes;
$IncludeCorruptedFiles = $Yes;
&archive_Restore('',$ControlFilesBackupNameBase . $BackupFileNameExtension);
if ( $AnErrorOccurred == $No )  { &zdr1aNoError }
$NA = 1;
while ()  {
  if ( -e "$ControlNameBase$NA$CompressionExtension" )  {
      &runExternalCommand(("$UncompressStdin" .
        " < $ControlNameBase$NA$CompressionExtension" .
        " > $ControlNameBase$NA"), 'uncompression command');
      }
  elsif ( ! -e "$ControlNameBase$NA" )  { last }
  $NA = $NA + 1;
  }
&deleteTmpFilesAndExit(0);
}



if ( $Action == $Compare     or     $Action == $Restore     or
    $Action == $DesperateRestore1b )  {
if ( $NumberOfLastBackup < 1 )  { &zNoOldBackups }
&startMdti;
$NA = 1;
while ( $NA <= $NumberOfLastBackup )  {
  if ( -e ($ControlNameBase . $NA) )
      { $ControlList = $ControlNameBase . $NA }
  elsif ( -e ($ControlNameBase . $NA . $CompressionExtension) )  {
      $ControlList =
          $ControlNameBase . $NA . $TempExtension ;
      push(@TempFiles,$ControlList);
      &runExternalCommand(("$UncompressStdin" .
        " < $ControlNameBase$NA$CompressionExtension" .
        " > $ControlList"), 'uncompression command');
      }
  else { &zNoControlList($NA); $NA = $NA + 1; next }
  if ( -z $ControlList )  { $NA = $NA + 1; next }
  $NameOfBackupArchiveFile =
      $BackupFileNameBase . $NA . $BackupFileNameExtension;
  chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
  if ( $Action == $Compare )  { &archive_Compare
       ("$ConfigDirectory/$ControlList", $NameOfBackupArchiveFile) }
  else  { &archive_Restore("$ConfigDirectory/$ControlList",
           $NameOfBackupArchiveFile) }
  chdir($ConfigDirectory) or &zNoCD($ConfigDirectory);
  $NA = $NA + 1;
  }
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $Compare   $Restore   $DesperateRestore1b



if ( $Action == $DesperateRestore2 )  {
&startMdti;
chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
$NA = 1;
while ()  {
  $NameOfBackupArchiveFile =
      $BackupFileNameBase . $NA . $BackupFileNameExtension;
  &archive_Restore('',$NameOfBackupArchiveFile);
  $NA = $NA + 1;
  }
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $DesperateRestore2



if ( $Action == $List )  {
#print(STDERR "action is list\n");
if ( $NumberOfLastBackup < 1 )  { &zNoOldBackups }
#print(STDERR "about to start mdti\n");
&startMdti;
$NA = 1;
#print(STDERR "\$NA is $NA, \$NumberOfLastBackup is $NumberOfLastBackup\n");
while ( $NA < $NumberOfLastBackup )  {
  #print(STDERR "doing list loop\n");
  $NameOfBackupArchiveFile =
      $BackupFileNameBase . $NA . $BackupFileNameExtension;
  print("\n\n\n\ncontents of $NameOfBackupArchiveFile\n",
        "=====================================================\n");
  # next sub will use system(), but system() does not flush the buffer for
  # print(); so the output of the previous print will be displayed AFTER the
  # output of the next system(); unless we flush the buffer.
  $OUTPUT_AUTOFLUSH = $Yes; $OUTPUT_AUTOFLUSH = $No;
  &archive_List($NameOfBackupArchiveFile);
  $NA = $NA + 1;
  }
#print(STDERR "at end of list loop\n");
&deleteTmpFilesAndExit(0);
#&deleteTmpFilesAndExit(1)
}  # end of if ( $Action == $List



if ( $Action == $Find )  {
if ( $NumberOfLastBackup < 1 )  { &zNoOldBackups }
if ( $PatternsFrom ne '' )  {
  open(FH_P,"< $PatternsFrom") or &zNoOpenR($PatternsFrom);
  while ( <FH_P> )   { chomp($_); push(@Patterns,$_) }
  close(FH_P);
  }
if ( $#Patterns < 0 )  { &zNothingToF }
$NA = 1;
while ( $NA <= $NumberOfLastBackup )  {
  if ( -e "$LsListNameBase$NA" )  { $LsList = $LsListNameBase . $NA }
  elsif ( -e "$LsListNameBase$NA$CompressionExtension" )  {
      $LsList = $LsListNameBase . $NA . $TempExtension;
      push(@TempFiles,$LsList);
      &runExternalCommand(("$UncompressStdin" .
        " < $LsListNameBase$NA$CompressionExtension" .
        " > $LsList"), 'uncompression command');
      }
  else  { &zNoLsList; $NA = $NA + 1; next }
  $DirectoryFromLsList = '';
  open(FH_LsList,"< $LsList") or &zNoOpenR($LsList);
  $LastLineWasBlank = $No;
  while ( <FH_LsList> )  {
    chomp($_);
    if ( $_ eq '' )  { $LastLineWasBlank = $Yes; next }
    if ( substr($_,0,6) eq 'total ' )  { next }
    else  {
      if ( $LastLineWasBlank == $Yes     and     substr($_,-1) eq ':' )  {
        $DirectoryFromLsList = substr($_,0,-1);
        $LastLineWasBlank = $No;
        next;
        }
      $LastLineWasBlank = $No;
      }
    ($SA,undef) = &parseLsLine($_);
    if ( $DirectoryFromLsList ne '' )
        { $SA = $DirectoryFromLsList . '/' . $SA }
    $NB = 0;
    while ( $NB <= $#Patterns )  {
      if ( $SA =~ m/$Patterns[$NB]/ )  {
        #print("$SA matches '$Patterns[$NB]'\n");
        #print($FindSeperator,'-',$SA, "\n");
        print($NA,$FindSeperator, $SA, "\n", $_, "\n");
        last;
        }
      #print("$SA does not match '$Patterns[$NB]'\n");
      $NB = $NB + 1;
      }
    }
  $NA = $NA + 1;
  }
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $Find )



if ( $Action == $CompareSelectedFiles     or
     $Action == $RestoreSelectedFiles )  {
my   $ControlList = '';
while ( defined($SA = pop(@FileNames)) )  { &getBackupNumberAndFileName($SA) }
if ( $FileNamesFrom ne '' )  {
  open(FH_FileNamesFrom,"< $FileNamesFrom") or zNoOpenR($FileNamesFrom);
  while ( defined($SA = <FH_FileNamesFrom>) )  {
    chomp($SA);
    &getBackupNumberAndFileName($SA);
    }
  close(FH_FileNamesFrom);
  }
if ( $#FileToCompareOrRestore == -1 )  { &zNothingToCR }
&startMdti;
push(@TempFiles,$TemporaryControlList);
my $BackupNumber = $FirstBackupToCompareOrRestoreFrom;
while ( $BackupNumber <= $LastBackupToCompareOrRestoreFrom )  {
  $NameCount = 0;
  while ( $NameCount <= $#FileToCompareOrRestore )  {
    if ( $BackupToCompareOrRestoreFrom[$NameCount] eq $BackupNumber )  {
      $ControlList =
          $ControlList . $FileToCompareOrRestore[$NameCount] . "\n";
      splice(@BackupToCompareOrRestoreFrom,$NameCount,1);
      splice(@FileToCompareOrRestore,$NameCount,1);
      next;
      }
    $NameCount = $NameCount + 1;
    }
  if ( $ControlList ne '' )  {
    open(FH_TemporaryControlList,"> $TemporaryControlList") or &zNoOpenW;
    print(FH_TemporaryControlList $ControlList);
    close(FH_TemporaryControlList);
    $ControlList = '';
    chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
    if ( $Action == $CompareSelectedFiles )
          { &archive_Compare("$ConfigDirectory/$TemporaryControlList",
               ($BackupFileNameBase . $BackupNumber .
               $BackupFileNameExtension)) }
    else  { &archive_Restore("$ConfigDirectory/$TemporaryControlList",
           ($BackupFileNameBase . $BackupNumber .
           $BackupFileNameExtension)) }
    chdir($ConfigDirectory) or &zNoCD($ConfigDirectory);
    }
  $BackupNumber = $BackupNumber + 1;
  }
&deleteTmpFilesAndExit(0);
}  # end of if ( $Action == $CompareSelectedFiles     or
   #             $Action == $RestoreSelectedFiles )  {



if ( $Action == $CheckConfiguration )  {
if ( $AnErrorOccurred == $No )
  { print("\nparanoidbackup.pl: configuration is ok\n") }
&startMdti;
&deleteTmpFilesAndExit(0);
}



if ( $Action == $MakeVirtualRestoreList )  {
if ( -e $VirtualRestoreList )  {
  print(STDERR "
paranoidbackup.pl: unable to make virtual restore list because there is
already a file named $VirtualRestoreList
");
  &deleteTmpFilesAndExit(1);
  }
if ( -e ($VirtualRestoreList . $CompressionExtension) )  {
  print(STDERR "
paranoidbackup.pl: unable to make virtual restore list because there is
already a file named $VirtualRestoreList$CompressionExtension
");
  &deleteTmpFilesAndExit(1);
  }
&listCurrentFiles;
if ( $CompressLists == $Yes )
   { &runExternalCommand("$CompressStdin < $CurrentFilesList > " .
       "$VirtualRestoreList$CompressionExtension",'compression command') }
else { &runExternalCommand("cp $CurrentFilesList $VirtualRestoreList",
            'copy command') }
&deleteTmpFilesAndExit(0);
}



print(STDERR '
paranoidbackup.pl: bug detected: action command line parameter
is not missing, but no action taken
');
&deleteTmpFilesAndExit(40);



sub archive_Compare  {
my $SA;
# $_[0]  is name of the control file, which contains a list of files
# to backup/compare/restore to/from the archive.
# $_[1]  is the name of the file which is the backup archive
&mdtiCommand("read\n$_[1]\n");
if ( $IncludeCorruptedFiles == $Yes )
  { $SA = $ArchiveProgram . ' ' . $ArchiveOption_Compare . ' ' .
     $ArchiveOption_IncludeCorruptedFiles . ' ' .
     $ArchiveOption_FileListForRestoreOrCompare . $_[0] . ' ' .
     $ArchiveOption_ArchiveIsStdInOrOut . ' < ' . $MdtiDirectory . '/data' }
else  { $SA = $ArchiveProgram . ' ' . $ArchiveOption_Compare . ' ' .
     $ArchiveOption_FileListForRestoreOrCompare . $_[0] . ' ' .
     $ArchiveOption_ArchiveIsStdInOrOut . ' < ' . $MdtiDirectory . '/data' }
$LastArchiveProgramExitCode = system($SA) / 256;
if ( $LastArchiveProgramExitCode > 0 )  { &zArchEx($SA) }
if ( $LastArchiveProgramExitCode > $ArchiveProgram_MaximumExitCode )  {
  $AnErrorOccurred = $Yes;
  $AnErrorOccurredLastMdtiCommand = $Yes;
  }
&mdtiResult;
}



sub archive_List {
# $_[0]  is the name of the file which is the backup archive
my $SA;
&mdtiCommand("read\n$_[0]\n");
$SA = $ArchiveProgram . ' ' . $ArchiveOption_List . ' ' .
    $ArchiveOption_ArchiveIsStdInOrOut . ' < ' . $MdtiDirectory . '/data';
$LastArchiveProgramExitCode = system($SA) / 256;
if ( $LastArchiveProgramExitCode > 0 )  { &zArchEx($SA) }
if ( $LastArchiveProgramExitCode > $ArchiveProgram_MaximumExitCode )  {
  $AnErrorOccurred = $Yes;
  $AnErrorOccurredLastMdtiCommand = $Yes;
  }
&mdtiResult;
}



sub archive_MakeArchive {
# $_[0]  is name of the control file, which contains a list of files
# to backup/compare/restore to/from the archive.
# $_[1]  is the name of the file which is the backup archive
my $SA;
&mdtiCommand("create\n$_[1]\n");
$SA = $ArchiveProgram . ' ' . $ArchiveOption_MakeArchive . ' ';
if ( $IncludeCorruptedFiles == $Yes )
    { $SA = $SA . $ArchiveOption_IncludeCorruptedFiles . ' ' }
if ( $ArchiveOption_FileListForMakeArchive eq '<' )
    { $SA = $SA . $ArchiveOption_ArchiveIsStdInOrOut .
        ' < ' . $_[0] . ' > ' . $MdtiDirectory . '/data' }
else  { $SA = $SA . $ArchiveOption_FileListForMakeArchive . $_[0] . ' ' .
    $ArchiveOption_ArchiveIsStdInOrOut . ' > ' . $MdtiDirectory . '/data' }
$LastArchiveProgramExitCode = system($SA) / 256;
if ( $LastArchiveProgramExitCode > 0 )  { &zArchEx($SA) }
if ( $LastArchiveProgramExitCode > $ArchiveProgram_MaximumExitCode )  {
  $AnErrorOccurred = $Yes;
  $AnErrorOccurredLastMdtiCommand = $Yes;
  }
&mdtiResult;
}


sub archive_Restore {
# $_[0]  is name of the control file, which contains a list of files
# to backup/compare/restore to/from the archive.
# $_[1]  is the name of the file which is the backup archive
my $SA;
&mdtiCommand("read\n$_[1]\n");
$SA = $ArchiveProgram . ' ' . $ArchiveOption_Restore . ' ';
if ( $IncludeCorruptedFiles == $Yes )
    { $SA = $SA . $ArchiveOption_IncludeCorruptedFiles . ' ' }
if ( $_[0] eq '' )  { $SA = $SA . $ArchiveOption_ArchiveIsStdInOrOut .
     ' < ' . $MdtiDirectory . '/data' }
else  { $SA = $SA . $ArchiveOption_FileListForRestoreOrCompare . $_[0] .
    ' ' . $ArchiveOption_ArchiveIsStdInOrOut .
    ' < ' . $MdtiDirectory . '/data' }
$LastArchiveProgramExitCode = system($SA) / 256;
if ( $LastArchiveProgramExitCode > 0 )  { &zArchEx($SA) }
if ( $LastArchiveProgramExitCode > $ArchiveProgram_MaximumExitCode )  {
  $AnErrorOccurred = $Yes;
  $AnErrorOccurredLastMdtiCommand = $Yes;
  }
&mdtiResult;
}



sub deleteTmpFilesAndExit  {
#print(STDERR "about to stop mdti\n");
if ( $MdtiRunning == $Yes    and    -p "$MdtiDirectory/commands" )  {
  sleep(5);
  open(FH_MdtiCommands, "> $MdtiDirectory/commands");
  print(FH_MdtiCommands "exit\n");
  close(FH_MdtiCommands);
  }
#print(STDERR "about to change directory\n");
chdir($ConfigDirectory);
#$AnErrorOccurred = $Yes;
#print(STDERR "about to delete temporary files ",@TempFiles,"\n");
if  ( $BackupIsIncomplete )  { print(STDERR "
paranoidbackup.pl: backup was incomplete. Read the section on
incomplete backups in the file paranoidbackup.text.\n") }

if  ( $BackupIsIncomplete   or   $AnErrorOccurred )  {
  if  ( $#TempFiles > -1 )  {
    print(STDERR "
paranoidbackup.pl: an error occurred,
so the following temporary files were not deleted:
");
    for ( @TempFiles )  { print(STDERR "$_\n") }
    }
  }
else  { unlink(@TempFiles) }
#print(STDERR "about to exit, \$_[0] is $_[0]\n");
exit($_[0]);
}




sub findNextNonWhitespace  {
my $NA = $_[1];
my $SA = '';
while () {
  $SA = substr($_[0],$NA,1);
  if ($SA eq '')  { return($NA) }
  if ($SA eq '\r' or $SA eq '\n' or $SA eq '\t' or $SA eq ' ')
      { $NA = $NA + 1; next }
  return($NA);
  }
}


sub findNextWhitespace  {
my $NA = $_[1];
my $SA = '';
while () {
  $SA = substr($_[0],$NA,1);
  if ($SA eq '')  { return($NA) }
  if ($SA eq '\r' or $SA eq '\n' or $SA eq '\t' or $SA eq ' ')
      { return($NA) }
  $NA = $NA + 1;
  }
}



sub getBackupNumberAndFileName  {
my $NA = index($_[0],$FindSeperator);
if ( $NA < 0 )  { &zNoFileName($_[0]); return }
my $NB = substr($_[0],0,$NA);
my $SA = substr($_[0],($NA + $LengthOfFindSeperator));
# if $NB is not numeric, perl will give a warning, but $NB will be zero
# so the test will work.
if ( $NB < 1   or   $NB > $NumberOfLastBackup )  {
  print(STDERR "
paranoidbackup.pl: no backup number in
$_[0]
"); return }
if ( ! defined($FirstBackupToCompareOrRestoreFrom) )
   { $FirstBackupToCompareOrRestoreFrom = $NB }
else { if ( $NB < $FirstBackupToCompareOrRestoreFrom )  
          { $FirstBackupToCompareOrRestoreFrom = $NB } }
if ( ! defined($LastBackupToCompareOrRestoreFrom) )
   { $LastBackupToCompareOrRestoreFrom = $NB }
else { if ( $NB > $LastBackupToCompareOrRestoreFrom )
          { $LastBackupToCompareOrRestoreFrom = $NB } }
push(@BackupToCompareOrRestoreFrom,$NB);
push(@FileToCompareOrRestore,$SA);
}



sub listCurrentFiles  {
$CurrentFilesList = $CurrentFilesList . $PROCESS_ID;
push(@TempFiles,$CurrentFilesList);
if ( defined($PreLsCommands) )   { if ( $PreLsCommands ne '' )
       { &runExternalCommand($PreLsCommands,'PreLsCommands') } }
chdir($DirectoryToBackup) or &zNoCD($DirectoryToBackup);
&runExternalCommand(
  "lsincexc.pl --include-exclude-file=$ConfigDirectory/$DirectoryIncludeExclude > $CurrentFilesList",
  'file listing command');
chdir($ConfigDirectory) or &zNoCD($ConfigDirectory);
if ( defined($PostLsCommands) )   { if ( $PostLsCommands ne '' )
    { &runExternalCommand($PostLsCommands,'PostLsCommands') } }
}




sub mdtiCommand  {
#print(STDERR "sub mdtiCommand $_[0]\n");
if ( ! defined($_[0]) )  { &zMdtiNoCommandToSend }
if ( ! -p "$MdtiDirectory/commands" )  { &zMdtiNoCommandPipe }
sleep(5);
$LastMdtiCommand = $_[0];
$AnErrorOccurredLastMdtiCommand = $No;
open(FH_MdtiCommands, "> $MdtiDirectory/commands")
           or &zMdtiNoOpenCommands;
print(FH_MdtiCommands $LastMdtiCommand) or &zMdtiNoWriteCommands;
close(FH_MdtiCommands);
}



sub mdtiResult  {
#print(STDERR "sub mdtiResult\n");
my $NA; my $SA; my @A;
if ( ! -p "$MdtiDirectory/commands" )  { &zMdtiNoCommandPipe }
sleep(5);
#print(STDERR "sending result command\n");
open(FH_MdtiCommands, "> $MdtiDirectory/commands")
           or &zMdtiNoOpenCommands;
print(FH_MdtiCommands "result\n") or &zMdtiNoWriteCommands;
close(FH_MdtiCommands);
#print(STDERR "getting response\n");
open(FH_MdtiData, "< $MdtiDirectory/data") or &zMdtiNoOpenData;
$NA = 0;
@A = ();
while ( defined($SA = <FH_MdtiData>)    and    $NA < 10 )  {
  #print("receiving result: $SA");
  push(@A,$SA);
  $NA = $NA + 1;
  }
close(FH_MdtiData);
#print("full result received is:\n@A");
#print("\$A[1] is '$A[1]'\n");
if ( ! defined($A[0]) )  { &zMdtiNoResult('') }
#print("\$A[0] is '$A[0]'\n");
if ( $A[0] eq "failure\n" )  {
  $AnErrorOccurredLastMdtiCommand = $Yes;
  $AnErrorOccurred = $Yes;
  }
if ( $AnErrorOccurredLastMdtiCommand )  { &zMdtiFailure(@A);return }
if ( $A[0] eq "success\n" )  { return }
&zMdtiNoResult(@A);
}



sub modifyOldControlLists  {
# remove deleted and changed files from the old control lists, and add the
# modified control lists to the list of control files
my $LastVersionNumber = 1;
# uncompress the old control lists
my $NA = 1;
while ( $NA < $NumberOfThisBackup )  {
  if ( ! -e "$ControlNameBase$NA" )  {
    if ( -e "$ControlNameBase$NA$CompressionExtension" )  {
      &runExternalCommand(("$UncompressStdin" .
        " < $ControlNameBase$NA$CompressionExtension" .
        " > $ControlNameBase$NA"), 'uncompression command');
      #print("uncompressing $ControlNameBase$NA\n");
      }
    else  { &zNoControlList($NA) }
    }
  # the file may not exist, but it does no harm to delete a file
  # which does not exist, so why bother to check if it exists?
  unlink($ControlNameBase . $NA . $CompressionExtension);
  rename($ControlNameBase . $NA,
         $ControlNameBase . $NA . $TempExtension . $LastVersionNumber);
  $NA = $NA + 1;
  }

# If the control list has a size of zero, we could skip adjusting it,
# because we will never remove anything from an empty control list. That
# would make paranoid backup a little faster, but I have not bothered to
# code it.
# running on a computer with 32 megabytes of memory, with a deleted and
# changed files list of 330,000 bytes, grep ran out of memory. grep reads
# the deleted and changed files list into memory, and the memory used will
# be larger than the size of the file, but the amount of memory used should
# not be more than twice the size of the file. So why did grep run out of
# memory? I tried to duplicate this error in a grep command without running
# paranoid backup; even with a deleted and changed files list of 1,500,000
# bytes, grep did not run out of memory. Maybe the tape server uses too much
# memory for tape buffers. But the tape server buffers are empty while
# paranoid backup is running grep; doesn't perl automatically unallocate
# string memory if the size of the string is reduced to 0? Maybe the tape
# server needs to unallocate the memory after it empties the buffers.
# So we have to make sure the deleted and changed files list
# is not too large. If the list is too large, we need to split it into
# multiple small lists, and run one small list at a time.
# The small lists will be slightly larger than
# $MaxSizeDeletedAndChangedFilesList because we make the small list to a size
# of $MaxSizeDeletedAndChangedFilesList, then add the rest of the current
# line because the list needs to contain whole lines. So if the complete
# list is a few bytes larger than $MaxSizeDeletedAndChangedFilesList, then
# the first part list might be the same as the complete list, which is the
# same as if we had not split the list at all, except we wasted time
# splitting the list. This is inefficient but harmless, and I think that
# situation is rare, so I have not done anything to prevent it.
if ( (-s $DeletedAndChangedFiles) <= $MaxSizeDeletedAndChangedFilesList )  {
  my $NB = $LastVersionNumber;
  $LastVersionNumber = $LastVersionNumber + 1;
  $NA = 1;
  while ( $NA < $NumberOfThisBackup )  {
    &modifyOneControlList(
         $ControlNameBase . $NA . $TempExtension . $NB,
         $ControlNameBase . $NA . $TempExtension . $LastVersionNumber,
         $DeletedAndChangedFiles);
    $NA = $NA + 1;
    }
  }
else  {
  my $LastDelListNumber = 0;
  open(FH_BigDelList, "< $DeletedAndChangedFiles");
  until ( eof(FH_BigDelList) )  {
   $LastDelListNumber = $LastDelListNumber + 1;
    my $LittleDelList = $DeletedAndChangedFiles . $LastDelListNumber;
    push(@TempFiles, $LittleDelList);
    open(FH_LittleDelList, "> $LittleDelList");
    # when we do print(), perl puts the data in a buffer, and writes the
    # data to the file later. Since the data probably has not been written to
    # the file yet, -s returns the old size of the file. Since we mistakenly
    # think the file is smaller than it is, we write extra data to the file.
    # Thus the file becomes slightly larger than we intended.
    # we could fix this problem by using syswrite() instead of print, or by
    # keeping a count of how much data we have written to the file.
    # The files seem to become 1K to 2K larger than we intended. That is
    # not a large error, and we do not need an exact file size, and it is
    # not causing me any problems, so I do not see any reason to fix this.
    # maybe we should count the lines instead of checking the file size.
    while ( ( -s $LittleDelList ) < $MaxSizeDeletedAndChangedFilesList )  {
       my $SB;
       if ( defined( $SB = <FH_BigDelList> ) ) 
             { print(FH_LittleDelList $SB) }
       else { last }
       }
    close(FH_LittleDelList);
    }
  close(FH_BigDelList);
  my $DelListNumber = 1;
  while ( $DelListNumber <= $LastDelListNumber )  {
    my $NB = $LastVersionNumber;
    $LastVersionNumber = $LastVersionNumber + 1;
    $NA = 1;
    while ( $NA < $NumberOfThisBackup )  {
      &modifyOneControlList(
           $ControlNameBase . $NA . $TempExtension . $NB,
           $ControlNameBase . $NA . $TempExtension . $LastVersionNumber,
           $DeletedAndChangedFiles . $DelListNumber);
      $NA = $NA + 1;
      }
    $DelListNumber = $DelListNumber + 1;
    }
  }

# recompress the old control lists, and add the old control lists to the
# temporary control list
$NA = 1;
while ( $NA < $NumberOfThisBackup )  {
  #print("\$NA is '$NA'\n");
  my $ListName = $ControlNameBase . $NA;
  #print("\$ListName is '$ListName'\n");
  my $ListNameCompressed = $ControlNameBase . $NA . $CompressionExtension;
  #print("\$ListNameCompressed is '$ListNameCompressed'\n");
  my $ListNameTmp =
      $ControlNameBase . $NA . $TempExtension . $LastVersionNumber;
  #print("\$ListNameTmp is '$ListNameTmp'\n");
  my $ListSize = -s($ListNameTmp);
  #print("size of '$ListNameTmp' is '$ListSize'\n");
  if ( $ListSize <= $TooSmallToCompress     or
       $CompressLists == $No    or    $AnErrorOccurred )  {
    #print("not compressing '$ListNameTmp'\n");
    rename($ListNameTmp,$ListName);
    print(FH_TemporaryControlList $ListName, "\n");
    }
  else  {
    #print("compressing '$ListNameTmp'\n");
    &runExternalCommand(("$CompressStdin < $ListNameTmp > " .
        $ListNameCompressed), 'compression command');
    print(FH_TemporaryControlList $ListNameCompressed, "\n");
    }
  # the versions of the control lists which existed when we started paranoid
  # backup need to be added to the list of temporary files, because we want
  # these files to be deleted after the backup is successfully completed.
  # we could have added these file names to the list of temporary files
  # earlier. But I thought it was better to wait as long as possible before
  # adding these file names to the list of temporary files because if the
  # backup fails and we want to undo the failed backup, then we would want
  # these files. I wanted to be sure these files would NOT be deleted if the
  # backup failed. 
  push(@TempFiles,$ControlNameBase . $NA . $TempExtension . '1');
  $NA = $NA + 1;
  }
}



sub modifyOneControlList  {
my $NA;
#print("sub modifyOneControlList called with '$_[0]' '$_[1]' '$_[2]'\n");
push(@TempFiles, $_[1]);
$NA = system("grep -Fvxf $_[2] $_[0] > $_[1]");
#print("grep -Fvxf $_[2] $_[0] > $_[1] returned $NA\n");
# the exit code of grep is 0 if matches were found, 1 if no matches were
# found, 2 if error. So we need to recognize that exit code 1 is not an
# error, but exit code 2 is an error.
if ( $NA == 0    or    $NA == 256 )  { return }
$AnErrorOccurred = $Yes;
print(STDERR "
paranoidbackup.pl: the following grep command:
grep -Fvxf $_[2] $_[0] > $_[1]
returned an exit code of ",($NA/256),"
maybe you need to set MaxSizeDeletedAndChangedFilesList smaller
");
if ( $IgnoreGrepErrors == $No )  { print(STDERR
"probably you should manually remove the changed and deleted files from the
old control lists. If grep failed while trying to create
'",$ControlNameBase,"6",$TempExtension,"8'; then for control lists 1 to 6,
your manually edited control lists should have names like
'",$ControlNameBase,"1",$TempExtension,"8',
'",$ControlNameBase,"6",$TempExtension,"8', etc; and the rest of the control
lists should have names like '",$ControlNameBase,"7",$TempExtension,"7',
'",$ControlNameBase,"8",$TempExtension,"7', etc; except the very last control
list should not be changed. Then replace the deleted and changed files lists
with zero length files, and then press enter to continue.
");
  $SA = <STDIN>;
  }
}



sub parseLsLine  {
# The exact format of the ls line varies depending on what version of ls
# we are using. Also, if one number like the size or number of hard links
# is unusually large, extra characters are inserted, and the following
# fields are shifted. The easy way to parse the ls line would be to cut at
# certain character positions; however that would result in errors
# if the format of the ls line varied. That is this looks for the next
# whitespace, looks for the next nonwhitespace, etc.
# This sub returns '' for every piece of data which it cannot extract
# from the input. It is up to the calling routine to decide whether or
# not that is an error.
chomp($_[0]);
my $Name;
my $LinksTo = '';
my $Size = '';
my $MajorNumber = '';
my $MinorNumber = '';
my $Type = substr($_[0],0,1);
my $Permissions = substr($_[0],1,9);
my $SP1 = 11;
$SP1 = &findNextNonWhitespace($_[0],$SP1);
my $SP2 = &findNextWhitespace($_[0],$SP1);
my $HardLinks = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1);
my $UID = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1);
my $GID = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
if ( $Type eq 'b'  or  $Type eq 'c' )  {
  $SP2 = index($_[0],',',$SP1);
  if ( $SP2 < $SP1 ) { $SP2 = length($_[0]) }
  $MajorNumber = substr($_[0],$SP1,$SP2-$SP1);
  $SP1 = &findNextNonWhitespace($_[0],$SP2+1);
  $SP2 = &findNextWhitespace($_[0],$SP1);
  $MinorNumber = substr($_[0],$SP1,$SP2-$SP1);
  }
else  {
  $SP2 = &findNextWhitespace($_[0],$SP1);
  $Size = substr($_[0],$SP1,$SP2-$SP1);
  }
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1 + 23);
my $Date = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
if ( $Type eq 'l' )  {
  $SP2 = index($_[0],' -> ',$SP1);
  if ( $SP2 < $SP1 ) { $SP2 = length($_[0]) }
  $Name = substr($_[0],$SP1,$SP2-$SP1);
  $LinksTo = substr($_[0],$SP2+4);
  }
else {
  $Name = substr($_[0],$SP1);
  }
#print("Name is '$Name'\n");
#print("Type is '$Type'\n");
#print("Permissions is '$Permissions'\n");
#print("HardLinks is '$HardLinks'\n");
#print("UID is '$UID'\n");
#print("GID is '$GID'\n");
#print("Size is '$Size'\n");
#print("MajorNumber is '$MajorNumber'\n");
#print("MinorNumber is '$MinorNumber'\n");
#print("Date is '$Date'\n");
#print("LinksTo is '$LinksTo'\n");
return($Name,$Type,$Permissions,$HardLinks,$UID,$GID,$Size,$MajorNumber,
       $MinorNumber,$Date,$LinksTo);
}



sub readConfigurationFile  {
$FileNumber = $FileNumber + 1;
if ( $FileNumber > $MaxNestedConfigFiles )  {
    print(STDERR "
paranoidbackup.pl: There are too many configuration files within other
configuration files. Configuration files are nested $FileNumber
levels deep or deeper. Are you sure you do not have an infinite
nesting, where file A includes file B, and file B includes file A?
");
  &deleteTmpFilesAndExit(11);
  }
$CurrentFileHandle = "C$FileNumber";
if ( ! open($CurrentFileHandle, "< $_[0]") )  {
    print(STDERR "
paranoidbackup.pl: unable to read configuration file
$_[0]
");
  &deleteTmpFilesAndExit(11);
  }
while (<$CurrentFileHandle>)  {
  my $SA; my $SB; my $NA;
  chomp $_;
  if ( $_ eq '' )  { next }
  if ( substr($_,0,1) eq '#' )  { next }
  $NA = index($_,'=');
  if ( $NA < 0 )  {
    print(STDERR "
paranoidbackup.pl: configuration file error: line does not contain \'=\'
current configuration file is $_[0]
current line is $_
");
    $AnErrorOccurred = $Yes;
    next;
    }
  if ( $NA == 0 )  {
    print(STDERR "
paranoidbackup.pl: configuration file error: line begins with \'=\'
current configuration file is $_[0]
current line is $_
");
    $AnErrorOccurred = $Yes;
    next;
    }
  $SA = substr($_,0,$NA);
  $SB = substr($_,($NA + 1));
  if ( $WarnAboutTrailingSpaces == $Yes    and    substr($SB,-1) eq ' ' )  {
    print(STDERR "
paranoidbackup.pl: warning: line in configuration file ends in space.
paranoidbackup.pl is assuming this is correct.
current configuration file is $_[0]
current line is $_
");
    }
  if ( $SA eq 'include' )  {
    &readConfigurationFile($SB);
    next;
    }
  # everything we read from the configuration file is a string.
  # if we are expecting a number, I set the option to $SB+0 instead of $SB.
  # I added 0 to make sure that perl converts the string to a number.
  if($SA eq 'AddToPath'){$AddToPath=$SB;next}
  if($SA eq 'ArchiveOption_ArchiveIsStdInOrOut')
    {$ArchiveOption_ArchiveIsStdInOrOut=$SB;next}
  if($SA eq 'ArchiveOption_Compare'){$ArchiveOption_Compare=$SB;next}
  if($SA eq 'ArchiveOption_FileListForRestoreOrCompare')
    {$ArchiveOption_FileListForRestoreOrCompare=$SB;next}
  if($SA eq 'ArchiveOption_FileListForMakeArchive')
    {$ArchiveOption_FileListForMakeArchive=$SB;next}
  if($SA eq 'ArchiveOption_IncludeCorruptedFiles')
    {$ArchiveOption_IncludeCorruptedFiles=$SB;next}
  if($SA eq 'ArchiveOption_List'){$ArchiveOption_List=$SB;next}
  if($SA eq 'ArchiveOption_MakeArchive'){$ArchiveOption_MakeArchive=$SB;next}
  if($SA eq 'ArchiveOption_Restore'){$ArchiveOption_Restore=$SB;next}
  if($SA eq 'ArchiveProgram_MaximumExitCode')
    {$ArchiveProgram_MaximumExitCode=$SB;next}
  if($SA eq 'ArchiveProgram'){$ArchiveProgram=$SB;next}
  if($SA eq 'BackupFileNameBase'){$BackupFileNameBase=$SB;next}
  if($SA eq 'BackupFileNameExtension'){$BackupFileNameExtension=$SB;next}
  if($SA eq 'BeforeNewFilesList'){$BeforeNewFilesList=$SB;next}
  if($SA eq 'directory include excludes'){$DirectoryIncludeExclude=$SB;next}
  if($SA eq 'CFLIncludeExcludes'){$CFLIncludeExcludes=$SB;next}
  if($SA eq 'CFLoptions'){$CFLoptions=$SB;next}
  if($SA eq 'ControlFilesBackupNameBase'){$ControlFilesBackupNameBase=$SB;next}
  if($SA eq 'ControlNameBase'){$ControlNameBase=$SB;next}
  if($SA eq 'CompareFileLists'){$CompareFileLists=$SB;next}
  if($SA eq 'CompressionExtension'){$CompressionExtension=$SB;next}
  if($SA eq 'CompressLists')  {
    if ( $SB eq 'yes' )  { $CompressLists=$Yes }
    elsif ( $SB eq 'no' )  { $CompressLists=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if($SA eq 'CompressStdin'){$CompressStdin=$SB;next}
  if($SA eq 'CurrentFilesList'){$CurrentFilesList=$SB;next}
  if($SA eq 'DeletedAndChangedFiles'){$DeletedAndChangedFiles=$SB;next}
  if($SA eq 'DirectoryToBackup'){$DirectoryToBackup=$SB;next}
  if($SA eq 'ExcludedNewFilesLsListNameBase')
    {$ExcludedNewFilesLsListNameBase=$SB;next}
  if($SA eq 'FindSeperator'){$FindSeperator=$SB;next}
  if($SA eq 'LsListNameBase'){$LsListNameBase=$SB;next}
  if($SA eq 'MaxNestedConfigFiles'){$MaxNestedConfigFiles=$SB+0;next}
  if($SA eq 'MaxSizeDeletedAndChangedFilesList')
    {$MaxSizeDeletedAndChangedFilesList=$SB + 0;next}
  if($SA eq 'MdtiDirectory'){$MdtiDirectory=$SB;next}
  if($SA eq 'PreLsCommands'){$PreLsCommands=$SB;next}
  if($SA eq 'before accessing backups commands')
    {$PreAccessToBackupsCommands=$SB;next}
  if($SA eq 'PostLsCommands'){$PostLsCommands=$SB;next}
  if($SA eq 'TempExtension'){$TempExtension=$SB;next}
  if($SA eq 'TemporaryControlList'){$TemporaryControlList=$SB;next}
  if($SA eq 'TooSmallToCompress'){$TooSmallToCompress=$SB;next}
  if($SA eq 'UncompressStdin'){$UncompressStdin=$SB;next}
  if($SA eq 'VirtualRestoreList'){$VirtualRestoreList=$SB;next}
  if($SA eq 'WarnAboutTrailingSpaces')  {
    if ( $SB eq 'yes' )  { $WarnAboutTrailingSpaces=$Yes }
    elsif ( $SB eq 'no' )  { $WarnAboutTrailingSpaces=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  print(STDERR "
paranoidbackup.pl: configuration file error: unknown option $SA
current configuration file is $_[0]
current line is $_
");
  $AnErrorOccurred = $Yes;
  }
$FileNumber = $FileNumber - 1;
if ( $FileNumber < 0 )  {
    print(STDERR "
paranoidbackup.pl: bug detected: \$FileNumber is $FileNumber.
This is less than 0; it is not supposed to be less than 0.
");
  &deleteTmpFilesAndExit(40);
  }
$CurrentFileHandle = "C$FileNumber";
}



sub runExternalCommand  {
my $NA; my $SA = 'external command';
if ( defined($_[1]) )  { $SA = $_[1] }
$NA = system($_[0]);
if ( $NA != 0 )  {
  print(STDERR "
paranoidbackup.pl: the following $SA
$_[0]
returned an exit code of ",($NA/256),"\n");
  &deleteTmpFilesAndExit(20);
  }
}




sub startMdti  {
my $NA;
if ( $MdtiRunning == $Yes )  { return }
if ( ! -d $MdtiDirectory )  { &zMdtiNoDirectory }
if ( -e "$MdtiDirectory/commands" )  { &zMdtiAlreadyOn }
$ChildPID = fork;
if ( ! defined($ChildPID) )  { &zNoFork }
# The parent runs in the foreground, the child runs in the background.
# The final exit code is the exit code of the parent.
# My first thought was to have paranoidbackup.pl be the parent, and let
# the server run in the background. But paranoidbackup.pl does not need to
# get user input, while the server might want user input. So I am trying
# letting the server be the parent. But I want the exit code from
# paranoidbackup.pl, not the exit code of the server, so the parent must
# trap the exit code from the child, and return that as the final exit code.
# if ( $ChildPID == 0 )  { exec("$MdtiDirectory/start") or &zMdtiStartFailed }
if ( $ChildPID != 0 )  { 
  $ServerExitStatus = system("$MdtiDirectory/start");
  if ( $ServerExitStatus > 0 )  { &zMdtiStartFailed($ServerExitStatus) }
  #print(STDERR "waiting for child\n");
  waitpid($ChildPID,0);
  #print(STDERR "child is done\n");
  $NA = $CHILD_ERROR >> 8;
  if ( $ServerExitStatus > 0     and     $NA < 10 )  { exit(20) }
  exit($NA);
  }
sleep(5);
if ( ! -e "$MdtiDirectory/commands" )  {
    sleep(20);
    if ( ! -e "$MdtiDirectory/commands" )  { &zMdtiNoCommands }
    }
$MdtiRunning = $Yes;
}



sub zArchEx  { print(STDERR "
paranoidbackup.pl: The following archive program command
$_[0]
returned an exit code of $LastArchiveProgramExitCode
"); return }

sub zConfigYorN  { print(STDERR "
paranoidbackup.pl: $_[0] should be set to 'yes' or 'no'; not '$_[1]'
"); $AnErrorOccurred = $Yes; return }

sub zDelSize0  { print(STDERR "
paranoidbackup.pl: MaxSizeDeletedAndChangedFilesList is set to
'$MaxSizeDeletedAndChangedFilesList'. It must be more than 0.
"); $AnErrorOccurred = $Yes; return }

sub zdr1aNoError  { print(STDERR "
paranoidbackup.pl: No errors occurred while restoring control files
backup; so you could be doing a normal restore instead of
--desperate-restore-1a
"); return }

sub zMdtiAlreadyOn  { print(STDERR "
paranoidbackup.pl: unable to start the multiple disk or tape interface
because it is already running, which means it is probably in use by another
program. If it is not in use, stop it; if it is not running, delete
$MdtiDirectory/commands; and try again.
"); &deleteTmpFilesAndExit(20) }

sub zMdtiFailure  { print(STDERR "
paranoidbackup.pl: The multiple disk or tape interface returned the
following result:
"); for ( @_ )  { print(STDERR $_) }
print(STDERR "The last command was:
$LastMdtiCommand
");
if ( $Force== $Yes  ) { return }
&deleteTmpFilesAndExit(20);
}

sub zMdtiNoCommands  { print(STDERR "
paranoidbackup.pl: \'$MdtiDirectory/commands\' was not created when the
multiple disk or tape interface was started. Probably the interface is not
working.
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoCommandPipe  { print(STDERR "
paranoidbackup.pl: there is no pipe named $MdtiDirectory/commands
Probably the mdti server is not running.
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoCommandToSend  { print(STDERR "
paranoidbackup.pl: bug detected: sub mdtiCommand called with no command to
send to mdti
"); &deleteTmpFilesAndExit(40) }

sub zMdtiNoDirectory  { print(STDERR "
paranoidbackup.pl: The directory for the multiple disk or tape interface is
supposed to be \'$MdtiDirectory\', but there is no such directory
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoOpenCommands  { print(STDERR "
paranoidbackup.pl: unable to open $MdtiDirectory/commands
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoOpenData  { print(STDERR "
paranoidbackup.pl: unable to open $MdtiDirectory/data
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoResult  { print(STDERR "
paranoidbackup.pl: the multiple disk or tape interface did not return a
correct result. What it actually returned was:
"); for ( @_ )  { print(STDERR $_) }
print(STDERR "The last command was:
$LastMdtiCommand
");
$AnErrorOccurredLastMdtiCommand = $Yes;
$AnErrorOccurred = $Yes;
if ( $Force == $Yes ) { return }
&deleteTmpFilesAndExit(20) }

sub zMdtiNoStart  { print(STDERR "
paranoidbackup.pl: unable to find $MdtiDirectory/start
"); &deleteTmpFilesAndExit(20) }

sub zMdtiNoWriteCommands  { print(STDERR "
paranoidbackup.pl: unable to write to $MdtiDirectory/commands
"); &deleteTmpFilesAndExit(20) }

sub zMdtiStartFailed  { print(STDERR "
paranoidbackup.pl: the mdti server $MdtiDirectory/start
returned $_[0]
the exit code was ", (($_[0] & 0xFF00) >> 8), "
the signal was ", ($_[0] & 0x7F), "
");
if ( ($_[0] & 0x80) == 1 )  { print(STDERR "core dumped\n") }
else  { print(STDERR "no core dump\n") }
return }

sub zNoOldBackups  { print(STDERR "
paranoidbackup.pl: no old backups found: unable to compare, restore,
find, or list
"); &deleteTmpFilesAndExit(1) }

sub zNoCD { print(STDERR "
paranoidbackup.pl: unable to change to directory $_[0]
"); &deleteTmpFilesAndExit(20) }

sub zNoCFR { if ( $Force == $Yes ) { print(STDERR "
paranoidbackup.pl: trying to continue the restore even though
errors occurred while restoring the control files.
"); return } print(STDERR "
paranoidbackup.pl: errors occurred while restoring the control files.
See the section on restore problems in the file paranoidbackup.text
"); &deleteTmpFilesAndExit(13) }

sub zNoControlList  { print(STDERR "
paranoidbackup.pl: unable to find control list $_[0], which should be named
$ControlNameBase$_[0] or $ControlNameBase$_[0]$CompressionExtension
"); return }

sub zNoDirectory  { print(STDERR "
paranoidbackup.pl: $_[0] is set to '$_[1]'
but there is no such directory
"); $AnErrorOccurred = $Yes; return }

sub zNoFileName  { print(STDERR "
paranoidbackup.pl: $_[0]
is wrong; It should be the backup number, then '$FindSeperator',
then the file name.
"); return }

sub zNoFork  { print(STDERR "
paranoidbackup.pl: unable to fork
"); &deleteTmpFilesAndExit(20) }

sub zNoLsList  { print(STDERR "
paranoidbackup.pl: unable to find ls list $NA, which should be named
$LsListNameBase$NA or $LsListNameBase$NA$CompressionExtension
"); return }

sub zNoOpenR  { print(STDERR "
paranoidbackup.pl: unable to open and read from $_[0]
"); &deleteTmpFilesAndExit(20) }

sub zNoOpenW  { print(STDERR "
paranoidbackup.pl: unable to open and write to $_[0]
"); &deleteTmpFilesAndExit(20) }

sub zNoSRnumber  { print(STDERR "
paranoidbackup.pl: $_[0]
is wrong; It should be the backup number, then '$FindSeperator',
then the file name. '$_[1]' is not a backup number.
"); return }

sub zNoStart  { print(STDERR "
paranoidbackup.pl: there is nothing named 'start' in the mdti directory
$MdtiDirectory
"); $AnErrorOccurred = $Yes; return }

sub zNotDefined  { print(STDERR "
paranoidbackup.pl: $_[0] is not in the configuration file
"); $AnErrorOccurred = $Yes; return }

sub zNothingToBackup  { print(STDERR "
paranoidbackup.pl: there is nothing that needs to be backed up
"); &deleteTmpFilesAndExit(1) }

sub zNothingToF  { print(STDERR "
paranoidbackup.pl: there are no patterns to find
"); &deleteTmpFilesAndExit(1) }

sub zNothingToCR  { print(STDERR "
paranoidbackup.pl: there is nothing to compare or restore
"); &deleteTmpFilesAndExit(1) }

sub zNoVRL  { print(STDERR "
paranoidbackup.pl: unable to find virtual restore list $VirtualRestoreList
or $VirtualRestoreList$CompressionExtension
"); &deleteTmpFilesAndExit(20) }




__END__

paranoidbackup.pl never allows the archive program to open the data pipe and
read or write the archive from or to the data pipe. Instead,
paranoidbackup.pl requires that the archive program write the archive to
standard output and read the archive from standard input, and
paranoidbackup.pl redirects standard input and output to the data pipe as
needed. Why? Well, suppose the archive program tries to read from the
archive, but there is some error in the parameters given to the archive
program. Did the archive program open the archive before it exited? There is
no way to know. Yet the mdti interface requires that the data pipe be opened
the correct number of times, or else it deadlocks. But if we tell the
archive program to read from standard input, and redirect the data pipe to
standard input; then we can be sure that the shell did open the data pipe,
even if the archive program never read from standard input. So it is safer
to use redirection. The bad news is that redirection is a shell function, so
this makes paranoidbackup.pl dependent on the shell. But all shells that I
know understand that '<' and '>' mean redirection, so this should not be a
problem.

Paranoid Backup makes a list of all files, and then decides which files to
back up based on this list. This automatically excludes the new ls list and
the new virtual restore list, because the new ls list is created after the
list of all files is created, and the virtual restore list is adjusted after
the list of all files is created. However, these two files should not be
excluded. If your hard drive crashed and you did a restore, these files
should be restored. There are several ways to back up these files. We add
them to the list of all files or to the new control list, or create dummy
files before making the list of all files. However, there are two problems.
First, the size and time/date information in the ls list will be inaccurate,
because the size and time/date of these files is not known until after the
list of all files is created. So we have to go back later and adjust the ls
list, or else allow it to be inaccurate. Second, Paranoid Backup does not
finish these files until after the backup, in case the backup fails. If the
files are to be backed up, they must be ready before the backup, and this
makes the process of aborting a failed backup a little more complicated. So
what I actually did was to add the new ls list and the new virtual restore
list to the control lists backup, because this was simpler. This is probably
the best solution for the virtual restore list, which will be adjusted again
next backup anyway. But the new ls list will not be adjusted again, and
since the control lists backup will be thrown away next backup, it will have
to be backed up in the usual way next backup, which should happen
automatically. But it might be better to somehow get it into the current
backup.

Maybe we should check the command line, and if the program name was
'backup', assume option --backup, if the program name was 'compare', assume
option --compare, and if the program name was 'restore', assume option
--restore.

Maybe --compare and --compare-last-backup should compare the control lists
backup as well as the main backup.

Maybe Paranoid Backup should detect if the last backup was incomplete; and
if so refuse to do another backup until the mess was cleaned up. We could
create a zero length lock file when we start a backup, and delete it when
the backup is complete; if the lock file exists we could not do a new
backup.

Maybe we should have archive options for verbose and interactive. But if the
archive program is going to be interactive, then it has to run in the
foreground, so the server will have to run in the background, so the server
can not get user input.

We could have a Paranoid Backup verbose option, so Paranoid Backup would
display messages saying now doing this, now doing that, etc. We could have
an archive verbose option, so that Paranoid Backup would tell the archive
program to be verbose. We could have a Paranoid Backup debug option, so
Paranoid backup would display messages like now running sub a, now running
sub b, $a is this, $b is that, etc.

If you give more than one action, Paranoid Backup does the last action.
Maybe it should do all actions if you give more than one action.

When Paranoid Backup compresses the lists, it checks the sizes
of each control lists, and does not compress the control list is smaller
than $TooSmallToCompress. But Paranoid Backup always compresses the last
control list, the ls lists, and the virtual restore list. Maybe Paranoid
Backup should check the sizes of all lists.

I would like to have Paranoid Backup able to warn me if it was skipping
important files because I had accidently excluded them, but I can not see
how to do that. If I put something stupid in the configuration files, so
that it excludes some important files, how can Paranoid Backup tell whether
that was a mistake, or did I really want to do that? Maybe the archive
program should display a warning if the archive program was asked to compare
or restore a file which was not backed up.


If you backup your computer every week for twenty years, that will be more
than 1000 backups, and the backup number will be over 1000.
This could cause problems with some devices. Now you may think that you are
not likely to keep doing the same backups for twenty years. It is true
that I have never done the same backup more than 10 times; but that is
because every backup program I ever tried turned out to be useless. Why did
you think I wrote my own backup program? The point is that Paranoid Backup
is designed to be used frequently over long periods of time.

Ftape 4.02 allows only 232 backups per tape.

If you are mounting the backup device as a DOS filesystem, and Paranoid
Backup is making the archive file name 'pb_nr' + backup number + '.tgz';
then backup 999 will be 'pb_nr999.tgz', which is ok; and backup 1000 will be
'pb_nr1000.tgz', which is not a valid DOS filename.

Compares are very slow because it has to read through all old backups. Maybe
we should create an option for a quick compare, make a new file list,
compare to the virtual restore list, output the changed and deleted files;
don't read the tape at all. Or we could add an option so that after a
successful backup it does not delete the temporary list of changed and
deleted files, so you could check the list afterwards to see which files had
changed or been deleted.

Perhaps there should be an option for a diff compare, which would generate a
diff patch.


We could make Paranoid Backup faster by piping several processes together.
The first process would list files, and pipe the file names to the second
process, which would select the files to be backed up and pipe the filenames
to the third process, which would create an archive and pipe the archive to
the fourth process, which would write the archive to tape. However, that
would use more memory and more cpu time, and paranoid backup would probably
not work on slow computers. The best solution would be to make
paranoid capable of piping the processes
together and running the processes simultaneously, or of running the
processes one at a time, and there should be an option to select which
method paranoid backup should use.

Paranoid Backup has pre-ls and post-ls commands, which it runs
before and after making the file list. The mdti servers have start and
stop commands, which they run when starting and stopping the mdti servers.
Sometimes you want the same commands in both the pre-ls commands and
in the mdti start commands. For example, you might want to mount
some network drives for backup, and shut down some uneeded services to
free up more memory and cpu time for paranoid backup. So paranoid backup
would mount drives, shut down services, list files, restart services,
umount drives, sort the file list, mount drives again, shut down
services again, do the backup, restart services, and unmount drives. This
is inefficient because services were shut down and drives mounted
twice, and because freed up memory and cpu time were available for listing
files and for doing the backup, but not for sorting the file list.
So you might want to put all the start commands in the
pre-ls commands, and put all the stop commands in the mdti
stop commands, and have no post-ls commands or mdti start commands. That
is a bad idea, because if you do a restore or compare, the pre-ls commands
do not run. Another idea is to put the start commands at the beginning
of pbui and the stop commands at the end of pbui. But the start
commands are not needed for all paranoid backup functions, and
it makes paranoid backup more complex to configure because we have one
more configuration file to edit. A better solution would be
to put the start commands as both pre-ls commands and mdti start commands,
but put the stop commands as only mdti stop commands. Then when you do a
backup, paranoid backup would mount drives, shut down services, list
files, sort files, mount drives again, shutdown services again, do the
backup, restart services, and unmount drives. The start commands would
fail when run the second time, but the error could be ignored as long
as the last command returns an exit code of 0, and the start
commands would be run for compares and restores. Or we could change
paranoid backup and add another set of start and
stop commands, and the start commands would run before the
pre-ls commands, and would run in compares and restores when the
pre-ls commands do not run, and the stop commands would run after the mdti
server shuts down.




Traditionally, archive programs have included tape management features,
because archive programs are usually used to write to and read from tape
drives, and tape drives are usually accessed through archive programs. But I
think this is bad; I think that tape management functions should be seperate
from archive management functions, in a seperate program. The tape
management program should deal with things like block size, spooling buffer,
verifying that the correct tape is in the tape drive, prompting to insert,
remove, and change tapes, formatting if neccessary, checking free space,
bad blocks, etc. The archive management program should ignore all of these
things. Thus Paranoid Backup makes backups to the multiple disk or tape
interface. Paranoid Backup does not do anything about managing disks or
tapes; it leaves all that to the program which operates the multiple disk or
tape interface.



exit codes:
0   ok
1   nothing to back up, compare, restore, find; unable to make virtual
    restore list because it already exists; aborted by user

10  incorrect command line parameters
11  invalid configuration file
13  errors occured while restoring the control files

20  other fatal error

40  bug detected

Note that if perl errors occur, then perl chooses the exit code. If perl
runs out of memory, you get exit code 1. If perl fails to compile, you
get exit code 2. To determine if the exit code came from perl or from
the program, read the error messages.
