#!/usr/bin/perl -w

use integer;
use English;

use sigtrap;
$SIG{PIPE} = \&signalTrap;
$SIG{INT} = \&signalTrap;
$SIG{TERM} = \&signalTrap;
$No = 0;
$Yes = 1;
$Failure = 0;
$Success = 1;

# for $DiskChangeAction
$None = 0;
$PromptAndReadStdin = 1;
$PromptAndWait = 2;
$RunExternalCommands = 3;

@Commands = ('');
$ConfigurationError = $No;
$CurrentDisk = 0;
@FileName = ();
$IndexChanged = $No;
$LastDisk = 1;
$MountAttempts = 0;
$NewDisk = $No;
$NextDisk = 0;
$PreviousDisk = 0;
$Results = "success\nno action has been taken yet\n";
$SignalPipeReceived = $No;
$UseCurrentDirectory = $No;
@WhichDiskHasFirstPartOfFile = ();
@WhichDiskHasLastPartOfFile = ();

$NA = -1;
while ( $NA < $#ARGV ) {
  $NA = $NA + 1;
  if ( $ARGV[$NA] eq '--current-directory' )
     { $UseCurrentDirectory = $Yes; next }
  if ( substr($ARGV[$NA],0,17) eq '--mdti-directory=' )
     { $WorkingDirectory = substr($ARGV[0],17); next }
  if ( substr($ARGV[$NA],0,8) eq '--start=' )
     { $StartCommand = substr($ARGV[0],8); next }
  }

if ( $UseCurrentDirectory == $No )  {
  if ( ! defined($WorkingDirectory) )  {
    if ( ! defined($StartCommand) )  { $StartCommand = $PROGRAM_NAME }
    #print("start command is $StartCommand\n");
    $NA = rindex($StartCommand,'/');
    if ( $NA == 0 )  { $WorkingDirectory = '/' }
    elsif ( $NA < 0 )  { $WorkingDirectory = '.' }
    else  { $WorkingDirectory = substr($StartCommand,0,$NA) }
    }
  #print("working directory is $WorkingDirectory\n");
  chdir($WorkingDirectory) or &zNoCD($WorkingDirectory);
  }

if ( -e 'commands' ) { &zCommandsExists }
&runExternalCommand('mknod commands p', 'make pipe command');
if ( ! -p 'data' )
    { &runExternalCommand('mknod data p', 'make pipe command') }
&readConfigurationFile;
if ( ! defined($DiskDevice) )  { &zNotInConfig('disk device') }
elsif ( ! -b $DiskDevice )  { &zNoDevice }
if ( ! defined($BlockSize) )  { &zNotInConfig('block size') }
if ( ! defined($DiskChangeAction) )  { &zNotInConfig('disk change action') }
elsif ( $DiskChangeAction == $PromptAndWait )  {
  if ( ! defined($DiskChangeWait) )
      { &zNotInConfig('number of seconds to wait for disk change') }
  }
elsif ( $DiskChangeAction == $RunExternalCommands )  {
  if ( ! defined($DiskChangeCommands) )
      { &zNotInConfig('disk change commands or script') }
  }
if ( ! defined($MaxMountAttempts) )
      { &zNotInConfig('number of times to try to mount') }
if ( ! defined($TryMountingFirst) )
      { &zNotInConfig('try mounting first') }
if ( ! defined($TypeOfFileSystem) )  { &zNotInConfig('type of file system') }
if ( ! defined($MountPoint) )  { &zNotInConfig('mount point') }
elsif ( ! -d $MountPoint ) { mkdir($MountPoint,0755) or
            &zNoMkdir($MountPoint) }
if ( $ConfigurationError == $Yes ) { &zConfigError }
if ( defined($StartCommands) )
    { &runExternalCommand($StartCommands, 'start commands') }
&readIndexFile;

L_Command: while () {
open(FH_CommandsPipe, "< commands") or &zNoReadCommands;
@Commands = <FH_CommandsPipe>;
close(FH_CommandsPipe);
if ( $#Commands < 0 )  { @Commands = (''); next }
if ( $Commands[0] eq "exit\n" )  { last }
# if ( $Commands[0] eq "use stdin\n" ) { next }
# if ( $Commands[0] eq "display does not need to be saved\n" ) { next }
if ( $Commands[0] eq "create\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    open(FH_DataPipe, "< data"); close(FH_DataPipe);
    next;
    }
  chomp($Commands[1]);
  $FileSelector = 0;
  until ( $FileSelector > $#FileName )  {
    if ( $FileName[$FileSelector] eq $Commands[1] )  {
      $Results = "failure\nfile already exists\n$Commands[1]\n";
      open(FH_DataPipe, "< data"); close(FH_DataPipe);
      next L_Command;
      }
    $FileSelector = $FileSelector + 1;
    }
  $WhichDiskHasFirstPartOfFile[$FileSelector] = $LastDisk;
  open(FH_DataPipe, "< data") or &zNoReadData;
  #print("\$LastDisk is $LastDisk, \$\#FileName is $#FileName\n");
  if ( $LastDisk == 1    and    $#FileName == -1 )  { $NewDisk = $Yes }
  $CopyBuffer = '';
#  $SA = '';
  $NextDisk = $LastDisk;
  L_Disk: while ()  {
    $MountAttempts = 0;
    if ( ! &loadDisk )  {
      $Results = "failure\nunable to create file\n$Commands[1]\n";
      close(FH_DataPipe);
      next L_Command;
      }
    #print("opening disk file $Commands[1]\n");
    open(FH_Disk, "> $MountPoint/$Commands[1]") or
             &zNoOpenW("$MountPoint/$Commands[1]");
    #print("\$CopyBuffer is $CopyBuffer\n");
    $NB = length($CopyBuffer);
    if ( $NB > 0 )  {
      $NA = syswrite(FH_Disk,$CopyBuffer,$NB);
      if ( ! defined($NA) )  { $NA = 0 }
      if ( $NA < $NB )  {
        close(FH_Disk);
        $NewDisk = $Yes;
        $CurrentDisk = -1;
        next L_Disk;
        }
      }
    until ( eof(FH_DataPipe) )  {
      read(FH_DataPipe,$CopyBuffer,$BlockSize);
      $NB = length($CopyBuffer);
      $NA = syswrite(FH_Disk,$CopyBuffer,$NB);
      if ( ! defined($NA) )  { $NA = 0 }
      if ( $NA < $NB )  {
        #print("data written is $NA\n");
        #print('data left to write is ',($NB - $NA),"\n");
        close(FH_Disk);
        $CopyBuffer = substr($CopyBuffer,$NA);
        $NextDisk = $CurrentDisk + 1;
        next L_Disk;
        }
      }
    close(FH_Disk);
    last;
    }
  $FileName[$FileSelector] = $Commands[1];
  $WhichDiskHasLastPartOfFile[$FileSelector] = $LastDisk;
  $IndexChanged = $Yes;
  $Results = "success\nfile created\n$Commands[1]\n";
  next;
  }
if ( $Commands[0] eq "delete\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    next;
    }
  chomp($Commands[1]);
  $FileSelector = 0;
  until ( $FileSelector > $#FileName )  {
    if ( $FileName[$FileSelector] eq $Commands[1] )  {
      $DiskNumber = $WhichDiskHasFirstPartOfFile[$FileSelector];
      until ( $DiskNumber > $WhichDiskHasLastPartOfFile[$FileSelector] )  {
        $NextDisk = $DiskNumber;
        $MountAttempts = 0;
        if ( ! &loadDisk )  {
          $Results = "failure\nunable to delete file\n$Commands[1]\n";
          close(FH_DataPipe);
          next L_Command;
          }
        unlink("$MountPoint/$Commands[1]");
        $DiskNumber = $DiskNumber + 1;
        }
      $IndexChanged = $Yes;
      splice(@WhichDiskHasFirstPartOfFile,$FileSelector,1);
      splice(@WhichDiskHasLastPartOfFile,$FileSelector,1);
      splice(@FileName,$FileSelector,1);
      $Results = "success\nfile deleted\n$Commands[1]\n";
      #print('@FileName is ',@FileName,"\n");
      #print('first disks are ',@WhichDiskHasFirstPartOfFile,"\n");
      #print('last disks are ',@WhichDiskHasLastPartOfFile,"\n");
      next L_Command;
      }
    $FileSelector = $FileSelector + 1;
    }
  $Results = "failure\nfile does not exist\n$Commands[1]\n";
  next;
  }
if ( $Commands[0] eq "read\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    open(FH_DataPipe, "> data"); close(FH_DataPipe);
    next;
    }
  chomp($Commands[1]);
  $FileSelector = 0;
  until ( $FileSelector > $#FileName )  {
    #print(STDERR "file selector points to \'$FileName[$FileSelector]\'\n");
    #print(STDERR "command file name is \'$Commands[1]\'\n");
    if ( $FileName[$FileSelector] eq $Commands[1] )  {
      open(FH_DataPipe, "> data") or &zNoWriteData;
      $DiskNumber = $WhichDiskHasFirstPartOfFile[$FileSelector];
      until ( $DiskNumber > $WhichDiskHasLastPartOfFile[$FileSelector]
              or        $SignalPipeReceived )  {
        $NextDisk = $DiskNumber;
        $MountAttempts = 0;
        if ( ! &loadDisk )  {
          $Results = "failure\nunable to read file\n$Commands[1]\n";
          close(FH_DataPipe);
          next L_Command;
          }
        open(FH_Disk, "< $MountPoint/$Commands[1]") or
             &zNoOpenR("$MountPoint/$Commands[1]");
        until ( eof(FH_Disk) )  {
          read(FH_Disk, $CopyBuffer, $BlockSize);
          print(FH_DataPipe $CopyBuffer);
          }
        close(FH_Disk);
        $DiskNumber = $DiskNumber + 1;
        }
      close(FH_DataPipe);
      if ( $SignalPipeReceived ) {
        $Results = "failure\nread aborted by SIGPIPE\n$Commands[1]\n";
        $SignalPipeReceived = $No;
        }
      else  { $Results = "success\nfile read\n$Commands[1]\n" }
      next L_Command;
      }
    $FileSelector = $FileSelector + 1;
    }
  $Results = "failure\nfile does not exist\n$Commands[1]\n";
  open(FH_DataPipe, "> data"); close(FH_DataPipe);
  next;
  }
if ( $Commands[0] eq "result\n" )  {
  open(FH_DataPipe, "> data") or &zNoWriteData;
  #print("sending result:\n$Results");
  print(FH_DataPipe $Results);
  close(FH_DataPipe);
  next;
  }
$Results = "failure\ncommand not known\n";
}

&unload(0);




sub loadDisk  {
my $SA; my $NA;
#print("1 \$CurrentDisk is $CurrentDisk, \$NextDisk is $NextDisk\n");
if ( $CurrentDisk == $NextDisk )  { return($Success) }
#print("2 \$CurrentDisk is $CurrentDisk, \$NextDisk is $NextDisk\n");
if ( $NextDisk > $LastDisk )  { $LastDisk = $NextDisk; $NewDisk = $Yes }
if ( $CurrentDisk < 0    and    $NextDisk != 0    and
      $DiskChangeAction == $None )  { return($Failure) }
#print("3 \$CurrentDisk is $CurrentDisk, \$NextDisk is $NextDisk\n");
$MountAttempts = $MountAttempts + 1;
if ( $MountAttempts > $MaxMountAttempts )  { return($Failure) }
#print("4 \$CurrentDisk is $CurrentDisk, \$NextDisk is $NextDisk\n");
if ( $CurrentDisk != 0 )  {
  $PreviousDisk = $CurrentDisk;
  &runExternalCommand("umount $DiskDevice", 'unmount command');
  $CurrentDisk = 0;
  }
if ( $NextDisk == 0 )  { return($Success) }
#print("5 \$CurrentDisk is $CurrentDisk, \$NextDisk is $NextDisk\n");
if ( $TryMountingFirst == $No    or    $MountAttempts > 1 )  {
  if ( $DiskChangeAction == $PromptAndReadStdin )  {
    &zDiskEnter;
    $SA = <STDIN>;
    if ( $SA eq "exit\n" )  { &unload(1) }
    if ( $SA eq "fail\n" )  { return($Failure) }
    }
  elsif ( $DiskChangeAction == $PromptAndWait )  {
    &zDiskWait;
    sleep($DiskChangeWait);
    }
  elsif ( $DiskChangeAction == $RunExternalCommands )  { &runExternalCommand(
      "$DiskChangeCommands $PreviousDisk $NextDisk", 'disk change commands') }
 }
#print("mount command: mount -t $TypeOfFileSystem $DiskDevice $MountPoint");
#print("\$NewDisk is $NewDisk\n");
$NA = system("mount -t $TypeOfFileSystem $DiskDevice $MountPoint");
#print("system-mount returned $NA\n");
if ( $NA != 0 )  {
#  if ( $DiskChangeAction == $None )   { return($Failure) }
  #print("mount failed\n");
  &zNoMountDisk;
  return(&loadDisk);
  }
$CurrentDisk = -1;
if ( -e "$MountPoint/_disk_id" )  {
  #print("disk id file exists\n");
  open(FH_DiskID, "< $MountPoint/_disk_id")  or
                    &zNoOpenR("$MountPoint/_disk_id");
  $SA = <FH_DiskID>;
  close(FH_DiskID);
  if ( substr($SA,0,5) eq 'disk '     and     substr($SA,-1) eq "\n" )
      { $CurrentDisk = substr($SA,5,-1) }
  if ( $CurrentDisk < 0 )  { &zUnknownDisk; return(&loadDisk) }
  if ( $CurrentDisk != $NextDisk )  { &zWrongDisk; return(&loadDisk) }
  $NewDisk = $No;
  }
elsif ( $NewDisk == $Yes )  {
  #print("\$NewDisk is yes, disk id does not exist\n");
  open(FH_DiskID, "> $MountPoint/_disk_id");
  $NA = print(FH_DiskID "disk $NextDisk\n");
  close(FH_DiskID);
  if ( $NA == 0 )  { &zNoWriteDisk; return(&loadDisk) }
  $CurrentDisk = $NextDisk;
  $NewDisk = $No;
  }
else  { &zUnknownDisk; return(&loadDisk) }
return($Success);
}



sub readConfigurationFile  {
#system("pwd&&true");
open(FH_ConfigFile, "< config") or &zNoOpenR("$WorkingDirectory/config");
while (<FH_ConfigFile>)  {
  my $SA; my $SB; my $NA;
  chomp $_;
  if ( $_ eq '' )  { next }
  if ( substr($_,0,1) eq '#' )  { next }
  $NA = index($_,'=');
  if ( $NA < 0 )  { &zConfigNoEq; next }
  if ( $NA == 0 )  { &zConfigBeginEq; next }
  $SA = substr($_,0,$NA);
  $SB = substr($_,($NA + 1));
  if ( substr($SB,-1) eq ' ' )  { &zConfigEndSpace; next }
  if ( $SA eq 'disk device' ) { $DiskDevice=$SB; next }
  if ( $SA eq 'mount point' ) { $MountPoint=$SB; next }
  if ( $SA eq 'start commands' ) { $StartCommands=$SB; next }
  if ( $SA eq 'block size' ) { $BlockSize=$SB; next }
  if ( $SA eq 'stop commands' ) { $StopCommands=$SB; next }
  if ( $SA eq 'type of file system' ) { $TypeOfFileSystem=$SB; next }
  if ( $SA eq 'disk change action' )  {
    if ( $SB eq 'none' ) { $DiskChangeAction=$None; next }
    if ( $SB eq 'prompt and read stdin' )
      { $DiskChangeAction=$PromptAndReadStdin; next }
    if ( $SB eq 'prompt and wait' ) { $DiskChangeAction=$PromptAndWait; next }
    if ( $SB eq 'run external commands' )
      { $DiskChangeAction=$RunExternalCommands; next }
    &zConfigWrong($SA,$SB);
    }
  if($SA eq 'try mounting first')  {
    if ( $SB eq 'yes' )  { $TryMountingFirst=$Yes }
    elsif ( $SB eq 'no' )  { $TryMountingFirst=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ( $SA eq 'disk change commands or script' )
      { $DiskChangeCommands=$SB; next }
  if ( $SA eq 'number of seconds to wait for disk change' )
    { $DiskChangeWait=$SB; next }
  if ( $SA eq 'number of times to try to mount' )
    { $MaxMountAttempts=$SB; next }
  &zConfigUnknownOption($SA);
  }
close(FH_ConfigFile);
}




sub readIndexFile  {
open(FH_Index, "< index") or &zNoOpenR("$WorkingDirectory/index");
$FileSelector = 0;
while (<FH_Index>)  {
  my @A;
  if ( $_ eq "\n" )  { next }
  @A = split(' ',$_);
  if ( $#A < 2 )  { &zIndexBadLine; next }
  if ( $A[1] < 1     or     $A[2] < $A[1]     or     $A[0] eq '' )
    { &zIndexBadLine; next }
  $FileName[$FileSelector] = $A[0];
  $WhichDiskHasFirstPartOfFile[$FileSelector] = $A[1];
  $WhichDiskHasLastPartOfFile[$FileSelector] = $A[2];
  if ( $LastDisk < $WhichDiskHasLastPartOfFile[$FileSelector] )
    { $LastDisk = $WhichDiskHasLastPartOfFile[$FileSelector] }
  $FileSelector = $FileSelector + 1;
  }
#print('file name is ',@FileName,"\n");
#print('first disk is ',@WhichDiskHasFirstPartOfFile,"\n");
#print('last disk is ',@WhichDiskHasLastPartOfFile,"\n");
close(FH_Index);
}




sub runExternalCommand  {
my $NA; my $SA = 'external command';
if ( defined($_[1]) )  { $SA = $_[1] }
$NA = system($_[0]);
if ( $NA != 0 )  {
  print(STDERR "
mdti.mdisks.pl: the following $SA
$_[0]
returned an exit code of ",($NA/256),"\n");
  &unload(10);
  }
}




sub signalTrap  {
if ( $_[0] eq 'PIPE' )  { $SignalPipeReceived = $Yes }
elsif ( $_[0] eq 'INT'    or     $_[0] eq 'TERM' )  { &unload(1) }
else { &zWrongSignal($_[0]) }
}





sub unload  {

if ( $CurrentDisk != 0 )
    { system("umount $DiskDevice")    and    print(STDERR "
mdti.mdisks.pl: unmount command 'umount $DiskDevice'
returned an exit code of ", $NA/256,"\n"); $CurrentDisk = 0 }

if ( defined($MountPoint) )  { rmdir($MountPoint) }

if ( $IndexChanged == $Yes )  {
  $NA = open(FH_Index, "> index");
  if ( ! defined($NA) )  { $NA = 0 }
  if ( $NA > 0 )  {
    $FileSelector = 0;
    #print("file selector is $FileSelector\n");
    #print("last field of \@FileName is $#FileName\n");
    until ( $FileSelector > $#FileName )  {
      #print("file selector is $FileSelector\n");
      #print("last field of \@FileName is $#FileName\n");
      print(FH_Index $FileName[$FileSelector], ' ',
        $WhichDiskHasFirstPartOfFile[$FileSelector], ' ',
        $WhichDiskHasLastPartOfFile[$FileSelector], "\n");
      $FileSelector = $FileSelector + 1;
      }
    close(FH_Index);
    }
  else  { print(STDERR "
mdti.mdisks.pl:  unable to open and write to the file named \'index\'
") }
  }

if ( defined($StopCommands) )   { if ( $StopCommands ne '' )  {
    $NA = system($StopCommands);
    if ( $NA != 0 )  { print(STDERR "
mdti.mdisks.pl: stop commands '$StopCommands'
returned $NA; exit code was ", $NA/256, "\n") }}}

unlink('commands','data');
exit($_[0]);
}




sub zCommandsExists  { print(STDERR "
mdti.mdisks.pl: unable to start because $WorkingDirectory/commands
already exists. This probably means that this disk or tape set is already
in use by another program. Use the command ps to see what programs are
running. If you are sure that no other programs are using this disk or
tape set, delete $WorkingDirectory/commands and try again.
"); exit(2) }


sub zConfigBeginEq  { print(STDERR "
mdti.mdisks.pl: line from config file begins with \'=\'. Current line is
$_
"); $ConfigurationError = $Yes; return }

sub zConfigEndSpace  { print(STDERR "
mdti.mdisks.pl: line from config file ends with space.
mdti.mdisks.pl is assuming this is correct. Current line is
$_
"); return }

sub zConfigError  { print(STDERR "
mdti.mdisks.pl: exiting because of configuration errors
"); &unload(3) }

sub zConfigNoEq  { print(STDERR "
mdti.mdisks.pl: line from config file does not contain \'=\'. Current line is
$_
"); $ConfigurationError = $Yes; return }

sub zConfigUnknownOption  { print(STDERR "
mdti.mdisks.pl: line from config file is unknown option '$_[0]'
Current line is $_
"); $ConfigurationError = $Yes; return }

sub zConfigWrong  { print(STDERR "
mdti.mdisks.pl: $_[0] can not be set to '$_[1]'
"); $ConfigurationError = $Yes }

sub zConfigYorN  { print(STDERR "
mdti.mdisks.pl: $_[0] should be set to 'yes' or 'no'; not '$_[1]'
"); $ConfigurationError = $Yes; return }

sub zDiskEnter  { print(STDERR "
mdti.mdisks.pl: insert disk $NextDisk and press enter;
or type 'fail' and press enter to abort the current operation; or
type 'exit' and press enter to abort all operations and exit tdd.mdisks.pl
") }

sub zDiskWait  { print(STDERR "
mdti.mdisks.pl: insert disk $NextDisk
") }

sub zIndexBadLine  { print(STDERR "
mdti.mdisks.pl: line from index file is incorrect,
ignoring this line. Current line is
$_
"); return }

sub zNoCD { print(STDERR "
mdti.mdisks.pl: unable to change to directory $_[0]
"); &deleteTmpFilesAndExit(3) }

sub zNoDevice  { print(STDERR "
mdti.mdisks.pl: there is no device named $DiskDevice
"); $ConfigurationError = $Yes }

sub zNotInConfig  { print(STDERR "
mdti.mdisks.pl: there is no \'$_[0]\=\'
in the configuration file
"); $ConfigurationError = $Yes }

sub zNoMkdir  { print(STDERR "
mdti.mdisks.pl:  unable to make directory $_[0]
"); $ConfigurationError = $Yes; return }

sub zNoMountDisk  { print(STDERR "
mdti.mdisks.pl: unable to mount this disk; it may not be formatted correctly,
or the mount parameters may be wrong, or maybe there is no disk
in the drive, or maybe the device is already mounted.
") }

sub zNoOpenR  { print(STDERR "
mdti.mdisks.pl: unable to open and read from $_[0]
"); &unload(10) }

sub zNoReadCommands  { print(STDERR "
mdti.mdisks.pl:  unable to open and read the pipe named 'commands'
"); &unload(10) }

sub zNoReadData  { print(STDERR "
mdti.mdisks.pl:  unable to open and read from pipe $WorkingDirectory/data
"); &unload(10) }

sub zNoWriteData  { print(STDERR "
mdti.mdisks.pl:  unable to open and write to pipe $WorkingDirectory/data
"); &unload(10) }

sub zNoWriteDisk  { print(STDERR "
mdti.mdisks.pl: unable to write to this disk; it may be full, or it may be
write protected
") }

sub zWrongDisk  { print(STDERR "
mdti.mdisks.pl: wrong disk: this is disk $CurrentDisk
") }

sub zWrongSignal  { print(STDERR "
mdti.mdisks.pl: signal '$_[0]' received and trapped; only signals PIPE, TERM, and
INT are supposed to be trapped.
"); &unload(10)  }

sub zUnknownDisk  { print(STDERR "
mdti.mdisks.pl: wrong disk: this is not disk $NextDisk
") }







__END__

You should read mdti.text before you read this.

mdti.mdisks.pl is an implementation of the multiple disk and tape interface.
mdti.mdisks.pl should work with any type of drive which can be mounted, like
floppy disk drives.

mdti.mdisks.pl requires a configuration file named 'config'. The
configuration file should have the following things:

block size      required        The block size is the amount of data which
is read from or written to the disk at a time. You do not want the block
size to be too small, because that would be slow. You do not want the block
size to be too big, because that would use a lot of memory. I would guess
that any block size more than 10000 and less than 200000 would be good.
If you really want to know the optimum block size, you will have to
experiment. It is probably easier for the device driver, and therefore
faster, if the block size for mdti.mdisks.pl is a multiple of the block size
of the disk drive. All disk drives that I know about use a block size of 512
or 1024, so I suggest you always use a block size which is a multiple of
1024.
example:    block size=65536

disk device    required      The disk device is the name of the block device
special file for the disk drive.
example:    disk device=/dev/fd0

mount point   required      The mount point is the name of a directory to
which the disk drive will be mounted. mdti.mdisks.pl will make and remove
this directory as needed.
example:      mount point=mnt

start commands     optional    Some commands to run when mdti.mdisks.pl
starts. If these commands do not return an exit code of 0, mdti.mdisks.pl
will abort. You could put commands to load modules here.

stop commands      optional    Like start commands, but at the end. You
could put commands to unload modules here.

type of file system     required    The type of file system on the disks.
This is used by the mount command. For more information see the man page for
mount.
examples:    type of file system=msdos      type of file system=ext2
             type of file system=minix

disk change action       required       What to do when the disk has to be
changed. When mdti.mdisks.pl starts, it assumes there is no disk in the
drive, so loading the first disk is a disk change; unloading the
last disk is not a disk change.
  disk change action=none    Assume the correct disk is already in the
drive. If you are doing unattended backups and you are
sure that the whole backup will fit onto one disk, then use this.
(Remember to put the disk in the drive before you leave.) If the correct
disk is not in the drive, then mdti.mdisks.pl will skip the current command
and wait for the next command. Note that mdti.mdisks.pl does not exit, and
it does not report the error unless it receives the 'result' command.
  disk change action=prompt and read stdin    Displays a message to standard
error and waits for the user to press enter when it is time to change disks.
This works good if mdti.mdisks.pl is running in one terminal, and the backup
program is running in a different terminal; BUT THIS WILL NOT WORK IF
mdti.mdisks.pl IS RUNNING IN THE BACKGROUND!
  disk change action=prompt and wait    Displays a message to standard
error and waits for a short while, then tries to mount the disk. Repeats
until the correct disk is mounted. Use this if mdti.mdisks.pl will be
running in the background, and needs to prompt for disks.
See 'number of seconds to wait for disk change'.
  disk change action=run external commands   Runs some other program when it
is time to change disks. See 'disk change commands or script'.

disk change commands or script
required if disk change action=run external commands
You can put any linux commands here, but you probably want a script.
You might want to prompt the user, or you might want to control an
autoloader or changer. mdti.mdisks.pl will add two things to your command:
the number of the disk which is currently in the drive, and the number of
the disk which is needed next. If you are using the name of a script, these
two things should become two parameters to your script; the number of the
current disk is the first parameter and the number of the next disk is the
second parameter. If you are using a complicated command,
these two things might be interpreted some other way. The first
disk is 1, the second disk is 2, 0 means no disk in the drive, and -1 means
the disk in the drive cannot be identified. mdti.mdisks.pl will request disk
0 when it is done, so your script should not be confused by that;
mdti.mdisks.pl should never request disk -1, but it may say that the current
disk is disk -1. When mdti.mdisks.pl starts, it does not know what disk is
in the drive so it assumes disk 0; your autoloader control script should not
be confused if mdti.mdisks.pl says to remove disk 0 and insert disk 1 when
disk 1 is already in the drive.
The commands must return an exit code of 0, or mdti.mdisks.pl will abort.
'disk change commands or script' is ignored if 'disk change action' is set
to anything other than 'run external commands'.
examples:      disk change commands or script=ChangeDisk
               disk change commands or script=foo; bar && gleef > o #

number of seconds to wait for disk change
required if disk change action=prompt and wait
How long does it take you to change disks? I can change floppies in about
five seconds. But for some reason, the disk activity light does not go out
for about five seconds after the disk is unmounted. So I set this to 10.
This is ignored if disk change action is set to anything other than
prompt and wait.
example:    number of seconds to wait for disk change=10

number of times to try to mount     required When mdti.mdisks.pl mounts a
disk, if the mount fails or if it is the wrong disk, then it tries again.
But you probably do not want to retry an infinite number of times. If this
is set to 0, then it will never try to mount any disk; you probably do not
want to do that. If you are using 'disk change action=none', then you
probably want to use 'number of times to try to mount=1'; it will not try
again if the first mount fails.
If you are using 'disk change action=run external commands', then it depends
on what commands you are using. If you are running a script which prompts
the user, then if the mount fails you probably want to prompt the user again
a few times. But if you are running a script which controls an autoloader or
changer, then if a mount fails you probably do not want to try again. If you
are using 'disk change action=prompt and read stdin', then if a mount fails
you probably want to try again a few times, because the user might
accidentally insert the wrong disk; but it is not very important what number
you use because the user can abort when it prompts for disks. If you are
using 'disk change action=prompt and wait' then you probably want to use a
bigger number because the user might have to spend some time searching for
the correct disk, or the user might have gone away or been distracted for a
few minutes. If it is attempting a mount every ten seconds, and it takes
twenty minutes to find the disk, then that would be 120 mount attempts.
example: number of times to try to mount=8

try mounting first      if 'try mounting first=yes', then the first time
mdti.mdisks.pl needs a disk, it will skip the disk change action and will
attempt to mount the disk right away. If the mount fails, then it will do
the disk change action before it tries again. This will save you one prompt
if you are clever enough to put the first disk in the drive before you start
mdti.mdisks.pl. If 'try mounting first=no', then mdti.mdisks.pl will do the
disk change action before trying to mount the first disk. 'try mounting
first' has no effect if 'disk change action=none'.



Also note that when you first set up a disk set with mdti.mdisks.pl as the
interface server, you need to create the file named 'index', because it is
an error if mdti.mdisks.pl can not find the index. Enter the command
'> index' to make a zero length file named 'index'.




some possible improvements:
detect whether or not there is a disk in the drive without mounting it.
allow the use of two drives, use one then the other then the first again
etc, so the user can change disks in one drive while it is reading/writing
the other drive.
write the disk id information to the boot sector/volume
table/superblock/file allocation table, or anywhere other than the data
area, so all the data area could be used for data. Some disk filesystems
have space reserved for a label or volume name, use that space.
erase or format new disks if needed.
cache data from the disk in memory or on the hard drive.
when prompting the user, halt the foreground process, save the display,
prompt the user, wait for a response, restore the display, restart the
foreground process.
if X is running, open a dialog box window for prompting.
compare the index to the files actually on the disks, and adjust the index
to match the disks.
Allow a mix of different devices and different filesystem types.
Check if the filenames are valid for the filesystem. if the filenames are
not legal, then create a legal filename and save both filenames in the
index, and switch between them as needed.
beep the computer when it is time to change disks
prompt in other languages
don't mount the disk, read and write directly to the block device; this
would probably allow us to fit more data on each disk, but it bad blocks
might be a problem because we would be bbypassing the bad block list. Also,
if in emergency we were trying to read data from the disks without the
interface server program, it would be easier if we could mount the disks in
the usual way.



If the client program asks to read a file, but then opens and closes the
data pipe without reading anything, then this server gets hit with SIGPIPE,
and it will exit without cleaning up after itself unless we do something
about SIGPIPE. So it traps SIGPIPE and aborts the read if it gets SIGPIPE.
Probably SIGPIPE could be blocked instead of trapped; that would be less
code, but that would not abort the read; it would send the data nowhere
instead of sending it to the pipe, but it would still read the data from the
disks. By aborting the read the server is ready for the next command sooner;
a lot sooner if it was a long read involving many disks.

exit codes:
0  ok
1  aborted by user
2  already running
3  configuration error
10 miscellaneous fatal error
40 bug detected

Note that if perl errors occur, then perl chooses the exit code. If perl
runs out of memory, you get exit code 1. If perl fails to compile, you
get exit code 2. To determine if the exit code came from perl or from
the program, read the error messages.
