#!/usr/bin/perl -w

use integer;
use English;

use sigtrap;
$SIG{PIPE} = \&signalTrap;
$SIG{INT} = \&signalTrap;
$SIG{TERM} = \&signalTrap;
$No = 0;
$Yes = 1;
#$Failure = 0;
#$Success = 1;

@Commands = ('');
$ConfigurationError = $No;
$Results = "success\nno action has been taken yet\n";
$SignalPipeReceived = $No;
$UseCurrentDirectory = $No;
$CopyBuffer = '';
$BlockSize = 262144;

$NA = -1;
while ( $NA < $#ARGV ) {
  $NA = $NA + 1;
  if ( $ARGV[$NA] eq '--current-directory' )
     { $UseCurrentDirectory = $Yes; next }
  if ( substr($ARGV[$NA],0,17) eq '--mdti-directory=' )
     { $WorkingDirectory = substr($ARGV[0],17); next }
  if ( substr($ARGV[$NA],0,8) eq '--start=' )
     { $StartCommand = substr($ARGV[0],8); next }
  }

if ( $UseCurrentDirectory == $No )  {
  if ( ! defined($WorkingDirectory) )  {
    if ( ! defined($StartCommand) )  { $StartCommand = $PROGRAM_NAME }
    #print("start command is $StartCommand\n");
    $NA = rindex($StartCommand,'/');
    if ( $NA == 0 )  { $WorkingDirectory = '/' }
    elsif ( $NA < 0 )  { $WorkingDirectory = '.' }
    else  { $WorkingDirectory = substr($StartCommand,0,$NA) }
    }
  #print("working directory is $WorkingDirectory\n");
  chdir($WorkingDirectory) or &zNoCD($WorkingDirectory);
  }

if ( -e 'commands' ) { &zCommandsExists }
&runExternalCommand('mknod commands p', 'make pipe command');
if ( ! -p 'data' )
    { &runExternalCommand('mknod data p', 'make pipe command') }

&readConfigurationFile;
if ( defined($StartCommands) )
    { &runExternalCommand($StartCommands, 'start commands') }
if ( ! defined($StoreFilesInThisDirectory) )
    { &zNotInConfig('store files in this directory') }
elsif ( ! -d $StoreFilesInThisDirectory )
     { mkdir($StoreFilesInThisDirectory,0755) or
            &zNoMkdir($StoreFilesInThisDirectory) }
if ( $ConfigurationError == $Yes ) { &zConfigError }


L_CommandFromCommandPipe:
while () {
open(FH_CommandsPipe, "< commands") or &zNoReadCommands;
@Commands = <FH_CommandsPipe>;
close(FH_CommandsPipe);
if ( $#Commands < 0 )  { @Commands = (''); next }
if ( $Commands[0] eq "exit\n" )  { last }
# if ( $Commands[0] eq "use stdin\n" ) { next }
# if ( $Commands[0] eq "display does not need to be saved\n" ) { next }
if ( $Commands[0] eq "create\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    open(FH_DataPipe, "< data"); close(FH_DataPipe);
    next;
    }
  chomp($Commands[1]);
  if ( -e "$StoreFilesInThisDirectory/$Commands[1]" )  {
    $Results = "failure\nfile already exists\n$Commands[1]\n";
    open(FH_DataPipe, "< data"); close(FH_DataPipe);
    next;
    }
  open(FH_DataPipe, "< data") or &zNoReadData;
  #print("opening disk file $Commands[1]\n");
  open(FH_DataFile, "> $StoreFilesInThisDirectory/$Commands[1]") or
             &zNoOpenW("$StoreFilesInThisDirectory/$Commands[1]");
  until ( eof(FH_DataPipe) )  {
    read(FH_DataPipe,$CopyBuffer,$BlockSize);
    $NA = syswrite(FH_DataFile,$CopyBuffer);
    if ( $NA != length($CopyBuffer) )  {
      &zErrWriteFile($StoreFilesInThisDirectory/$Commands[1]);
      close(FH_DataFile);
      close(FH_DataPipe);
      $Results = "failure\nerror writing to file\n$StoreFilesInThisDirectory/$Commands[1]\n";
      next L_CommandFromCommandPipe;
      }
    }
  close(FH_DataFile);
  close(FH_DataPipe);
  $Results = "success\nfile created\n$Commands[1]\n";
  next;
  }

if ( $Commands[0] eq "delete\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    next;
    }
  chomp($Commands[1]);
  if ( ! -e "$StoreFilesInThisDirectory/$Commands[1]" )  {
    $Results = "failure\nfile does not exist\n$Commands[1]\n";
    next;
    }
  if ( ! unlink("$StoreFilesInThisDirectory/$Commands[1]") )  {
    $Results = "failure\nunable to delete file\n$Commands[1]\n";
    next;
    }
  $Results = "success\nfile deleted\n$Commands[1]\n";
  #print('@FileName is ',@FileName,"\n");
  next;
  }

if ( $Commands[0] eq "read\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    open(FH_DataPipe, "> data"); close(FH_DataPipe);
    next;
    }
  chomp($Commands[1]);
  if ( ! -e "$StoreFilesInThisDirectory/$Commands[1]" )  {
    $Results = "failure\nfile does not exist\n$Commands[1]\n";
    open(FH_DataPipe, "> data"); close(FH_DataPipe);
    next;
    }
  open(FH_DataPipe, "> data") or &zNoWriteData;
  open(FH_DataFile, "< $StoreFilesInThisDirectory/$Commands[1]") or
           &zNoOpenR("$StoreFilesInThisDirectory/$Commands[1]");
  until ( eof(FH_DataFile) )  {
    read(FH_DataFile, $CopyBuffer, $BlockSize);
    $NA = syswrite(FH_DataPipe, $CopyBuffer);
    if ( $NA != length($CopyBuffer) )  {
      close(FH_DataFile);
      close(FH_DataPipe);
      if ( $SignalPipeReceived ) {
        $Results = "failure\nread aborted by SIGPIPE\n$Commands[1]\n";
        $SignalPipeReceived = $No;
        next L_CommandFromCommandPipe;
        }
      &zErrWriteDataPipe("data");
      $Results = "failure\nerror writing to data pipe\n";
      next L_CommandFromCommandPipe;
      }
    }
  close(FH_DataFile);
  close(FH_DataPipe);
  if ( $SignalPipeReceived ) {
    $Results = "failure\nread aborted by SIGPIPE\n$Commands[1]\n";
    $SignalPipeReceived = $No;
    next;
    }
  else  { $Results = "success\nfile read\n$Commands[1]\n" }
  next;
  }

if ( $Commands[0] eq "result\n" )  {
  open(FH_DataPipe, "> data") or &zNoWriteData;
  #print("sending result:\n$Results");
  print(FH_DataPipe $Results);
  close(FH_DataPipe);
  next;
  }
$Results = "failure\ncommand not known\n";
}

&unload(0);




sub readConfigurationFile  {
#system("pwd&&true");
open(FH_ConfigFile, "< config") or &zNoOpenR("$WorkingDirectory/config");
while (<FH_ConfigFile>)  {
  my $SA; my $SB; my $NA;
  chomp $_;
  if ( $_ eq '' )  { next }
  if ( substr($_,0,1) eq '#' )  { next }
  $NA = index($_,'=');
  if ( $NA < 0 )  { &zConfigNoEq; next }
  if ( $NA == 0 )  { &zConfigBeginEq; next }
  $SA = substr($_,0,$NA);
  $SB = substr($_,($NA + 1));
  if ( substr($SB,-1) eq ' ' )  { &zConfigEndSpace; next }
  if ( $SA eq 'store files in this directory' ) { $StoreFilesInThisDirectory=$SB; next }
  if ( $SA eq 'start commands' ) { $StartCommands=$SB; next }
  if ( $SA eq 'stop commands' ) { $StopCommands=$SB; next }
  &zConfigUnknownOption($SA);
  }
close(FH_ConfigFile);
}




sub runExternalCommand  {
my $NA; my $SA = 'external command';
if ( defined($_[1]) )  { $SA = $_[1] }
$NA = system($_[0]);
if ( $NA != 0 )  {
  print(STDERR "
mdti.drive.pl: the following $SA
$_[0]
returned $NA; the exit code was ",($NA/256),"\n");
  &unload(10);
  }
}




sub signalTrap  {
if ( $_[0] eq 'PIPE' )  { $SignalPipeReceived = $Yes }
elsif ( $_[0] eq 'INT'    or     $_[0] eq 'TERM' )  { &unload(1) }
else { &zWrongSignal($_[0]) }
}





sub unload  {
if ( defined($StopCommands) )   { if ( $StopCommands ne '' )  {
    $NA = system($StopCommands);
    if ( $NA != 0 )  { print(STDERR "
mdti.drive.pl: stop commands '$StopCommands'
returned $NA; exit code was ", $NA/256, "\n") }}}
unlink('commands','data');
exit($_[0]);
}




sub zCommandsExists  { print(STDERR "
mdti.drive.pl: unable to start because $WorkingDirectory/commands
already exists. This probably means that this disk or tape set is already
in use by another program. Use the command ps to see what programs are
running. If you are sure that no other programs are using this disk or
tape set, delete $WorkingDirectory/commands and try again.
"); exit(2) }


sub zConfigBeginEq  { print(STDERR "
mdti.drive.pl: line from config file begins with \'=\'. Current line is
$_
"); $ConfigurationError = $Yes; return }

sub zConfigEndSpace  { print(STDERR "
mdti.drive.pl: line from config file ends with space.
mdti.drive.pl is assuming this is correct. Current line is
$_
"); return }

sub zConfigError  { print(STDERR "
mdti.drive.pl: exiting because of configuration errors
"); &unload(3) }

sub zConfigNoEq  { print(STDERR "
mdti.drive.pl: line from config file does not contain \'=\'. Current line is
$_
"); $ConfigurationError = $Yes; return }

sub zConfigUnknownOption  { print(STDERR "
mdti.drive.pl: line from config file is unknown option '$_[0]'
Current line is $_
"); $ConfigurationError = $Yes; return }

sub zConfigWrong  { print(STDERR "
mdti.drive.pl: $_[0] can not be set to '$_[1]'
"); $ConfigurationError = $Yes }

sub zConfigYorN  { print(STDERR "
mdti.drive.pl: $_[0] should be set to 'yes' or 'no'; not '$_[1]'
"); $ConfigurationError = $Yes; return }

sub zErrWriteDataPipe  { print(STDERR "
mdti.drive.pl: error writing to data pipe \'$_[0]\'
");
}

sub zErrWriteFile  { print(STDERR "
mdti.drive.pl: error writing to file \'$_[0]\'
");
}

sub zNoCD { print(STDERR "
mdti.drive.pl: unable to change to directory $_[0]
"); &deleteTmpFilesAndExit(3) }

sub zNotInConfig  { print(STDERR "
mdti.drive.pl: there is no \'$_[0]\=\'
in the configuration file
"); $ConfigurationError = $Yes }

sub zNoMkdir  { print(STDERR "
mdti.drive.pl:  unable to make directory $_[0]
"); $ConfigurationError = $Yes; return }

sub zNoOpenR  { print(STDERR "
mdti.drive.pl: unable to open and read from $_[0]
"); &unload(10) }

sub zNoOpenW  { print(STDERR "
mdti.drive.pl: unable to open and write to $_[0]
"); &unload(10) }

sub zNoReadCommands  { print(STDERR "
mdti.drive.pl:  unable to open and read the pipe named 'commands'
"); &unload(10) }

sub zNoReadData  { print(STDERR "
mdti.drive.pl:  unable to open and read from pipe $WorkingDirectory/data
"); &unload(10) }

sub zNoWriteData  { print(STDERR "
mdti.drive.pl:  unable to open and write to pipe $WorkingDirectory/data
"); &unload(10) }

sub zNoWriteDisk  { print(STDERR "
mdti.drive.pl: unable to write to this disk; it may be full, or it may be
write protected
") }

sub zWrongSignal  { print(STDERR "
mdti.drive.pl: signal '$_[0]' received and trapped; only signals PIPE, TERM, and
INT are supposed to be trapped.
"); &unload(10)  }








__END__

You should read mdti.text before you read this.

mdti.drive.pl is an implementation of the multiple disk and tape interface.
mdti.drive.pl was created for use with Paranoid Backup, for backing up
to a directory, which could be the mount point or a subdirectory
of the mount point of another hard drive.


mdti.drive.pl requires a configuration file named 'config'. The
configuration file should have the following things:

store files in this directory   required      This is the name
of the directory where mdti.drive.pl will store the files.
If you are doing backups to another hard drive, then this directory should
be on the hard drive where you want to store the backups. This directory
will be created automatically if needed.

start commands     optional    Some commands to run when mdti.drive.pl
starts. If these commands do not return an exit code of 0, mdti.drive.pl
will abort. You could put commands to mount the drive here.

stop commands      optional    Like start commands, but at the end. You
could put commands to unmount the drive here.



Note that the tape and disk mdti servers use an index, which is a
file named 'index' in the mdti directory. This drive server does not use
an index.



If the client program asks to read a file, but then opens and closes the
data pipe without reading anything, then this server gets hit with
SIGPIPE, and it will exit without cleaning up after itself unless we
do something about SIGPIPE. So it traps SIGPIPE and aborts the read if
it gets SIGPIPE. Probably SIGPIPE could be blocked instead of trapped;
that would be less code, but that would not abort the read; it would
send the data nowhere instead of sending it to the pipe, but
it would still read the data. By aborting the read the server is ready for
the next command sooner; a lot sooner if it was a long read.

exit codes:
0  ok
1  aborted by user
2  already running
3  configuration error
10 miscellaneous fatal error
40 bug detected

Note that if perl errors occur, then perl chooses the exit code. If perl
runs out of memory, you get exit code 1. If perl fails to compile, you
get exit code 2. To determine if the exit code came from perl or from
the program, read the error messages.
