#!/usr/bin/perl -w
use integer;

$Include = 1;
$Exclude = 0;

$LsCommand = 'ls --format=long --almost-all --full-time --numeric-uid-gid';
$CurrentDirectory = '';
@IncludeOrExclude = ($Include);
@IncExcPatterns = ('.');
$NameOfIncludeExcludeFile = '';
@SubdirectoriesToList = ();
@SubdirectoriesOfCurrentDirectory = ();


$StartingDirectory = &PWD;
#print("starting directory is '$StartingDirectory'\n");
&readCommandLineParameters;
if ( $NameOfIncludeExcludeFile ne '' ) { &readIncludeExcludeFile }
&listCurrentDirectory;
while ( $#SubdirectoriesToList > -1 ) { &listNextSubdirectory }




sub  findNextNonWhitespace  {
my $NA = $_[1];
my $SA = '';
while () {
  $SA = substr($_[0],$NA,1);
  if ($SA eq '')  { return($NA) }
  if ($SA eq '\r' or $SA eq '\n' or $SA eq '\t' or $SA eq ' ')
      { $NA = $NA + 1; next }
  return($NA);
  }
}


sub  findNextWhitespace  {
my $NA = $_[1];
my $SA = '';
while () {
  $SA = substr($_[0],$NA,1);
  if ($SA eq '')  { return($NA) }
  if ($SA eq '\r' or $SA eq '\n' or $SA eq '\t' or $SA eq ' ')
      { return($NA) }
  $NA = $NA + 1;
  }
}



sub isFileNameIncludedOrExcluded  {
  # start with the last pattern
  my $IncExcPatternCount = $#IncludeOrExclude;
  #print(STDERR "file name is '$_[0]'\n");
  # for each pattern ...
  while ( $IncExcPatternCount >= 0 ) {
    # if filename matches pattern ...
    if ( $_[0] =~ m/$IncExcPatterns[$IncExcPatternCount]/ ) {
      #print(STDERR "file matched '$IncExcPatterns[$IncExcPatternCount]'\n");
      # return the include or exclude value stored in
      # $IncludeOrExclude[$IncExcPatternCount]
      #print(STDERR "returning '$IncludeOrExclude[$IncExcPatternCount]'\n");
      return($IncludeOrExclude[$IncExcPatternCount]);
      }
    # the pattern did not match the filename    
    # try the previous pattern
    $IncExcPatternCount = $IncExcPatternCount - 1;
    }
  # none of the patterns matched, so exclude the file
  return($Exclude);
  }



sub listCurrentDirectory  {
#print("listing current directory\n");
my $Name;
@SubdirectoriesOfCurrentDirectory = ();
open(FH_listing,"$LsCommand|");
while (<FH_listing>) {
  print($_);
  if ( substr($_,0,1) eq 'd' )  {
    ($Name,undef) = &parseLsLine($_);
    if ( &isFileNameIncludedOrExcluded($CurrentDirectory . $Name)
                                                        == $Include )  {
      @SubdirectoriesOfCurrentDirectory =
          ( ($CurrentDirectory . $Name) ,@SubdirectoriesOfCurrentDirectory);
      }
    }
  }
close(FH_listing);
@SubdirectoriesToList =
      (@SubdirectoriesToList,@SubdirectoriesOfCurrentDirectory);
@SubdirectoriesOfCurrentDirectory = ();
}


sub listNextSubdirectory   {
$CurrentDirectory = $SubdirectoriesToList[$#SubdirectoriesToList];
$#SubdirectoriesToList = $#SubdirectoriesToList - 1;
#print("changing to directory '$StartingDirectory$CurrentDirectory'\n");
chdir("$StartingDirectory$CurrentDirectory")
       or   &zNoChdir("$StartingDirectory$CurrentDirectory");
print("\n$CurrentDirectory:\n");
$CurrentDirectory = $CurrentDirectory . '/';
&listCurrentDirectory;
}



sub parseLsLine  {
# The exact format of the ls line varies depending on what version of ls
# we are using. Also, if one number like the size or number of hard links
# is unusually large, extra characters are inserted, and the following
# fields are shifted. The easy way to parse the ls line would be to cut at
# certain character positions; however that would result in errors
# if the format of the ls line varied. That is this looks for the next
# whitespace, looks for the next nonwhitespace, etc.
# This sub returns '' for every piece of data which it cannot extract
# from the input. It is up to the calling routine to decide whether or
# not that is an error.
chomp($_[0]);
my $Name;
my $LinksTo = '';
my $Size = '';
my $MajorNumber = '';
my $MinorNumber = '';
my $Type = substr($_[0],0,1);
my $Permissions = substr($_[0],1,9);
my $SP1 = 11;
$SP1 = &findNextNonWhitespace($_[0],$SP1);
my $SP2 = &findNextWhitespace($_[0],$SP1);
my $HardLinks = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1);
my $UID = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1);
my $GID = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
if ( $Type eq 'b'  or  $Type eq 'c' )  {
  $SP2 = index($_[0],',',$SP1);
  if ( $SP2 < $SP1 ) { $SP2 = length($_[0]) }
  $MajorNumber = substr($_[0],$SP1,$SP2-$SP1);
  $SP1 = &findNextNonWhitespace($_[0],$SP2+1);
  $SP2 = &findNextWhitespace($_[0],$SP1);
  $MinorNumber = substr($_[0],$SP1,$SP2-$SP1);
  }
else  {
  $SP2 = &findNextWhitespace($_[0],$SP1);
  $Size = substr($_[0],$SP1,$SP2-$SP1);
  }
$SP1 = &findNextNonWhitespace($_[0],$SP2);
$SP2 = &findNextWhitespace($_[0],$SP1 + 23);
my $Date = substr($_[0],$SP1,$SP2-$SP1);
$SP1 = &findNextNonWhitespace($_[0],$SP2);
if ( $Type eq 'l' )  {
  $SP2 = index($_[0],' -> ',$SP1);
  if ( $SP2 < $SP1 ) { $SP2 = length($_[0]) }
  $Name = substr($_[0],$SP1,$SP2-$SP1);
  $LinksTo = substr($_[0],$SP2+4);
  }
else {
  $Name = substr($_[0],$SP1);
  }
#print("Name is '$Name'\n");
#print("Type is '$Type'\n");
#print("Permissions is '$Permissions'\n");
#print("HardLinks is '$HardLinks'\n");
#print("UID is '$UID'\n");
#print("GID is '$GID'\n");
#print("Size is '$Size'\n");
#print("MajorNumber is '$MajorNumber'\n");
#print("MinorNumber is '$MinorNumber'\n");
#print("Date is '$Date'\n");
#print("LinksTo is '$LinksTo'\n");
return($Name,$Type,$Permissions,$HardLinks,$UID,$GID,$Size,$MajorNumber,
       $MinorNumber,$Date,$LinksTo);
}



sub PWD  {
my $SA = `pwd`;
if ( substr($SA,0,1) ne '/' ) {
  print(STDERR "
lsincexc.pl: pwd returned '$SA'
instead of a string which begins with '/'
");
  exit(10);
  }
chomp($SA);
if ( substr($SA,-1) eq '/')  {
  return($SA);  # ends with /
  #return($SA . '.');  # does not end with /
  }
else  {
  return($SA . '/');  # ends with /
  #return($SA);  # does not end with /
  }
}


sub readCommandLineParameters  {
my $NA = -1;
while ( $NA < $#ARGV ) {
  $NA = $NA + 1;
  if ($ARGV[$NA] eq '--help') {
    print("
lsincexc.pl  options:
--help
--include-exclude-file=[name of include exclude file]
--version
");
    exit(0);
    }
  if (substr($ARGV[$NA],0,23) eq '--include-exclude-file=') {
    $NameOfIncludeExcludeFile = substr($ARGV[$NA],23);
    #print("include exclude file name is '$NameOfIncludeExcludeFile'\n");
    next;
    }
  if ($ARGV[$NA] eq '--version') {
    print("lsincexc.pl   (ls with include exclude)      version 1.0\n");
    exit(0);
    }
  print(STDERR "
lsincexc.pl: unknown command line option:  $ARGV[$NA]
try     lsincexc.pl --help
");
  exit(11);
  }
#print("got command line parameters\n");
}


sub readIncludeExcludeFile  {
@IncludeOrExclude = ();
@IncExcPatterns = ();
if (!open(FH_IncExcFile,"<$NameOfIncludeExcludeFile")) {
  print(STDERR "
lsincexc.pl: unable to open include/exclude file
'$NameOfIncludeExcludeFile'
");
  exit(12);
  }
$IncExcPatternCount = 0;
while (<FH_IncExcFile>) {
  chomp($_);
  if (substr($_, 0, 4) eq 'inc ') {
    $IncExcPatterns[$IncExcPatternCount] = substr($_, 4);
    $IncludeOrExclude[$IncExcPatternCount] = $Include;
    $IncExcPatternCount = $IncExcPatternCount + 1;
    }
  if (substr($_, 0, 4) eq 'exc ') {
    $IncExcPatterns[$IncExcPatternCount] = substr($_, 4);
    $IncludeOrExclude[$IncExcPatternCount] = $Exclude;
    $IncExcPatternCount = $IncExcPatternCount + 1;
    }
  }
close(FH_IncExcFile);
chomp(@IncExcPatterns);
}


sub  zNoChdir  {
print(STDERR "
lsincexc.pl: unable to change to directory '$_[0]'
");
exit(13);
}


__END__

This is lsincexc.pl, ls with include/exclude, a selectively recursive ls.
It recurses into some subdirectories, but not into other subdirectories.

The include/exclude file controls which subdirectories are recursed
into and which subdirectories are not recursed into. You give lsincexc.pl
an include/exclude file with the '--include-exclude-file=' command
line option.

If you do not give an include/exclude file, lsincexc.pl will recurse
into all subdirectories. If you really want to do that, you should
forget this program and use 'ls --recursive'.

If you use the command line parameter '--include-exclude-file=' more
than once, the last one is used and the others are ignored.

The include/exclude file is a text file. If the first four characters of a
line are 'inc ', then the rest of the line is an include pattern. If the
first four characters of a line are 'exc ', then the rest of the line is
an exclude pattern. Any other line is a comment and is ignored. If more
than one pattern matches the name of a subdirectory, then the last pattern
which matches the pattern controls whether the subdirectory is included or
excluded. If no patterns match the name of the subdirectory,
then the subdirectory is excluded. Included means the subdirectory will be
recursed into. Excluded means the subdirectory will not be
recursed into. The patterns are perl patterns, which are version 8 regular
expressions, like grep patterns, NOT like sh patterns.
In the include/exclude file, put the general rules first, then the
exceptions to the rules, then the exceptions to the exceptions. For example:

inc .
exc var\/
inc var\/lib
exc var\/lib\/games

The first line includes everything. The second line excludes
subdirectories of var, but does not exclude var. If the second line was
'exc var', then var would be excluded, and lsincexc.pl would not recurse
into var, and lsincexc.pl would not find any subdirectories in var, and
thus all subdirectories of var would be excluded, and the last two lines
would be meaningless.

exit codes:
10  failure to get name of current directory
11  unknown command line option
12  unable to open include exclude file
13  failure to change directory
