#!/usr/bin/perl -w

use integer;
use English;

use sigtrap;
$SIG{PIPE} = \&SignalTrap;
$SIG{INT} = \&SignalTrap;
$SIG{TERM} = \&SignalTrap;

$No = 0;
$Yes = 1;
$Failure = 0;
$Success = 1;
$Deleted = 'd';
$NotDeleted = 'n';
$NoTape = 0;
$BlankTape = -1;
$WrongTapeSet = -2;
$RightTape = -3;

$FileHandle_TapeDevice = 'A';
$FileHandle_DataPipe = 'B';
$FileHandle_CommandsPipe = 'C';

# for $TapeChangeAction
$None = 0;
$PromptAndReadStdin = 1;
$PromptAndWait = 2;
$RunExternalCommands = 3;

# for $VolumeTableProgram
$Vtblc = 1;

$AlreadyExiting = $No;
$Buffer = '';
@Commands = ('');
$ConfigurationError = $No;
$CurrentTape = 0;
@FileName = ();
@FilesForAdjustVolTab = ();
$FirstLoadAttempt = $Yes;
$FooterMarker = 'mtif1';
    # mtif1 means multiple tape interface footer version 1
@FileDate = ();
@FragmentNumber = ();
$HeaderMarker = 'mtih1';
    # mtih1 means multiple tape interface header version 1
$HeaderReadBuffer = '';
$IndexHasChanged = $No;
@IsFileDeleted = ();
$LoadAttempts = 0;
$RebuildIndex = $No;
$Results = "success\nno action has been taken yet\n";
$SignalPipeReceived = $No;
@TapeNumberOfFileFragment = ();
@TapePositionOfFileFragment = ();
$TapeToLoad = 0;
$TapeToRemove = 0;

$NA = -1;
while ( $NA < $#ARGV ) {
  $NA = $NA + 1;
  #print(STDERR "parameter is '$ARGV[$NA]'\n");
  if ( substr($ARGV[$NA],0,17) eq '--mdti-directory=' )
     { $MdtiDirectory = substr($ARGV[0],17); next }
  if ( $ARGV[$NA] eq '--rebuild-index' )
     { $RebuildIndex = $Yes; next }
  if ( substr($ARGV[$NA],0,8) eq '--start=' )
     { $StartCommand = substr($ARGV[0],8); next }
  }

if ( ! defined($MdtiDirectory) )  {
    if ( ! defined($StartCommand) )  { $StartCommand = $PROGRAM_NAME }
    #print(STDERR "start command is $StartCommand\n");
    $NA = rindex($StartCommand,'/');
    if ( $NA == 0 )  { $MdtiDirectory = '/' }
    elsif ( $NA < 0 )  { $MdtiDirectory = '.' }
    else  { $MdtiDirectory = substr($StartCommand,0,$NA) }
    }
#print(STDERR "working directory is $MdtiDirectory\n");
chdir($MdtiDirectory) or &zNoCD($MdtiDirectory);

if ( -e 'commands' ) { &zCommandsExists }
&RunExternalCommand('mknod commands p', 'make pipe command');
if ( ! -p 'data' )
    { &RunExternalCommand('mknod data p', 'make pipe command') }
$LengthOfFooterMarker = length($FooterMarker);
$LengthOfHeaderMarker = length($HeaderMarker);

&ReadConfigurationFile;
if ( ! defined($TapeDataTransferMinimumSize) )
      { &zNotInConfig('tape data transfer minimum size') }
if ( ! defined($TapeDataTransferMaximumSize) )
      { &zNotInConfig('tape data transfer maximum size') }
else {
  $TapeDataTransferMaximumSize = ($TapeDataTransferMaximumSize /
      $TapeDataTransferMinimumSize) * $TapeDataTransferMinimumSize;
  if ( $TapeDataTransferMaximumSize < $TapeDataTransferMinimumSize )
      { $TapeDataTransferMaximumSize = $TapeDataTransferMinimumSize }
  }
if ( ! defined($AbortOnIndexErrors) )
      { &zNotInConfig('abort on index errors') }
if ( ! defined($HeaderReadSize) )  { &zNotInConfig('header read size') }
else  {
  $NA = $HeaderReadSize / $TapeDataTransferMinimumSize;
  $HeaderReadSize = ($NA + 1) * $TapeDataTransferMinimumSize;
  if ( $HeaderReadSize > $TapeDataTransferMaximumSize )
      { $HeaderReadSize = $TapeDataTransferMaximumSize }
  }
#print(STDERR "header read size is $HeaderReadSize\n"); exit;
if ( ! defined($MaximumFooterSize) ) {
#  $NA = $LengthOfFooterMarker / $TapeDataTransferMinimumSize;
#  $MaximumFooterSize = ($NA + 1) * $TapeDataTransferMinimumSize;
  $MaximumFooterSize =
     $LengthOfFooterMarker + $TapeDataTransferMinimumSize - 1;
  }
if ( ! defined($MaximumHeaderSize) )
      { &zNotInConfig('maximum header size') }
if ( ! defined($MTback) )
      { &zNotInConfig('mt back') }
if ( ! defined($MTprogram) )
      { &zNotInConfig('mt program') }
if ( ! defined($MaxLoadAttempts) )
      { &zNotInConfig('number of times to try to load') }
if ( ! defined($OverwritesAreAllowed) )
      { &zNotInConfig('overwrites are allowed') }
if ( ! defined($TapeChangeAction) )  { &zNotInConfig('tape change action') }
elsif ( $TapeChangeAction == $PromptAndWait )  {
  if ( ! defined($TapeChangeWait) )
      { &zNotInConfig('number of seconds to wait for tape change') }
  }
elsif ( $TapeChangeAction == $RunExternalCommands )  {
  if ( ! defined($TapeChangeCommands) )
      { &zNotInConfig('tape change commands or script') }
  }
if ( ! defined($TapeDevice) )  { &zNotInConfig('tape device') }
elsif ( (! -b $TapeDevice)    and    (! -c $TapeDevice) )
     { &zNoDevice($TapeDevice) }
if ( ! defined($TapeSetName) )
      { &zNotInConfig('tape set name') }
if ( ! defined($TryLoadingFirst) )
      { &zNotInConfig('try loading first') }
if ( ! defined($VerifyEndOfData) )
      { &zNotInConfig('verify end of data') }
if ( ! defined($VerifyDeletes) )
      { &zNotInConfig('verify deletes') }
if ( ! defined($VerifyTapes) )
      { &zNotInConfig('verify tapes') }
elsif ( $VerifyTapes == $Yes     and     ( ! defined($UnknownTape) ) )
      { &zNotInConfig('unknown tapes are') }
if ( ! defined($VolumeTableProgram) )
      { &zNotInConfig('volume table program') }
elsif ( $VolumeTableProgram == $Vtblc )  {
  if ( ! defined($VtblcDevice) )
      { &zNotInConfig('vtblc device') }
  elsif ( (! -b $VtblcDevice)     and     (! -c $VtblcDevice) )
       { &zNoDevice($VtblcDevice) }
  }
if ( ! defined($WarnAboutIndexErrors) )
      { &zNotInConfig('warn about index errors') }
if ( $ConfigurationError == $Yes ) { &zConfigError }


if ( defined($StartCommands) )
    { &RunExternalCommand($StartCommands, 'start commands') }
#if ( $RebuildIndex == $Yes )  { print(STDERR "rebuild index is yes\n") }
#else  { print(STDERR "rebuild index is no\n") }
if ( $RebuildIndex )  { &RebuildIndex }
#print(STDERR "about to read index\n");
&ReadIndexFile;
#print(STDERR "ready for first command\n");

L_Command: while () {
open($FileHandle_CommandsPipe, "< commands") or &zNoReadCommands;
@Commands = <$FileHandle_CommandsPipe>;
close($FileHandle_CommandsPipe);
#print(STDERR "command is:\n",@Commands);
if ( $#Commands < 0 )  { @Commands = (''); next }
if ( $Commands[0] eq "exit\n" )  { last }
if ( $Commands[0] eq "create\n" )  { &TapeWrite; next }
if ( $Commands[0] eq "read\n" )  { &TapeRead; next }
if ( $Commands[0] eq "delete\n" )  {
  if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    next;
    }
  chomp($Commands[1]);
  if ( &SetFileSelectorToFirstFragmentOf($Commands[1]) )  {
    while () {
      $IsFileDeleted[$FileSelector] = $Deleted;
      &SetFileSelectorToNextFragmentOf($FileSelector) or last;
      }
    $IndexHasChanged = $Yes;
    $Results = "success\nfile deleted\n$Commands[1]\n";
    }
  else  { $Results = "failure\nfile does not exist\n$Commands[1]\n" }
  next;
  }
if ( $Commands[0] eq "result\n" )  {
  open($FileHandle_DataPipe, "> data") or &zNoWriteData;
  #print(STDERR "sending result:\n$Results");
  print($FileHandle_DataPipe $Results);
  close($FileHandle_DataPipe);
  next;
  }
$Results = "failure\ncommand not known\n";
}

&Unload(0);




sub ChangeTapes_PromptOrScriptOrWhatever  {
my $SA;
#print(STDERR "sub ChangeTapes_PromptOrScriptOrWhatever\n");
if ( $FirstLoadAttempt     and     $TryLoadingFirst )
    { $FirstLoadAttempt = $No; return($Success) }
if ( $TapeChangeAction == $RunExternalCommands )  {
    &RunExternalCommand("$TapeChangeCommands $TapeToRemove $TapeToLoad",
        'tape change commands');
    }
elsif ( $TapeToLoad == $NoTape )  { &zTapeRemove; return($Success) }
elsif ( $TapeChangeAction == $PromptAndReadStdin )  {
    &zTapeEnter;
    $SA = <STDIN>;
    if ( $SA eq "exit\n" )  { &Unload(1) }
    if ( $SA eq "fail\n" )  { return($Failure) }
    }
elsif ( $TapeChangeAction == $PromptAndWait )  {
    &zTapeWait;
    sleep($TapeChangeWait);
    }
return($Success);
}




sub IdentifyTape  {
my $NA;
# read volume table?
#print(STDERR "sub IdentifyTape\n");
#print(STDERR "tape to load is $TapeToLoad\n");
#print(STDERR "unknown tape is $UnknownTape\n");
#print(STDERR "blank tape is $BlankTape\n");
$FragmentToRead = 0;
while ()  {
  &MoveTapeTo($FragmentToRead);
  #print(STDERR "about to test for file fragment for identify tape\n");
  if ( &IsThereAFileFragmentAtThisPosition == $No )  {
    #print(STDERR "no fragment at this position\n");
    #print(STDERR "\$TapePosition is $TapePosition\n");
    if ( $TapePosition > 0 )  {
      # $UnknownTape should be set to $RightTape, $BlankTape, or
      # $WrongTapeSet
      if ( $UnknownTape == $RightTape )  { $CurrentTape = $TapeToLoad }
      else  { $CurrentTape = $UnknownTape }
      }
    else { $CurrentTape = $BlankTape }
    #print(STDERR "sub IdentifyTape: tape $CurrentTape\n");
    return;
    }
  #print(STDERR "there is a fragment at this position\n");
  &ReadHeaderData;
  close($FileHandle_TapeDevice);
  $HeaderReadBuffer = '';
  if ( ! defined($TapeSetNameFromHeader) )  {
    $FragmentToRead = $FragmentToRead + 1;
    next;
    }
  if ( $TapeSetNameFromHeader ne $TapeSetName )  {
    $CurrentTape = $WrongTapeSet;
    #print(STDERR "wrong tape set is $WrongTapeSet\n");
    return;
    }
  $CurrentTape = $TapeNumberFromHeader;
  #print(STDERR "sub IdentifyTape: tape $CurrentTape\n");
  return;
  }
}




sub IsThereAFileFragmentAtThisPosition  {
# to detect whether or not there is a file fragment at the current tape
# position, use mt fsf 1. If it returns exit code 2, then there is no file
# fragment at the current position.
# This sub should return $No if there is no tape in the drive, although I
# did not actually test it.
my $NA;
#print(STDERR "sub IsThereAFileFragmentAtThisPosition\n");
#print(STDERR "attempting $MTprogram fsf 1 to test for fragment\n");
$NA = (system("$MTprogram -f $TapeDevice fsf 1 2> /dev/null") & 0xFFFF) >> 8;
#print(STDERR "attempt returned $NA\n");
if ( $NA == 2 )  {
  #print(STDERR "sub IsThereAFileFragmentAtThisPosition: no fragment\n");
  return($No);
  }
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice fsf 1",$NA) }
$TapePosition = $TapePosition + 1;
#print(STDERR "attempting $MTprogram $MTback 2 after fragment found\n");
$NA = (system("$MTprogram -f $TapeDevice $MTback 2 2> /dev/null")
    & 0xFFFF) >> 8;
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice $MTback 2",$NA) }
$TapePosition = $TapePosition - 1;
#print(STDERR "sub IsThereAFileFragmentAtThisPosition: fragment found\n");
return($Yes);
}




sub IsThereATapeInTheDrive  {
# do a rewind to test if there is a tape in the drive; if the exit code of
# rewind is 0, there is a tape in the drive; if the exit code of rewind is 2
# there is no tape in the drive; any other exit code is an unknown error.
my $NA;
#print(STDERR "sub IsThereATapeInTheDrive\n");
#print(STDERR "attempting $MTprogram rewind\n");
$NA = (system("$MTprogram -f $TapeDevice rewind 2> /dev/null") & 0xFFFF) >> 8;
#print(STDERR "checking for tape: exit code is $NA\n");
if ( $NA == 2 )  {
  #print(STDERR "sub IsThereATapeInTheDrive: no tape\n");
  return($No);
  }
#print(STDERR "checking for tape: exit code is not 2\n");
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice rewind",$NA) }
$TapePosition = 0;
#print(STDERR "sub IsThereATapeInTheDrive: tape found\n");
return($Yes);
}




sub LoadTape  {
# set $TapeToLoad, $LoadAttempts = 0, and $NextTapeIsProbablyBlank
# before calling this sub
#print(STDERR "sub LoadTape\n");
if ( ! defined($TapeToLoad) )  { &zLoadTapeNotDefined }
#print(STDERR "\$CurrentTape is $CurrentTape, \$TapeToLoad is $TapeToLoad\n");
if ( $CurrentTape == $TapeToLoad )  { return($Success) }
#print(STDERR "LoadTape 2\n");
# $CurrentTape < 0   means $BlankTape or $WrongTapeSet
if ( $CurrentTape < 0    and    $TapeToLoad != $NoTape    and
      $TapeChangeAction == $None )  { return($Failure) }
#print(STDERR "LoadTape 3\n");
$LoadAttempts = $LoadAttempts + 1;
if ( $LoadAttempts > $MaxLoadAttempts )  { return($Failure) }
#print(STDERR "LoadTape 4\n");
if ( $CurrentTape != $NoTape )  { &RewindTapeAndAdjustVolumeTable }
$TapeToRemove = $CurrentTape;
# if ( $TapeChangeAction != $RunExternalCommands    and
#    $TapeToLoad == $NoTape )  { return($Success) }
#print(STDERR "LoadTape 5\n");
&ChangeTapes_PromptOrScriptOrWhatever  or  return($Failure);
#print(STDERR "LoadTape 6\n");
if ( $TapeToLoad == $NoTape )  { return($Success) }
#print(STDERR "about to test if there is a tape in the drive\n");
if ( &IsThereATapeInTheDrive == $No )  { &zNoTape; return(&LoadTape) }
if ( $VerifyTapes == $No )
      { $CurrentTape = $TapeToLoad; return($Success) }
&IdentifyTape;
#print(STDERR "current tape is $CurrentTape\n");
if ( $CurrentTape == $WrongTapeSet )  { &zWrongTapeSet; return(&LoadTape) }
# should we erase tapes from wrong tape sets?
if ( $CurrentTape == $BlankTape )  {
  if ( $NextTapeIsProbablyBlank )
      { $CurrentTape = $TapeToLoad; return($Success) }
  else  { &zWrongBlankTape; return(&LoadTape) }
  }
if ( $CurrentTape == $TapeToLoad )  { return($Success) }
&zWrongTape;
return(&LoadTape);
}




sub MoveTapeTo  {
# this is not the most efficient way to reposition the tape, but it is safe
# and reliable and should work for just about all tape drives; and most
# important of all it will work even if $TapePosition is wrong.
my $NA;
# The next command could be skipped; it is only needed if the tape is
# positioned part way through the first fragment, AND IF the tape driver
# does not move the tape when you try to move the tape further than is
# possible. My ftape 4 moves the tape as far as possible when I try to move
# the tape further than is possible, so I do not need this. But I do not
# know if other tape drivers are the same, so it seems safer to include the
# next command; it does no harm other than to waste time.
system("$MTprogram -f $TapeDevice $MTback 1 2> /dev/null");
# The next command could be skipped, but it speeds things up if the tape
# is positioned many tape positions from the beginning.
system("$MTprogram -f $TapeDevice $MTback $TapePosition 2> /dev/null");
# keep backing up until it can not back up any more
until ( system("$MTprogram -f $TapeDevice $MTback 2 2> /dev/null") )  {}
# the previous commands rewind the tape. So wouldn't it be simpler to do mt
# rewind? It would be simpler, but this is better if the tape driver
# optimizes tape movements. If your tape driver is ftape 4 and you do mt bsf
# 10 and then mt fsf 10; ftape does nothing; then if you open the tape
# device and write data to the tape, ftape moves the tape to where the tape
# is supposed to be. ftape optimizes tape movement by delaying tape
# movements as long as possible, and then combining multiple tape movements
# into a single tape movement. But rewinds are not delayed. Thus this
# complicated way of rewinding the tape is faster than mt rewind for ftape.
# But if your tape driver does not optimize tape movement, then it would be
# simpler and faster to use mt rewind.
# Now that the tape is rewound to tape position 0, move forward to where
# we want to go to
$NA = ( system("$MTprogram -f $TapeDevice fsf $_[0] 2> /dev/null")
    & 0xFFFF ) >> 8;
if ( $NA == 2 )
    { &zNoTapePosition("$MTprogram -f $TapeDevice fsf $_[0]",$NA) }
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice fsf $_[0]",$NA) }
$TapePosition = $_[0];
}




sub ReadConfigurationFile  {
#system("pwd&&True");
open(FH_ConfigFile, "< config") or &zNoOpenR("config",$MdtiDirectory);
while (<FH_ConfigFile>)  {
  my $SA; my $SB; my $NA;
  chomp $_;
  if ( $_ eq '' )  { next }
  if ( substr($_,0,1) eq '#' )  { next }
  $NA = index($_,'=');
  if ( $NA < 0 )  { &zConfigNoEq; next }
  if ( $NA == 0 )  { &zConfigBeginEq; next }
  $SA = substr($_,0,$NA);
  $SB = substr($_,($NA + 1));
  if ( substr($SB,-1) eq ' ' )  { &zConfigEndSpace; next }
  if ($SA eq 'abort on index errors')  {
    if ( $SB eq 'yes' )  { $AbortOnIndexErrors=$Yes }
    elsif ( $SB eq 'no' )  { $AbortOnIndexErrors=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ( $SA eq 'header read size' ) { $HeaderReadSize=$SB; next }
  if ($SA eq 'warn about index errors')  {
    if ( $SB eq 'yes' )  { $WarnAboutIndexErrors=$Yes }
    elsif ( $SB eq 'no' )  { $WarnAboutIndexErrors=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ( $SA eq 'maximum footer size' ) { $MaximumFooterSize=$SB; next }
  if ( $SA eq 'maximum header size' ) { $MaximumHeaderSize=$SB; next }
  if ( $SA eq 'number of times to try to load' )
    { $MaxLoadAttempts=$SB; next }
  if ( $SA eq 'mt back' ) { $MTback=$SB; next }
  if ( $SA eq 'mt program' ) { $MTprogram=$SB; next }
  if ($SA eq 'overwrites are allowed')  {
    if ( $SB eq 'yes' )  { $OverwritesAreAllowed=$Yes }
    elsif ( $SB eq 'no' )  { $OverwritesAreAllowed=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ( $SA eq 'start commands' ) { $StartCommands=$SB; next }
  if ( $SA eq 'stop commands' ) { $StopCommands=$SB; next }
  if ( $SA eq 'tape change action' )  {
    if ( $SB eq 'none' ) { $TapeChangeAction=$None; next }
    if ( $SB eq 'prompt and read stdin' )
      { $TapeChangeAction=$PromptAndReadStdin; next }
    if ( $SB eq 'prompt and wait' ) { $TapeChangeAction=$PromptAndWait; next }
    if ( $SB eq 'run external commands' )
      { $TapeChangeAction=$RunExternalCommands; next }
    &zConfigWrong($SA,$SB);
    }
  if ( $SA eq 'tape change commands or script' )
      { $TapeChangeCommands=$SB; next }
  if ( $SA eq 'number of seconds to wait for tape change' )
    { $TapeChangeWait=$SB; next }
  if ( $SA eq 'tape data transfer minimum size' )
      { $TapeDataTransferMinimumSize=$SB; next }
  if ( $SA eq 'tape data transfer maximum size' )
      { $TapeDataTransferMaximumSize=$SB; next }
  if ( $SA eq 'tape device' ) { $TapeDevice=$SB; next }
  if ( $SA eq 'tape set name' ) { $TapeSetName=$SB; next }
  if ($SA eq 'try loading first')  {
    if ( $SB eq 'yes' )  { $TryLoadingFirst=$Yes }
    elsif ( $SB eq 'no' )  { $TryLoadingFirst=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ($SA eq 'unknown tapes are')  {
    if ( $SB eq 'blank tapes' )  { $UnknownTape=$BlankTape }
    elsif ( $SB eq 'wrong tape set' )  { $UnknownTape=$WrongTapeSet }
    elsif ( $SB eq 'right tape' )  { $UnknownTape=$RightTape }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ($SA eq 'verify deletes')  {
    if ( $SB eq 'yes' )  { $VerifyDeletes=$Yes }
    elsif ( $SB eq 'no' )  { $VerifyDeletes=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ($SA eq 'verify end of data')  {
    if ( $SB eq 'yes' )  { $VerifyEndOfData=$Yes }
    elsif ( $SB eq 'no' )  { $VerifyEndOfData=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ($SA eq 'verify tapes')  {
    if ( $SB eq 'yes' )  { $VerifyTapes=$Yes }
    elsif ( $SB eq 'no' )  { $VerifyTapes=$No }
    else  { &zConfigYorN($SA,$SB) }
    next;
    }
  if ( $SA eq 'volume table program' )  {
    if ( $SB eq 'none' ) { $VolumeTableProgram=$None; next }
    if ( $SB eq 'vtblc' ) { $VolumeTableProgram=$Vtblc; next }
    &zConfigWrong($SA,$SB);
    }
  if ( $SA eq 'vtblc device' ) { $VtblcDevice=$SB; next }
  &zConfigUnknownOption($SA);
  }
close(FH_ConfigFile);
}




sub ReadHeaderData  {
# move the tape to the beginning of the file fragment before calling this sub
# This sub opens the tape but does not close the tape, in case you want to
# continue reading. So after you call this sub, either continue reading; or
# else close the tape, clear $HeaderReadBuffer, and move the tape forward or back so
# that the tape is positioned at the beginning of a file fragment.
# You probably want to call &IsThereAFileFragmentAtThisPosition before
# calling this sub.
my $NA; my $NB; my $NC; my $SA;
#print(STDERR "\$TapePosition is $TapePosition\n");
#print(STDERR "sub ReadHeaderData\n");
#print(STDERR "sub ReadHeaderData 1\n");
if ( $HeaderReadBuffer ne '' )  { &zHeaderReadBufferNotEmpty }
#print(STDERR "sub ReadHeaderData 2\n");
# open($FileHandle_TapeDevice,"<$TapeDevice") or &zNoOpenR($TapeDevice);
sysopen($FileHandle_TapeDevice,$TapeDevice,0) or &zNoOpenR($TapeDevice);
#print(STDERR "sub ReadHeaderData 3\n");
$HeaderSize = $LengthOfHeaderMarker;  # The name $HeaderSize is a little
# misleading. This sub uses $HeaderSize to mark the number of bytes read so
# far, or as the number of bytes which should be available for the next
# read. $LengthOfHeaderMarker is the number of bytes which should be
# available for the first read.
# When this sub returns, $HeaderSize will be the size of the header.
#print(STDERR "sub ReadHeaderData 4\n");
#print(STDERR "\$HeaderSize is $HeaderSize\n");
until ( length($HeaderReadBuffer) >= $HeaderSize )
#    { sysread($FileHandle_TapeDevice,$HeaderReadBuffer,$HeaderReadSize,
#           length($HeaderReadBuffer))   or   last }
    {
    #print(STDERR "length of header read buffer is ",
                   #length($HeaderReadBuffer),"\n");
    $NA = sysread($FileHandle_TapeDevice,$HeaderReadBuffer,
                    $HeaderReadSize,length($HeaderReadBuffer));
    #print(STDERR "read $NA bytes\n");
    #print(STDERR "length of header read buffer is ",
                 #length($HeaderReadBuffer),"\n");
    if ( $NA == 0 )  { last } }
#print(STDERR "sub ReadHeaderData 5\n");
#print(STDERR "first 70 bytes of header are:\n'",
             #substr($HeaderReadBuffer,0,70),"'\n");
if ( substr($HeaderReadBuffer,0,$LengthOfHeaderMarker) ne $HeaderMarker )  {
  undef($TapeSetNameFromHeader);
  undef($TapeNumberFromHeader);
  undef($FileNameFromHeader);
  undef($FileDateFromHeader);
  undef($FragmentNumberFromHeader);
  $HeaderSize = 0;
  #print(STDERR "sub ReadHeaderData: no header\n");
  return;
  }
#print(STDERR "sub ReadHeaderData 6\n");
if ( length($HeaderReadBuffer) < $HeaderSize )  { &ReadHeaderError; return }
#print(STDERR "sub ReadHeaderData 7\n");
while ()  {
  ($TapeNumberFromHeader, $NA, $FragmentNumberFromHeader, $NB,
      $FileDateFromHeader, $NC) =
      &UnpackVunsignedInteger($HeaderReadBuffer, $HeaderSize, 3);
  if ( defined($NC)    or
       length($HeaderReadBuffer) >= $MaximumHeaderSize )  { last }
  sysread($FileHandle_TapeDevice,$HeaderReadBuffer,$HeaderReadSize,
       length($HeaderReadBuffer))   or   last;
  }
#print(STDERR "sub ReadHeaderData 8\n");
#print(STDERR "\$TapeNumberFromHeader is $TapeNumberFromHeader\n");
#print(STDERR "\$FragmentNumberFromHeader is $FragmentNumberFromHeader\n");
#print(STDERR "\$FileDateFromHeader is $FileDateFromHeader\n");
if ( ! defined($NC) )  { &ReadHeaderError; return }
$HeaderSize = $HeaderSize + $NA + $NB + $NC;
#print(STDERR "sub ReadHeaderData 9\n");
while ()  {
  ($TapeSetNameFromHeader, $NA, $FileNameFromHeader, $NB, undef, $NC) =
     &UnpackVstring($HeaderReadBuffer, $HeaderSize, 3);
  if ( defined($NC)    or
       length($HeaderReadBuffer) >= $MaximumHeaderSize )  { last }
  sysread($FileHandle_TapeDevice,$HeaderReadBuffer,$HeaderReadSize,
       length($HeaderReadBuffer))   or   last;
  }
#print(STDERR "sub ReadHeaderData 10\n");
#print(STDERR "\$TapeSetNameFromHeader is '$TapeSetNameFromHeader'\n");
#print(STDERR "\$FileNameFromHeader is '$FileNameFromHeader'\n");
#print(STDERR "size of additional header data is $NC\n");
if ( ! defined($NC) )  { &ReadHeaderError; return }
$HeaderSize = $HeaderSize + $NA + $NB + $NC;
$CalculatedChecksum = unpack("%32L*",
      (substr($HeaderReadBuffer,0,$HeaderSize) . "\0\0\0"));
$NA = $HeaderSize;
$HeaderSize = $HeaderSize + 4;
#print(STDERR "sub ReadHeaderData 11\n");
until ( length($HeaderReadBuffer) >= $HeaderSize )
  { sysread($FileHandle_TapeDevice,$HeaderReadBuffer,$HeaderReadSize,
        length($HeaderReadBuffer))   or   last }
#print(STDERR "sub ReadHeaderData 12\n");
$ChecksumFromHeader = unpack('L', substr($HeaderReadBuffer,$NA,4));
if ( ! defined($ChecksumFromHeader) )  { &ReadHeaderError; return }
if ( $CalculatedChecksum != $ChecksumFromHeader )
    { &ReadHeaderError; return }
#print(STDERR "sub ReadHeaderData: header found\n");
}




sub ReadHeaderError  {
print(STDERR "
mdti.tapes.pl: tape file/volume $TapePosition (The first file/volume is 0,
the second is 1, etc.) has data at the beginning which is similar to but not
exactly like a file header. This file/volume might be a corrupted
file/volume, or it might be a file/volume from a different program.
");
undef($TapeSetNameFromHeader);
undef($TapeNumberFromHeader);
undef($FileNameFromHeader);
undef($FileDateFromHeader);
undef($FragmentNumberFromHeader);
$HeaderSize = 0;
}




sub ReadIndexFile  {
my $PreviousFile;
$IndexIsWrong = $No;
open(FH_Index, "< index") or &zNoOpenR("index",$MdtiDirectory);
$FileSelector = 0;
while (<FH_Index>)  {
  my @A;
  if ( $_ eq "\n" )  { next }
  @A = split(' ',$_,6);
  if ( $#A < 5 )  { &zIndexBadLine; next }
  unless ( $A[2] eq $Deleted     or     $A[2] eq $NotDeleted )
    { &zIndexBadLine; next }
  if ( $A[0] < 1     or     $A[3] < 1    or    $A[5] eq '' )
    { &zIndexBadLine; next }
  $TapeNumberOfFileFragment[$FileSelector] = $A[0];
  $TapePositionOfFileFragment[$FileSelector] = $A[1];
  $IsFileDeleted[$FileSelector] = $A[2];
  $FragmentNumber[$FileSelector] = $A[3];
  $FileDate[$FileSelector] = $A[4];
  $FileName[$FileSelector] = $A[5];
  chomp($FileName[$FileSelector]);
  $FileSelector = $FileSelector + 1;
  }
#print('file name is ',@FileName,"\n");
close(FH_Index);
# we could put some code here to sort the index to put it into the
# correct order if it is in the wrong order, but probably if the index
# is in the wrong order there will also be missing or extra entries,
# so it would be better to fix the index by rebuilding it.
if ( $WarnAboutIndexErrors == $No )  { return }
$PreviousFile = 0;
$FileSelector = 1;
until ( $FileSelector > $#FileName )  {
  if ( $TapePositionOfFileFragment[$FileSelector]
     <= $TapePositionOfFileFragment[$PreviousFile]
     and $TapeNumberOfFileFragment[$FileSelector]
     <= $TapeNumberOfFileFragment[$PreviousFile] )
        { &zIndexInWrongOrder($FileName[$FileSelector],
                 $FileName[$PreviousFile]) }
  if ( $FragmentNumber[$FileSelector] > 1 )  {
    if (
      ($FragmentNumber[$FileSelector] - 1) != $FragmentNumber[$PreviousFile]
      or     $FileName[$PreviousFile] ne $FileName[$FileSelector] )
         { &zIndexWrongFragment($FileName[$FileSelector],
            $FragmentNumber[$FileSelector],$FileName[$PreviousFile],
            $FragmentNumber[$PreviousFile]) }
    }
  $PreviousFile = $FileSelector;
  $FileSelector = $FileSelector + 1;
  }
if ( $IndexIsWrong    and    $AbortOnIndexErrors )  { unload(11) }
}




sub RebuildIndex  {
my $NA;
#print(STDERR "sub RebuildIndex\n");
if ( -e "index" )  { &zIndexAlreadyExists }
#print(STDERR "sub RebuildIndex 1\n");
print(STDERR "How many tapes are in this tape set? ");
#print(STDERR "sub RebuildIndex 2\n");
$LastTape = <STDIN>;
#print(STDERR "sub RebuildIndex 3\n");
chomp($LastTape);
$FileSelector = -1;
#print(STDERR "sub RebuildIndex 4\n");
while ( $CurrentTape < $LastTape )  {
  $TapeToLoad = $CurrentTape + 1;
  $LoadAttempts = 0;
  $NextTapeIsProbablyBlank = $No;
  &LoadTape;
  $FragmentToRead = 0;
  #print(STDERR "about to test for a file fragment for rebuild index\n");
  while ()  {
    &MoveTapeTo($FragmentToRead);
    if ( &IsThereAFileFragmentAtThisPosition == $No )  { last }
    &ReadHeaderData;
    close($FileHandle_TapeDevice);
    $HeaderReadBuffer = '';
    $FileSelector = $FileSelector + 1;
    if ( defined($TapeSetNameFromHeader) )  {
      if ( $TapeSetName ne $TapeSetNameFromHeader    or
          $TapeNumberFromHeader != $CurrentTape )  { &zTapeHeaderMisMatch }
      $FileName[$FileSelector] = $FileNameFromHeader;
      $FileDate[$FileSelector] = $FileDateFromHeader;
      $FragmentNumber[$FileSelector] = $FragmentNumberFromHeader;
      $IsFileDeleted[$FileSelector] = $NotDeleted;
      $TapePositionOfFileFragment[$FileSelector] = $TapePosition;
      $TapeNumberOfFileFragment[$FileSelector] = $CurrentTape;
      }
    else  {
      $FileName[$FileSelector] = "__UNKNOWN__$CurrentTape.$TapePosition";
      $FileDate[$FileSelector] = 0;
      $FragmentNumber[$FileSelector] = 1;
      $IsFileDeleted[$FileSelector] = $NotDeleted;
      $TapePositionOfFileFragment[$FileSelector] = $TapePosition;
      $TapeNumberOfFileFragment[$FileSelector] = $CurrentTape;
      }
    $FragmentToRead = $FragmentToRead + 1;
    }
  }
$IndexHasChanged = $Yes;
&Unload(0);
}




sub RemoveDeletedIndexEntries  {
# figure out how many index entries to remove
my $NA = $FirstFileFragmentToBeOverwritten;
my $NB = 0;  # number of index entries to remove
#print(STDERR "sub RemoveDeletedIndexEntries ...");
until ( $NA > $#FileName )  {
    if ( $TapeNumberOfFileFragment[$NA] != $CurrentTape )  { last }
    $NB = $NB + 1;
    $NA = $NA + 1;
    }
# remove index entries
if ( $NB > 0 )  {
  splice(@TapeNumberOfFileFragment,$FirstFileFragmentToBeOverwritten,$NB);
  splice(@TapePositionOfFileFragment,$FirstFileFragmentToBeOverwritten,$NB);
  splice(@IsFileDeleted,$FirstFileFragmentToBeOverwritten,$NB);
  splice(@FragmentNumber,$FirstFileFragmentToBeOverwritten,$NB);
  splice(@FileDate,$FirstFileFragmentToBeOverwritten,$NB);
  splice(@FileName,$FirstFileFragmentToBeOverwritten,$NB);
  $IndexHasChanged = $Yes;
  }
#print(STDERR "$NB entries removed from index\n");
}





sub RewindTapeAndAdjustVolumeTable  {
my $NA;
#print(STDERR "sub RewindTapeAndAdjustVolumeTable\n");
#print(STDERR "attempting $MTprogram rewind\n");
$NA = (system("$MTprogram -f $TapeDevice rewind 2> /dev/null") & 0xFFFF) >> 8;
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice rewind",$NA); return }
$TapePosition = 0;
if ( $VolumeTableProgram == $Vtblc )  {
  my ($sec,$min,$hour,$day,$mon,$year,$SA);
  for ( @FilesForAdjustVolTab )  {
    ($sec,$min,$hour,$day,$mon,$year) = localtime($FileDate[$_]);
#    until ( $year < 100 )  { $year = $year - 100 }
    $SA = sprintf('%02u:%02u:%02u %02u/%02u/%02u',
                  $hour,$min,$sec,$mon,$day,$year);
    &RunExternalCommand("vtblc --file=$VtblcDevice " .
       "--vtbl-entry=$TapePositionOfFileFragment[$_] " .
       "'--modify=label=$FileName[$_],date=$SA'");
    # vtblc does not set the date correctly. I guess this is a bug in vtblc. 
    # vtblc expects a 2 digit year, so I am not sure if the year 2000 should
    # be 00 or 100. Either way vtblc sets the year to 1974. I thought it
    # used to work before 2000; maybe vtblc has the Y2K bug.
    }
  }
@FilesForAdjustVolTab = ();
}





sub RunExternalCommand  {
my $NA; my $SA = 'external command';
if ( defined($_[1]) )  { $SA = $_[1] }
$NA = (system($_[0]) & 0xFFFF) >> 8;
if ( $NA != 0 )  {
  print(STDERR "
mdti.tapes.pl: the following $SA
$_[0]
returned an exit code of $NA\n");
  &Unload(10);
  }
}




sub SetFileSelectorToFirstFragmentOf  {
my $NA = $#FileName + 1;
my $NB = -1;
#print(STDERR "sub SetFileSelectorToFirstFragmentOf\n");
while ( $NA > 0 )  {
  $NA = $NA - 1;
  if ( $FileName[$NA] ne $_[0] )  { next }
  if ( $FragmentNumber[$NA] > 1 )  { next }
  if ( $IsFileDeleted[$NA] eq $Deleted )  { next }
  if ( $NB < 0 )  { $NB = $NA }
  elsif ( $FileDate[$NA] > $FileDate[$NB] )  { $NB = $NA }
  }
#print(STDERR "\$NB is $NB\n");
if ( $NB < 0 )  { undef($FileSelector); return($Failure) }
else  { $FileSelector = $NB; return($Success) }
}




sub SetFileSelectorToNextFragmentOf  {
my $NA = $#FileName + 1;
my $NB = $FragmentNumber[$_[0]] + 1;
while ( $NA > 0 )  {
  $NA = $NA - 1;
  if ( $FileName[$NA] ne $FileName[$_[0]] )  { next }
  if ( $FragmentNumber[$NA] != $NB )  { next }
  if ( $IsFileDeleted[$NA] eq $Deleted )  { next }
  if ( $FileDate[$NA] != $FileDate[$_[0]] )  { next }
  $FileSelector = $NA;
  return($Success);
  }
return($Failure);
}




sub SetLastIndexEntryThisTape  {
my $NA = $#FileName;
$LastIndexEntryThisTape = -1;
until ( $NA < 0 )  {
  if ( $TapeNumberOfFileFragment[$NA] == $CurrentTape )  {
    $LastIndexEntryThisTape = $NA;
    last;
    }
  $NA = $NA - 1;
  }
}





sub SignalTrap  {
if ( $_[0] eq 'PIPE' )  { $SignalPipeReceived = $Yes }
elsif ( $_[0] eq 'INT'    or     $_[0] eq 'TERM' )  { &Unload(1) }
else { &zWrongSignal($_[0]) }
}




sub TapeRead  {
open($FileHandle_DataPipe, "> data") or &zNoReadData;
if ( $Buffer ne '' )  { &zBufferNotEmpty }
if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    close($FileHandle_DataPipe);
    return;
    }
chomp($Commands[1]);
if ( &SetFileSelectorToFirstFragmentOf($Commands[1]) )
      { &TapeReadSelectedFile }
else  { $Results = "failure\nfile does not exist\n$Commands[1]\n" }
close($FileHandle_DataPipe);
}




sub TapeReadSelectedFile  {
# $FileSelector should already point to the first fragment of the file
# to be read
my $NA;
#print(STDERR "sub TapeReadSelectedFile\n");
if ( ! defined($FileSelector) )  { &zFileSelectorNotDefined }
if ( ! defined($FileName[$FileSelector]) )  { &zFileSelectorNoFileName }
#print(STDERR "\$FileSelector is $FileSelector\n");
while ()  {
  $NA = &TapeReadSelectedFragmentOfFile;
  if ( $NA == $Failure )  { last }
  &SetFileSelectorToNextFragmentOf($FileSelector) or last;
  }
if ( $NA == $Success )  {
  # remove the footer
  my $LengthOfBuffer; my $Pointer;
  $LengthOfBuffer = length($Buffer);
  if ( $LengthOfBuffer > 0 )  {
    $Pointer = rindex($Buffer,$FooterMarker);
    if ( $Pointer > -1    and    $LengthOfBuffer > $LengthOfFooterMarker )  {
      if ( ("\0" x (($LengthOfBuffer - $Pointer) - $LengthOfFooterMarker))
           ne substr($Buffer,($Pointer + $LengthOfFooterMarker)) )
        { $Pointer = -1 }
      }
    if ( $Pointer == -1 )  { print($FileHandle_DataPipe $Buffer) }
    elsif ( $Pointer > 0 )
        { print($FileHandle_DataPipe substr($Buffer,0,$Pointer)) }
    }
  $Results = "success\nfile read\n$Commands[1]\n";
  }
$Buffer = '';
}






sub TapeReadSelectedFragmentOfFile  {
# $FileSelector should already point to the fragment to be read
my $NA; my $NB;
#print(STDERR "sub TapeReadSelectedFragmentOfFile\n");
#print(STDERR "\$FileSelector is $FileSelector\n");
$TapeToLoad = $TapeNumberOfFileFragment[$FileSelector];
#print(STDERR "\$TapeToLoad is $TapeToLoad\n");
$LoadAttempts = 0;
$NextTapeIsProbablyBlank = $No;
if ( ! &LoadTape )  {
    $Results = "failure\nunable to load tape\n$Commands[1]\n";
    return($Failure);
    }
&MoveTapeTo($TapePositionOfFileFragment[$FileSelector]);
#print(STDERR "about to test for fragment before reading\n");
if ( &IsThereAFileFragmentAtThisPosition == $No )
      { return(&zNoFileAtTapePosition) }
&ReadHeaderData;
if ( $HeaderSize > 0 )  {
  if ( $TapeSetNameFromHeader ne $TapeSetName )
      { return(&zHeaderSaysWrongTape) }
  if ( $TapeNumberFromHeader != $CurrentTape )
      { return(&zHeaderSaysWrongTape) }
  if ( $FileNameFromHeader ne $FileName[$FileSelector] )
      { return(&zWrongFileAtTapePosition) }
  if ( $FragmentNumberFromHeader != $FragmentNumber[$FileSelector] )
      { return(&zWrongFileAtTapePosition) }
  }
$Buffer = $Buffer . substr($HeaderReadBuffer,$HeaderSize);
$HeaderReadBuffer = '';
$NA = length($Buffer) - $MaximumFooterSize;
if ( $NA > 0 )  {
  print($FileHandle_DataPipe substr($Buffer,0,$NA));
  $Buffer = substr($Buffer,$NA);
  }
until ( $SignalPipeReceived )  {
  sysread($FileHandle_TapeDevice,$Buffer,$TapeDataTransferMaximumSize,
          length($Buffer))  or  last;
  $NA = length($Buffer) - $MaximumFooterSize;
  if ( $NA > 0 )  {
    print($FileHandle_DataPipe substr($Buffer,0,$NA));
    $Buffer = substr($Buffer,$NA);
    }
  }
if ( $SignalPipeReceived ) {
  $Results = "failure\nread aborted by SIGPIPE\n$Commands[1]\n";
  $SignalPipeReceived = $No;
  close($FileHandle_TapeDevice);
  return($Failure);
  }
$TapePosition = $TapePosition + 1;
close($FileHandle_TapeDevice);
}






sub TapeWrite  {
my $NA; my $NB;
#print(STDERR "preparing to open data pipe and write to tape\n");
open($FileHandle_DataPipe, "< data") or &zNoWriteData;
#print(STDERR "data pipe open\n");
if ( $Buffer ne '' )  { &zBufferNotEmpty }
if ( ! defined($Commands[1]) )  {
    $Results = "failure\nfile name not given\n";
    close($FileHandle_DataPipe);
    return;
    }
chomp($Commands[1]);
undef($FooterSize);
$FragmentNumberOfFragmentBeingWritten = 1;
# figure out how many files to overwrite
$FirstFileFragmentToBeOverwritten = $#FileName + 1;
$NA = $#FileName;
#print(STDERR "figuring out how many fragments to overwrite\n");
while ( $NA > -1 )  {
  if ( $IsFileDeleted[$NA] eq $NotDeleted )  { last }
  $FirstFileFragmentToBeOverwritten = $NA;
  $NA = $NA - 1;
  }
if ( $FirstFileFragmentToBeOverwritten == 0 )  { $TapeToLoad = 1 }
elsif ( $FirstFileFragmentToBeOverwritten == ($#FileName + 1) )
    { $TapeToLoad = $TapeNumberOfFileFragment[$#FileName] }
else   { $TapeToLoad =
      $TapeNumberOfFileFragment[$FirstFileFragmentToBeOverwritten] }
if ( $#FileName < 0 )  { $NextTapeIsProbablyBlank = $Yes }
else  { $NextTapeIsProbablyBlank = $No }
$FileDate = time;
if ( ! &TapeWrite_OpenTape )  { close($FileHandle_DataPipe); return }
until ( eof($FileHandle_DataPipe) )  {
  if ( length($Buffer) < $TapeDataTransferMaximumSize )
      { read($FileHandle_DataPipe,$Buffer,
             ($TapeDataTransferMaximumSize - length($Buffer)),
             length($Buffer)) }
  if ( length($Buffer) >= $TapeDataTransferMaximumSize )  {
    $NA = syswrite(
              $FileHandle_TapeDevice,$Buffer,$TapeDataTransferMaximumSize);
    if ( ! defined($NA) ) { $NA = 0 }
    $Buffer = substr($Buffer,$NA);
    if ( $DataWritten <= $HeaderSize )  {
      $DataWritten = $DataWritten + $NA;
      # $DataWritten is used to detect whether or not more than the header
      # has been written, so once $DataWritten is larger than $HeaderSize,
      # there is no reason to keep increasing $DataWritten, and if we did
      # keep increasing it, it might get too big and overflow, so it is
      # better to not increase it.
      }
    if ( $NA != $TapeDataTransferMaximumSize ) { &TapeWrite_NewTape or last }
    }
  }
if ( eof($FileHandle_DataPipe) )  {
  $Buffer = $Buffer . $FooterMarker;
  if ( (length($Buffer) % $TapeDataTransferMinimumSize) != 0 )  {
    $NA = length($Buffer) / $TapeDataTransferMinimumSize;
    $NA = $NA + 1;
    $NA = $NA * $TapeDataTransferMinimumSize;
    $FooterSize = $NA - length($Buffer);
    $Buffer = $Buffer . ("\0" x $FooterSize);
    }
  $Results = "success\nfile created\n$Commands[1]\n";
  until ( length($Buffer) == 0 )  {
    $NB = length($Buffer);
    #print(STDERR "about to try to write $NB bytes\n");
    $NA = syswrite($FileHandle_TapeDevice,$Buffer,$NB);
    if ( ! defined($NA) ) { $NA = 0 }
    #print(STDERR "actually wrote $NA bytes\n");
    $Buffer = substr($Buffer,$NA);
    if ( $DataWritten <= $HeaderSize )
        { $DataWritten = $DataWritten + $NA }
    if ( $NA != $NB )  { &TapeWrite_NewTape or last }
    }
  }
&TapeWrite_CloseTape;
$Buffer = '';
close($FileHandle_DataPipe);
}




sub TapeWrite_CloseTape  {
close($FileHandle_TapeDevice);
# If we were trying to overwrite some file fragments, but the write failed;
# were they overwritten or not? If we failed to open the tape, they were not
# overwritten. If we wrote 1 or more bytes to the tape, they were
# overwritten. But what if we successfully opened the tape, but failed to
# write any data to the tape? Probably they were not overwritten.
# If no data was written to the tape, do not remove index entries and do not
# make new index entries.
if ( $DataWritten < 1 )  { &zNoDataWritten; return }
&RemoveDeletedIndexEntries;
# if we did not write a meaningful amount of data and this is the first
# file fragment on the tape, then do not make index entries because
# this tape is useless and we will be throwing it away.
if ( $DataWritten <= $HeaderSize    and    $TapePosition == 0 )
    { $TapePosition = $TapePosition + 1; return }
# make new index entries
splice(@TapeNumberOfFileFragment,$FirstFileFragmentToBeOverwritten,0,
       $CurrentTape);
splice(@TapePositionOfFileFragment,$FirstFileFragmentToBeOverwritten,0,
       $TapePosition);
splice(@FileDate,$FirstFileFragmentToBeOverwritten,0,$FileDate);
if ( $DataWritten > $HeaderSize )  {
  splice(@FileName,$FirstFileFragmentToBeOverwritten,0,$Commands[1]);
  splice(@FragmentNumber,$FirstFileFragmentToBeOverwritten,0,
         $FragmentNumberOfFragmentBeingWritten);
  $FragmentNumberOfFragmentBeingWritten =
      $FragmentNumberOfFragmentBeingWritten + 1;
  splice(@IsFileDeleted,$FirstFileFragmentToBeOverwritten,0,$NotDeleted);
  }
else  {
  splice(@FileName,$FirstFileFragmentToBeOverwritten,0,
         "__UNKNOWN__$CurrentTape.$TapePosition");
  splice(@FragmentNumber,$FirstFileFragmentToBeOverwritten,0,1);
  splice(@IsFileDeleted,$FirstFileFragmentToBeOverwritten,0,$Deleted);
  }
push(@FilesForAdjustVolTab,$FirstFileFragmentToBeOverwritten);
$FirstFileFragmentToBeOverwritten = $FirstFileFragmentToBeOverwritten + 1;
$IndexHasChanged = $Yes;
$TapePosition = $TapePosition + 1;
}




sub TapeWrite_OpenTape  {
my $SA; my $NA; my $NB;
$LoadAttempts = 0;
#print(STDERR "about to attempt to load tape\n");
if ( ! &LoadTape )  {
    $Results = "failure\nunable to load tape\n$Commands[1]\n";
    return($Failure);
    }
#print(STDERR "after attempting to load tape\n");
# maybe we could add some code here to use the volume table program to
# verify the files to overwrite and to verify the end of data
# verify the files to overwrite
if ( $FirstFileFragmentToBeOverwritten <= $#FileName    and
    $VerifyDeletes == $Yes )  {
  $NA = $FirstFileFragmentToBeOverwritten;
  until ( $NA > $#FileName )  {
    &VerifyIndexEntry($NA);
    $NA = $NA + 1;
    }
  }
# verify end of data
if ( $VerifyEndOfData == $Yes )  { &VerifyEndOfData }
# overwrite files
$SomethingToDelete = $No;
if ( $FirstFileFragmentToBeOverwritten <= $#FileName )  {
  if ( $TapeNumberOfFileFragment[$FirstFileFragmentToBeOverwritten] ==
       $CurrentTape )  { $SomethingToDelete = $Yes }
  }
if ( $SomethingToDelete )  {
  if ( $OverwritesAreAllowed )  { &MoveTapeTo(
       $TapePositionOfFileFragment[$FirstFileFragmentToBeOverwritten]) }
  elsif ( $VolumeTableProgram == $Vtblc )  {
    #print(STDERR "attempting $MTprogram rewind\n");
    $NA = (system("$MTprogram -f $TapeDevice rewind 2> /dev/null")
        & 0xFFFF) >> 8;
    if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice rewind",$NA) }
    $TapePosition = 0;
    &RunExternalCommand("vtblc --file=$VtblcDevice --truncate=" .
       "$TapePositionOfFileFragment[$FirstFileFragmentToBeOverwritten]");
    &RemoveDeletedIndexEntries;
    &SetLastIndexEntryThisTape;
    if ( $LastIndexEntryThisTape == -1 )  { &MoveTapeTo(0) }
    else  { &MoveTapeTo(
             $TapePositionOfFileFragment[$LastIndexEntryThisTape] + 1) }
    }
  else  { $SomethingToDelete = $No }
  }
if ( $SomethingToDelete = $No )  {
  &SetLastIndexEntryThisTape;
  if ( $LastIndexEntryThisTape == -1 )  { &MoveTapeTo(0) }
  else  { &MoveTapeTo(
             $TapePositionOfFileFragment[$LastIndexEntryThisTape] + 1) }
  }
# open($FileHandle_TapeDevice,">$TapeDevice") or &zNoOpenW($TapeDevice);
sysopen($FileHandle_TapeDevice,$TapeDevice,1) or &zNoOpenW($TapeDevice);
$DataWritten = 0;
$SA = $HeaderMarker . &VunsignedInteger($CurrentTape) .
    &VunsignedInteger($FragmentNumberOfFragmentBeingWritten) .
    &VunsignedInteger($FileDate) .
    &Vstring($TapeSetName) . &Vstring($Commands[1]) . &Vstring('');
$SA = $SA . pack('L',unpack("%32L*","$SA\0\0\0"));
$HeaderSize = length($SA);
$Buffer = $SA . $Buffer;
}





sub TapeWrite_NewTape  {
my $NA;
&TapeWrite_CloseTape;
# if any of the last header is still in $Buffer, remove it
if ( $HeaderSize > $DataWritten )
    { $Buffer = substr($Buffer,($HeaderSize - $DataWritten)) }
# if $HeaderSize >= $DataWritten, then no real data has been written
# to the tape; if $TapePosition == 0 then this is the beginning of the tape;
# we just started writing to a new blank tape. So if we started writing to a
# blank tape and the tape was full before we wrote a meaningful amount of
# data, then this tape is worthless and should be replaced.
# Otherwise get the next tape.
if ( $HeaderSize >= $DataWritten    and    $TapePosition == 0 )  { &zBadTape }
else  { $TapeToLoad = $TapeToLoad + 1 }
#if ( defined($TapeToLoad) ) { print(STDERR "tape to load defined\n") }
#if ( defined($TapeNumberOfFileFragment[$#FileName]) )
    #{ print(STDERR "tape number defined\n") }
if ( $TapeToLoad > $TapeNumberOfFileFragment[$#FileName] )
    { $NextTapeIsProbablyBlank = $Yes }
else  { $NextTapeIsProbablyBlank = $No }
&TapeWrite_OpenTape or return($Failure);
if ( defined($FooterSize) )  {
  $Buffer = substr($Buffer,0,(0 - $FooterSize));
  $NA = length($Buffer) / $TapeDataTransferMinimumSize;
  $NA = $NA + 1;
  $NA = $NA * $TapeDataTransferMinimumSize;
  $FooterSize = $NA - length($Buffer);
  $Buffer = $Buffer . ("\0" x $FooterSize);
  }
}





sub Unload  {
if ( $AlreadyExiting )  { return }
$AlreadyExiting = $Yes;
$TapeToLoad = 0; $LoadAttempts = 0; $NextTapeIsProbablyBlank = $No;
&LoadTape;
if ( $IndexHasChanged )  {
  $NA = open(FH_Index, "> index");
  if ( ! defined($NA) )  { $NA = 0 }
  if ( $NA > 0 )  {
    $FileSelector = 0;
    #print(STDERR "file selector is $FileSelector\n");
    #print(STDERR "last field of \@FileName is $#FileName\n");
    until ( $FileSelector > $#FileName )  {
      #print(STDERR "file selector is $FileSelector\n");
      #print(STDERR "last field of \@FileName is $#FileName\n");
      print(FH_Index  $TapeNumberOfFileFragment[$FileSelector], ' ',
        $TapePositionOfFileFragment[$FileSelector], ' ',
        $IsFileDeleted[$FileSelector], ' ',
        $FragmentNumber[$FileSelector], ' ',
        $FileDate[$FileSelector], ' ',
        $FileName[$FileSelector], "\n");
      $FileSelector = $FileSelector + 1;
      }
    close(FH_Index);
    }
  else  { print(STDERR "
mdti.tapes.pl:  unable to open and write to the file named \'index\'
") }
  }
if ( defined($StopCommands) )
  { &RunExternalCommand($StopCommands,'stop commands') }
unlink('commands','data');
exit($_[0]);
}




sub UnpackVunsignedInteger  {
# $_[0] is the input string, $_[1] is the start position, $_[2] is the
# number of VunsignedIntegers to unpack
# call this sub like this:
#   ($UnsignedInteger1,$SizeOfVunsignedInteger1,$UnsignedInteger2,
#         $SizeOfVunsignedInteger2,...,$LastUnsignedInteger,
#         $SizeOfLastVunsignedInteger) = $&UnpackVunsignedInteger
#         ($InputString,$StartPosition,$NumberOfVunsignedIntegersToUnpack);
# Remember that this sub converts the VunsignedIntegers to regular unsigned
# integers as it unpacks them; and the size is not the size of the unsigned
# integer, it is the size of the VunsignedInteger, it is the number of bytes
# of $InputString used by the VunsignedInteger. The size is returned in case
# you want to know how much of $InputString was read or if you want to know
# where in $InputString is the end of the last VunsignedInteger; if you do
# not care, then throw away the size.
my $Start; my $End; my $UnsignedInteger; my @Output = ();
my $NA = 1; my $NB; my $NC; my $SA;
use integer;
if ( $#_ < 2 ) { return(@Output) }
$Start = $_[1];
$End = length($_[0]);
until ( $NA > $_[2] )  {
  if ( ($Start + 1) > $End )  { last }
  $NB = unpack('C',substr($_[0],$Start,1));
  $Start = $Start + 1;
  if ( ($Start + $NB) > $End )  { last }
  $SA = substr($_[0],$Start,$NB);
  $Start = $Start + $NB;
  $UnsignedInteger = 0;
  $NC = length($SA) - 1;
  until ( $NC < 0 )  {
    { no integer;
    $UnsignedInteger = $UnsignedInteger << 8;
    $UnsignedInteger = $UnsignedInteger | unpack('C',substr($SA,$NC,1)); }
    $NC = $NC - 1;
    }
  push(@Output,$UnsignedInteger,($NB + 1));
  $NA = $NA + 1;
  }
return(@Output);
}




sub UnpackVstring  {
# $_[0] is the input string, $_[1] is the start position, $_[2] is the
# number of Vstrings to unpack
# call this sub like this:
#   ($String1,$SizeOfVstring1,$String2,$SizeOfVstring2,...,$LastString,
#           $SizeOfLastVstring) = $&UnpackVstring
#           ($InputString,$StartPosition,$NumberOfVstringsToUnpack);
# Remember that this sub converts the Vstrings to regular strings as it
# unpacks them; and the size is not the size of the string, it is the size
# of the Vstring, it is the number of bytes of $InputString used by the
# Vstring. The size is returned in case you want to know how much of
# $InputString was read or if you want to know where in $InputString is the
# end of the last Vstring; if you do not care, then throw away the size.
my $Start; my $End; my $Size; my @Output = ();
my $NA = 1; my $NB; my $NC; my $SA;
use integer;
if ( $#_ < 2 ) { return(@Output) }
$Start = $_[1];
$End = length($_[0]);
until ( $NA > $_[2] )  {
  if ( ($Start + 1) > $End )  { last }
  $NB = unpack('C',substr($_[0],$Start,1));
  $Start = $Start + 1;
  if ( ($Start + $NB) > $End )  { last }
  $SA = substr($_[0],$Start,$NB);
  $Start = $Start + $NB;
  $Size = 0;
  $NC = length($SA) - 1;
  until ( $NC < 0 )  {
    { no integer;
    $Size = $Size << 8;
    $Size = $Size | unpack('C',substr($SA,$NC,1)); }
    $NC = $NC - 1;
    }
  if ( ($Start + $Size) > $End )  { last }
  push(@Output,substr($_[0],$Start,$Size),($Size + $NB + 1));
  $Start = $Start + $Size;
  $NA = $NA + 1;
  }
return(@Output);
}




sub VerifyEndOfData  {
my $NA;
#print(STDERR "sub VerifyEndOfData\n");
&SetLastIndexEntryThisTape;
if ( $LastIndexEntryThisTape == -1 )  { &MoveTapeTo(0) }
else { &MoveTapeTo($TapePositionOfFileFragment[$LastIndexEntryThisTape] + 1) }
#print(STDERR "attempting $MTprogram fsf 1 to see if at end of data\n");
$NA = ( system("$MTprogram -f $TapeDevice fsf 1 2> /dev/null")
    & 0xFFFF) >> 8;
if ( $NA == 2 )  { return }
if ( $NA != 0 )  { &zMtError("$MTprogram -f $TapeDevice fsf 1",$NA) }
$TapePosition = $TapePosition + 1;
if ( $LastIndexEntryThisTape == -1 )  { &MoveTapeTo(0) }
else  {
  &MoveTapeTo($TapePositionOfFileFragment[$LastIndexEntryThisTape]);
  &ReadHeaderData;
  close($FileHandle_TapeDevice);
  $HeaderReadBuffer = '';
  if ( defined($TapeSetNameFromHeader) )  {
    if ( $TapeSetNameFromHeader ne $TapeSetName[$LastIndexEntryThisTape]   or
    $TapeNumberFromHeader != $TapeNumberOfFileFragment[$LastIndexEntryThisTape]
    or    $FileNameFromHeader ne $FileName[$LastIndexEntryThisTape]    or
    $FileDateFromHeader != $FileDate[$LastIndexEntryThisTape]   or
    $FragmentNumberFromHeader != $FragmentNumber[$LastIndexEntryThisTape] )
        { &zVerifyIndexError($LastIndexEntryThisTape) }
    }
  &MoveTapeTo($TapePosition + 1);
  }
# make index entries for unknown files
#print(STDERR "about to test for file fragment to verify end of data\n");
while ( &IsThereAFileFragmentAtThisPosition == $Yes )  {
  &ReadHeaderData;
  close($FileHandle_TapeDevice);
  $HeaderReadBuffer = '';
  $LastIndexEntryThisTape = $LastIndexEntryThisTape + 1;
  if ( defined($TapeSetNameFromHeader) )  {
    if ( $TapeSetName != $TapeSetNameFromHeader    or
         $TapeNumberFromHeader != $CurrentTape )  { &zTapeHeaderMisMatch }
    splice(@FileName,$LastIndexEntryThisTape,0,$FileNameFromHeader);
    splice(@FragmentNumber,$LastIndexEntryThisTape,0,
           $FragmentNumberFromHeader);
    splice(@FileDate,$LastIndexEntryThisTape,0,$FileDateFromHeader);
    }
  else  {
    splice(@FileName,$LastIndexEntryThisTape,0,
           "__UNKNOWN__$CurrentTape.$TapePosition");
    splice(@FragmentNumber,$LastIndexEntryThisTape,0,1);
    splice(@FileDate,$LastIndexEntryThisTape,0,0);
    }
  splice(@TapeNumberOfFileFragment,$LastIndexEntryThisTape,0,
         $CurrentTape);
  splice(@TapePositionOfFileFragment,$LastIndexEntryThisTape,0,
         $TapePosition);
  splice(@IsFileDeleted,$LastIndexEntryThisTape,0,$NotDeleted);
  &MoveTapeTo($TapePosition + 1);
  }
# check again how many files to overwrite
$FirstFileFragmentToBeOverwritten = $#FileName + 1;
$NA = $#FileName;
while ( $NA > -1 )  {
  if ( $IsFileDeleted[$NA] eq $NotDeleted )  { last }
  $FirstFileFragmentToBeOverwritten = $NA;
  $NA = $NA - 1;
  }
}




sub VerifyIndexEntry  {
#print(STDERR "sub VerifyIndexEntry called for index entry $_[0]\n");
if ( $TapeNumberOfFileFragment[$_[0]] != $CurrentTape )
    { &zVerifyIndexWrongTape($_[0]) }
&MoveTapeTo($TapePositionOfFileFragment[$_[0]]);
&ReadHeaderData;
close($FileHandle_TapeDevice);
$HeaderReadBuffer = '';
if ( defined($TapeSetNameFromHeader) )  {
  if ( $TapeSetNameFromHeader ne $TapeSetName   or
  $TapeNumberFromHeader != $TapeNumberOfFileFragment[$_[0]]   or
  $FileNameFromHeader ne $FileName[$_[0]]    or
  $FileDateFromHeader != $FileDate[$_[0]]   or
  $FragmentNumberFromHeader != $FragmentNumber[$_[0]] )
      { &zVerifyIndexError($_[0]) }
  }
&MoveTapeTo($TapePositionOfFileFragment[$_[0]] + 1);
}




sub Vstring  {
# This is a variation of the pack() function, but it does not need a
# template to unpack() because the template is packed with it.
# A Vstring is a variable sized string. A Vstring includes a header which
# gives the length of the Vstring. If several Vstrings are combined into one
# long string, then the can be seperated again by using the size of the
# first one to find the end of the first one, which is the beginning of the
# second one; read the size of the second one and find the end of the second
# one, etc. Vstrings use few bytes but are tricky to manipulate; they are
# useful for when you want to pack multiple strings into a single file, and
# want to be able to read it back later and seperate the strings again, and
# you have absolutely no idea how big the strings are. A Vstring can be any
# size from 0 bytes to (256 to the 255th power minus 1) bytes. A 0 byte string
# becomes a 1 byte Vstring; a 1 byte string becomes a 3 byte Vstring; a 255
# byte string becomes a 257 byte Vstring; a 256 byte string becomes a 259
# byte Vstring; etc.
# A Vstring has a two part header. The first part is one byte, and it gives
# the number of bytes in the second part. The second part gives the number
# of bytes in the string. If you know what size strings you are storing,
# then it is probably simpler to use a one part header, which gives the size
# of the string, or to use the normal pack() function. But if you do not
# know what size string will be stored, then you do not know how many bytes
# are needed to store the size, and you should be using Vstrings. Or if you
# are writing a program to store small strings, but you think that maybe in
# a few years when memory, hard drives, and files are bigger then someone
# may try to use your program to store long strings; then you should use
# Vstrings.
my $NA; my $NB = 0; my $SA = '';
use integer;
if ( ! defined($_[0]) )  { return(undef) }
$NA = length($_[0]);
if ( $NA < 0 )  { return(undef) }  # $NA should not be negative, but if it
              # is, then it is an error. perl 5.004_04 has a bug such that
              # integers larger than 2G are mistaken for negative numbers.
while ( $NA > 0 )  {
  $SA = $SA . pack('C',($NA & 0xFF));
  $NA = $NA >> 8;
  $NB = $NB + 1;
  }
return(pack('C',$NB) . $SA . $_[0])
}




sub VunsignedInteger  {
# converts an unsigned integer into a string, can theoretically handle
# numbers from 0 to (256 to the 255th power minus 1). Like pack(), except
# you do not need a template, and you do not need to say long, short, char,
# etc, and allows a very large range of unsigned integers. It is more
# flexible than pack(); it can pack very large numbers, yet it does not
# waste space when packing small numbers.
# like Vstring, but for a unsigned integer
# why not signed integers? because if you packed a 32 bit signed integer and
# unpacked it as a 64 bit signed integer, it would be wrong. But there is no
# problem packing a 32 bit unsigned integer and unpacking it as a 64
# bit unsigned integer. Remember, this sub is for when you do not know how
# many bits the integer is. If you are packing signed integers, you have to
# know how many bits it is, and if you know how many bits it is, you should
# use the normal pack() function.
my $NA; my $NB = 0; my $SA = '';
use integer;
if ( ! defined($_[0]) )  { return(undef) }
if ( $_[0] < 0 )  { return(undef) }
$NA = $_[0];
while ( $NA > 0 )  {
  $SA = $SA . pack('C',($NA & 0xFF));
  $NA = $NA >> 8;
  $NB = $NB + 1;
  }
return(pack('C',$NB) . $SA)
}




sub zBadTape  {
if ( $DataWritten == 0 )  { print(STDERR "
mdti.tapes.pl: Something is wrong with this tape. mdti.tapes.pl could not
write any data to this tape. Maybe the tape needs to be reformatted, maybe
mdti.tapes.pl positioned the tape wrong, maybe something is wrong with the
tape driver, maybe the block size is wrong, maybe somebody removed the tape,
maybe the tape is write protected, or maybe the tape is junk. Fix this tape,
or get another tape to use as tape $CurrentTape.
"); } else  { print(STDERR "
mdti.tapes.pl: Something is wrong with this tape. mdti.tapes.pl could
only write $DataWritten bytes of data to this tape, which is less than the
header size of $HeaderSize bytes. Maybe the tape needs to be reformatted,
maybe somebody removed the tape, or maybe the tape is junk. Fix this tape,
or get another tape to use as tape $CurrentTape.
"); } }

sub zBufferNotEmpty  { print(STDERR "
mdti.tapes.pl: bug detected: sub TapeWrite or sub TapeRead called when the
buffer was not empty. Probably the routine which previously used the buffer
did not empty the buffer when it was done.
"); &Unload(40) }

sub zCommandsExists  { print(STDERR "
mdti.tapes.pl: unable to start because something named 'commands' already
exists in directory '$MdtiDirectory'.
This probably means that this tape or tape set is already
in use by another program. Use the command ps to see what programs are
running. If you are sure that no other programs are using this tape or
tape set, delete commands and try again.
"); exit(2) }


sub zConfigBeginEq  { print(STDERR "
mdti.tapes.pl: line from config file begins with \'=\'. Current line is
$_
"); $ConfigurationError = $Yes }

sub zConfigEndSpace  { print(STDERR "
mdti.tapes.pl: line from config file ends with space.
mdti.tapes.pl is assuming this is correct. Current line is
$_
") }

sub zConfigError  { print(STDERR "
mdti.tapes.pl: exiting because of configuration errors
"); &Unload(3) }

sub zConfigNoEq  { print(STDERR "
mdti.tapes.pl: line from config file does not contain \'=\'. Current line is
$_
"); $ConfigurationError = $Yes }

sub zConfigUnknownOption  { print(STDERR "
mdti.tapes.pl: line from config file is unknown option '$_[0]'
Current line is $_
"); $ConfigurationError = $Yes }

sub zConfigWrong  { print(STDERR "
mdti.tapes.pl: $_[0] can not be set to '$_[1]'
"); $ConfigurationError = $Yes }

sub zConfigYorN  { print(STDERR "
mdti.tapes.pl: $_[0] should be set to 'yes' or 'no'; not '$_[1]'
"); $ConfigurationError = $Yes }

sub zFileSelectorNotDefined  { print(STDERR "
mdti.tapes.pl: bug detected: sub TapeReadSelectedFile called when
\$FileSelector is not defined.
[["); &Unload(40) }

sub zFileSelectorNoFileName  { print(STDERR "
mdti.tapes.pl: bug detected: sub TapeReadSelectedFile called when
\$FileName[\$FileSelector] is not defined. \$FileSelector is $FileSelector.
"); &Unload(40) }


sub zHeaderReadBufferNotEmpty  { print(STDERR "
mdti.tapes.pl: bug detected: sub ReadHeaderData called when the header read
buffer was not empty. Probably the routine which previously called sub
ReadHeaderData did not empty the buffer when it was done.
"); &Unload(40) }

sub zHeaderSaysWrongTape  { print(STDERR "
mdti.tapes.pl: This is supposed to be tape set $TapeSetName, tape
$CurrentTape, tape position $TapePosition, file $FileName[$FileSelector]
fragment $FragmentNumber[$FileSelector]; but the header of the file
says it is tape set $TapeSetNameFromHeader, tape $TapeNumberFromHeader,
file $FileNameFromHeader, fragment $FragmentNumberFromHeader.
Maybe you should rebuild the index.
"); $Results = "failure\nindex corrupted\n$Commands[1]\n";
return($Failure) }

sub zIndexAlreadyExists  { print(STDERR "
mdti.tapes.pl: unable to rebuild index because the index already exists. If
you really want to rebuild the index, delete the old index first, and then
try again
"); &Unload(10) }

sub zIndexBadLine  { print(STDERR "
mdti.tapes.pl: line from index file is incorrect,
ignoring this line. Current line is
$_
") }

sub zIndexInWrongOrder  { print(STDERR "
mdti.tapes.pl: The index is in the wrong order. '$_[0]'
should not come after '$_[1]'.
Maybe you should rebuild the index.
"); $IndexIsWrong = $Yes }

sub zIndexWrongFragment  { print(STDERR "
mdti.tapes.pl: There are errors in the index. '$_[0]',
fragment $_[1], is not the next fragment after '$_[2]',
fragment $_[3].
Maybe you should rebuild the index.
"); $IndexIsWrong = $Yes }

sub zLoadTapeNotDefined  { print(STDERR "
mdti.tapes.pl: bug detected: sub LoadTape called when \$TapeToLoad was not
defined.
"); &Unload(40) }

sub zMtError  { print(STDERR "
mdti.tapes.pl: the following mt command:
$_[0]
returned an exit code of $_[1]
"); &Unload(10) }

sub zNoCD { print(STDERR "
mdti.tapes.pl: unable to change to directory $_[0]
"); &deleteTmpFilesAndExit(3) }

sub zNoDataWritten  { print(STDERR "
mdti.tapes.pl: unable to write any data to tape $CurrentTape. mdti.tapes.pl
is assuming this means that the tape is full, and will try to continue with
a new tape. However, this may mean that something is wrong with either the
tape driver or with mdti.tapes.pl. There may be no tape in the drive. The
tape may be write protected. The tape driver may be configured wrong. The
tape driver's block size may be different from mdti.tapes.pl's tape data
transfer minimum size. You may need to set overwrites are allowed=no. Maybe
you need to change mt back=bsf to mt back=bsfm, or vice versa. Or there may
be a bug in mdti.tapes.pl, maybe it is moving the tape wrong. If you think
something is wrong, you might want to press control-c to abort.
") }

sub zNoDevice  { print(STDERR "
mdti.tapes.pl: there is no device named $_[0]
"); $ConfigurationError = $Yes }

sub zNoFileAtTapePosition  { print(STDERR "
mdti.tapes.pl: index is wrong: the index says that file
'$FileName[$FileSelector]' fragment $FragmentNumber[$FileSelector]
is supposed to be at tape position $TapePositionOfFileFragment[$FileSelector],
but there is nothing at tape position $TapePosition. Maybe you should rebuild
the index.
"); $Results = "failure\nindex corrupted\n$Commands[1]\n";
return($Failure) }

sub zNoLoadTape  { print(STDERR "
mdti.tapes.pl: unable to load this tape; it may not be formatted correctly,
or the load parameters may be wrong, or maybe there is no tape
in the drive, or maybe the device is already loaded.
") }

sub zNoMkdir  { print(STDERR "
mdti.tapes.pl:  unable to make directory $_[0]
"); $ConfigurationError = $Yes }

sub zNoOpenR  { print(STDERR "
mdti.tapes.pl: unable to open and read from $_[0]
"); if ( defined($_[1]) ) { print(STDERR "in directory $_[1]
") } &Unload(10) }

sub zNoReadCommands  { print(STDERR "
mdti.tapes.pl:  unable to open and read the pipe named 'commands'
"); &Unload(10) }

sub zNoReadData  { print(STDERR "
mdti.tapes.pl:  unable to open and read from pipe named 'data' in directory
$MdtiDirectory
"); &Unload(10) }

sub zNoTape  { print(STDERR "
mdti.tapes.pl: there is no tape in the drive
") }

sub zNoTapePosition  { print(STDERR "
mdti.tapes.pl: bug detected: sub MoveTapeTo called to move from tape
position $TapePosition to tape position $_[1], but the mt command
'$_[0]'
returned an exit code of 2, which means that there is no such tape position.
"); &Unload(40) }

sub zNotInConfig  { print(STDERR "
mdti.tapes.pl: there is no \'$_[0]\=\'
in the configuration file
"); $ConfigurationError = $Yes }

sub zNoWriteData  { print(STDERR "
mdti.tapes.pl:  unable to open and write to pipe named 'data' in directory
$MdtiDirectory
"); &Unload(10) }

sub zNoWriteTape  { print(STDERR "
mdti.tapes.pl: unable to write to this tape; it may be full, or it may be
write protected
") }

sub zTapeEnter  { print(STDERR "
mdti.tapes.pl: insert tape $TapeToLoad and press enter;
or type 'fail' and press enter to abort the current operation; or
type 'exit' and press enter to abort all operations and exit mdti.tapes.pl
") }

sub zTapeHeaderMisMatch  { print(STDERR "
mdti.tapes.pl: The information in the header of a file seems wrong.
The header says it is tape set '$TapeSetNameFromHeader',
tape $TapeNumberFromHeader, file '$FileNameFromHeader',
fragment $FragmentNumberFromHeader.
This is supposed to be tape set '$TapeSetName', tape $CurrentTape,
file number $TapePosition.
Assuming this is tape set '$TapeSetName', tape $CurrentTape;
not tape set '$TapeSetNameFromHeader', tape $TapeNumberFromHeader.
") }

sub zTapeRemove  { if ( $TapeToRemove > 0 ) { print(STDERR "
mdti.tapes.pl: you may remove tape $TapeToRemove
") }}

sub zTapeWait  { print(STDERR "
mdti.tapes.pl: insert tape $TapeToLoad
") }

sub zVerifyIndexError  { print(STDERR "
mdti.tapes.pl: index entry $_[0] does not match what is on the tape. This is
supposed to be tape set '$TapeSetName', tape $CurrentTape, tape
position $TapePosition. The index says this is file '$FileName[$_[0]]',
fragment $FragmentNumber[$_[0]], date $FileDate[$_[0]]. 
But the file header on the tape says it is tape set
'$TapeSetNameFromHeader', tape $TapeNumberFromHeader, file
'$FileNameFromHeader', fragment $FragmentNumberFromHeader, date
$FileDateFromHeader.
The index is probably corrupted and you need to rebuild the index.
"); &Unload(10) }

sub zVerifyIndexWrongTape  { print(STDERR "
mdti.tapes.pl: bug detected: sub VerifyIndexEntry called to verify index
entry $_[0], this index entry is on tape $TapeNumberOfFileFragment[$_[0]],
but the current tape is tape $CurrentTape.
"); &Unload(40) }

sub zWrongBlankTape  { print(STDERR "
mdti.tapes.pl: wrong tape: this is a blank tape, not tape $TapeToLoad
") }

sub zWrongFileAtTapePosition  { print(STDERR "
mdti.tapes.pl: index is wrong: the index says that file
'$FileName[$FileSelector]' fragment $FragmentNumber[$FileSelector]
is supposed to be at tape position
$TapePositionOfFileFragment[$FileSelector],
but instead there is file '$FileNameFromHeader' fragment
$FragmentNumberFromHeader at tape position $TapePosition. Maybe you should
rebuild the index.
"); $Results = "failure\nindex corrupted\n$Commands[1]\n";
return($Failure) }

sub zWrongTape  { print(STDERR "
mdti.tapes.pl: wrong tape: this is tape $CurrentTape, not tape $TapeToLoad
") }

sub zWrongTapeSet  {
if ( defined($TapeSetNameFromHeader) )  { print(STDERR "
mdti.tapes.pl: wrong tape set: this is tape $TapeNumberFromHeader from tape
set '$TapeSetNameFromHeader', not tape $TapeToLoad from tape set '$TapeSetName'
") } else { print(STDERR "
mdti.tapes.pl: this is an unknown tape containing unknown data written by an
unknown program, not tape $TapeToLoad from tape set '$TapeSetName'
") } }

sub zWrongSignal  { print(STDERR "
mdti.tapes.pl: signal '$_[0]' received and trapped; only signals PIPE,
TERM, and INT are supposed to be trapped.
"); &Unload(10)  }

sub zUnknownTape  { print(STDERR "
mdti.tapes.pl: wrong tape: this is not tape $TapeToLoad
") }


__END__

mdti.tapes.pl is an mdti (multiple disk and tape interface) server for
Paranoid Backup. It uses simple tape functions, so it should work with most
tape drivers. The simple tape functions are not always the best way to
manage tape drives, but if we use the more advanced tape functions, then we
might make mdti.tapes.pl incompatible with some tape drivers. If you do not
like that, you could always create your own server, and optimize it for your
favorite tape driver. But if you are going to do that much work, why not
rewrite the whole interface? See the file mdti.text for some suggestions on
an improved interface.

I was thinking about using a spooling buffer to read and write the tapes. We
could have allocated a large block of memory as a buffer, and then when
writing to the tape we could put the data in the buffer instead of writing
it to the tape, and then when the buffer was full we would transfer data
from the buffer to the tape. This would make the tape less likely to
shoeshine. But I decided that I could accomplish the same thing with a lot
less work by using a very large block size. But if there are any tape
drivers which do not allow large block sizes, then maybe the spooling buffer
idea should be resurrected.

This program refers to tape files/volumes as 'fragments'. This is
because if a file has to be split up to store it on tape, it appears to be
several files/volumes on the tape, but what appears to be seperate
files/volumes are really fragments of a single file. This version of
mdti.tapes.pl only splits files into fragments if the file is to big to fit
on a single tape. However, if someone has too much free time on their hands,
they could devise a way to delete files from the middle of a tape, and then
this system of fragments could be used to fit a file into fragmented free
space.

When tar reads a tape, when tar closes the tape device when it is done
reading, the tape is positioned at the end of the tape file/volume just read,
and you either do another read or mt fsf 1 to move the tape to the beginning
of the next tape file/volume. But when I open the tape device, read until
end of file, and then close the tape device, the tape is already positioned
at the beginning of the next tape file/volume. How does tar prevent the tape
from moving to the next tape file/volume?

This program has trouble when it reads part of a tape file/volume but quits
before end of file, such as when it reads the header, or when a read is
aborted by SIGPIPE. If it did not get to end of file, then the tape is
positioned somewhere in the middle of the tape file/volume it was reading.
But if it aborted just before end of file, then the tape is positioned at
the beginning of the next tape file/volume. I could not find a way to detect
if it had aborted just before end of file; perl has an eof() function, but
that only works with read(), not with sysread(); there is no syseof()
function (and no syscall(eof,...) function). Thus, unfortunately,
$TapePosition is unreliable after every aborted read. My solution was to
have sub MoveTapeTo always rewind the tape to tape position 0 before moving
the tape to wherever, and always call sub MoveTapeTo after an aborted read.
(Actually sub MoveTapeTo is called BEFORE every read and write, but that has
the same effect.) If I could do like tar and prevent the tape from moving to
the next tape file/volume at end of file, then I would not need to detect
end of file and there would be no problem, and that would probably make
be faster.

If the client program asks to read a file, but then opens and closes the
data pipe without reading anything, then this server gets hit with SIGPIPE,
and it will exit without cleaning up after itself unless we do something
about SIGPIPE. So it traps SIGPIPE and aborts the read if it gets SIGPIPE.
Probably SIGPIPE could be blocked instead of trapped; that would be less
code, but that would not abort the read; it would send the data nowhere
instead of sending it to the pipe, but it would still read the data from the
tapes. By aborting the read the server is ready for the next command sooner;
a lot sooner if it was a long read involving many tapes.



maybe headers and footer should be optional. It could automatically not use
footers if the minimum block size was 1.

maybe there should be an option for whether or not to allow duplicate file
names.

maybe it should retension the tapes; maybe it should remember when it last
used each tape and retension if it has been more than some amount of time

maybe it should cache tape data on the hard drive for faster access

maybe it should be able to delete fragments from the middle of tapes.
probably if it does that it should also defragment the free space on the
tapes.

if X is running, we could open a dialog box window for prompting.

header format:
header marker  'mtih1'   5 bytes
tape number       VunsignedInteger
fragment number     VunsignedInteger
fragment date    VunsignedInteger
tape set name    Vstring
file name      Vstring
rest of header     Vstring
checksum        4 bytes

footer format:
footer marker   'mtif1'     5 bytes
nuls      any number of bytes

The tape set name and tape number really do not belong in the header, but
where else can we put them? They should go in the volume table, but
unfortunately different kinds of tapes use different kinds of volume tables,
and we would need different methods of reading and writing the volume table
for different kinds of tape drives. We could make a special id file with the
tape set name and tape number, but that would use up one segment and one
entry in the volume table; it seems wasteful to use a whole 29K segment to
store 25 bytes of data.

When mdti.tapes.pl is trying to identify the tape, it reads the header of
the first file. If the first file has no header or the header is corrupted,
it checks the second file, etc, until it finds a valid header. It reads the
tape number from the header. If there are no valid headers, then it is an
unknown tape. When mdti.tapes.pl is trying to read a file, it uses the
information in the index to move the tape to where the file is supposed to
be. Then it reads the header to verify that it has found the correct file.

The information in the header is similar to the information in the index
file. When mdti.tapes.pl needs a file, it first looks in the index
information, which should be in memory, because it can find information in
the index much faster than it can search the headers on the tapes. But then
it verifies the index information by reading the headers on the tapes, and
actual reads and writes are based on the information in the file headers;
unless the file headers are unreadable, in which case reads and writes are
based on the index information.

If the header is corrupted, mdti.tapes.pl will not be able to seperate the
header from the file, and if you read the file it will appear to have
garbage data prefixed to it. This could cause problems, because many archive
programs will exit if a file contains leading garbage, and will give an
error message saying something like wrong format. kxarc can handle archives
with leading garbage, and afio probably can too.


The format of the index file:

The index file is a text file.

Each line in the index file describes one fragment. A fragment is a part of
a file on one tape. If a file is too big to fit on one tape, then the file
is split into fragments, and one fragment is written to each tape.
If the file fits on one tape, then there will be one fragment for that file.
When reading a file, the server should find and reassemble the fragments
automatically. If a file is split into three fragments, then the file will
have three lines in the index file, one line for each fragment.

Each line in the index file has the following format: tape number of file
fragment, space, tape position of file fragment, space, is the file deleted,
space, fragment number, space, fragment date, space, file name.

The tape number of the file fragment is 1 if the fragment is on the first
tape, 2 if the fragment is on the second tape, etc.

The tape position of the file fragment is 0 if the fragment is the first
volume/file on the tape, 1 for the second volume/file on the tape, etc.
You should be able to pass the tape position to mt fsf to move the tape
from the beginning of the tape to the beginning of the fragment.

Deleting files from tapes is not always possible, because you can only
delete the last file on the tape, or the last files, or all files; and you
may not have the tape tool needed. Or you may have to rewind the tape to
delete a file, and it may inconvenient or inefficient to rewind the tape
right now. So when you delete a file, the fragments are marked in the index
as deleted, and are deleted later when it is possible or convenient. Is the
file deleted should be n if the fragment is not deleted, d if the fragment
is deleted. When the fragment is actually deleted, it is removed from the
index. You can not read a file which is marked as deleted, even though the
file is still on the tape. To undelete a file you have to unload the server
and manually edit the index file and change d for deleted to n for not
deleted. When the server rebuilds the index from the tapes, it assumes that
all files are not deleted.

The fragment number is 1 for the first fragment of the file, 2 for the
second fragment of the file, etc. If the file was not split into multiple
fragments, there will be one fragment with a fragment number of 1.

The fragment date is a number which gives the number of clock ticks
(seconds?) since the beginning of Unix, which was about 1970 AD. 1 billion
clock ticks is a little more than 15 years, so a fragment of a file created
in the year 2000 AD should have a date of a litle less than 2 billion.

The file name can be any number of characters and may include any characters
except newline. The server allows more than one file to have the same file
name, except if more than one file has the same name, then a read or delete
of that file will read or delete the last one. If the last one is already
deleted, then it reads or deletes the next to last one, etc. The last one is
the one with the largest (newest) date.

When the server rebuilds the index or when it is trying to write something
to the tape, if it finds a fragment without a valid header, then it assigns
the file name '__UNKNOWN__' plus the tape number and position. (A fragment
without a valid header is probably something written to the tape by a
different program.) Thus it should be safe to allow other programs to write
data to the tapes used by mdti.tapes.pl. mdti.tapes.pl can even read data
written by other programs. You can write data to the tapes while
mdti.tapes.pl is not running, and it will update its index when it finds the
new data. But if you delete some data from the tapes, then mdti.tapes.pl
does not update its index automatically; it aborts and tells you to rebuild
the index.

I have suppressed all error messages from the mt program by adding
' 2> /dev/null' to all mt commands. mdti.tapes.pl intentionally causes many
mt errors; if the mt error messages are not suppressed, then the display
fills with '/dev/tape: Invalid argument' repeated many times. However, if
things are not working, then you might need to see the mt error messages. If
you want to see the mt error messages, then you need to edit this file. Use
search and replace to replace all instances of ' 2> /dev/null' with nothing.
Maybe we should add a command line option to unsuppress mt error messages;
or redirect mt error messages into a file and display them if a serious
error occurs, otherwise delete the error message file when done.


exit codes:
0  ok
1  aborted by user
2  already running
3  configuration error
10 miscellaneous fatal error
11 errors in index
40 bug detected

Note that if perl errors occur, then perl chooses the exit code. If perl
runs out of memory, you get exit code 1. If perl fails to compile, you
get exit code 2. To determine if the exit code came from perl or from
the program, read the error messages.
