/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  win.c                                                        */
/*          This module was needed because of the strange updates of     */
/*          werase() and wclrtoeol() from ncurses 1.8.1 to 1.8.5         */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>


/*************************************************************************/
/* Name:     winclr                                                      */
/* Purpose:  Fills the window with the right fore-/background color.     */
/*************************************************************************/
void winclr(WINDOW *win)
{
    int x,y;
  
    for (y = 0; y <= win->_maxy; y++)
	for (x = 0; x <= win->_maxx; x++)
	    mvwaddch(win,y,x,' ');
}

/*************************************************************************/
/* Name:     winclrtoeol                                                 */
/* Purpose:  Fills the current line with the right fore-/background color*/
/*************************************************************************/
void winclrtoeol(WINDOW *win)
{
    int x,y;
  
    getyx(win,y,x);
    for(; x <= win->_maxx; x++)
	mvwaddch(win,y,x,' ');
    wmove(win,y + 1,0);
}


/*************************************************************************/
/* Copyright (C) 1995 Matthias Hanisch, Wuerzburg                        */
/*************************************************************************/
