/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  watch.c                                                      */
/*          Function for the so called watch mode.                       */
/*          That means logging the tape operation in an extra window.    */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <unistd.h>
#include <ntape.h>

#define WATCH_WIN_WIDTH 60
#define WATCH_WIN_HEIGHT 10

static WINDOW *watch_win = NULL, *box_win = NULL;
static char watch_win_title[WATCH_WIN_WIDTH];
static int linefeed;

/*************************************************************************/
/* Name:     create_watch_win                                            */
/* Purpose:  Creates the watch window in the upper right corner.         */
/*************************************************************************/
void create_watch_win(char *title)
{
    strcpy(watch_win_title,title);
    
    box_win = newwin(WATCH_WIN_HEIGHT+2, WATCH_WIN_WIDTH+2, 
		     3, COLS-WATCH_WIN_WIDTH-5);
    leaveok(box_win,TRUE);
    keypad(box_win,TRUE);
    set_color_pair(box_win,TAPELOGWINDOW);
    winclr(box_win);
    box(box_win,ACS_VLINE,ACS_HLINE);
    touchwin(box_win);
    wrefresh(box_win);
    
    watch_win = newwin(WATCH_WIN_HEIGHT, WATCH_WIN_WIDTH, 4,
		       COLS - WATCH_WIN_WIDTH - 4);
    leaveok(watch_win,TRUE);
    scrollok(watch_win,TRUE);
    keypad(watch_win,TRUE);
    set_color_pair(watch_win,TAPELOGWINDOW);
    winclr(watch_win);
    wmove(watch_win,0,0);
    linefeed = 0;
    touchwin(watch_win);
    wrefresh(watch_win);
}


/*************************************************************************/
/* Name:     print_watch_win                                             */
/* Purpose:  Prints a message in the watch window.                       */
/*************************************************************************/
void print_watch_win(char *msg)
{
    int x,y,i = 0;
    
    if (watch_win)
    {
	for (i = 0; msg[i] != '\0'; i++)
	    if (msg[i] == '\n')
		linefeed = 1;
	    else
	    {
		if (linefeed)
		{
		    linefeed = 0;
		    getyx(watch_win,y,x);
		    winclrtoeol(watch_win);
		    if (y == WATCH_WIN_HEIGHT-1)
		    {
			scroll(watch_win);
			wmove(watch_win,y,0);
			winclrtoeol(watch_win);
			wmove(watch_win,y,0);
		    }
		}
		waddch(watch_win,msg[i]);
	    }
	getyx(watch_win,y,x);
	
	if (y == WATCH_WIN_HEIGHT-1 && x>1)
	    winclrtoeol(watch_win);
	wmove(watch_win,y--,x);
	
	touchwin(watch_win);
	wrefresh(watch_win);
    }
}


/*************************************************************************/
/* Name:     destroy_watch_win                                           */
/* Purpose:  Destroys the watch window.                                  */
/*************************************************************************/
void destroy_watch_win()
{
    if (watch_win)
    {
	sleep(1);  /* You should be able to read the last line */
	delwin(watch_win);
	watch_win = NULL;
    }
}


/*************************************************************************/
/* Copyright (C) 1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
