/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  ntape.c                                                      */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>

void main(void);

int popup_active;

/*************************************************************************/
/* Name:     main                                                        */
/* Purpose:  Program start and main loop.                                */
/*************************************************************************/
void main()
{
    int c;

/* Initialisierung */
    nta_init();

/* Aufbau des Bildschirms */
    nta_initscr();

/* Einlesen der Tapelistbox */
    init_tape_list();

/* Fuellen der Listbox */
    init_list();

    while(1)
    {
	c = getch();
	switch(c)
	{
	case KEY_DOWN:
	    if (popup_active == 0)
		scroll_down_list();
	    else
		scroll_down_popup();
	    break;
	case KEY_UP:
	    if (!popup_active)
		scroll_up_list();
	    else
		scroll_up_popup();
	    break;
	case KEY_A1:
	case KEY_HOME:
	    if (!popup_active)
		top_pos_list();
	    break;
	case KEY_END:
	case KEY_C1:
	    if (!popup_active)
		bottom_pos_list();
	    break;
	case KEY_NPAGE:
	    page_down_list();
	    break;
	case KEY_PPAGE:
	    page_up_list();
	    break;
	case KEY_LEFT:
	    change_menu(0);
	    break;
	case TAB_KEY:
	case KEY_RIGHT:
	    change_menu(1);
	    break;
	case ESCAPE_KEY:
	    if (popup_active)
		destroy_popup();
	    break;
	case CR_KEY:
	    if (popup_active)
		choose_cell();
	    else
		choose_menu();
	    break;
	case SPACE_KEY:
	    if (!popup_active)
		info_box();
	    break;
	default:
#ifdef DEBUG
	    fprintf(stderr,"\nKeycode %d %o %x ",c,c,c);
#endif
	    break;
	}
    }
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
