/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  msgbox.c                                                     */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>

static int chosen_cell;
static WINDOW *msgbox;
static char *button[][2] = 
{
    {"   OK   "," Cancel "},
    {"  Yes   ","   No   "}
};

void draw_buttons(unsigned int,unsigned int,unsigned int);

/*************************************************************************/
/* Name:     MessageBox                                                  */
/* Purpose:  Opens and manages massage box.                              */
/*************************************************************************/
int MessageBox(char *msg,unsigned int no_but,unsigned int but_text,
	       unsigned int def_but)
{
    int c,fertig = 0;

    msgbox = newwin(5,strlen(msg)+4,(LINES-3-5)/2+2,(COLS-strlen(msg)-4)/2);
    leaveok(msgbox,TRUE);
    keypad(msgbox,TRUE);
    set_color_pair(msgbox,MSGBOX);
    winclr(msgbox);
    box(msgbox,ACS_VLINE,ACS_HLINE);
    mvwaddstr(msgbox,1,2,msg);
    chosen_cell = def_but;
    while(!fertig)
    {
	draw_buttons(no_but,strlen(msg)+4,but_text);
	touchwin(msgbox);
	wrefresh(msgbox);
	c = getch();
	switch(c)
	{
	case TAB_KEY:
	case KEY_RIGHT:
	     if (chosen_cell == no_but - 1)
		  chosen_cell = 0;
	     else
		  chosen_cell++;
	     break;
	case KEY_LEFT:
	     if (chosen_cell)
		  chosen_cell--;
	     else
		  chosen_cell = no_but - 1;
	     break;
	case CR_KEY:
	     fertig = 1;
	     break;
	default:
	    break;
	}
    }
    delwin(msgbox);
    return(1-chosen_cell);
}


/*************************************************************************/
/* Name:     draw_buttons                                                */
/* Purpose:  Draws button(s).                                            */
/*************************************************************************/
void draw_buttons(unsigned int but,unsigned int width,
		  unsigned int which_text)
{
    int i;

    for (i = 0; i < but; i++)
    {
	if (i == chosen_cell)
	    set_color_pair(msgbox,INV_MSGBOX);
	else
	    set_color_pair(msgbox,MSGBOX);
	if (i == 0)
	{
	    if (but == 2)
		mvwaddstr(msgbox,3,3,button[which_text][0]);
	    else
		mvwaddstr(msgbox,3,width / 2 - 4,button[which_text][1]);
	}
	else
	    mvwaddstr(msgbox,3,width - 11,button[which_text][1]);
    }
}
  

/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
