#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <assert.h>
#include <applet-widget.h>
#include <libgnomeui/gnome-window-icon.h>

#include "gchive_48.xpm"
#include "gchive_32.xpm"
#include "interface.h"
#include "support.h"
#include "sys/wait.h"
#include "conf.h"

GtkWidget *about;
gchar *grarcommand="gnomerar";
gchar *grar_cmd;
gint timeout=0;

static GtkTargetEntry dnd_types[] =
{
	{"STRING",0,0},
	{"text/plain",0,0},
	{"application/x-rootwin-drop",0,1}
};

#ifdef HAVE_PANEL_PIXEL_SIZE
static int gnochive_applet_size=PIXEL_SIZE_STANDARD;
#else
static int gnochive_applet_size;
#endif

static GtkTooltips *tooltip = NULL;

GtkWidget *applet;
GtkWidget *label;
GtkWidget *window;
GtkWidget *vbox;
GdkColor c;
GdkGC *gc;
GdkPixmap *pixmap;
GdkBitmap *mask;

GdkColormap *colormap;
GtkStyle *style;

GtkWidget *pix;
GtkWidget *frame;
GtkWidget *fixed;
GtkWidget *fixed1;

int i;

static void
prop_fnc (AppletWidget *applet,gpointer data)
{
GtkWidget *window;
window=create_dialog6();
gtk_widget_show(window);
}

static void
about_fnc (AppletWidget *applet,gpointer data)
{
GtkWidget *window;
static const char *authors[] ={"Lucian Langa <cooly@gyl.ro>",NULL};
window=gnome_about_new(_("gnochive applet"),"1.0",
			_("Copyright (C) Lucian Langa 2000"),
			authors,
			_("An applet for gnochive. Supports drag'n'drop archiving"),NULL);

gtk_widget_show(window);
}

void
expose (GtkWidget *widget,GdkEventButton *event, gpointer data)
{
//gdk_draw_pixmap(window->window,gc,pixmap,0,0,0,0,64,64);

}

gint timeout_func(gpointer data)
{
FILE *stalefile;
stalefile=fopen("/tmp/gnochive.pid","r");
if (stalefile==NULL) {
		    gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_OUT);
		    gtk_widget_show(frame);
		    //applet_widget_add(APPLET_WIDGET(applet),frame);
		    gtk_widget_show(applet);
		    }
else {
    gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);
    gtk_widget_show(frame);
    //applet_widget_add(APPLET_WIDGET(applet),frame);
    gtk_widget_show(applet);
    }
if (stalefile!=NULL) fclose(stalefile);

return TRUE;
}

void
drag (GtkWidget *widget,
	GdkDragContext *context,
	gint x,
	gint y,
	GtkSelectionData * sel_data,
	guint info,guint time,
	gpointer data)
{
g_print("%s",(gchar *)sel_data->data);
}

void
press (GtkWidget *widget,GdkEventButton *event, gpointer data)
{
grar_cmd=g_strconcat(grarcommand,"&",NULL);
system(grar_cmd);
g_free(grar_cmd);
}

void
put_applet(void)
{
gtk_widget_set_usize(frame,gnochive_applet_size,gnochive_applet_size);
}

void
app_change_pixel_size (GtkWidget *widget,GdkEventButton *event, gpointer data)
{
#ifdef HAVE_PANEL_PIXEL_SIZE
    gnochive_applet_size=applet_widget_get_panel_pixel_size(APPLET_WIDGET(applet));
#else
    gnochive_applet_size=48;
#endif
gtk_widget_set_usize(frame,gnochive_applet_size,gnochive_applet_size);
if (gnochive_applet_size==48) {
			gtk_widget_hide(pix);
			pix=gnome_pixmap_new_from_xpm_d(gchive_48_xpm);
			gtk_widget_show(pix);
			}
else {
	gtk_widget_hide(pix);
	pix=gnome_pixmap_new_from_xpm_d(gchive_32_xpm);
	gtk_widget_show(pix);
    }
gtk_fixed_put(GTK_FIXED(fixed1),pix,0,0);
}

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  applet_widget_init ("gnochive applet", VERSION, argc, argv,NULL,0,NULL);
  applet = applet_widget_new("gnochive applet");
  gtk_widget_realize(applet);
  
  window = gtk_drawing_area_new();
  gtk_widget_set_usize(window,48,48);
  gtk_widget_set_app_paintable(window,TRUE);
  vbox=gtk_vbox_new(TRUE,0);
  
  
  //gtk_box_pack_start(GTK_BOX(vbox),window,TRUE,TRUE,0);
  
  pix=gnome_pixmap_new_from_xpm_d(gchive_48_xpm);
  gtk_widget_show(pix);
  fixed1=gtk_fixed_new();
  gtk_widget_show(fixed1);
  gtk_box_pack_start(GTK_BOX(vbox),fixed1,FALSE,FALSE,0);
    
#ifdef HAVE_PANEL_PIXEL_SIZE
  gtk_signal_connect(GTK_OBJECT(applet),"change_pixel_size",GTK_SIGNAL_FUNC(app_change_pixel_size),NULL);
#endif

  gtk_widget_set_events(fixed1,GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_MOTION_MASK);
  gtk_signal_connect(GTK_OBJECT(fixed1),"button_press_event",GTK_SIGNAL_FUNC(press),NULL);
  gtk_signal_connect(GTK_OBJECT(fixed1),"expose_event",GTK_SIGNAL_FUNC(expose),NULL);

  gtk_drag_dest_set(fixed1,GTK_DEST_DEFAULT_ALL,dnd_types,2,GDK_ACTION_COPY|GDK_ACTION_MOVE);
  gtk_signal_connect(GTK_OBJECT(fixed1),"drag_data_received",GTK_SIGNAL_FUNC(drag),NULL);
  gtk_widget_show(vbox);
  
  frame=gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_OUT);
  gtk_widget_set_usize(frame,48,48);
  gtk_widget_show(frame);
  
  fixed=gtk_fixed_new();
  gtk_widget_show(fixed);
  gtk_fixed_put(GTK_FIXED(fixed),vbox,0,0);
  gtk_container_add(GTK_CONTAINER(frame),fixed);
  
  
  applet_widget_add(APPLET_WIDGET(applet),frame);
  // tooltips
  tooltip=gtk_tooltips_new();
  gtk_tooltips_set_tip(tooltip,applet,"gnochive applet",NULL);
  
#ifdef HAVE_PANEL_PIXEL_SIZE
    gnochive_applet_size=applet_widget_get_panel_pixel_size(APPLET_WIDGET(applet));
#else
    gnochive_applet_size=48;
#endif
    put_applet();
    

  gtk_widget_show(applet);
  
  applet_widget_register_stock_callback(APPLET_WIDGET(applet),"Properties",GNOME_STOCK_MENU_PROP,_("Properties"),prop_fnc,NULL);
  applet_widget_register_stock_callback(APPLET_WIDGET(applet),"Help",GNOME_STOCK_PIXMAP_HELP,_("Help"),about_fnc,NULL);
  applet_widget_register_stock_callback(APPLET_WIDGET(applet),"about",GNOME_STOCK_MENU_ABOUT,_("About"),about_fnc,NULL);
  timeout=gtk_timeout_add(100,timeout_func,NULL);
  
//  putenv(BASE_DIR);
  applet_widget_gtk_main();
  

//  gtk_main ();
  return 0;
}

