#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

char buf [1024];

main (int argc, char **argv) {
  int ifd;
  unsigned long GrandTotalRead = 0;

  if ((ifd = open (argv [1], O_RDONLY)) < 0) {
    fprintf (stderr, "open %s failed\n", argv [1]);
    exit (1);
  }

  while (1) {
    char *p = buf;
    int left = sizeof (buf);
    int sofar = 0;
    int eof = 0;

    while (left) {
      int n;
      n = read (ifd, p, left);
      sofar += n;
      GrandTotalRead += n;
      left -= n;
      p += n;
/*      if (n == 0) {
	eof++;
	break;
      }
      else */ if (n < 0) {
	fprintf (stderr, "read failed\n");
	exit (1);
      }
      if (left != 0) {
	FILE *tty;
	close (ifd);
	fprintf (stderr, "short read\n");
	fprintf (stderr, "Total read: %ld\n", GrandTotalRead);
	tty = fopen ("/dev/tty", "r");
	if (!tty) {
	  fprintf (stderr, "open /dev/tty failed!\n");
	  exit (1);
	}
	fprintf (stderr, "hit any char when ready\n");
	getc (tty);
	fclose (tty);
	if ((ifd = open (argv [1], O_RDONLY)) < 0 ) {
	  fprintf (stderr, "open %s failed\n", argv [1]);
	  exit (1);
	}
      }
    }

    p = buf;
    left = sofar;
    sofar = 0;

    while (left) {
      int n;
      n = write (1, p, left);
      if (n < 0) {
	fprintf (stderr, "write error\n" );
	exit (1);
      }
      sofar += n;
      left -= n;
      p += n;
    }
    if (eof) break;
  }
}
