#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

char buf [1024];

main (int argc, char **argv) {
  int ofd;
  unsigned long GrandTotalWritten = 0;

  if ((ofd = open (argv [1], O_WRONLY)) < 0) {
    fprintf (stderr, "open %s failed\n", argv [1]);
    exit (1);
  }

  while (1) {
    char *p = buf;
    int left = sizeof (buf);
    int sofar = 0;
    int eof = 0;

    while (left) {
      int n;
      n = read (0, p, left);
      sofar += n;
      left -= n;
      p += n;
      if (n == 0) {		/* EOF */
	eof++;
	break;
      }
      else if (n < 0) {
	fprintf (stderr, "read failed\n");
	exit (1);
      }
    }

    p = buf;
    left = sofar;
    sofar = 0;

    while (left) {
      int n;
      n = write (ofd, p, left);
      if (n < 0) {
	fprintf (stderr, "write error\n" );
	exit (1);
      }
      sofar += n;
      GrandTotalWritten += n;
      left -= n;
      p += n;
      if (left != 0) {
	FILE *tty;
	close (ofd);
	fprintf (stderr, "short write\n");
	fprintf (stderr, "Total written: %ld\n", GrandTotalWritten);
	tty = fopen ("/dev/tty", "r");
	if (!tty) {
	  fprintf (stderr, "open /dev/tty failed!\n");
	  exit (1);
	}
	fprintf (stderr, "hit any char when ready\n");
	getc (tty);
	fclose (tty);
	if ((ofd = open (argv [1], O_WRONLY)) < 0 ) {
	  fprintf (stderr, "open %s failed\n", argv [1]);
	  exit (1);
	}
      }
    }
    if (eof) break;
  }
}
