#include <message.h>
#include <somef.h>

int main(int argc,char *argv[])
{
char *in,*out,*passwd;
FILE *Fin,*Fout;

  if (argc==2) {
    if (strcmp(argv[1],"--copyright")==0) {
      printf("%s\n\n",VERSION);
      printf("%s",COPYRIGHT);
      exit(0);
    }
    else if (strcmp(argv[1],"--version")==0) {
      printf("%s\n",VERSION);
      exit(0);
    }
  }

  if (argc!=4) {
    fprintf(stderr,"%s\n%s\n%s\n%s\n",
            "usage: undes <passwd> <file in> <file out>",
            "       undes --copyright",
            "       undes --version",
            "       '-' for file --> stdin/stdout"
           );
    exit((argc==1) ? 0 : 2);
  }

  passwd=argv[1];
  in    =argv[2];
  out   =argv[3];

  if (strcmp(in,"-")!=0) {
    if (strcmp(in,out)==0) {
      fprintf(stderr,"%s\n","<file in> and <file out> cannot be the same");
      exit(1);
    }
  }

  if (strcmp(in,"-")==0) {
    Fin=stdin;
  }
  else {
    Fin=fopen(in,"rb");
  }
  if (strcmp(out,"-")==0) {
    Fout=stdout;
  }
  else {
    Fout=fopen(out,"wb");
  }

  checkNull(Fin,in);
  checkNull(Fout,out);

  /* fprintf(stderr,"decrypting %s to %s\n",in,out); */

  {CRYPT_INFO info;
   CRYPT_ALGO alg  =CRYPT_ALGO_3DES;
   CRYPT_MODE mode =CRYPT_MODE_CBC;
   CRYPT_QUERY_INFO queryInfo;
   char pass[MAX_PASS_SIZE],key[MAX_KEY_SIZE];
   char iv[CRYPT_MAX_IVSIZE];
   int  KEY_SIZE,ivSize;
   int  i,L,fh;
   char *buffer,*bufbegin;
   long *buf;
   int  first=(1==1);
   char p[MAX_PASS_SIZE];

    buffer=(char *) malloc(BUF_ALLOC);
    bufbegin=buffer+sizeof(long)+sizeof(long);
    if (buffer==NULL) { fprintf(stderr,"Can't allocate buffer\n");exit(1); }
    buf=(long *) buffer;

    initLibrary();
    queryAlgoModeInformation(alg,mode,&queryInfo);

    KEY_SIZE=queryInfo.keySize;
    ivSize  =queryInfo.ivSize;

    /*fprintf(stderr,"maximum password size: %d\n",KEY_SIZE);*/
    /*fprintf(stderr,"encryption key size  : %d\n",ivSize);*/
    /*fprintf(stderr,"decrypting using 3DES...");*/
     
    for(i=0;i<KEY_SIZE && passwd[i]!='\0';i++) {
      pass[i]=passwd[i];
    }
    for(;i<KEY_SIZE;i++) {
      pass[i]=KEY_FILLER;
    }

    PRG_VERSION=-1;
    fh=fileno(Fin);

    /*L=read(fh,&PRG_VERSION,sizeof(PRG_VERSION));checkRead(L);*/

    PRG_VERSION=readversion(fh);
    checkVersion(PRG_VERSION);

    initCryptContext(&info,alg,mode);
    loadCryptContext(&info,pass,KEY_SIZE);

    queryContextInformation(&info,&queryInfo);
    ivSize=queryInfo.ivSize;
   
    L=read(fh,iv,ivSize);checkRead(L);
    loadIV(&info,iv,ivSize);

    /* decrypt the file */

    L=read(fh,p,MAX_PASS_SIZE);checkRead(L);
    
    L=read(fh,buffer,BUF_ALLOC);checkRead(L);
    while( L!=0 ) {long len;
      /*fprintf(stderr,".");fseek(stderr,0,SEEK_END);*/
      decryptBuffer(&info,buffer,BUF_ALLOC);

      len=buf[0];
      if (len<0) { len=BUF_SIZE; }

      if (first) {int i;
        decryptBuffer(&info,p,MAX_PASS_SIZE);
        for(i=0;i<KEY_SIZE && p[i]==pass[i];i++);
        if (i!=KEY_SIZE) {
          fprintf(stderr,"Password is not correct, no decryption possible\n");
          exit(1);
        }
        first=(1==0);
      }

      fwrite(bufbegin,len,1,Fout);checkWrite(Fout);
      L=read(fh,buffer,BUF_ALLOC);checkRead(L);
    }

    decryptBuffer(&info,buffer,0);
    destroyCryptContext(&info);

    /*fprintf(stderr,"done.\n");*/

    endLibrary();
    free(buffer);
  }

  if (Fin!=stdin)   { fclose(Fin); }
  if (Fout!=stdout) { fclose(Fout); }

  /*fprintf(stderr,"\n");*/

return 0;  
}

