#include <message.h>
#include <stdio.h>

char *VERSION="DES/UNDES V1.2.0, (C) 1998 H.N.M. Dijkema (GPL)";

long PRG_VERSION=10200L;

char *COPYRIGHT=
"    Copyright (C) 1998/1999 H.N.M. Dijkema\n"
"\n"
"    This product includes software developed by Eric Young (eay@mincom.oz.au)\n"
"\n"
"    This program is free software; you can redistribute it and/or modify\n"
"    it under the terms of the GNU General Public License as published by\n"
"    the Free Software Foundation; either version 2 of the License, or\n"
"    (at your option) any later version.\n"
"\n"
"    This program is distributed in the hope that it will be useful,\n"
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"    GNU General Public License for more details.\n"
"\n"
"    You should have received a copy of the GNU General Public License\n"
"    along with this program; if not, write to the Free Software\n"
"    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
"\n"
"    You can contact the author by electronic mail, hnmdijkema@softhome.nl\n"
"\n"
"\n"
"Acknowledgements\n"
"----------------\n"
"The author of CRYPTLIB, Peter Putmann of University of Auckland\n"
"cryptl99.zip Free encryption library for DOS/UNIX/Windows\n"
"\n"
"The DES and 3DES encryption code was contributed by Eric Young\n"
"<eay@psych.psy.uq.oz.au> and is part of his libdes package.\n"
"The primary ftp site for the full libdes is\n"
"   ftp://ftp.psy.uq.oz.au/pub/Crypto/DES/libdes-x.xx.tar.gz.\n"
"\n";

static long KnownVersions[]={10200L,-1};

void checkVersion(long ver)
{
int i;
  for(i=0;KnownVersions[i]!=ver && KnownVersions[i]!=-1L;i++);
  if (KnownVersions[i]==-1L) {
    fprintf(stderr,
            "I don't know the version of this file, can't decrypt this\n"
           );
    exit(1);
  }
}

unsigned long readversion(int fh)
{
unsigned char c[4];
long v;
size_t L;
  L=read(fh,c,sizeof(c));checkRead(L);
  v=((c[3]*256+c[2])*256+c[1])*256+c[0];
return v;
}

void writeversion(FILE *F,unsigned long v)
{
unsigned char c[4];
   c[0]=v%256;v/=256;
   c[1]=v%256;v/=256;
   c[2]=v%256;v/=256;
   c[3]=v;
   fwrite(c,sizeof(c),1,F);
}

