#include <message.h>
#include <somef.h>
#include <stdlib.h>

int main(int argc,char *argv[])
{
char *in,*out,*passwd;
FILE *Fin,*Fout;

  /*fprintf(stderr,"%s",VERSION);*/

  if (argc==2) {
    if (strcmp(argv[1],"--copyright")==0) {
      printf("%s\n\n",VERSION);
      printf("%s",COPYRIGHT);
      exit(0);
    }
    else if (strcmp(argv[1],"--version")==0) {
      printf("%s\n",VERSION);
      exit(0);
    }
  }

  if (argc!=4) {
    fprintf(stderr,"%s\n%s\n%s\n%s\n",
            "usage: des <passwd> <file in> <file out>",
            "       des --copyright",
            "       des --version",
            "       '-' for file --> stdin/stdout"
           );
    exit((argc==1) ? 0 : 2);
  }

  passwd=argv[1];
  in    =argv[2];
  out   =argv[3];

  if (strcmp(in,"-")!=0) {
    if (strcmp(in,out)==0) {
      fprintf(stderr,"%s\n","<file in> and <file out> cannot be the same");
      exit(1);
    }
  }
  
  if (strcmp(in,"-")==0) {
    Fin=stdin;
  } else {
    Fin=fopen(in,"rb");
  }

  if (strcmp(out,"-")==0) {
    Fout=stdout;
  }
  else {
    Fout=fopen(out,"wb");
  }

  checkNull(Fin,in);
  checkNull(Fout,out);

  writeversion(Fout,PRG_VERSION);
  /*fwrite(&PRG_VERSION,sizeof(PRG_VERSION),1,Fout);*/

  /*fprintf(stderr,"Encrypting %s to %s\n",in,out);*/

  {CRYPT_INFO info;
   CRYPT_ALGO alg  =CRYPT_ALGO_3DES;
   CRYPT_MODE mode =CRYPT_MODE_CBC;
   CRYPT_QUERY_INFO queryInfo;
   char       pass[MAX_PASS_SIZE],key[MAX_KEY_SIZE];
   int        KEY_SIZE,ivSize;
   int        i,L,first;
   int        fh;
   char *buffer,*bufbegin;
   long *buf;

    buf=(long *) buffer=(char *) malloc(BUF_ALLOC);
    if (buffer==NULL) { fprintf(stderr,"Cannot allocate buffer\n");exit(1); }
    bufbegin=buffer+sizeof(long)+sizeof(long);

    initLibrary();
    
    queryAlgoModeInformation(alg, mode, &queryInfo);
    
    KEY_SIZE=queryInfo.keySize;
    ivSize  =queryInfo.ivSize;

    /*fprintf(stderr,"maximum password size: %d\n",KEY_SIZE);*/
    /*fprintf(stderr,"encryption key size  : %d\n",ivSize);*/
    /*fprintf(stderr,"encrypting using 3DES...");*/

    for(i=0;i<KEY_SIZE && passwd[i]!='\0';i++) {
      pass[i]=passwd[i];
    }
    for(;i<KEY_SIZE;i++) {
      pass[i]=KEY_FILLER;
    }

    initCryptContext(&info,alg,mode);
    loadCryptContext(&info,pass,KEY_SIZE);

    first=(1==1);
    fh=fileno(Fin);
    L=read(fh,bufbegin,BUF_SIZE);checkRead(L);
    while( L!=0 ) {
      /*fprintf(stderr,".");fseek(stderr,0,SEEK_END);*/
      if (L==BUF_SIZE) {
         buf[0]=-abs(buf[2]);if (buf[0]==0) { buf[0]=-1L; }
         buf[1]=-abs(buf[3]);
      } else {
         buf[0]=L;
         buf[1]=-abs(buf[2]);
      }
      encryptBuffer(&info,buffer,BUF_ALLOC);
      if (first) {CRYPT_QUERY_INFO queryInfo;
                  char iv[ CRYPT_MAX_IVSIZE ];
                  int  ivSize,i;
                  char p[MAX_PASS_SIZE];
        queryContextInformation(&info,&queryInfo);
        ivSize=queryInfo.ivSize;
        retrieveIV(&info, iv);
        fwrite(iv,ivSize,1,Fout);checkWrite(Fout);

        for(i=0;i<KEY_SIZE;i++) { p[i]=pass[i]; }
        encryptBuffer(&info,p,MAX_PASS_SIZE);
        fwrite(p,MAX_PASS_SIZE,1,Fout);checkWrite(Fout);
        
        first=(1==0);
      }
      fwrite(buffer,BUF_ALLOC,1,Fout);checkWrite(Fout);
      L=read(fh,bufbegin,BUF_SIZE);checkRead(L);
    }

    encryptBuffer(&info,buffer,0);
    destroyCryptContext(&info);

    /*fprintf(stderr,"done.\n");*/

    endLibrary();
    free(buffer);
  }

  if (Fin!=stdin)   { fclose(Fin); }
  if (Fout!=stdout) { fclose(Fout); }

  /*fprintf(stderr,"\n");*/

return 0;  
}

