package backuplib;

#
#  a collection of perl utilities to perform system backups
#  rob@xania.demon.co.uk  6/7/1998
#
#  Distributed under the GNU General Public License.
#  This software contains no warranty.

$PREFIX = "/etc/backup";
$DELAYPERIOD = 1; # period (days) used when examining files for incrementals
$BUDEVICE = "/dev/nst0";
$MTCMD = "mt -f $BUDEVICE ";
$TARC = "tar cf $BUDEVICE ";
$TARCINCR = "tar c -T $TEMPFILE -f $BUDEVICE ";
$SCSIDRIVER = 1;  # set this to 0 if you don't have a SCSI tape drive
$SETMARK = 0;     # used to mark positions on the tape for incrementals
$volpaths = "$PREFIX/volumes-to-archive";
$markfile = "$PREFIX/markfile";

$TEMPFILE = "/tmp/.flist";

sub dat_exists {
  
  if( ! -e $BUDEVICE ) {
    print( "backuplib: could not find tape device\n" );
    exit( 1 );
  }
}


sub dat_rewind {

  dat_exists();

  system( "$MTCMD rewind" );
 
}

sub dat_findmark {
  
  dat_exists();
  if( $SCSIDRIVER == 1 ) {
    if( -e $markfile ) {
      die( "dat_findmark" ) unless open( mark_fh, $markfile );
      binmode( mark_fh );
      read( mark_fh, $SETMARK, 4 ); # shouldn't need to increase size of read
      print( "SETMARK = $SETMARK\n" );
      
      system( "$MTCMD fss $SETMARK" );
      close( mark_fh );
      
    } else {
      print( "dat_findmark: no setmark stored by a previous session\n" );
    }
  } else  {
    print( "unfortunately, you are trying ot use the 'setmark' feature but your drive\n\rdoes not seem to support it" );
  }
}

sub dat_setmark {

  dat_exists();
  if( $SCSIDRIVER == 1 ) {
    $SETMARK++;
    system( "$MTCMD wset" );
    die( "dat_setmark" ) unless open( mark_fh, ">$markfile" ); # write mode
    print( mark_fh $SETMARK );
  } else  {
    print( "unfortunately, you are trying ot use the 'setmark' feature but your drive\n\rdoes not seem to support it" );
  }
  
}


# load and lock

sub dat_load {
  
  dat_exists();
  if( $SCSI_DRIVER == 1 ) {  
    system( "$MTCMD load" );               # intialise drive
    system( "$MTCMD lock" );               
    system( "$MTCMD datcompression 1 " );  # activate compression
  }
  dat_rewind();
}

sub dat_unload {
  
  dat_exists();
  
  system( "$MTCMD unlock" );
  system( "$MTCMD offline" );

}

sub dat_backup {

  open( vol_fh, $volpaths ) or die( "could not open list of files" );
  binmode( vol_fh );

  while( <vol_fh> ) {
    s/[\n\r]//g;  # essential to kill the end of line markers

    if((! -d $_ ) && ( ! -f $_ )) {
      print( "invalid volume: $_\n" );
      next;
    }
    system( "$TARC  $_" );
    
  }
  dat_setmark(); # record our position on the tape
  
  close( vol_fh );
}

#this function will handle directories or individual files and will
# only backup those files less than $DELAYPERIOD days since modification

sub dat_backup_incremental {
  
  my $written = 0;

  dat_rewind();    # ALWAYS REWIND TAPE FIRST, that way we can 
                   # seek for the last set mark on the tape!!!

  open( vol_fh, $volpaths ) or die( "could not open list of files" );
  binmode( vol_fh );

  dat_findmark();  # find the end of the last file written to tape
  
  while( <vol_fh> ) {
    
    s/[\n\r]//g;  # essential to kill the end of line markers

    if((! -d $_ ) && ( ! -f $_ )) {
      print( "invalid volume: $_\n" );
      next;
    }
    
    if( -d $_ ) {

      system( "find $_ -mtime -$DELAYPERIOD \! -type d -print > $TEMPFILE" );
    
      
      if( -e $TEMPFILE ) {
	print( "backup up $TEMPFILE files...\n" );
	$written = 1;
	system( "$TARCINCR " );
	unlink( $TEMPFILE );
      } else {
	print( "skipping $_\n" );
      }
      next;
    }
    if( -e $_ && ( -M ($_) <  $DELAYPERIOD )  ) {
      $written = 1;
      system( "$TARC $_ " );
    }
    
    
    
  }
  if( $written > 0  ) {  # then yes we have written to tape...
    dat_setmark();       # so update the file for last tape position
  }
    
  close( vol_fh );
}


