#!/bin/sh
# do tar with the following options:
# c - create, l - local file system
# v - verbose, V - Volume name:
# S - test for sparse files
echo Doing full backup of /tmp file system...
now=`date`
then=`cat dates/date.backup.tmp`
title="incremental backup of /tmp from $then to $now"
logfile="logs/`date "+%y%m%d"`.tmp.inc.log" 
echo >  $logfile
echo >>  $logfile
echo >>  $logfile
echo >>  $logfile
tail -f $logfile &
tar -clzvSf -\
	--block-compress\
	-V "$title"\
	-N "$then"\
	-X excludes/tmp.exclude\
	/tmp \
	2>> $logfile |\
	dd obs=4000k 2>>$logfile >/dev/tape
echo $now > dates/date.backup.tmp
echo Ready.
echo Transcript written to $logfile .
