#!/bin/sh
# do tar with the following options:
# c - create, l - local file system
# v - verbose, V - Volume name:
# S - test for sparse files
echo Doing full backup of DOS file system...
now=`date`
then=`cat dates/date.backup.dos`
title="incremental backup of /dos (DOS partition), from $then to $now"
logfile="logs/`date "+%y%m%d"`.dos.inc.log" 
echo >  $logfile
echo >>  $logfile
echo >>  $logfile
echo >>  $logfile
tail -f $logfile &
tar -czlvSf -\
	--block-compress \
	-V "$title"\
	-N "$then"\
	-X excludes/dos.exclude\
	/dos \
	2>> $logfile |\
	dd obs=4000k 2>>$logfile >/dev/tape
echo $now > dates/date.backup.dos
echo Ready.
echo Transcript written to $logfile .
