#include "numtbl.moc"

#include <qpainter.h>

#include <string.h>
#include <stdlib.h>


// -- class NumTbl implementation

NumTbl::NumTbl(int _cols, int _maxNum, QWidget *parent, const char *name)
 : QTableView(parent, name)
{
  setBackgroundMode(PaletteBase);
  setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

  cols = _cols; maxNum = _maxNum;
  rows = maxNum / cols;
  if (maxNum % cols != 0) rows++;

  setNumRows(rows);
  setNumCols(cols);
  setCellWidth(30);
  setCellHeight(20);
  setFixedSize(30 * cols + 4, 20 * rows + 4);
  
  selected = new bool[maxNum];
  for (int i = 0; i < maxNum; i++)
    selected[i] = FALSE;
}

NumTbl::~NumTbl()
{
  delete[] selected;
}

QString NumTbl::selection()
{
  QString sel;

  for (int i = 0; i < maxNum; i++)
    if (selected[i] == TRUE)
    {
      QString tmp;
      tmp.sprintf("%d,", i + 1);
      sel += tmp;
    }

  // schlechte Lsung
  if (!sel.isEmpty())
    sel.remove(sel.length() - 1, 1);

  return sel;
}

void NumTbl::setSelection(bool *sel)
{
  for (int i = 0; i < maxNum; i++)
    selected[i] = sel[i];
}

void NumTbl::setSelection(const char *sel)
{
  for (int i = 0; i < maxNum; i++)
    selected[i] = FALSE;

  char *selBuf = new char[strlen(sel) + 1];
  strcpy(selBuf, sel);

  char *buf = strtok(selBuf, ",");
  while (buf)
  {
    int num = atoi(buf);
    if (num > 0 && num <= maxNum)
      selected[num - 1] = TRUE;

    buf = strtok(NULL, ",");
  }

  repaint();
  newSelection();
}

void NumTbl::deselectAll ()
{
 for (int i = 0; i < maxNum; i++)
    selected[i] = FALSE;

    repaint ();
    newSelection ();
}
void NumTbl::mousePressEvent(QMouseEvent *m)
{
  int row = findRow(m->y());
  int col = findCol(m->x());
  int num;

  if ((m->button() == LeftButton))
    if ((num = findNum(row, col)) != -1)
    {
      selected[num] = 1 - selected[num];
      updateCell(row, col);
      newSelection();
    }
}

void NumTbl::paintCell(QPainter *p, int row, int col)
{
  int w = cellWidth(col);
  int h = cellHeight(row);
  int num;

  if ((num = findNum(row, col)) != -1)
  {
    p->setPen(black);
    if (selected[num] == TRUE)
    {
      p->setBrush(black);
      p->drawRect(1, 1, w - 2, h - 2);
      p->setPen(white);
    }

    QString text;
    text.setNum(num + 1);
    p->drawText(0, 0, w, h, AlignCenter, text);
  }
}

int NumTbl::findNum(int row, int col)
{
  int ret = (col + (row * cols));
  if ((ret < 0) || (ret >= maxNum))
    ret = -1;

  return ret;
}

void NumTbl::newSelection()
{
  QString tmp = selection();
  emit selectionChanged(tmp.data());
}
