#ifndef CRONTABLE_H
#define CRONTABLE_H

#include <qkeycode.h>

#include "krowtable.h"


// -- class CronRow

class CronRow: public KRow
{
public:
  CronRow();
  CronRow(QString line, QString _comment, bool syscron = FALSE);
  ~CronRow() {}	  

  QString line(bool syscron);

  QString getMinute()  { return minute; }
  QString getHour()    { return hour; }
  QString getDOM()     { return DOM; }
  QString getMonth()   { return month; }
  QString getDOW()     { return DOW; }
  QString getUser()    { return user; }
  QString getCommand() { return command; }
  QString getComment() { return comment; }
  bool    isEnabled()  { return enabled; }
  bool    isEdited()   { return isedited; }

  void setMinute(QString value)  { minute = value; }
  void setHour(QString value)    { hour = value; }
  void setDOM(QString value)     { DOM = value; }
  void setMonth(QString value)   { month = value; }
  void setDOW(QString value)     { DOW = value; }
  void setUser(QString value)    { user = value; }
  void setCommand(QString value) { command = value; }
  void setComment(QString value) { comment = value; }
  void setEnabled(bool value)    { enabled = value; }
  void setIsEdited(bool value)   { isedited = value; }
protected:
  void    paint(QPainter *p, int col, int width);

  QString minute;
  QString hour;
  QString DOM;
  QString month;
  QString DOW;
  QString user;
  QString command;
  QString comment;
  bool    enabled;
  bool    isedited;
};

// -- class CronTable

class CronTable: public KRowTable
{
 Q_OBJECT
signals:
  void doubleClick();
  void rightClick();
public:
  CronTable(QWidget *parent = 0, const char *name = 0);
  ~CronTable() {}

  void    addItem(QString line, QString comment);
  void    addItem(CronRow *row);
  void    clear();
  int     currentItem()           { return currentRow(); }
  void    setCurrentItem(int row);
  void    setCrontype(bool value) { syscron = value; }
  void    setUser(QString value)  { user = value; }

  QString line(int row) { return ((CronRow *) getRow(row))->line(syscron); }

  int count()                     { return numRows(); }
protected:
  void mousePressEvent(QMouseEvent *e);
  void mouseDoubleClickEvent(QMouseEvent *);
  void keyPressEvent(QKeyEvent *);
private:
  bool    syscron;
  QString user;
};

#endif // CRONTABLE_H
