/*
 *  Name	: tzone.cpp ( part of kcmclock )
 *  Version     : 0.1
 *  Description : Date & Time setting for KDE
 *
 *  Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "xpm/world.xpm"
#include "tzone.h"
#include "tzone.moc"

static bool GUI;

Tzone::Tzone(QWidget * parent, const char *name, bool init)
	: KConfigWidget (parent, name)
{
	initMetaObject();

	if (init)
		{
		GUI = FALSE;
		return;
		}
	else    GUI = TRUE;

	// *************************************************************
	// Start Dialog
	// *************************************************************

	tzonelist = new QComboBox( FALSE, this, "ComboBox_1" );
	tzonelist->setGeometry( 10, 10, 360, 30 );
	tzonelist->setMinimumSize( 10, 10 );
	tzonelist->setMaximumSize( 32767, 32767 );
	tzonelist->setSizeLimit( 10 );
	tzonelist->setAutoResize( FALSE );

	QLabel* dlgedit_WorldMap;
	dlgedit_WorldMap = new QLabel( this, "WorldMap" );
	dlgedit_WorldMap->setGeometry( 10, 50, 350, 180 );
	dlgedit_WorldMap->setMinimumSize( 350, 180 );
	dlgedit_WorldMap->setMaximumSize( 350, 180 );
	dlgedit_WorldMap->setText( "" );
	dlgedit_WorldMap->setAlignment( 289 );
	dlgedit_WorldMap->setMargin( -1 ); 

	resize( 380,250 );
	setMinimumSize( 380, 250 );
	setMaximumSize( 380, 250 );

	// *************************************************************
	// End Dialog
	// *************************************************************

	QPixmap pm( world );
	dlgedit_WorldMap->setPixmap(pm);
	dlgedit_WorldMap->setGeometry(10, 50, pm.width(), pm.height());

	loadSettings();
}

Tzone::~Tzone ()
{
if (GUI)
        {
        delete( tzonelist ); 
	}
}

void Tzone::loadSettings()
{
	KConfig *config = kapp->getConfig();
	config->setGroup("tzone");
	pos = config->readNumEntry("TZ", 14);

	for ( int i=14 ; i > 0 ; i-- )
		{
		QString s;
		s.sprintf( "GMT -%d", i);
		tzonelist->insertItem( s );
		}
	tzonelist->insertItem( "GMT 0" );
	for ( int i=1 ; i < 15 ; i++ )
		{
		QString s;
		s.sprintf( "GMT +%d", i);
		tzonelist->insertItem( s );
		}		
	tzonelist->setCurrentItem(pos);
}		

void Tzone::applySettings()
{
	QString Param;
	Param.sprintf("%02d",tzonelist->currentItem());

	BufS=kapp->kde_bindir()+"/set_tzone.sh "+Param;
	int res = system(BufS);
	if ( res != 0 )
		{
		BufS.sprintf("kcmclock error #%d",res/256);
		QMessageBox::warning( 0, BufS,ktr("setting new Time Zone !!"));
		}

	// write some stuff ;-)
	KConfig *config = kapp->getConfig();

	config->setGroup("tzone");
	config->writeEntry("TZ", tzonelist->currentItem() );
	config->sync();
}
