/*
 *  Name        : main.cpp ( part of kcmclock )
 *  Version     : 0.1
 *  Description : Date & Time setting for KDE
 *
 *  Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <kcontrol.h>
#include "tzone.h"
#include "dtime.h"

class KcmclockApplication : public KControlApplication
{
public:

	KcmclockApplication(int &argc, char **arg, const char *name);
	void	apply();

private:

	Tzone	*tzone;
	Dtime	*dtime;
};

KcmclockApplication::KcmclockApplication(int &argc, char **argv, const char *name)
	: KControlApplication(argc, argv, name)
{
tzone = 0; dtime = 0;

if (runGUI())
	{
	if (!pages || pages->contains("dtime"))
		addPage(dtime = new Dtime(dialog, "Date/Time", FALSE),ktr("&Date/Time"), "kcmclock.html");

	if (!pages || pages->contains("tzone"))
		addPage(tzone = new Tzone(dialog, "Time Zone", FALSE),ktr("&Time Zone"), "kcmclock.html");

	if (tzone || dtime)
		dialog->show();
	else 	{
		fprintf(stderr, ktr("usage: kcmclock [dtime,tzone]\n"));
		justInit = TRUE;
		}
	}
}

void KcmclockApplication::apply()
{
	if (tzone) tzone->applySettings();
	if (dtime) dtime->applySettings();
}

// ***********************************************************************
// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// >>>>>>>>>>>>>>>>>>>>>>>>> Our trip start here <<<<<<<<<<<<<<<<<<<<<<<<<
// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// ***********************************************************************
int main(int argc, char **argv)
{
KcmclockApplication app(argc, argv, "kcmclock");
app.setTitle(ktr("Properties - Date/Time"));

if (app.runGUI())
	return app.exec();
else 	return 0;
}
