/*
 *  Name        : dtime.h ( part of kcmclock )
 *  Version     : 0.1
 *  Description : Date & Time setting for KDE
 *
 *  Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef dtime_included
#define dtime_included

#include <stdlib.h>

#include <qlined.h>
#include <qmsgbox.h>
#include <qcombo.h>
#include <qtimer.h>
#include <qtablevw.h>
#include <qdatetm.h>

#include <kapp.h>
#include <kcontrol.h>

#define ktr klocale->translate

////////// :-( a new versio of Kdatetable is needed :-( //////////
//
/////////////////// KDateTable widget class //////////////////////
//
// Copyright (C) 1997 Tim D. Gilman
//
// Written using Qt (http://www.troll.no) for the
// KDE project (http://www.kde.org)
//
// This is a support class for the KDatePicker class.  It just
// draws the calender table without titles, but could theoretically
// be used as a standalone.
//
// When a date is selected by the user, it emits a signal: dateSelected(QDate)

class KDateTable2: public QTableView 
{
Q_OBJECT
public:
	KDateTable2(QWidget *parent=0, QDate date=QDate::currentDate(), const char *name=0, WFlags f=0);
	~KDateTable2();

public slots:
	void SetDate(QDate);

signals:
	void monthChanged(QDate);
	void dateSelected(QDate);

protected:
	void paintCell( QPainter *p, int row, int col );
	void resizeEvent( QResizeEvent * );
	void mousePressEvent(QMouseEvent *e);

private:
	QDate m_date;
	int m_firstDayOfWeek;
	int m_daysInPrevMonth;
	int m_oldRow;
	int m_oldCol;
	bool m_bSelection;
	int m_selRow;
	int m_selCol;

	void setSelection(int row, int col);
	void getPrevMonth(QDate dtnow, QDate &dtprv);
	void getNextMonth(QDate dtnow, QDate &dtnxt);
	int dayNum(int row, int col);

private:  // Disabled copy constructor and operator=
	KDateTable2(const KDateTable2 & ) {}
	KDateTable2 &operator=(const KDateTable2 &) { return *this; }
};

class Dtime : public KConfigWidget
{
Q_OBJECT
public:
	Dtime( QWidget *parent=0, const char* name=0, bool init=FALSE );
	~Dtime( );

	void		applySettings();
	void		loadSettings();

private slots:
	void		Timeout();
	void		Inc_time();
	void		Dec_time(); 
	void		Joke(QLineEdit* edit,int incr,int Max,int Min,bool refr);
	void		Init();
	void		Now();
	void		Dec_year();
	void		Inc_year();
	void		set_month(int);
	void		set_year(const char*);
	void		set_time(const char*);
	void		ChangeDate(QDate);

private:
	KDateTable2	*Cal;
	QComboBox	*month;
	QLineEdit	*year;

	QLineEdit	*hour;
	QLineEdit	*minute;
	QLineEdit	*second;

	QTime		time;
	QDate		date;
	
	QString		BufS;
	int		BufI;
	bool		refresh;
	bool		ontimeout;
};

class Kclock : public QWidget
{
Q_OBJECT
public:
	Kclock( QWidget *parent=0, const char *name=0 );

protected:
	virtual void	paintEvent( QPaintEvent *event );

private slots:
	void		Timeout();

private:
	QTime		time;
	QString		Buf;
};


#endif // dtime_included
