/*
 *  Name	: dtime.cpp ( part of kcmclock )
 *  Version	: 0.1
 *  Description	: Date & Time setting for KDE
 *
 *  Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "dtime.h"
#include "dtime.moc" 

static bool GUI;

Dtime::Dtime(QWidget * parent, const char *name, bool init)
	: KConfigWidget (parent, name)
{
	initMetaObject();

	if (init)
		{
		GUI = FALSE;
		return;
		}
	else    GUI = TRUE;

	// *************************************************************
	// Start Dialog
	// *************************************************************

	QFrame* dlgedit_Frame_2;
	dlgedit_Frame_2 = new QFrame( this, "Frame_2" );
	dlgedit_Frame_2->setGeometry( 220, 10, 145, 235 );
	dlgedit_Frame_2->setMinimumSize( 10, 10 );
	dlgedit_Frame_2->setMaximumSize( 32767, 32767 );
	dlgedit_Frame_2->setFrameStyle( 49 );

	QFrame* dlgedit_Frame_1;
	dlgedit_Frame_1 = new QFrame( this, "Frame_1" );
	dlgedit_Frame_1->setGeometry( 10, 10, 205, 235 );
	dlgedit_Frame_1->setMinimumSize( 10, 10 );
	dlgedit_Frame_1->setMaximumSize( 32767, 32767 );
	dlgedit_Frame_1->setFrameStyle( 49 );

	Cal = new KDateTable2( this );
	Cal->setGeometry( 20, 50, 185, 155 );
	Cal->setMinimumSize( 10, 10 );
	Cal->setMaximumSize( 32767, 32767 );

	QPushButton* dlgedit_PushButton_1;
	dlgedit_PushButton_1 = new QPushButton( this, "PushButton_1" );
	dlgedit_PushButton_1->setGeometry( 80, 210, 70, 25 );
	dlgedit_PushButton_1->setMinimumSize( 10, 10 );
	dlgedit_PushButton_1->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_1, SIGNAL(pressed()), SLOT(Init()) );
	dlgedit_PushButton_1->setText( "&Today" );
	dlgedit_PushButton_1->setAutoRepeat( FALSE );
	dlgedit_PushButton_1->setAutoResize( FALSE );

	month = new QComboBox( FALSE, this, "ComboBox_1" );
	month->setGeometry( 20, 20, 105, 20 );
	month->setMinimumSize( 10, 10 );
	month->setMaximumSize( 32767, 32767 );
	connect( month, SIGNAL(activated(int)), SLOT(set_month(int)) );
	month->setSizeLimit( 12 );
	month->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_9;
	dlgedit_PushButton_9 = new QPushButton( this, "PushButton_9" );
	dlgedit_PushButton_9->setGeometry( 260, 210, 70, 25 );
	dlgedit_PushButton_9->setMinimumSize( 10, 10 );
	dlgedit_PushButton_9->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_9, SIGNAL(pressed()), SLOT(Now()) );
	dlgedit_PushButton_9->setText( "&Now" );
	dlgedit_PushButton_9->setAutoRepeat( FALSE );
	dlgedit_PushButton_9->setAutoResize( FALSE );

	Kclock* dlgedit_User_2;
	dlgedit_User_2 = new Kclock( this, "User_2" );
	dlgedit_User_2->setGeometry( 225, 20, 135, 135 );
	dlgedit_User_2->setMinimumSize( 135, 135 );
	dlgedit_User_2->setMaximumSize( 135, 135 );

	QPushButton* dlgedit_PushButton_10;
	dlgedit_PushButton_10 = new QPushButton( this, "PushButton_10" );
	dlgedit_PushButton_10->setGeometry( 330, 170, 20, 10 );
	dlgedit_PushButton_10->setMinimumSize( 10, 10 );
	dlgedit_PushButton_10->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_10, SIGNAL(pressed()), SLOT(Inc_time()) );
	dlgedit_PushButton_10->setText( "+" );
	dlgedit_PushButton_10->setAutoRepeat( FALSE );
	dlgedit_PushButton_10->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_11;
	dlgedit_PushButton_11 = new QPushButton( this, "PushButton_11" );
	dlgedit_PushButton_11->setGeometry( 330, 180, 20, 10 );
	dlgedit_PushButton_11->setMinimumSize( 10, 10 );
	dlgedit_PushButton_11->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_11, SIGNAL(pressed()), SLOT(Dec_time()) );
	dlgedit_PushButton_11->setText( "-" );
	dlgedit_PushButton_11->setAutoRepeat( FALSE );
	dlgedit_PushButton_11->setAutoResize( FALSE );

	hour = new QLineEdit( this, "LineEdit_1" );
	hour->setGeometry( 240, 170, 25, 20 );
	hour->setMinimumSize( 10, 10 );
	hour->setMaximumSize( 32767, 32767 );
	connect( hour, SIGNAL(textChanged(const char*)), SLOT(set_time(const char*)) );
	hour->setText( "" );
	hour->setMaxLength( 2 );
	hour->setEchoMode( QLineEdit::Normal );
	hour->setFrame( TRUE );

	minute = new QLineEdit( this, "LineEdit_2" );
	minute->setGeometry( 270, 170, 25, 20 );
	minute->setMinimumSize( 10, 10 );
	minute->setMaximumSize( 32767, 32767 );
	connect( minute, SIGNAL(textChanged(const char*)), SLOT(set_time(const char*)) );
	minute->setText( "" );
	minute->setMaxLength( 2 );
	minute->setEchoMode( QLineEdit::Normal );
	minute->setFrame( TRUE );

	second = new QLineEdit( this, "LineEdit_3" );
	second->setGeometry( 300, 170, 25, 20 );
	second->setMinimumSize( 10, 10 );
	second->setMaximumSize( 32767, 32767 );
	connect( second, SIGNAL(textChanged(const char*)), SLOT(set_time(const char*)) );
	second->setText( "" );
	second->setMaxLength( 2 );
	second->setEchoMode( QLineEdit::Normal );
	second->setFrame( TRUE );

	year = new QLineEdit( this, "LineEdit_4" );
	year->setGeometry( 140, 20, 40, 20 );
	year->setMinimumSize( 10, 10 );
	year->setMaximumSize( 32767, 32767 );
	connect( year, SIGNAL(textChanged(const char*)), SLOT(set_year(const char*)) );
	year->setText( "" );
	year->setMaxLength( 4 );
	year->setEchoMode( QLineEdit::Normal );
	year->setFrame( TRUE );

	QPushButton* dlgedit_PushButton_12;
	dlgedit_PushButton_12 = new QPushButton( this, "PushButton_12" );
	dlgedit_PushButton_12->setGeometry( 185, 30, 20, 10 );
	dlgedit_PushButton_12->setMinimumSize( 10, 10 );
	dlgedit_PushButton_12->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_12, SIGNAL(pressed()), SLOT(Dec_year()) );
	dlgedit_PushButton_12->setText( "-" );
	dlgedit_PushButton_12->setAutoRepeat( FALSE );
	dlgedit_PushButton_12->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_13;
	dlgedit_PushButton_13 = new QPushButton( this, "PushButton_13" );
	dlgedit_PushButton_13->setGeometry( 185, 20, 20, 10 );
	dlgedit_PushButton_13->setMinimumSize( 10, 10 );
	dlgedit_PushButton_13->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_13, SIGNAL(pressed()), SLOT(Inc_year()) );
	dlgedit_PushButton_13->setText( "+" );
	dlgedit_PushButton_13->setAutoRepeat( FALSE );
	dlgedit_PushButton_13->setAutoResize( FALSE );

	resize( 370,250 );
	setMinimumSize( 370, 250 );
	setMaximumSize( 370, 250 );

	// *************************************************************
	// End Dialog
	// *************************************************************

	month->insertItem( ktr("Jan") );
	month->insertItem( ktr("Feb") );
	month->insertItem( ktr("Mar") );
	month->insertItem( ktr("Apr") );
	month->insertItem( ktr("May") );
	month->insertItem( ktr("Jun") );
	month->insertItem( ktr("Jul") );
	month->insertItem( ktr("Aug") );
	month->insertItem( ktr("Sep") );
	month->insertItem( ktr("Oct") );
	month->insertItem( ktr("Nov") );
	month->insertItem( ktr("Dec") );

	Init();
	Now();
	
	connect( Cal, SIGNAL(dateSelected(QDate)), SLOT(ChangeDate(QDate)));

	// start internal timer
	time = QTime::currentTime();
	QTimer *internalTimer = new QTimer( this );
	connect( internalTimer, SIGNAL(timeout()), SLOT(Timeout()) );
	internalTimer->start( 1000 );
}

Dtime::~Dtime ()
{
if (GUI)
	{
	delete( Cal );
	delete( month );
	delete( year );

	delete( hour );
	delete( minute );
	delete( second );
	}
}

void Dtime::Init()
{
	time = QTime::currentTime();
	date = QDate::currentDate();  
	month->setCurrentItem(date.month()-1);
	BufS.sprintf("%04d",date.year());
	year->setText(BufS);
	Cal->SetDate(date);
}

void Dtime::set_year(const char* y)
{
	if ( atoi(y) < 1800 )
		return;
	if ( !date.setYMD(atoi(y),date.month(),date.day()) )
		date.setYMD(1970,date.month(),date.day());
	Cal->SetDate(date);
}

void Dtime::set_time(const char* t)
{
	if ( !ontimeout ) refresh = FALSE;
}

void Dtime::ChangeDate(QDate d)
{
	date = d;
}

void Dtime::set_month(int m)
{
	if ( !date.setYMD(date.year(),m+1,date.day()) )
		date.setYMD(date.year(),m+1,1);
	Cal->SetDate(date);
}

void Dtime::Now()
{
	refresh = TRUE;
}

void Dtime::Dec_year()
{
	Joke(year,-1,0,9999,FALSE);
	if ( !date.setYMD(atoi(year->text()),date.month(),date.day()) )
		date.setYMD(atoi(year->text()),date.month(),1);
	Cal->SetDate(date);
}

void Dtime::Inc_year()
{
	Joke(year,1,0,9999,FALSE);
	date.setYMD(atoi(year->text()),date.month(),date.day());
	Cal->SetDate(date);
}

void Dtime::loadSettings()
{
	// read some stuff ;-)
	KConfig *config = kapp->getConfig();
	config->setGroup("Options");
	// null = config->readNumEntry("null", 0);
	// null = config->readEntry("null", "null");
}

void Dtime::applySettings()
{
	QString Param;
	Param.sprintf("%02d %02d %02d %02d %04d %02d",date.month(),date.day(),atoi(hour->text()),atoi(minute->text()),date.year(),atoi(second->text()));

	BufS=kapp->kde_bindir()+"/set_dtime.sh "+Param;
	int res = system(BufS);
	if ( res != 0 )
		{
		BufS.sprintf("kcmclock error #%d",res/256);
		QMessageBox::warning( 0, BufS,ktr("setting new Date/Time !!"));
		}

	// write some stuff ;-)
	KConfig *config = kapp->getConfig();
	config->setGroup("dtime");
	config->writeEntry("null", "null");
	config->writeEntry("null", "null");
	config->sync();
}

void Dtime::Inc_time()
{
	if ( hour->hasFocus() )
		Joke(hour,1,0,23,TRUE);
	if ( minute->hasFocus() )
		Joke(minute,1,0,59,TRUE);
	if ( second->hasFocus() )
		Joke(second,1,0,59,TRUE);
}

void Dtime::Dec_time()
{
	if ( hour->hasFocus() )
		Joke(hour,-1,0,23,TRUE);
	if ( minute->hasFocus() )
		Joke(minute,-1,0,59,TRUE);
	if ( second->hasFocus() )
		Joke(second,-1,0,59,TRUE);
}

void Dtime::Joke(QLineEdit *edit,int incr,int Min,int Max,bool refr)
{
	if ( refr ) refresh = FALSE;
	BufI=atoi(edit->text());
	BufI=BufI + incr;
	if ( BufI > Max ) BufI = Min;
	if ( BufI < Min ) BufI = Max;
	if ( Max > 99 )
		BufS.sprintf("%04d",BufI);
	else    BufS.sprintf("%02d",BufI);
	edit->setText(BufS);
}    

void Dtime::Timeout()
{
	// get current time
	time = QTime::currentTime();
	if ( !refresh ) return;
	ontimeout = TRUE;
	BufS.sprintf("%02d",time.second());
	second->setText(BufS);
	BufS.sprintf("%02d",time.minute());
	minute->setText(BufS);
	BufS.sprintf("%02d",time.hour());
	hour->setText(BufS);
	ontimeout = FALSE;
}

Kclock::Kclock( QWidget *parent, const char *name )
	: QWidget( parent, name )
{
	initMetaObject();

	// start internal timer
	time = QTime::currentTime();
	QTimer *internalTimer = new QTimer( this );
	connect( internalTimer, SIGNAL(timeout()), SLOT(Timeout()) );
	internalTimer->start( 1000 );
}

void Kclock::Timeout()
{
	// get current time
	time = QTime::currentTime();
	repaint();
}

void Kclock::paintEvent( QPaintEvent * )
{
	if ( !isVisible() )
		return;

	QPainter paint;
	paint.begin( this );

	QPointArray pts;
	QPoint cp = rect().center();
	int d = QMIN(width(),height());
	paint.setPen( gray );
	paint.setBrush( gray );
	paint.setViewport(4,4,width(),height());

	for ( int c=0 ; c < 2 ; c++ )
		{
		QWMatrix matrix;
		matrix.translate( cp.x(), cp.y() );
		matrix.scale( d/1000.0F, d/1000.0F );

		// lancetta delle ore 
		float h_angle = 30*(time.hour()%12-3) + time.minute()/2;
		matrix.rotate( h_angle );
		paint.setWorldMatrix( matrix );
		pts.setPoints( 4, -20,0,  0,-20, 300,0, 0,20 );
		paint.drawPolygon( pts );
		matrix.rotate( -h_angle );

		// lancetta dei minuti
		float m_angle = (time.minute()-15)*6;
		matrix.rotate( m_angle );
		paint.setWorldMatrix( matrix );
		pts.setPoints( 4, -10,0, 0,-10, 400,0, 0,10 );
		paint.drawPolygon( pts );
		matrix.rotate( -m_angle );

		// lancetta dei secondi
		float s_angle = (time.second()-15)*6;
		matrix.rotate( s_angle );
		paint.setWorldMatrix( matrix );
		pts.setPoints(4,0,0,0,0,400,0,0,0);
			paint.drawPolygon( pts );
		matrix.rotate( -s_angle );

		// quadrante
		for ( int i=0 ; i < 60 ; i++ )
			{
			paint.setWorldMatrix( matrix );
			if ( (i % 5) == 0 )
				paint.drawLine( 450,0, 500,0 );	// draw hour lines
			else	paint.drawPoint( 480,0 );	// draw second lines
			matrix.rotate( 6 );
			}

		paint.setPen( black );
		paint.setBrush( black );
		paint.setViewport(0,0,width(),height());
		}
	paint.end();
}

/////////////////// START KDateTable widget class //////////////////////
//
// Copyright (C) 1997 Tim D. Gilman
//
// Written using Qt (http://www.troll.no) for the
// KDE project (http://www.kde.org)
//
// This is a support class for the KDatePicker class.  It just
// draws the calender table without titles, but could theoretically
// be used as a standalone.
//
// When a date is selected by the user, it emits a signal: dateSelected(QDate)


static char *day[] = { "Sun","Mon","Tue","Wed","Thu","Fri","Sat" };

KDateTable2::KDateTable2(QWidget *parent, QDate date, const char *name, WFlags f) 
	: QTableView(parent, name, f)
{
   initMetaObject();
   
   setBackgroundColor(white);

   setNumRows(7);
   setNumCols(7);
   setTableFlags(Tbl_clipCellPainting);

   QRect rec = contentsRect();
   setCellWidth(rec.width()/7);
   setCellHeight(rec.height()/7);
   
   m_oldRow = m_oldCol = 0;
   m_selRow = m_selCol = 0;
   m_bSelection = FALSE;

   setFocusPolicy(StrongFocus);

   // initialize date
   SetDate(date);
}

KDateTable2::~KDateTable2()
{
}

void KDateTable2::SetDate(QDate d)
{
	int c,r;
	m_date = d;

	// get the day of the week on the first day
	QDate dayone(m_date.year(), m_date.month(), 1);
	m_firstDayOfWeek = dayone.dayOfWeek();

	// determine number of days in previous month
	QDate prvmonth;
	getPrevMonth(m_date, prvmonth);   
	m_daysInPrevMonth = prvmonth.daysInMonth();

	// From day to axis ;-)
	r = (int)(( d.day() + m_firstDayOfWeek ) / 7 );
	if ( ( ( d.day() + m_firstDayOfWeek ) % 7 ) != 0 )
		{
		r++;
		c = 7 - ( (r * 7) - m_firstDayOfWeek - d.day());
		}
	else	c = 7;

// fprintf(stdout,"m=%d,r=%d,c=%d\n",m_firstDayOfWeek,r,c);
	setSelection(r,c-1);
	repaint();
}

void KDateTable2::paintCell( QPainter *p, int row, int col )
{
   int w = cellWidth();
   int h = cellHeight();
   bool bSelected = FALSE;

   if (0==row) {
      p->setPen(darkBlue);
      p->setFont(QFont("Arial", 12, QFont::Bold, TRUE));
      p->drawText(0, 0, w, h, AlignCenter, day[col]);
      p->setPen(black);
      p->moveTo(0, h-1);
      p->lineTo(w-1, h-1);
   }
   else {
      int nDay = dayNum(row, col);
      
      p->setFont(QFont("Arial", 12));
      if (m_bSelection && row==m_selRow && col==m_selCol) {  // item is selected
	 bSelected = TRUE;
	 p->setBrush(darkBlue);
	 p->setPen(red);
	 p->drawEllipse(4,h/2-(w-8)/3,w-8,2*(w-8)/3); // think of better way
      }
      
      QString day;
      day.sprintf("%i", nDay);
      p->setPen(bSelected? white : black);
      if (nDay > 0 && nDay <= m_date.daysInMonth()) {
	 p->drawText(0, 0, w, h, AlignCenter, day);
      }
      else if (nDay <= 0) {
	 int nDayPrv = m_daysInPrevMonth + nDay;
	 day.sprintf("%i", nDayPrv);
	 p->setPen(bSelected? white : gray);
	 p->drawText(0, 0, w, h, AlignCenter, day);
      }
      else {
	 int nDayNext = nDay - m_date.daysInMonth();
	 day.sprintf("%i", nDayNext);
	 p->setPen(bSelected? white : gray);
	 p->drawText(0, 0, w, h, AlignCenter, day);
      }
      
      if (bSelected && hasFocus()) {
	 if ( style() == WindowsStyle)
	   p->drawWinFocusRect(1, 1, w-2, h-2);
	 else {
	    QColorGroup g = colorGroup();
	    p->setPen( black );
	    p->setBrush( NoBrush );
	    p->drawRect( 1, 1, w-2, h-2 );
	 }
      }
//      m_bSelected = FALSE;
   }
}

void KDateTable2::mousePressEvent(QMouseEvent *e)
{
   if (e->type() != Event_MouseButtonPress)
     return;
   
   int row, col;
   
   QPoint mouseCoord = e->pos();
   row = findRow(mouseCoord.y());
   col = findCol(mouseCoord.x());

   if (row > 0)
     setSelection(row, col);
   
}

void KDateTable2::setSelection(int row, int col)
{
   int nDay = dayNum(row, col);
   bool bDayInMonth =  row > 0 && nDay > 0 && nDay <= m_date.daysInMonth() ? TRUE : FALSE;
   
   if (!bDayInMonth)  // do nothing
     return;
   
   if (bDayInMonth) {
      m_selRow = row;
      m_selCol = col;
   } 
   
   // if we clicked on a valid day for the current month and there is something already
   // selected, then update it
   if (m_bSelection && bDayInMonth) { // if something already selected
      updateCell(m_oldRow, m_oldCol);
   }
   
   // update new selection
   if (bDayInMonth) {
      m_bSelection = TRUE;  // validating selection
      m_date.setYMD(m_date.year(),m_date.month(),nDay);
      updateCell(row, col);
      emit dateSelected(m_date);
   }
   
   // remember last selected location
   m_oldRow = row;
   m_oldCol = col; 
}

void KDateTable2::resizeEvent( QResizeEvent *)
{
	QRect rec = contentsRect();
	setCellWidth(rec.width()/7);
	setCellHeight(rec.height()/7);
}

// gets a date on the first day of the previous month
void KDateTable2::getPrevMonth(QDate dtnow, QDate &dtprv)
{
	int month = dtnow.month() > 1 ? dtnow.month()-1 : 12;
	int year = dtnow.month() > 1 ? dtnow.year() : dtnow.year()-1;
	dtprv = QDate(year, month, 1);
}

// gets a date on the first day of the next month
void KDateTable2::getNextMonth(QDate dtnow, QDate &dtnxt)
{
	int month = dtnow.month() < 12 ? dtnow.month()+1 : 1;
	int year = dtnow.month() < 12 ? dtnow.year() : dtnow.year()+1;
	dtnxt = QDate(year, month, 1);
}

int KDateTable2::dayNum(int row, int col)
{
	return 7*row - 7 + 1 + col - m_firstDayOfWeek;
}

//
/////////////////// END KDateTable widget class //////////////////////
