/* Placed in public domain by Mario Grosso, 2004 */
#include "ienclock.h"

char workbuffer[SAMPLES*NUMBUFFER];
int maxdelta;
int safemode;
int testmode;
float levelref;

static long jdate(struct tm *t)
{
  long c, m, y;

  y = t->tm_year + 1900;
  m = t->tm_mon + 1;
  if (m > 2)
    m = m - 3;
  else {
    m = m + 9;
    y--;
  }
  c = y / 100L;     
  y -= 100L * c;
  return t->tm_mday + (c * 146097L) / 4 + (y * 1461L) / 4 +
    (m * 153L + 2) / 5 + 1721119L;
}
static void InitGoertzel(GCONSTANT* g, float freq)
{
  int   k;
  FLOATING      floatN;
  FLOATING      omega;

  floatN = (FLOATING) STEP;
  k = (int) (0.5 + ((floatN * freq) / SAMPLERATE));
  omega = (2.0 * PI * k) / floatN;
  g->sine = sin(omega);
  g->cosine = cos(omega);

  g->coeff = 2.0 * g->cosine;
  g->Q1=g->Q2=0;
}
static void ProcessSample(GCONSTANT *g, unsigned char sample)
{
  FLOATING Q0;
  Q0 = g->coeff * g->Q1 - g->Q2 + (FLOATING) sample;
  g->Q2 = g->Q1;
  g->Q1 = Q0;
}


static void GetRealImag(GCONSTANT* g, FLOATING *realPart, FLOATING *imagPart)
{
  *realPart = (g->Q1 - g->Q2 * g->cosine);
  *imagPart = (g->Q2 * g->sine);
}
static FLOATING GetMagnitudeSquared(GCONSTANT *g)
{
  FLOATING result;

  result = g->Q1 * g->Q1 + g->Q2 * g->Q2 - g->Q1 * g->Q2 * g->coeff;
  return result;
}

static FLOATING testFreq(GCONSTANT *g, FLOATING frequency, unsigned char * buf)
{
  FLOATING      magnitudeSquared;
  FLOATING      magnitude;
  FLOATING      real;
  FLOATING      imag;
  int i;

  for (i=0; i< STEP; i++)
    {
      ProcessSample(g, buf[i]);
    }
  GetRealImag(g, &real, &imag);
  
  magnitudeSquared = GetMagnitudeSquared(g);
  
  magnitude = sqrt(magnitudeSquared);  
  
  g->Q1=g->Q2=0;   
  if (testmode==3)  { printf("freq: %f - mag: %f\n",frequency, magnitude);}  
  return magnitude;
}
static int CenterBin( GCONSTANT *g,  FLOATING frequency, DSPCB * dsp)
{
  char * stbuf, *tuned;
  int i,x=0,y;
  FLOATING maxmag=0.0, magnitude;
  stbuf=tuned=dsp->buf-(STEP/2);
  y=dsp->unproc+(STEP/2);
  for (i=0; i< STEP; i+=(STEP/4))
    {
      magnitude=testFreq(g, frequency, &stbuf[i]);
      if (magnitude> maxmag) maxmag=magnitude, tuned=&stbuf[i], x=i;
    }
  dsp->unproc=y-x;
  dsp->buf=tuned;
  levelref=max(levelref,(maxmag*0.5));
  if (testmode==3)
    printf("tune  buf: %x - read: %d - unproc:%d\n",
	   dsp->buf, dsp->bufferread, dsp->unproc);
  return 0;
}

static int decode_tab( int * ientab, int padbuf)
{
  int cv[]={80,40,20,10,8,4,2,1};
  int p1,p2,pa,s1=1,s2=1,sa=1;
  struct tm tm;
  time_t this;
  struct timeval tv, ctv;
  struct timezone tz;   
  int i, hr=0, ms=0, mn=0, dy=0, yr=0;

	
  for (i=0;i<SEGMENT; i++)
    {
      if (ientab[i] != ZERO_VALUE && ientab[i] != ONE_VALUE) 
	return INVALID_VALUE;
      if (testmode>=2)
	printf("%d:%d ",i,(ientab[i]==ONE_VALUE)?1:0);
      if (i<16) 
	s1=(ientab[i]== ONE_VALUE) ? s1^1:s1;
      if (i>16 && i<31) 
	s2=(ientab[i]== ONE_VALUE) ? s2^1:s2;
      if (i>31 && i< 47) 
	sa=(ientab[i]== ONE_VALUE) ? sa^1:sa;
      if (i==16)
	{
	  p1= (ientab[i]== ONE_VALUE) ?1:0;
	  if (testmode>=2)
	    printf("\n p1:%d s1:%d\n",p1,s1);
	  if (p1!=s1) {printf("parity check p1\n"); return (PARITY_CHECK);}
	}
      if (i==31)
	{
			
	  p2= (ientab[i]== ONE_VALUE) ?1:0;
	  if (testmode>=2)
	    printf("\n p2:%d s2:%d\n",p2,s2);
	  if (p2!=s2) {printf("parity check p2\n"); return (PARITY_CHECK);}
	}
      if (i==47)
	{
	  pa= (ientab[i]== ONE_VALUE) ?1:0;
	  if (testmode>=2)
	    printf("\n pa:%d sa:%d\n",pa,sa);
	  if (pa!=sa) {printf("parity check pa\n"); return (PARITY_CHECK);}
	}    	
    }
  if (testmode>=2)
    printf("\n");
  for (i=2; i< 8; i++)
    hr+= (ientab[i]== ONE_VALUE) ? cv[i] : 0;  /* -2+2 */
  for (i=8; i< 15; i++)
    ms+= (ientab[i]== ONE_VALUE) ? cv[i-7] : 0; /* -8+1 */
  for (i=17; i< 22; i++)
    mn+= (ientab[i]== ONE_VALUE) ? cv[i-14] : 0;   /* -17+3 */
  for (i=22; i< 28; i++)
    dy+= (ientab[i]== ONE_VALUE) ? cv[i-20] : 0;   /* -22+2 */
  for (i=34; i< 42; i++)
    yr+= (ientab[i]== ONE_VALUE) ? cv[i-34] : 0;
  if (testmode>=2)
    printf("Year %d - month %d - day %d - hour %d - minute %d \n",yr, mn, dy, hr, ms);    
  tm.tm_sec=53;
  tm.tm_min=ms;
  tm.tm_hour=hr;
  tm.tm_mday=dy;
  tm.tm_mon=mn-1;  /* month -1 */ 
  tm.tm_year=100+yr;
  tm.tm_wday=0; 
  tm.tm_yday=0;
  
  tm.tm_isdst=(ientab[15]==ONE_VALUE) ? 1:0;
  this=CEST;  			       		/* time is CET  based */
  this+=  (tm.tm_isdst)? 3600:0;                /* saving time        */ 
  tv.tv_sec= ((((jdate(&tm) - DAY1970 )* 24 + tm.tm_hour) * 60) +
	      tm.tm_min) * 60 + tm.tm_sec - this;
  tv.tv_usec=480000;                         /* last segment duration */
  tv.tv_usec+=(padbuf/8*1000);	             /* add unprocessed  time */
  gettimeofday(&ctv, &tz);
  if (testmode>=1)
    {
      printf("UTC:   %s", asctime(gmtime(&tv.tv_sec)));
      printf("Local: %s", asctime(localtime(&tv.tv_sec)));
    }
  if (maxdelta && ((difftime(tv.tv_sec,ctv.tv_sec)>maxdelta) || 
		   (difftime(ctv.tv_sec,tv.tv_sec)>maxdelta)))
    {
      printf("diff check\n");
      return (DIFF_CHECK);
    }
  if (safemode==0) {
 	if (settimeofday(&tv, &tz)==0)
    	{
        	if (testmode>=1)
		printf("Time successfully updated!\n");
    	}
  	else perror("settimeofday");
   }
  return 0;	    
}
static void usage()
{
  fprintf(stderr,"Usage: ienclock -d input device\n"
	  "\t\t -m\t max delta update time (default 5 min., 0=unlimited)\n"
	  "\t\t -s\t safe mode (don't update clock)\n"
	  "\t\t -t\t messages level 0-3 (default 1)\n"
	  "\t\t -h\t show this help\n "
          "\t\t -v\t show version\n"
	  );
  return;
}

int read_dsp(DSPCB * dsp)
{
  char buf[SAMPLES*4];
  char *sbuf, *sStart, *sEnd;
  int size,iTemp;

  size=(dsp->format==AFMT_U8)?1:2;
  size*=(SAMPLES*dsp->channels);
  if (dsp->buf==NULL)
    {
      memmove(workbuffer, workbuffer+SAMPLES, SAMPLES*(NUMBUFFER-1));
      sbuf=workbuffer+(SAMPLES*(NUMBUFFER-1));
      if (fread(buf, size, 1, dsp->fp) != 1)
	return EOF;
      dsp->buf=workbuffer+(SAMPLES*(NUMBUFFER-2));
      sStart=buf;
      sEnd=sStart+size;
      while (sStart<sEnd)
	{

	  switch (dsp->format)
	    {
	    case AFMT_U8:
	      *sbuf++ = *sStart++;
	      if(dsp->channels==2) sStart++;
	      break;
	    case AFMT_S16_LE:		 
	      iTemp=(*(short*)sStart) >> 8 ; 
	      ((short*)sStart)++;
	      if(dsp->channels==2) {
		iTemp+=(*(short*)sStart) >> 8;
		iTemp/=2;
		((short*)sStart)++;
	      }
	      iTemp^=0x80;
	      *sbuf++ = iTemp;
	      break;
	    default:
	      printf("unsupported format\n");
	      return EOF;
	      break;
	    }			 	  
	}
                	
      dsp->unproc=SAMPLES-STEP;
      dsp->bufferread++;
      if (testmode==3)
	printf("read_dsp-0  buf: %x - read: %d - unproc:%d\n", 
	       dsp->buf, dsp->bufferread, dsp->unproc);
      return (1);
    }
  if (dsp->unproc>=(STEP+STEP/2))
    {
      dsp->unproc-=STEP;
      dsp->buf+=STEP;
      if (testmode==3)
	printf("read_dsp-1 buf: %x - read: %d - unproc:%d\n", 
	       dsp->buf, dsp->bufferread, dsp->unproc);
      return (1);
    }
  memmove(workbuffer, workbuffer+SAMPLES, SAMPLES*(NUMBUFFER-1));
  sbuf=workbuffer+(SAMPLES*(NUMBUFFER-1));
  if (fread(buf, size, 1, dsp->fp) != 1)
    return EOF;
  sStart=buf;
  sEnd=sStart+size;
  while (sStart<sEnd)
    {
      switch (dsp->format)
	{
	case AFMT_U8:
	  *sbuf++ = *sStart++;
	  if(dsp->channels==2) sStart++;
	  break;
	case AFMT_S16_LE:
	  iTemp=(*(short*)sStart) >> 8;
	  ((short*)sStart)++;
	  if(dsp->channels==2) {
	    iTemp+=(*(short*)sStart) >> 8;
	    iTemp/=2;
	    ((short*)sStart)++;
	  }
	  iTemp^=0x80;
	  *sbuf++ = iTemp;
	  break;
	default:
	  return EOF;
	}
    }
	
  dsp->buf-=(SAMPLES-STEP);
  dsp->unproc+=(SAMPLES-STEP);
  dsp->bufferread++;
  if (testmode==3)
    printf("read_dsp-2 buf: %x - read: %d - unproc:%d\n",
	   dsp->buf, dsp->bufferread, dsp->unproc);
  return (1);
}
static int setcard( DSPCB* dsp)
{
 
  int channel;
  int format;
  int speed;
  int rc;
  
  format=dsp->format;
  rc=ioctl(fileno(dsp->fp), SNDCTL_DSP_SETFMT, &format);
  if (rc==EOF)
    {
      perror("ioctl setformat");
      return rc;
    }
  dsp->format=format;
  channel=2;
  rc=ioctl(fileno(dsp->fp), SNDCTL_DSP_CHANNELS, &channel);
  if (rc==EOF)
    {
      perror("ioctl setchannel");
      return rc;
    }
  dsp->channels=channel;
  speed=8000;
  rc=ioctl(fileno(dsp->fp), SNDCTL_DSP_SPEED, &speed);
  if (rc==EOF)
    {
      perror("ioctl set speed");
      return rc;
    }
  dsp->speed=speed;
  rc=ioctl(fileno(dsp->fp), SNDCTL_DSP_GETBLKSIZE,  &dsp->blksize);
    if (rc==EOF)
      dsp->blksize=4096;
  return 0;
    
}
int main(int argc, char **argv)
{
  	
  DSPCB dsp;
  GCONSTANT g2000, g2500;
  int ientab[SEGMENT];
  char c;
  char *fname;
  FLOATING magnitude;
  int ib, last, rc;
  	
  /*-------------------------------------------------------------------------*/
  /* Set default parameters before input options.                            */
  /*-------------------------------------------------------------------------*/
  safemode=0;
  maxdelta=18000;
  testmode=1;
  fname="/dev/dsp";
	
  while ((c=getopt(argc,argv, "t:hvm:d:s")) != EOF)
    {
      switch (c)
        {
	case  'd':
	  fname=optarg;
	  break;
	case 'h':
	  usage();
	  return 0;
	  break;
	case 'm':
	  if (!sscanf(optarg,"%d",&maxdelta))
	    {
	      printf("invalid argument to -m parameter: %s\n",
		     optarg);
	      usage();
	      return 4;
	    }
	  if (maxdelta) maxdelta*=60;
	  break;
	case 's':
	  safemode=1;
	  break;
	case 't':
	  sscanf(optarg,"%d",&testmode);
	  break;
	case 'v':
	  printf(VERSION);
	  return 0;
	  break;
	default:
	  usage();
	  return 8;
	}
    }
  	
  memset(&dsp,0,sizeof(DSPCB));
  dsp.fp = fopen(fname, "r");
  dsp.channels=2; 
  dsp.format=AFMT_S16_LE;
  //dsp.format=AFMT_U8;
  levelref=PEAKLEVEL;
  if (dsp.fp == NULL)
    {
      printf("Error on open file: %s  %s\n", fname, strerror(errno));
      return (8);
    }
  if (strcmp(fname,"/dev/dsp")==0)
    setcard(&dsp);
  ib=0;
  memset(&ientab,0,sizeof(ientab));
        
  InitGoertzel(&g2500, PULSE_ON + DRIFT_FREQ);
  InitGoertzel(&g2000, PULSE_OFF+ DRIFT_FREQ);
  //InitGoertzel(&g1000, 1000.0);
  memset(workbuffer,0,sizeof(workbuffer));
  while (dsp.bufferread< ((SAMPLERATE/SAMPLES) * 60*10))
    {
      if (read_dsp(&dsp) != 1)
	break;


    
      if ((ib>1 && (ientab[0] != ZERO_VALUE || ientab[1] != ONE_VALUE))
	       || (dsp.bufferread-last)>2)
    	{
	  ientab[0]=0;ientab[1]=0;
	  //memset(&ientab,0,sizeof(ientab));
	  ib=0;   	
	  last=0;
	  //	continue;
    	}   
      if (ib == SEGMENT)
    	{
	  rc=decode_tab(ientab, dsp.unproc);
	  if (rc)
	    {
	      memset(&ientab,0,sizeof(ientab));
	      last=0;
	      ib=0;
	    }
	  else 
	    {
	      fclose(dsp.fp); 
              return 0;
	    }
    	} 

      magnitude=testFreq(&g2000, 2000.0, dsp.buf);
      if (magnitude > levelref)
	{
	  if (!ib) CenterBin(&g2000, 2000.0, &dsp);
	  if (testmode>=2)
	    printf("buffno %d - seq %d - bit: %d - Magnitude: %f\n",
		   dsp.bufferread, ib, 0, magnitude);
	  ientab[ib]=ZERO_VALUE;
	  ib++;
	  last=dsp.bufferread;
	  continue;
	}  
      magnitude=testFreq(&g2500, 2500.0,dsp.buf);
      if (magnitude > levelref)
    	{
	  if (ib==32) CenterBin(&g2500, 2500.0, &dsp);
	  if (testmode>=2)
	    printf("buffno %d - seq %d - bit: %d - Magnitude: %f\n",
		   dsp.bufferread, ib, 1, magnitude);
	  ientab[ib]=ONE_VALUE;
	  ib++;
	  last=dsp.bufferread;
	  continue;
    	}   
    }

  fclose(dsp.fp);
  if (testmode>=1)
	  printf("Readed %d segments but interpreted no valid signal!\n",dsp.bufferread);
  return 4;
}
