.TH dcf77d 8 "08 March 1997" "Version 1.01" "Joerg Krause"
.SH NAME
dcf77d \- DCF77 serial radio clock daemon.
.SH SYNOPSIS
dcf77d [-k] [-h] [-c] [-p device] [-l loglevel]
.SH DESCRIPTION
.B dcf77d 
reads from an 
.B 'Atom Clock' 
via a serial port the raw
time and date information transmitted at 77.5 Khz from an
antenna located at Mainflingen near Frankfurt/Main (Germany).
The Signal is controlled by the Caesium Standard from the PTB Braunschweig.
Every second a pulse of 100ms or 200ms is transmitted to build up a data stream of '1'
and '0' over every minute.

.B dcf77d 
works in the background and adjusts the 
.B kernel  
and possibly the 
.B CMOS
time whenever these times differ from the time read from the dcf77 receiver.

Since setting the kernel time and writing to /dev/rtc requires
superuser-permissions
.B dcf77d
must be executed by root or a user with root-privileges.

.B dcf77d
logs its activities using the syslog service.

.B dcf77d
writes its process id to /var/run/dcf77d.pid.

.SH OPTIONS

.TP
.B -c
Set the CMOS time and date (default: disabled).

.B Note
that this feature requires a kernel with
.I Enhanced Realtime Clock
(/dev/rtc) support compiled in.
.TP
.B -h
Show version and usage, then exit. 
.TP
.B -k
Check for the existance of a previously started dcf77d and replace it
(needs proc-fs cmdline entry).
(default: disabled)
.TP
.B -l <loglevel>
A loglevel of 0 means log absolutely nothing, 1 log errors only and 2 log errors
and notices (default: 1).

Note that an error message "Clock out of synch." is an indicator for
bad reception, you should check the position and environment of the
dcf77 receiver if this occurs
.IR frequently . 
.TP
.B -p <device>
The serial device for the clock (default: /dev/cua0).
.LP
.SH SEE ALSO
.BR date (1),
.BR clock (8)

.SH AUTHOR
Joerg Krause (quacks@paula.owl.de)
