/***************************************************************************
                          tdsmonitor.cpp  -  description
                             -------------------
    begin                : Thu May 23 2002
    copyright            : (C) 2002 by Pete Gray
    email                : petegray@attbi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <tds.h>
#include <tdsmonitor.h>

void TDSApp::slotMonTimer()
{
  int c;
  DIR* dirp;
  struct dirent* direntp;
  QString litem;
  char l[255], ffnx[255], fxpm[255];
  FILE *fpsx;
  struct   tds_status_struct tdsx;
  pid_t gpid;
  int jc[7]={0};

  if ( (dirp = opendir (tdsstad)) == NULL ) {
    statusBar()->message (tr("Monitor cannot open Status directory"));
    return;
  }
  ListBox1->clear();
  for (c=0 ; ; ) {
    if ( (direntp = readdir(dirp)) == NULL) break;
    if (!strcmp(direntp->d_name,".")) continue;
    if (!strcmp(direntp->d_name,"..")) continue;
    strcpy (ffnx,tdssta);
    strcat (ffnx,direntp->d_name);
    if ( (fpsx=fopen(ffnx,"r")) == NULL ) {
       statmess ("Monitor cannot open",direntp->d_name,"Status file");
       continue;
    }
    if (fread(&tdsx,sizeof(struct tds_status_struct),1,fpsx) != 1) {
       statmess ("Monitor cannot read",direntp->d_name,"Status file");
       fclose (fpsx);
       continue;
    }
    fclose (fpsx);
#ifdef _XOPEN_SOURCE
# if (_XOPEN_SOURCE - 0) >= 600
    /* are we supposed to be running, but there's no process? */
    gpid = getsid (tdsx.pid);
    if (tdsx.state == RUNNING && gpid == -1) tdsx.state = ERROR;
# endif
#endif
    jc[6]++;
    if ( tdsx.state >= NEWJOB && tdsx.state <= ERROR) jc[tdsx.state-'0']++;
    if (tdsx.state == RUNNING && !CheckBox1->isChecked()) continue;
    if (tdsx.state == ERROR && !CheckBox2->isChecked()) continue;
    if (tdsx.state == WAITING && !CheckBox3->isChecked()) continue;
    if (tdsx.state == COMPLETED && !CheckBox4->isChecked()) continue;
    strcpy (l,direntp->d_name);
    strncat (l,"               ",(sizeof(jn)-1)-strlen(direntp->d_name));
    switch (tdsx.state) {
    case HELDJOB:
    case WAITING:
    case NEWJOB:
      strcat (l,ctime(&tdsx.time_requested));
      break;
    case COMPLETED:
      strcat (l,ctime(&tdsx.time_completed));
      break;
    default:
      strcat (l,ctime(&tdsx.time_started));
      break;
    }
    l[strlen(l)-1] = 0;
    litem = l;
    strcpy (fxpm,xpmbase);
    if (tdsx.state >= NEWJOB && tdsx.state <= ERROR)
       strcat (fxpm,xpm[tdsx.state-'0']);
    else
       strcat (fxpm,"xpmblank");
    ListBox1->insertItem ( QPixmap( fxpm ), litem, c++);
  }
  closedir (dirp);
  sprintf (l,"%d jobs: %d running, %d waiting, %d held, %d failed",
    jc[6],jc[RUNNING-'0'], jc[WAITING-'0'], jc[HELDJOB-'0'], jc[ERROR-'0']);
  JobInfo->setText(tr(l));
}
