/***************************************************************************
                          tdslistbox.cpp  -  description
                             -------------------
    begin                : Sun Jun 2 2002
    copyright            : (C) 2002 by Pete Gray
    email                : petegray@attbi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tds.h>
#include "../../tdsd/tdsd.h"
#include <qtextedit.h>

extern   tds_status_struct tds;

void TDSApp::slotListBox ()
{
  unsigned int i;
  QString title ("Job Detail: ");
  char script[33], user[33], line[256];
  QString log ("TDS: Viewing log of Job ");
  pid_t gpid;

  JobName->setFocus();
  strncpy (jn,ListBox1->currentText(),sizeof(jn)-1);
  for (i=0; i<sizeof(jn); i++) if (jn[i]==' ') jn[i] = '\0';
  if (!strlen(jn)) return;
  strcpy (ffn,tdssta);
  strcat (ffn,jn);
  if ( (fps=fopen(ffn,"r")) == NULL ) {
     statmess ("Cannot open",jn,"Status file");
     return;
  }
  if (fread(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
     statmess ("Cannot read",jn,"Status file");
     fclose (fps);
     return;
  }
  fclose (fps);
  strcpy (ffn,tdsjob);
  strcat (ffn,jn);
  if ( (fpj=fopen(ffn,"r")) == NULL ) {
     statmess ("Cannot open",jn,"Job File");
     return;
  }
  fgets(script,sizeof(script),fpj);
  fgets(user,sizeof(user),fpj);
  script[strlen(script)-1] = '\0';
  user[strlen(user)-1] = '\0';

  QDialog *dlg = new QDialog( centralWidget(), "InfoDlg", TRUE, 0 );
  title += jn;
  dlg->setCaption( title );

  QGroupBox *Box1 = new QGroupBox( dlg );
  Box1->setGeometry( QRect( 5, 5, 432, 54 ) );

  QLabel *su = new QLabel ( dlg );
  su->setGeometry ( QRect(10,10,240,44));
  su->setText( tr("Script:\nUser:") );

  QLabel *ul = new QLabel ( dlg );
  ul->setGeometry ( QRect(130,10,240,44));
  strcpy (line, script);
  strcat (line, "\n");
  strcat (line, user);
  ul->setText( tr (line) );

  QLabel *states = new QLabel ( dlg );
  states->setGeometry ( QRect(10,59,240,44));
  states->setText ( tr("Current State:\nRequested State:") );

  QLabel *st = new QLabel ( dlg );
  st->setGeometry ( QRect(130,59,240,44) );
#ifdef _XOPEN_SOURCE
# if (_XOPEN_SOURCE - 0) >= 600
    /* are we supposed to be running, but there's no process? */
    gpid = getsid (tds.pid);
    if (tds.state == RUNNING && gpid == -1) tds.state = ERROR;
# endif
#endif
  strcpy (line,lstatedesc[tds.state-'0']);
  strcat (line,"\n");
  strcat (line,rstatedesc[tds.state_requested-'0']);
  st->setText ( tr(line) );

  QLabel *times = new QLabel ( dlg );
  times->setGeometry ( QRect(10,108,240,66));
  times->setText ( tr("Time Requested:\nTime Started:\nTime Completed:") );

  QLabel *rsc = new QLabel ( dlg );
  rsc->setGeometry ( QRect (130,108,240,66));
  strcpy (line,ctime(&tds.time_requested));
  strcat (line,ctime(&tds.time_started));
  strcat (line,ctime(&tds.time_completed));
  line[strlen(line)-1] = '\0';
  rsc->setText ( tr(line));

  QLabel *ps = new QLabel ( dlg );
  ps->setGeometry ( QRect (10,176,240,66));
  ps->setText ( tr("PID:\nCompletion Status:\nCheckpoint:"));
  sprintf (line,"%d\n%d\n",tds.pid,tds.completion_status);
  strcat (line,tds.checkpoint);
  QLabel *psc = new QLabel ( dlg );
  psc->setGeometry ( QRect (130,176,240,66));
  psc->setText ( tr(line) );

  QLabel *ra = new QLabel ( dlg );
  ra->setGeometry ( QRect(285,59,150,22));
  ra->setText( tr("Runs after") );

  QListBox *DepList = new QListBox( dlg );
  DepList->setGeometry( QRect( 285, 81, 150, 200 ) );
  DepList->setSelectionMode (QListBox::NoSelection);
  QFont QFterm10 ("Terminal",10);
  QFterm10.setFixedPitch ( TRUE );
  DepList->setFont (QFterm10);

  while (!feof(fpj)) {
    if (fgets(line,sizeof(jn),fpj) != NULL) {
      line[strlen(line)-1] = '\0';
      DepList->insertItem ( line );
    }
  }
  fclose (fpj);

  QPushButton *Done = new QPushButton( dlg, "Done" );
  Done->setGeometry( QRect( 40, 260, 70, 22 ) );
  Done->setText( trUtf8( "&Done" ) );
  connect(Done, SIGNAL(pressed()), dlg, SLOT(reject()));

  QPushButton *ViewLog = new QPushButton( dlg, "ViewLog" );
  ViewLog->setGeometry( QRect( 130, 260, 70, 22 ) );
  ViewLog->setText( trUtf8( "&View Log" ) );
  connect(ViewLog, SIGNAL(pressed()), dlg, SLOT(accept()));

  if ( dlg->exec() == QDialog::Accepted ) {
/*    QDialog *dlg2 = new QDialog( centralWidget(), "LogDlg", TRUE, 0 ); */
    QDialog *dlg2 = new QDialog( centralWidget(), "LogDlg", FALSE, 0 );
    strcpy (ffn,tdslog);
    strcat (ffn,jn);
    QTextEdit *textEdit = new QTextEdit (dlg2);
    QFile file( ffn );
    if ( file.open( IO_ReadOnly ) ) {
      QTextStream ts( &file );
      textEdit->setText( ts.read() );
      textEdit->setReadOnly( TRUE );
      file.close();
      textEdit->resize (500,500);
      textEdit->show();
      log += jn;
      dlg2->setCaption( log );
      dlg2->show();
    }
  }
  delete dlg;
}
