/***************************************************************************
                          tdsaddjob.cpp  -  description
                             -------------------
    begin                : Thu May 23 2002
    copyright            : (C) 2002 by Pete Gray
    email                : petegray@attbi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <tds.h>
#include "../../tdsd/tdsd.h"
extern   tds_status_struct tds;

void TDSApp::slotJobAdd()
{
  QString title ("Add Job ");
  QLineEdit *DepName[10];
  int c, dep;

  statusBar()->message(tr(" "));
  if (badjobname()) return;
  umask (S_IRWXG | S_IRWXO);
  strcpy (ffn,tdssta);
  strcat (ffn,JobName->text());
  if ( (fps=fopen(ffn,"r")) != NULL ) {
     statmess ("Job",JobName->text(),"already exists");
     fclose (fps);
     JobName->setFocus();
     return;
  }
  QDialog *dlg = new QDialog( centralWidget(), "AddDlg", TRUE, 0 );
  title += JobName->text();
  dlg->setCaption( title );

  QLineEdit *UserName = new QLineEdit (dlg,"Username");
  UserName->setGeometry ( QRect(100,20,108,22));
  UserName->setMaxLength (32);
  QLineEdit *Script = new QLineEdit (dlg,"Script");
  Script->setGeometry ( QRect(100,50,108,22));
  Script->setMaxLength (128);

  QLabel *u = new QLabel ( dlg, "ulab");
  u->setGeometry ( QRect(10,20,60,22));
  u->setText( trUtf8( "User" ));
  QLabel *s = new QLabel ( dlg, "slab");
  s->setGeometry ( QRect(10,50,60,22));
  s->setText( trUtf8( "Script" ));

  QPushButton *OK = new QPushButton( dlg, "OK" );
  OK->setGeometry( QRect( 30, 80, 70, 22 ) );
  OK->setText( trUtf8( "OK" ) );
  connect(OK, SIGNAL(pressed()), dlg, SLOT(accept()));
  OK->setDefault ( TRUE );
  QPushButton *Cancel = new QPushButton( dlg, "Cancel" );
  Cancel->setGeometry( QRect( 120, 80, 70, 22 ) );
  Cancel->setText( trUtf8( "Cancel" ) );
  connect(Cancel, SIGNAL(pressed()), dlg, SLOT(reject()));

  if ( dlg->exec() == QDialog::Accepted ) {
   if ((UserName->text()).isEmpty() || (Script->text()).isEmpty()) {
     QMessageBox::information(this, tr("Bad User/Script"),
                                    tr("User/Script cannot be blank"),
                                    QMessageBox::Ok);
     JobName->setFocus();
     delete dlg;
     return;
   }
   now = time(NULL);
   if (strcmp("root",opw->pw_name)) {
      if (strcmp(opw->pw_name,UserName->text())) {
         statusBar()->message(tr ("You can only add/modify your own jobs"));
         delete dlg;
         return;
      }
   }
   if ( (pw = getpwnam(UserName->text())) == NULL ) {
      statusBar()->message(tr ("User not found"));
      delete dlg;
      return;
   }
   if ( (fps=fopen(ffn,"w")) == NULL ) {
      statmess ("Cannot create",JobName->text(),"Status file");
      delete dlg;
      return;
   }
   tds.state = NEWJOB;
   tds.state_requested = NOREQUEST;
   tds.time_requested = now;
   tds.time_started = 0;
   tds.time_completed = 0;
   tds.completion_status = 0;
   tds.pid = 0;
   tds.checkpoint[0] = '\0';
   if (fwrite(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      statmess ("Cannot write",JobName->text(),"Status record");
      delete dlg;
      return;
   }
   fclose (fps);
   chown (ffn,pw->pw_uid,pw->pw_gid);
   strcpy (ffn,tdsjob);
   strcat (ffn,JobName->text());
   if ( (fpj=fopen(ffn,"r")) != NULL ) {
      statmess ("Job",JobName->text(),"file already exists");
      fclose (fpj);
      delete dlg;
      return;
   }
   if ( (fpj=fopen(ffn,"w")) == NULL ) {
      statmess ("Cannot create",JobName->text(),"Job file");
      delete dlg;
      return;
   }
   if (fputs(Script->text(),fpj) < 0) statusBar()->message(tr ("Error writing script to job file"));
   fputc ('\n',fpj);
   if (fputs(UserName->text(),fpj) < 0) statusBar()->message(tr ("Error writing user to job file"));
   fputc ('\n',fpj);
   delete dlg;
   dep = QMessageBox::information(this, tr(JobName->text()),
                                    tr("Add dependencies?"),
                                    QMessageBox::Ok, QMessageBox::Cancel);
   if ( dep==QMessageBox::Ok ) {
     QDialog *dlg = new QDialog( centralWidget(), "DepDlg", TRUE, 0 );
     dlg->setCaption( tr("Add Dependencies") );
     QLabel *d = new QLabel ( dlg, "dlab");
     d->setGeometry ( QRect(10,10,200,22));
     d->setText( trUtf8( JobName->text() ));
     QLabel *d2 = new QLabel ( dlg, "dlab2");
     d2->setGeometry ( QRect(10,35,200,22));
     d2->setText( trUtf8( "runs after these jobs:" ));
     for (c=0; c<10; c++) {
       DepName[c] = new QLineEdit (dlg,"Depname");
       DepName[c]->setGeometry ( QRect(10,64+(c*27),108,22));
       DepName[c]->setMaxLength (32);
     }
     QPushButton *OK = new QPushButton( dlg, "OK" );
     OK->setGeometry( QRect( 30, 350, 70, 22 ) );
     OK->setText( trUtf8( "OK" ) );
     connect(OK, SIGNAL(pressed()), dlg, SLOT(accept()));
     OK->setDefault ( TRUE );
     QPushButton *Cancel = new QPushButton( dlg, "Cancel" );
     Cancel->setGeometry( QRect( 120, 350, 70, 22 ) );
     Cancel->setText( trUtf8( "Cancel" ) );
     connect(Cancel, SIGNAL(pressed()), dlg, SLOT(reject()));
     if ( dlg->exec() == QDialog::Accepted ) {
       for (c=0; c<10; c++) {
         if (!DepName[c]->text().isEmpty()) {
           fputs(DepName[c]->text(),fpj);
           fputc ('\n',fpj);
         }
       }
       infomess ("Job",JobName->text(),"Added, with Dependencies");
     }
     else
       infomess ("Job",JobName->text(),"Added, WITHOUT Dependencies");
     delete dlg;
   }
   else
     infomess ("Job",JobName->text(),"Added, no Dependencies");
   fclose (fpj);
   chown (ffn,pw->pw_uid,pw->pw_gid);
   JobName->clear();
  }
  else
    infomess ("Job",JobName->text(),"NOT Added");
  JobName->setFocus();
}
