/***************************************************************************
                          tds.h  -  description
                             -------------------
    begin                : Mon May 13 21:53:05 EDT 2002
    copyright            : (C) 2002 by Pete Gray
    email                : petegray@attbi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDS_H
#define TDS_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qtimer.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>

// application specific includes
#include "tdsview.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <pwd.h>
#include <time.h>
#include <unistd.h>

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class TDSView is
  * created which creates your view.
  */
class TDSApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    TDSApp();
    /** destructor */
    ~TDSApp();
    /** initializes all QActions of the application */
    void initActions();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** this creates the toolbars. Change the toobar look and add new toolbars in this
     * function */

    /** setup the statusbar */
    void initStatusBar();

    void initOther();
    /** setup the document*/
    void initDoc();
    /** setup the mainview*/
    void initView();

    bool badjobname();

    void infomess(char *, const char *, char *);
    void statmess(char *, const char *, char *);

    void modifyJob (char);

    /** overloaded for Message box on last window exit */
    bool queryExit();

  public slots:

    /** exits the application */
    void slotJobQuit();

    /** releases a group **/
    void slotGroupRelease();

    /** releases a job **/
    void slotJobRelease();

    /** releases a job **/
    void slotJobRun();

    /** releases a job **/
    void slotJobAdd();

    /** holds a job **/
    void slotJobHold();

    /** toggle the toolbar*/

    /** toggle the statusbar*/
    void slotViewStatusBar(bool toggle);

    /** shows an about dlg*/
    void slotHelpAbout();

    /** our monitor timer **/
    void slotMonTimer();

    void slotListBox();

  private:

    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    TDSView *view;

    /** job_menu contains all items of the menubar entry "Program" */
    QPopupMenu *jobMenu;
    /** view_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    /** actions for the application initialized in initActions() and used to en/disable them
      * according to your needs during the program */
    QAction *jobQuit;

    QAction *viewStatusBar;

    QAction *helpAboutApp;

    QLineEdit *JobName, *GroupName;
    QButtonGroup *ButtonGroup1;
    QGroupBox *GroupBox1, *GroupBox2;
    QPushButton *ReleaseGroup, *AddJob, *ReleaseJob, *RunJob, *HoldJob, *Quit;
    QCheckBox *CheckBox1, *CheckBox2, *CheckBox3, *CheckBox4;
    QListBox *ListBox1;
    QLabel *JobInfo;

    char tdsstad[255], tdssta[255], tdsjob[255], tdsgrp[255], tdslog[255], ffn[255];
    char jn[17], tdsbase[255], xpmbase[255];
    char     *tdsdir;
    time_t   now;
    FILE     *fps, *fpj, *fpg;
    struct   passwd *opw, *pw;

};
#endif 
