/***************************************************************************
                          tds.cpp  -  description
                             -------------------
    begin                : Mon May 13 21:53:05 EDT 2002
    copyright            : (C) 2002 by Pete Gray
    email                : petegray@attbi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qaccel.h>
#include "tds.h"

#include "../../tdsd/tdsd.h"
struct   tds_status_struct tds;

bool TDSApp::badjobname()
{
  if ((JobName->text()).isEmpty()) {
    QMessageBox::information(this, tr("Bad Jobname"),
                                    tr("Jobname cannot be blank"),
                                    QMessageBox::Ok);
    JobName->setFocus();
    return TRUE;
  }
  return FALSE;
}

void TDSApp::modifyJob(char modtype)
{
   statusBar()->message(tr(" "));
   if (badjobname()) return;
   now = time(NULL);
   strcpy (ffn,tdssta);
   strcat (ffn,JobName->text());
   if ( (fps=fopen(ffn,"r+")) == NULL ) {
      statmess ("Cannot open",JobName->text(),"Status file");
      return;
   }
   if ( fread(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      statmess ("Cannot read",JobName->text(),"Status record");
      fclose (fps);
      return;
   }
   tds.completion_status = 0;
   tds.pid = 0;
   tds.time_requested = now;
   switch (modtype) {
   case RUNJOB:
     tds.state = WAITING;
     tds.state_requested = RUNJOB;
     break;
   case RELEASEJOB:
     if (tds.state == ERROR || tds.state == WAITING || tds.state == RUNNING) {
       statmess ("Job",JobName->text(),"-state prevents release");
       fclose (fps);
       return;
     }
     tds.state = WAITING;
     tds.state_requested = RELEASEJOB;
     break;
   case HOLDJOB:
     if (tds.state == RUNNING || tds.state == ERROR) {
       statmess ("Job",JobName->text(),"-state prevents hold");
       fclose (fps);
       return;
     }
     tds.state = HELDJOB;
     break;
   }
   if ( fseek(fps,0,SEEK_SET) != 0) {
      statmess ("Cannot position",JobName->text(),"to Status record");
      fclose (fps);
      return;
   }
   if (fwrite(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      statmess ("Cannot write",JobName->text(),"Status record");
      fclose (fps);
      return;
   }
  switch (modtype) {
  case RUNJOB:
    infomess ("Job",JobName->text(),"Run forced"); break;
  case RELEASEJOB:
    infomess ("Job",JobName->text(),"Released"); break;
  case HOLDJOB:
    infomess ("Job",JobName->text(),"Put on Hold"); break;
  }
  JobName->clear();
  JobName->setFocus();
  fclose (fps);
}

TDSApp::TDSApp()
{
  resize (485,542);
  setCaption(tr("TDS: Task Dependency Scheduler " VERSION));

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initActions();
  initMenuBar();
  initStatusBar();

  initView();
  initOther();

  viewStatusBar->setOn(true);
  ListBox1->clear();
  QTimer * counter = new QTimer( this );
  connect( counter, SIGNAL(timeout()), this, SLOT(slotMonTimer()) );
  QTimer::singleShot( 1000, this, SLOT(slotMonTimer()) );
  counter->start( 15000 );      // repeating, every 15 seconds
}

TDSApp::~TDSApp()
{
}

/** initializes all QActions of the application */
void TDSApp::initActions(){

  jobQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
  connect(jobQuit, SIGNAL(activated()), this, SLOT(slotJobQuit()));

  viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
  connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

  helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
  connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

}

void TDSApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  jobMenu=new QPopupMenu();
  jobQuit->addTo(jobMenu);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  helpAboutApp->addTo(helpMenu);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  menuBar()->insertItem(tr("&Program"), jobMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(tr("&Info"), helpMenu);
}

void TDSApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready"), 2000);
}

void TDSApp::initOther()
{

  GroupBox1 = new QGroupBox( centralWidget(), "GroupBox1" );
  GroupBox1->setGeometry( QRect( 10, 60, 210, 50 ) );
  GroupBox1->setTitle( trUtf8( "Group Release" ) );

  GroupName = new QLineEdit( GroupBox1, "GroupName" );
  GroupName->setGeometry( QRect( 10, 20, 108, 22 ) );
  GroupName->setMaxLength (sizeof(jn)-1);

  ReleaseGroup = new QPushButton( GroupBox1, "ReleaseGroup" );
  ReleaseGroup->setGeometry( QRect( 130, 20, 70, 22 ) );
  ReleaseGroup->setText( trUtf8( "Release" ) );
  connect(ReleaseGroup, SIGNAL(clicked()), this, SLOT(slotGroupRelease()));

  GroupBox2 = new QGroupBox( centralWidget(), "GroupBox2" );
  GroupBox2->setGeometry( QRect( 10, 120, 465, 350 ) );
  GroupBox2->setTitle( trUtf8( "Monitor" ) );

  CheckBox1 = new QCheckBox( GroupBox2, "CheckBox1" );
  CheckBox1->setGeometry( QRect( 80, 15, 80, 20 ) );
  CheckBox1->setText( trUtf8( "Running" ) );
  CheckBox1->setChecked (TRUE);
  CheckBox2 = new QCheckBox( GroupBox2, "CheckBox2" );
  CheckBox2->setGeometry( QRect( 160, 15, 87, 20 ) );
  CheckBox2->setText( trUtf8( "Errors" ) );
  CheckBox2->setChecked (TRUE);
  CheckBox3 = new QCheckBox( GroupBox2, "CheckBox3" );
  CheckBox3->setGeometry( QRect( 240, 15, 87, 20 ) );
  CheckBox3->setText( trUtf8( "Waiting" ) );
  CheckBox3->setChecked (TRUE);
  CheckBox4 = new QCheckBox( GroupBox2, "CheckBox4" );
  CheckBox4->setGeometry( QRect( 320, 15, 87, 20 ) );
  CheckBox4->setText( trUtf8( "Completed" ) );
  CheckBox4->setChecked (TRUE);

  QLabel *t = new QLabel ( GroupBox2, "ListTitle");
  t->setGeometry ( QRect(30,42,400,22));
  t->setText( trUtf8( "STATE    NAME                      TIMESTAMP" ));

  ListBox1 = new QListBox( GroupBox2, "ListBox1" );
  ListBox1->insertItem( trUtf8( "New Item" ) );
  ListBox1->setGeometry( QRect( 10, 64, 445, 280 ) );
/*  ListBox1->setSelectionMode (QListBox::NoSelection); */
  QFont QFterm10 ("Terminal",10);
  QFterm10.setFixedPitch( TRUE );
  ListBox1->setFont (QFterm10);
  connect (ListBox1, SIGNAL(selected(int)), this, SLOT(slotListBox()));

  Quit = new QPushButton( centralWidget(), "Quit" );
  Quit->setGeometry( QRect( 380, 80, 70, 22 ) );
  Quit->setText( trUtf8( "&Quit" ) );
  connect(Quit, SIGNAL(clicked()), this, SLOT(slotJobQuit()));

  ButtonGroup1 = new QButtonGroup( centralWidget(), "ButtonGroup1" );
  ButtonGroup1->setGeometry( QRect( 10, 5, 450, 50 ) );
  ButtonGroup1->setTitle( trUtf8( "Job Control" ) );

  JobName = new QLineEdit (ButtonGroup1,"Jobname");
  JobName->setGeometry ( QRect(10,20,108,22));
  JobName->setMaxLength (sizeof(jn)-1);

  AddJob = new QPushButton( ButtonGroup1, "AddJob" );
  AddJob->setGeometry( QRect( 130, 20, 70, 22 ) );
  AddJob->setText( trUtf8( "&Add" ) );
  connect(AddJob, SIGNAL(clicked()), this, SLOT(slotJobAdd()));

  ReleaseJob = new QPushButton( ButtonGroup1, "ReleaseJob" );
  ReleaseJob->setGeometry( QRect( 210, 20, 70, 22 ) );
  ReleaseJob->setText( trUtf8( "&Release" ) );
  connect(ReleaseJob, SIGNAL(clicked()), this, SLOT(slotJobRelease()));

  RunJob = new QPushButton( ButtonGroup1, "RunJob" );
  RunJob->setGeometry( QRect( 290, 20, 70, 22 ) );
  RunJob->setText( trUtf8( "&Force Run" ) );
  connect(RunJob, SIGNAL(clicked()), this, SLOT(slotJobRun()));

  HoldJob = new QPushButton( ButtonGroup1, "HoldJob" );
  HoldJob->setGeometry( QRect( 370, 20, 70, 22 ) );
  HoldJob->setText( trUtf8( "&Hold" ) );
  connect(HoldJob, SIGNAL(clicked()), this, SLOT(slotJobHold()));

  // tab order
  setTabOrder( JobName, AddJob );
  setTabOrder( AddJob, ReleaseJob );
  setTabOrder( ReleaseJob, RunJob );
  setTabOrder( RunJob, HoldJob );
  setTabOrder( HoldJob, GroupName );
  setTabOrder( GroupName, ReleaseGroup );
  setTabOrder( ReleaseGroup, Quit );
  setTabOrder( Quit, CheckBox1 );
  setTabOrder( CheckBox1, CheckBox2 );
  setTabOrder( CheckBox2, CheckBox3 );
  setTabOrder( CheckBox3, CheckBox4 );
  setTabOrder( CheckBox4, ListBox1 );

   if ( (tdsdir = getenv("TDSDIR")) == NULL )
     strcpy (tdsbase,"/tds");
   else
     strcpy (tdsbase,tdsdir);
   strcpy (xpmbase,tdsbase);
   strcat (xpmbase,"/");
   strcpy (tdsgrp,tdsbase);
   strcat (tdsgrp,"/groups/");
   strcpy (tdssta,tdsbase);
   strcat (tdssta,"/status/");
   strcpy (tdsjob,tdsbase);
   strcat (tdsjob,"/jobs/");
   strcpy (tdsstad,tdsbase);
   strcat (tdsstad,"/status");
   strcpy (tdslog,tdsbase);
   strcat (tdslog,"/logs/");

   JobInfo = new QLabel ( centralWidget());
   JobInfo->setGeometry ( QRect(10,470,465,22));
   JobInfo->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   JobInfo->setAlignment( AlignBottom | AlignHCenter );

   if ((opw = getpwuid(getuid())) == NULL ) {
      statusBar()->message(tr("Problem accessing passwd"));
      infomess ("FATAL ERROR","(cannot continue)","Press OK to Quit");
      qApp->quit();
   }
}

void TDSApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  view=new TDSView(this);
  setCentralWidget(view);
}

bool TDSApp::queryExit()
{
  int exit=QMessageBox::information(this, tr("Quit"),
                                    tr("Do your really want to quit?"),
                                    QMessageBox::Ok, QMessageBox::Cancel);

  return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void TDSApp::slotGroupRelease()
{
  int ok = TRUE, all = TRUE, pass = 1;

   now = time(NULL);
   strcpy (ffn,tdsgrp);
   strcat (ffn,GroupName->text());
   if ( (fpg=fopen(ffn,"r")) == NULL ) {
      statusBar()->message(tr("Cannot open Group file"));
      return;
   }
  QString title ("Releasing Group ");
  QDialog *Gdlg = new QDialog( centralWidget(), "GrpDlg", FALSE, 0 );
  title += GroupName->text();
  Gdlg->setCaption( title );
  Gdlg->resize(170,220);

  QListBox *ListBoxGrp = new QListBox( Gdlg, "ListBoxGrp" );
  ListBoxGrp->setGeometry( QRect( 10, 10, 150, 200 ) );
  ListBoxGrp->setSelectionMode (QListBox::NoSelection);
  QFont QFterm10 ("Terminal",10);
  QFterm10.setFixedPitch ( TRUE );
  ListBoxGrp->setFont (QFterm10);

  do {
    if ( fseek(fpg,0,SEEK_SET) != 0) {
      statmess ("Cannot position","to start of","Group file");
      ok = FALSE;
      break;
    }
    if ( pass==2 ) Gdlg->show();
    do {
      if (fgets(jn,sizeof(jn),fpg) == NULL) {
        if (!feof(fpg)) {
          ok = FALSE;
          statmess ("Cannot read",GroupName->text(),"Group file");
        }
      }
      else {
        strcpy (ffn,tdssta);
        jn[strlen(jn)-1] = 0;
        strcat (ffn,jn);
        if ( (fps=fopen(ffn,"r+")) == NULL ) {
           statmess ("Cannot open",jn,"Status file");
           ok = FALSE;
           continue;
        }
        if (fread(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
           statmess ("Cannot read",jn,"Status file");
           ok = FALSE;
           fclose (fps);
           continue;
        }
        if (tds.state == ERROR || tds.state == WAITING || tds.state == RUNNING) {
           statmess ("Job",jn,"-state prevents release");
           ok = FALSE;
           fclose (fps);
           continue;
        }
        if ( pass == 2 && tds.state == HELDJOB ) all = FALSE;
        /** 1st pass - don't update. Group release doesn't release held jobs */
        if ( pass == 1 || tds.state == HELDJOB) {
          fclose (fps);
          continue;
        }
        tds.state = WAITING;
        tds.state_requested = RELEASEJOB;
        tds.time_requested = now;
        tds.completion_status = 0;
        tds.pid = 0;
        if ( fseek(fps,0,SEEK_SET) != 0) {
           statmess ("Cannot position",jn,"to Status record");
           fclose (fps);
           ok = FALSE;
           continue;
        }
        if (fwrite(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
           statmess ("Cannot write",jn,"Status");
           fclose (fps);
           ok = FALSE;
           continue;
        }
        fclose (fps);
        ListBoxGrp->insertItem (tr(jn));
      }
    } while (ok && !feof(fpg));
  } while (ok && ++pass < 3);
  fclose (fpg);
  if (ok) {
    if (all)
      infomess ("Group",GroupName->text(),"All Jobs Released");
    else
      infomess ("Group",GroupName->text(),"Released (except for HELD jobs)");
    GroupName->clear();
    JobName->setFocus();
  }
  else {
    GroupName->setFocus();
    if ( pass==1 )
      infomess ("Group",GroupName->text(),"Cannot be released");
    else
      infomess ("WARNING: Group",GroupName->text(),"PARTIALLY released");
  }
  delete Gdlg;
}

void TDSApp::slotJobRelease()
{
   modifyJob (RELEASEJOB);
}

void TDSApp::slotJobHold()
{
   modifyJob (HOLDJOB);
}

void TDSApp::slotJobRun()
{
   modifyJob (RUNJOB);
}

void TDSApp::slotJobQuit()
{
  statusBar()->message(tr("Exiting application..."));
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(queryExit()) qApp->quit();
  statusBar()->message(tr("Ready"));
}

void TDSApp::slotViewStatusBar(bool toggle)
{
  statusBar()->message(tr("Toggle statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off

  if (toggle == false)
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }
  statusBar()->message(tr("Ready"));
}

void TDSApp::slotHelpAbout()
{
  QMessageBox::about(this,tr("About..."),
                      tr("TDS\nVersion " VERSION "\n(c) 2002 by Pete Gray") );
}
