 /****************************************************************************
 *                           tdsd.c  -  description
 *                             -------------------
 *     begin                : Sun Jun 2 2002
 *     copyright            : (C) 2002 by Pete Gray
 *     email                : petegray@attbi.com
 ****************************************************************************/

 /****************************************************************************
 *                                                                           *
 *     This program is free software; you can redistribute it and/or modify  *
 *     it under the terms of the GNU General Public License as published by  *
 *     the Free Software Foundation; either version 2 of the License, or     *
 *     (at your option) any later version.                                   *
 *                                                                           *
 ****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
/* #include <process.h> */
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <dirent.h>
#include <string.h>
#include <signal.h>

#include "tdsd.h"

char     *tdsdir, *tdsdebug;
char     tdslog[255], tdssta[255], tdsjob[255], ffn[255];
char     command[255], user[255], tdsrestart[255];
time_t   now;
int      debug;

#define SLEEPTIME 10

int start_job (char *cmd, char *usr, char *jname, char *outdir, char *restart);
int is_runnable (char *jname);

int main (int argc, char *argv[])
{
   DIR*   dirp;
   struct dirent* direntp;
   struct passwd *pw;
   int    shutdown = 0, gotosleep;
   sigset_t sset;
   pid_t tpid, gpid;
   
   /* fork and exit the parent, for setsid to set new session id */
   if ( (tpid=fork()) > 0 ) exit(EXIT_SUCCESS);
   gpid = setsid();
   
   now = time(NULL);
   printf ("Startup %s",ctime(&now));
   if (sigemptyset(&sset)) perror ("sigemptyset");
   if (sigaddset(&sset, SIGCHLD)) perror ("sigaddset");
   if (sigprocmask(SIG_BLOCK,&sset,NULL)) perror ("sigprocmask");
   if ( (tdsdir = getenv("TDSDIR")) == NULL ) {
     printf ("TDS directory undefined\n");
     return EXIT_FAILURE;
   }
   if ( (pw = getpwuid(getuid())) == NULL ) {
      printf ("Could not get user info\n");
      return EXIT_FAILURE;
   }
   debug = ( (tdsdebug=getenv("TDSDEBUG")) != NULL);
   printf ("TDSDIR is %s, TDSDEBUG is %d. ",tdsdir,debug);
   printf ("Running as %s, pid %d\n",pw->pw_name,getpid());
   strcpy (tdslog,tdsdir);
   strcat (tdslog,"/logs/");
   strcpy (tdssta,tdsdir);
   strcat (tdssta,"/status");
   strcpy (tdsjob,tdsdir);
   strcat (tdsjob,"/jobs/");
   
   while (!shutdown) {
      gotosleep = -1;
      now = time(NULL);
      printf ("\n%sScanning jobs...\n",ctime(&now));
      if ( (dirp = opendir (tdssta)) == NULL ) {
	 perror (tdssta);
	 shutdown = -1;
      }
      else {
	 for (;;) {
	    if ( (direntp = readdir(dirp)) == NULL) break;
	    if (!strcmp(direntp->d_name,".")) continue;
	    if (!strcmp(direntp->d_name,"..")) continue;
	    if (is_runnable (direntp->d_name)) {
	       start_job (command,user,direntp->d_name,tdslog,tdsrestart);
/*	       gotosleep = 0; */
	    }
	 }
	 closedir (dirp);
	 if (gotosleep) sleep (SLEEPTIME);
      }
   }   
   now = time(NULL);
   printf ("Shutdown %s",ctime(&now));
   return EXIT_SUCCESS;
}

int is_runnable (char *jobname)
{
   FILE *fps, *fpj;
   struct tds_status_struct tds, tdsd;
   char jn[255];
   int depmet = -1;
   
   now = time(NULL);
   if (debug) printf ("\nJOB %s: ",jobname);
   strcpy (ffn,tdssta);
   strcat (ffn,"/");
   strcat (ffn,jobname);
   if ( (fps=fopen(ffn,"r")) == NULL ) {
      perror (ffn);
      return 0; 
   }
   if (fread(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      printf ("Cannot read status record (%s)\n",jobname);
      fclose (fps);
      return 0;
   }
   fclose (fps);
   if (debug) {
      printf ("(%s). ",statedesc[tds.state-'0']);
      printf ("req/start/comp %d/%d/%d\n",tds.time_requested,tds.time_started,tds.time_completed);
      printf ("%s. pid %d (status %d), ",rstatedesc[tds.state_requested-'0'],tds.pid,tds.completion_status);
      printf ("restart=%s\n",tds.checkpoint);
   }
   if (tds.state_requested == NOREQUEST) return 0;
   if (tds.state == HELDJOB) return 0;
   strcpy (ffn,tdsjob);
   strcat (ffn,jobname);
   if ( (fpj=fopen(ffn,"r")) == NULL) {
      perror (ffn);
      return 0;
   }
   if ( fgets(command,sizeof(command),fpj) == NULL) {
      perror ("Reading command from job file");
      printf ("Job (%s)\n",jobname);
      fclose (fpj);
      return 0;
   }
   if (fgets(user,sizeof(user),fpj) == NULL) {
      printf ("Cannot read user from job file (%s)\n",jobname);
      fclose (fpj);
      return 0;
   }
   strcpy (tdsrestart,tds.checkpoint);
   command[strlen(command)-1] = 0;
   user[strlen(user)-1] = 0;

   if (tds.time_requested <= tds.time_started) {
      fclose (fpj);
      return 0;
   }
   if (tds.state_requested == RUNJOB) {           /* run (forced) */
      if (tds.state != RUNNING) {
	 fclose (fpj);
	 return -1;
      }
   }
   if (tds.state_requested == RELEASEJOB) {       /* release */
      if (debug) printf (" deps:\n");
      do {
	 if (fgets(jn,sizeof(jn),fpj) == NULL) {
	    if (!feof(fpj)) {
	       perror ("getting next dep");
	       depmet=0;
	    }
	 }
	 else {
	    jn[strlen(jn)-1] = 0;
	    if (debug) printf ("  %s\n",jn);
	    strcpy (ffn,tdssta);
	    strcat (ffn,"/");
	    strcat (ffn,jn);
	    if ( (fps=fopen(ffn,"r")) == NULL ) {
	       perror (ffn);
	       depmet = 0;
	       continue;
	    }
	    if (fread(&tdsd,sizeof(struct tds_status_struct),1,fps) != 1) {
	       perror ("reading dep status");
       	       depmet = 0;
	       fclose (fps);
	       continue;
	    }
	    fclose (fps);
	    if (tdsd.state != COMPLETED) depmet = 0;
	    if (tds.state == NEWJOB) {            /* a new job */
	       if (tds.time_requested > tdsd.time_completed) depmet = 0;
	    }
	    else {
	       if (tdsd.time_completed < tds.time_started) depmet = 0;
	    }
	 }
      } while (depmet && !feof(fpj));
      fclose (fpj);
      if (debug) printf (" depmet=%d\n",depmet);
      return (depmet);
   }
   return 0;
}
