/****************************************************************************
 *                           tdscheckpoint.c  -  description
 *                                -------------------
 *     begin                : Sun Jun 2 2002
 *     copyright            : (C) 2002 by Pete Gray
 *     email                : petegray@attbi.com
 ****************************************************************************/

/*****************************************************************************
 *                                                                           *
 *     This program is free software; you can redistribute it and/or modify  *
 *     it under the terms of the GNU General Public License as published by  *
 *     the Free Software Foundation; either version 2 of the License, or     *
 *     (at your option) any later version.                                   *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
/* #include <process.h> */
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <dirent.h>

#include "tdsd.h"

char     *tdsdir, *tdsjobname;
char     tdssta[255], ffn[255];
FILE     *fps;
struct   tds_status_struct tds;

int main (int argc, char *argv[])
{
   if (argc < 2) {
      printf ("Usage: tdscheckpoint label\n");
      return EXIT_FAILURE;
   }

   if ( (tdsdir = getenv("TDSDIR")) == NULL ) {
     printf ("TDS directory undefined\n");
     return EXIT_FAILURE;
   }
   if ( (tdsjobname = getenv("TDSJOBNAME")) == NULL) {
      printf ("TDS jobname undefined - you must run from within TDS\n");
      return EXIT_FAILURE;
   }
   strcpy (tdssta,tdsdir);
   strcat (tdssta,"/status");
   strcpy (ffn,tdssta);
   strcat (ffn,"/");
   strcat (ffn,tdsjobname);
   if ( (fps=fopen(ffn,"r+")) == NULL ) {
      printf ("Status file (%s) does not exists\n",tdsjobname);
      perror ("fopen");
      return EXIT_FAILURE; 
   }
   if ( fread(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      perror ("Cannot read status");
      return EXIT_FAILURE;
   }
   strcpy (tds.checkpoint,argv[1]);
   if ( fseek(fps,0,SEEK_SET) != 0) {
      perror ("Cannot position to record");
      return EXIT_FAILURE;
   }
   if (fwrite(&tds,sizeof(struct tds_status_struct),1,fps) != 1) {
      perror ("Cannot write status");
      return EXIT_FAILURE;
   }
   fclose (fps);
   printf ("TDS checkpoint set (%s)\n",argv[1]);
   return EXIT_SUCCESS;
}
